/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation;

import cartoj.Enregistrement;
import cartoj.ICouche;
import cartoj.IFichierCont;
import cartoj.IFichierDon;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPoints;
import gls.geometry.GeoPositionnement;
import gls.geometry.Geometry;
import gls.localisation.LocalisationInfo;
import gls.localisation.alertc.LocalisantAlertc;
import gls.localisation.pr.LocalisantPr;
import gls.localisation.recherche.Recherche;
import gls.outils.GLS;
import java.util.Vector;

public class InfoTroncon {
    private Enregistrement troncon;
    private ICouche couche;
    private GeoPoint pointDebut;
    private GeoPoint pointFin;
    private String DF;
    private String type;
    private String idgdfDeb;
    private String idgdfFin;
    private String idgdf;
    private String[] valeurs = null;
    private boolean inverse;
    private boolean appliquerInversion = true;

    public InfoTroncon() {
    }

    public InfoTroncon(Enregistrement troncon) {
        this.troncon = troncon;
    }

    public InfoTroncon(Enregistrement troncon, ICouche couche) {
        this.couche = couche;
        this.troncon = troncon;
        if (troncon != null) {
            if (couche != null) {
                float[] listeX = couche.getCont().getX(troncon.getNum());
                float[] listeY = couche.getCont().getY(troncon.getNum());
                this.pointDebut = new GeoPoint(listeX[0], listeY[0]);
                this.pointFin = new GeoPoint(listeX[listeX.length - 1], listeY[listeY.length - 1]);
            }
            try {
                this.DF = troncon.getValeur(10);
                this.type = troncon.getValeur(11);
                this.idgdfDeb = troncon.getValeur(2);
                this.idgdfFin = troncon.getValeur(3);
                this.idgdf = troncon.getValeur(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.valeurs = troncon.getValeurs();
        } else {
            couche = null;
            this.DF = null;
            this.type = null;
            this.idgdfDeb = null;
            this.idgdfFin = null;
            this.idgdf = null;
            this.valeurs = null;
        }
    }

    public InfoTroncon(InfoTroncon infoTroncon) {
        this.set(infoTroncon);
    }

    public void set(Enregistrement troncon, ICouche couche) {
        this.couche = couche;
        this.troncon = troncon;
        if (troncon != null) {
            if (couche != null) {
                float[] listeX = couche.getCont().getX(troncon.getNum());
                float[] listeY = couche.getCont().getY(troncon.getNum());
                this.pointDebut = new GeoPoint(listeX[0], listeY[0]);
                this.pointFin = new GeoPoint(listeX[listeX.length - 1], listeY[listeY.length - 1]);
            }
            this.DF = troncon.getValeur(10);
            this.type = troncon.getValeur(11);
            this.idgdfDeb = troncon.getValeur(2);
            this.idgdfFin = troncon.getValeur(3);
            this.idgdf = troncon.getValeur(0);
            this.valeurs = troncon.getValeurs();
        } else {
            couche = null;
            this.DF = null;
            this.type = null;
            this.idgdfDeb = null;
            this.idgdfFin = null;
            this.idgdf = null;
            this.valeurs = null;
        }
    }

    public void set(InfoTroncon infoTroncon) {
        this.pointDebut = infoTroncon.getPointDebut();
        this.pointFin = infoTroncon.getPointFin();
        this.DF = infoTroncon.getDF();
        this.type = infoTroncon.getType();
        this.idgdfDeb = infoTroncon.getIdgdfDeb();
        this.idgdfFin = infoTroncon.getIdgdfFin();
        this.idgdf = infoTroncon.getIdgdf();
        this.troncon = infoTroncon.getTroncon();
        this.inverse = infoTroncon.estInverse();
        this.couche = infoTroncon.getCouche();
        this.valeurs = infoTroncon.getValeurs();
    }

    public void set(InfoTroncon infoTroncon, String[] valeurs) {
        this.pointDebut = infoTroncon.getPointDebut();
        this.pointFin = infoTroncon.getPointFin();
        this.DF = infoTroncon.getDF();
        this.type = infoTroncon.getType();
        this.idgdfDeb = infoTroncon.getIdgdfDeb();
        this.idgdfFin = infoTroncon.getIdgdfFin();
        this.idgdf = infoTroncon.getIdgdf();
        this.troncon = infoTroncon.getTroncon();
        this.inverse = infoTroncon.estInverse();
        this.couche = infoTroncon.getCouche();
        this.valeurs = valeurs;
    }

    public GeoPoint getPoint(int i) throws Exception {
        float[] listeX = this.getX();
        if (i >= 0 && listeX.length > 0 && i < listeX.length) {
            float[] listeY = this.getY();
            return new GeoPoint(listeX[i], listeY[i]);
        }
        throw new Exception("ERREUR L'INDICE N'EST PAS CORRECT");
    }

    public GeoPoints getPoints() {
        GeoPoints points = new GeoPoints();
        float[] listeX = this.getX();
        float[] listeY = this.getY();
        int i = 0;
        while (i < this.getNbPoints()) {
            points.ajouter(new GeoPoint(listeX[i], listeY[i]));
            ++i;
        }
        return points;
    }

    public GeoPoints getPoints(int iDeb, int iFin) throws Exception {
        GeoPoints points = new GeoPoints();
        int i = iDeb;
        while (i <= iFin) {
            points.ajouter(this.getPoint(i));
            ++i;
        }
        return points;
    }

    public int getNbPoints() {
        return this.getX().length;
    }

    public GeoPoint getPremierPoint() {
        try {
            return this.getPoint(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public GeoPoint getDernierPoint() {
        try {
            return this.getPoint(this.getNbPoints() - 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public float[] getX() {
        if (this.couche != null && this.troncon != null) {
            return this.inverse ? this.inverserCoordonnees(this.couche.getCont().getX(this.troncon.getNum())) : this.couche.getCont().getX(this.troncon.getNum());
        }
        return null;
    }

    public float[] getY() {
        if (this.couche != null && this.troncon != null) {
            return this.inverse ? this.inverserCoordonnees(this.couche.getCont().getY(this.troncon.getNum())) : this.couche.getCont().getY(this.troncon.getNum());
        }
        return null;
    }

    public String getValeur(int champ) {
        if (this.troncon != null) {
            if (this.valeurs == null) {
                return this.troncon.getValeur(champ);
            }
            return this.valeurs[champ];
        }
        return "";
    }

    public String[] getValeurs() {
        if (this.troncon != null) {
            if (this.valeurs == null) {
                return this.troncon.getValeurs();
            }
            return this.valeurs;
        }
        return null;
    }

    public int getNum() {
        if (this.troncon != null) {
            return this.troncon.getNum();
        }
        return -1;
    }

    public void inverserPoints() {
        GeoPoint pointTemp = this.pointDebut;
        this.pointDebut = this.pointFin;
        this.pointFin = pointTemp;
    }

    public void setInverse(boolean value) {
        this.inverse = value;
    }

    public void setInverse() {
        this.inverse = this.DF.equals("2");
    }

    public boolean estInverse() {
        return this.inverse;
    }

    public ICouche getCouche() {
        return this.couche;
    }

    public IFichierDon getDon() {
        return this.couche.getDon();
    }

    public IFichierCont getCont() {
        return this.couche.getCont();
    }

    public Enregistrement getTroncon() {
        return this.troncon;
    }

    public GeoPoint getPointDebut() {
        return this.pointDebut;
    }

    public GeoPoint getPointFin() {
        return this.pointFin;
    }

    public void setPointDebut(GeoPoint pointDebut) {
        this.pointDebut = pointDebut;
    }

    public void setPointFin(GeoPoint pointFin) {
        this.pointFin = pointFin;
    }

    public void setDF(String DF) {
        this.DF = DF;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIdgdfDeb(String idgdfDeb) {
        this.idgdfDeb = idgdfDeb;
    }

    public void setIdgdfFin(String idgdfFin) {
        this.idgdfFin = idgdfFin;
    }

    public String getDF() {
        return this.DF;
    }

    public String getType() {
        return this.type;
    }

    public String getIdgdfDeb() {
        return this.idgdfDeb;
    }

    public String getIdgdfFin() {
        return this.idgdfFin;
    }

    public void setIdgdf(String idgdf) {
        this.idgdf = idgdf;
    }

    public String getIdgdf() {
        return this.idgdf;
    }

    public int getLongueur() {
        int longueurTroncon;
        try {
            longueurTroncon = Integer.parseInt(this.getValeur(4));
        }
        catch (Exception e) {
            LocalisationInfo.ecrireLog("#--> ERREUR LONGUEUR TRONCON DISTANCE DOUBLE SENS");
            return -1;
        }
        return longueurTroncon;
    }

    public int getDepartementAtDistance(double distance) {
        return Recherche.getDepartementAtPoint(Geometry.rechercherPointDistance(this, distance));
    }

    public boolean estDepartementProche(LocalisantPr pr, double distance) {
        return Recherche.estDepartementProche(pr, Geometry.rechercherPointDistance(this, distance));
    }

    public void modifier(String[] valeurs) {
        this.modifier(valeurs, LocalisationInfo.appliquerChangementFinRoute);
    }

    public void modifier(String[] valeurs, boolean appliquer) {
        if (this.couche != null && valeurs != null && this.troncon != null) {
            this.valeurs = valeurs;
            if (appliquer) {
                this.couche.getDon().modifieEnreg(this.troncon.getNum(), this.valeurs);
            }
        }
    }

    public void ajouterAlertc(LocalisantAlertc alertcAAjouter) {
        if (alertcAAjouter != null && !alertcAAjouter.estVide()) {
            String champLocalisantAlertc = "";
            String champDistanceAlertc = "";
            for (LocalisantAlertc alertc : this.getAlertc(false)) {
                if (alertc.equals(alertcAAjouter)) continue;
                champLocalisantAlertc = champLocalisantAlertc.concat(String.valueOf(alertc.getEntiteAlertc().getLocalisant())).concat(";");
                champDistanceAlertc = champDistanceAlertc.concat(String.valueOf(alertc.getDistanceAlertc())).concat(";");
            }
            champLocalisantAlertc = champLocalisantAlertc.concat(String.valueOf(alertcAAjouter.getEntiteAlertc().getLocalisant()));
            champDistanceAlertc = champDistanceAlertc.concat(String.valueOf(alertcAAjouter.getDistanceAlertc()));
            this.valeurs[8] = champLocalisantAlertc;
            this.valeurs[9] = champDistanceAlertc;
            LocalisationInfo.ecrireLog("AJOUT ALERTC " + champLocalisantAlertc + " -- " + champDistanceAlertc);
            this.modifier(this.valeurs);
        }
    }

    public void ajouterPr(LocalisantPr prAAjouter) {
        if (prAAjouter != null && !prAAjouter.estVide()) {
            String champLocalisantPr = "";
            String champDistancePr = "";
            for (LocalisantPr pr : this.getPR(false)) {
                if (pr.equals(prAAjouter)) continue;
                champLocalisantPr = champLocalisantPr.concat(String.valueOf(pr.getEntitePr().toString(true))).concat(";");
                champDistancePr = champDistancePr.concat(String.valueOf(pr.getDistancePr())).concat(";");
            }
            champLocalisantPr = champLocalisantPr.concat(String.valueOf(prAAjouter.getEntitePr().toString(true)));
            champDistancePr = champDistancePr.concat(String.valueOf(prAAjouter.getDistancePr()));
            this.valeurs[6] = champLocalisantPr;
            this.valeurs[7] = champDistancePr;
            LocalisationInfo.ecrireLog("AJOUT PR " + champLocalisantPr + " -- " + champDistancePr);
            this.modifier(this.valeurs);
        }
    }

    public int getAbscisseMinimum() {
        if (this.inverse) {
            return this.getLongueur();
        }
        return 0;
    }

    public int getAbscisseMaximum() {
        return this.getLongueur();
    }

    public void deplacerAlertc(LocalisantAlertc alertcADeplacer, InfoTroncon tronconDestination) {
        if (alertcADeplacer != null && tronconDestination != null) {
            this.supprimerAlertc(alertcADeplacer);
            tronconDestination.ajouterAlertc(alertcADeplacer);
        }
    }

    public void deplacerPr(LocalisantPr prADeplacer, InfoTroncon tronconDestination) {
        if (prADeplacer != null && tronconDestination != null) {
            this.supprimerPr(prADeplacer);
            tronconDestination.ajouterPr(prADeplacer);
        }
    }

    public void supprimerPr(LocalisantPr prASupprimer) {
        if (prASupprimer != null && !prASupprimer.estVide()) {
            LocalisantPr pr;
            Vector<LocalisantPr> listePr = this.getPR(false);
            String champLocalisantPr = "";
            String champDistancePr = "";
            listePr.removeElement(prASupprimer);
            int i = listePr.size() - 1;
            while (i >= 0) {
                pr = listePr.get(i);
                if (pr.equals(prASupprimer)) {
                    listePr.remove(i);
                }
                --i;
            }
            i = 0;
            while (i < listePr.size() - 1) {
                pr = listePr.get(i);
                champLocalisantPr = champLocalisantPr.concat(String.valueOf(pr.getEntitePr().toString(true))).concat(";");
                champDistancePr = champDistancePr.concat(String.valueOf(pr.getDistancePr())).concat(";");
                ++i;
            }
            if (!GLS.estVide(listePr)) {
                pr = listePr.lastElement();
                champLocalisantPr = champLocalisantPr.concat(String.valueOf(pr.getEntitePr().toString(true)));
                champDistancePr = champDistancePr.concat(String.valueOf(pr.getDistancePr()));
            }
            this.valeurs[6] = champLocalisantPr;
            this.valeurs[7] = champDistancePr;
            LocalisationInfo.ecrireLog("AJOUT PR " + champLocalisantPr + " -- " + champDistancePr);
            this.modifier(this.valeurs);
        }
    }

    public void supprimerAlertc(LocalisantAlertc alertcASupprimer) {
        if (alertcASupprimer != null) {
            LocalisantAlertc alertc;
            String champLocalisantAlertc = "";
            String champDistanceAlertc = "";
            Vector<LocalisantAlertc> listeAlertc = this.getAlertc(false);
            int i = listeAlertc.size() - 1;
            while (i >= 0) {
                alertc = listeAlertc.get(i);
                if (alertc.equals(alertcASupprimer)) {
                    listeAlertc.remove(i);
                }
                --i;
            }
            i = 0;
            while (i < listeAlertc.size() - 1) {
                alertc = listeAlertc.get(i);
                try {
                    champLocalisantAlertc = champLocalisantAlertc.concat(String.valueOf(alertc.getEntiteAlertc().getLocalisant())).concat(";");
                    champDistanceAlertc = champDistanceAlertc.concat(String.valueOf(alertc.getDistanceAlertc())).concat(";");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (!GLS.estVide(listeAlertc)) {
                alertc = listeAlertc.get(listeAlertc.size() - 1);
                try {
                    champLocalisantAlertc = champLocalisantAlertc.concat(String.valueOf(alertc.getEntiteAlertc().getLocalisant()));
                    champDistanceAlertc = champDistanceAlertc.concat(String.valueOf(alertc.getDistanceAlertc()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.valeurs[8] = champLocalisantAlertc;
            this.valeurs[9] = champDistanceAlertc;
            LocalisationInfo.ecrireLog("SUPPRIME ALERTC " + champLocalisantAlertc + " -- " + champDistanceAlertc);
            this.modifier(this.valeurs);
        }
    }

    public void appliquerModifications() {
        if (this.valeurs != null) {
            this.couche.getDon().modifieEnreg(this.troncon.getNum(), this.valeurs);
        }
    }

    public String getNom() {
        if (this.troncon != null) {
            return this.getValeur(1);
        }
        return null;
    }

    public Vector getReferentiels(int champReferentiel) {
        return LocalisationInfo.recupDonneesLocalisation(this.getValeur(champReferentiel));
    }

    public Vector getAbscissesReferentiel(int champAbscisseReferentiel) {
        return this.getAbscissesReferentiel(champAbscisseReferentiel, this.appliquerInversion);
    }

    public Vector getAbscissesReferentiel(int champAbscisseReferentiel, boolean appliquerInversion) {
        int longueurTroncon;
        Vector listeAbscisses = LocalisationInfo.recupDonneesLocalisation(this.getValeur(champAbscisseReferentiel));
        if (appliquerInversion && this.inverse && listeAbscisses.size() > 0 && (longueurTroncon = this.getLongueur()) != -1) {
            int i = 0;
            while (i < listeAbscisses.size()) {
                listeAbscisses.setElementAt(String.valueOf(longueurTroncon - Integer.parseInt((String)listeAbscisses.get(i))), i);
                ++i;
            }
        }
        return listeAbscisses;
    }

    public GeoPositionnement getPositionnement(LocalisantAlertc alertc) {
        GeoPositionnement position = this.getPositionnement(alertc.getDistanceAlertc());
        if (position != null) {
            position.setObjet(alertc);
        }
        return position;
    }

    public GeoPositionnement getPositionnement(LocalisantPr pr) {
        GeoPositionnement position = this.getPositionnement(pr.getDistancePr());
        if (position != null) {
            position.setObjet(pr);
        }
        return position;
    }

    public GeoPositionnement getPositionnement(long distance) {
        LocalisationInfo.ecrireLog("+--> Distance " + distance);
        if (this.troncon != null && !LocalisationInfo.estNulle(distance)) {
            return new GeoPositionnement(this, distance);
        }
        return null;
    }

    public boolean estPR() {
        if (this.troncon != null) {
            return !this.getValeur(6).equals("");
        }
        return false;
    }

    public Vector<LocalisantPr> getPR() {
        return this.getPR(this.appliquerInversion);
    }

    public Vector<LocalisantPr> getPR(boolean appliquerInversion) {
        Vector listePR = this.getReferentiels(6);
        Vector<LocalisantPr> listeLocalisantPR = new Vector<LocalisantPr>();
        Vector listeDistancePR = this.getAbscissesReferentiel(7, appliquerInversion);
        if (listePR.size() == listeDistancePR.size()) {
            int i = 0;
            while (i < listePR.size()) {
                LocalisantPr pr = new LocalisantPr((String)listePR.get(i), (String)listeDistancePR.get(i));
                listeLocalisantPR.add(pr);
                ++i;
            }
        } else {
            GLS.getLogs().error((Object)("### ERREUR INFO LOCALISATION PR # CAUSE " + listePR.size() + " <> " + listeDistancePR.size() + " # IDGDF " + this.getIdgdf() + " # PR " + this.getValeur(6) + " # ABSCISSES " + this.getValeur(7)));
        }
        return listeLocalisantPR;
    }

    public LocalisantPr getPR(int i) {
        Vector<LocalisantPr> listeLocalisantPR = this.getPR();
        if (i < listeLocalisantPR.size() && i >= 0) {
            return listeLocalisantPR.get(i);
        }
        return null;
    }

    public GeoPositionnement getPositionnementPR(LocalisantPr prRecherche) {
        return this.getPositionnementPR(prRecherche, true);
    }

    public GeoPositionnement getPositionnementPR(LocalisantPr prRecherche, boolean testBaionnette) {
        LocalisantPr pr = this.getPR(prRecherche, testBaionnette);
        if (pr != null) {
            return this.getPositionnement(pr);
        }
        return null;
    }

    public LocalisantPr getPrMin() {
        return this.getPrMin(null, -1L, Long.MAX_VALUE);
    }

    public LocalisantPr getPrMin(LocalisantPr prAEviter) {
        return this.getPrMin(prAEviter, -1L, Long.MAX_VALUE);
    }

    public LocalisantPr getPrMin(long distanceMinimum) {
        return this.getPrMin(null, distanceMinimum, Long.MAX_VALUE);
    }

    public LocalisantPr getPrMin(long distanceMinimum, long distanceMaximum) {
        return this.getPrMin(null, distanceMinimum, distanceMaximum);
    }

    public LocalisantPr getPrMin(LocalisantPr prAEviter, long distanceMinimum, long distanceMaximum) {
        if (this.estPR()) {
            int i = 0;
            long distanceMin = distanceMinimum;
            long distanceMax = distanceMaximum;
            long distanceOk = Long.MAX_VALUE;
            LocalisantPr pr = null;
            LocalisantPr prProche = null;
            Vector<LocalisantPr> listePr = this.getPR();
            i = 0;
            while (i < listePr.size()) {
                pr = listePr.get(i);
                long distancePr = pr.getDistancePr();
                if (distancePr >= distanceMin && distancePr < distanceMax && !pr.equals(prAEviter, pr.estAbscisseNegatif()) && distancePr < distanceOk) {
                    distanceOk = pr.getDistancePr();
                    prProche = pr;
                }
                ++i;
            }
            return prProche;
        }
        return null;
    }

    public LocalisantPr getPrMax() {
        return this.getPrMax(null, -1L, Long.MAX_VALUE);
    }

    public LocalisantPr getPrMax(long distanceMax) {
        return this.getPrMax(null, -1L, distanceMax);
    }

    public LocalisantPr getPrMax(long distanceMin, long distanceMax) {
        return this.getPrMax(null, distanceMin, distanceMax);
    }

    public LocalisantPr getPrMax(LocalisantPr prAEviter) {
        return this.getPrMax(prAEviter, -1L, Long.MAX_VALUE);
    }

    public LocalisantPr getPrMax(LocalisantPr prAEviter, long distanceMinimum, long distanceMaximum) {
        if (this.estPR()) {
            boolean trouve = false;
            boolean fin = false;
            int i = 0;
            long distanceMin = distanceMinimum;
            long distanceMax = distanceMaximum;
            long distanceOk = -1L;
            LocalisantPr pr = null;
            LocalisantPr prProche = null;
            Vector<LocalisantPr> listePr = this.getPR();
            i = 0;
            while (i < listePr.size()) {
                pr = listePr.get(i);
                long distancePr = pr.getDistancePr();
                if (distancePr <= distanceMax && distancePr > distanceMin && !pr.equals(prAEviter, pr.estAbscisseNegatif()) && distancePr > distanceOk) {
                    distanceOk = distancePr;
                    prProche = pr;
                }
                ++i;
            }
            return prProche;
        }
        return null;
    }

    public LocalisantPr getPR(LocalisantPr prRecherche) {
        return this.getPR(prRecherche, true);
    }

    public LocalisantPr getPR(LocalisantPr prRecherche, boolean testBaionnette) {
        if (prRecherche != null && this.estPR()) {
            boolean trouve = false;
            int i = 0;
            LocalisantPr pr = null;
            Vector<LocalisantPr> listePR = this.getPR();
            boolean fin = GLS.estVide(listePR);
            while (!trouve && !fin) {
                pr = listePR.get(i);
                LocalisationInfo.ecrireLogDebug("PR RECHERCHE " + prRecherche + " - PR " + pr + " " + prRecherche.equals(pr));
                if (prRecherche.equals(pr.getEntitePr(), testBaionnette)) {
                    if (prRecherche.aDepartement() && !pr.aDepartement()) {
                        if (prRecherche.getDepartement() == this.getDepartementAtDistance(pr.getDistancePr())) {
                            trouve = true;
                        }
                    } else {
                        trouve = true;
                    }
                }
                boolean bl = fin = ++i == listePR.size();
            }
            listePR = null;
            if (trouve) {
                return pr;
            }
            pr = null;
            return null;
        }
        return null;
    }

    public boolean estAlertc() {
        if (this.troncon != null) {
            return !this.getValeur(8).equals("");
        }
        return false;
    }

    public GeoPositionnement getPositionnementAlertc(LocalisantAlertc alertcRecherche) {
        LocalisantAlertc alertc = this.getAlertc(alertcRecherche);
        if (alertc != null) {
            return this.getPositionnement(alertc);
        }
        return null;
    }

    public Vector<LocalisantAlertc> getAlertc() {
        return this.getAlertc(this.appliquerInversion);
    }

    public Vector<LocalisantAlertc> getAlertc(boolean appliquerInversion) {
        Vector listeAlertc = this.getReferentiels(8);
        Vector<LocalisantAlertc> listeLocalisantAlertc = new Vector<LocalisantAlertc>();
        Vector listeDistanceAlertc = this.getAbscissesReferentiel(9, appliquerInversion);
        if (listeAlertc.size() == listeDistanceAlertc.size()) {
            int i = 0;
            while (i < listeAlertc.size()) {
                listeLocalisantAlertc.add(new LocalisantAlertc((String)listeAlertc.get(i), (String)listeDistanceAlertc.get(i)));
                ++i;
            }
        } else {
            GLS.getLogs().error((Object)("### ERREUR INFO LOCALISATION ALERTC # CAUSE " + listeAlertc.size() + " <> " + listeDistanceAlertc.size() + " # IDGDF " + this.getIdgdf() + " # ALERTC " + this.getValeur(8) + " # ABSCISSES " + this.getValeur(9)));
        }
        return listeLocalisantAlertc;
    }

    public LocalisantAlertc getAlertc(int i) {
        Vector<LocalisantAlertc> listeLocalisantAlertc = this.getAlertc();
        if (i < listeLocalisantAlertc.size() && i >= 0) {
            return listeLocalisantAlertc.get(i);
        }
        return null;
    }

    public LocalisantAlertc getAlertc(LocalisantAlertc alertcRecherche) {
        if (alertcRecherche != null && this.estAlertc()) {
            boolean trouve = false;
            boolean fin = false;
            int i = 0;
            LocalisantAlertc alertc = null;
            Vector<LocalisantAlertc> listeAlertc = this.getAlertc();
            while (!trouve && !fin) {
                alertc = listeAlertc.get(i);
                if (alertcRecherche.equals(alertc.getEntiteAlertc())) {
                    trouve = true;
                }
                boolean bl = fin = ++i == listeAlertc.size();
            }
            if (trouve) {
                return alertc;
            }
            return null;
        }
        return null;
    }

    public boolean aAlertcDebut() {
        try {
            LocalisantAlertc alertcDebut = this.getAlertcDebut();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean aPrDebut() {
        try {
            LocalisantPr prDebut = this.getPrDebut();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean aPrFin() {
        try {
            LocalisantPr prFin = this.getPrFin();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean estAlertcFin(InfoTroncon troncon, LocalisantAlertc alertc) {
        return InfoTroncon.estAlertcFin(troncon, alertc, true);
    }

    public static boolean estAlertcDebut(InfoTroncon troncon, LocalisantAlertc alertc) {
        return InfoTroncon.estAlertcDebut(troncon, alertc, true);
    }

    public static boolean estAlertcFin(InfoTroncon troncon, LocalisantAlertc alertc, boolean inverser) {
        if (inverser) {
            return InfoTroncon.estAlertcFin(troncon, alertc, troncon.getAbscisseMaximum());
        }
        return InfoTroncon.estAlertcFin(troncon, alertc, troncon.getLongueur());
    }

    public static boolean estAlertcDebut(InfoTroncon troncon, LocalisantAlertc alertc, boolean inverser) {
        if (inverser) {
            return InfoTroncon.estAlertcDebut(troncon, alertc, troncon.getAbscisseMinimum());
        }
        return InfoTroncon.estAlertcDebut(troncon, alertc, 0.0);
    }

    private static boolean estAlertcFin(InfoTroncon troncon, LocalisantAlertc alertc, double abscisseMaximum) {
        if (troncon != null && alertc != null) {
            return (double)alertc.getDistanceAlertc() == abscisseMaximum;
        }
        return false;
    }

    private static boolean estAlertcDebut(InfoTroncon troncon, LocalisantAlertc alertc, double abscisseMinimum) {
        if (alertc != null) {
            return (double)alertc.getDistanceAlertc() == abscisseMinimum;
        }
        return false;
    }

    public boolean aAlertcFin() {
        try {
            LocalisantAlertc alertcFin = this.getAlertcFin();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public LocalisantAlertc getAlertcDebut() throws Exception {
        LocalisantAlertc alertcMin = this.getAlertcMin();
        if (alertcMin.getDistanceAlertc() == (long)this.getAbscisseMinimum()) {
            return alertcMin;
        }
        throw new Exception("AUCUN POINT ALERTC EN DEBUT DE TRONCON");
    }

    public LocalisantPr getPrDebut() throws Exception {
        LocalisantPr prMin = this.getPrMin();
        if (prMin.getDistancePr() == 0L) {
            return prMin;
        }
        throw new Exception("AUCUN PR EN DEBUT DE TRONCON");
    }

    public LocalisantPr getPrFin() throws Exception {
        LocalisantPr prMax = this.getPrMax();
        if (prMax.getDistancePr() == (long)this.getAbscisseMaximum()) {
            return prMax;
        }
        throw new Exception("AUCUN PR EN FIN DE TRONCON");
    }

    public LocalisantAlertc getAlertcFin() throws Exception {
        LocalisantAlertc alertcMax = this.getAlertcMax();
        if (alertcMax.getDistanceAlertc() == (long)this.getAbscisseMaximum()) {
            return alertcMax;
        }
        throw new Exception("AUCUN POINT ALERTC EN FIN DE TRONCON");
    }

    public LocalisantAlertc getAlertcMin() {
        return this.getAlertcMin(null, -1L, Long.MAX_VALUE);
    }

    public LocalisantAlertc getAlertcMin(LocalisantAlertc alertcAEviter) {
        return this.getAlertcMin(alertcAEviter, -1L, Long.MAX_VALUE);
    }

    public LocalisantAlertc getAlertcMin(long distanceMinimum) {
        return this.getAlertcMin(null, distanceMinimum, Long.MAX_VALUE);
    }

    public LocalisantAlertc getAlertcMin(long distanceMinimum, long distanceMaximum) {
        return this.getAlertcMin(null, distanceMinimum, distanceMaximum);
    }

    public LocalisantAlertc getAlertcMin(LocalisantAlertc alertcAEviter, long distanceMinimum, long distanceMaximum) {
        if (this.estAlertc()) {
            int i = 0;
            long distanceMin = distanceMinimum;
            long distanceMax = distanceMaximum;
            long distanceOk = Long.MAX_VALUE;
            LocalisantAlertc alertc = null;
            LocalisantAlertc alertcProche = null;
            Vector<LocalisantAlertc> listeAlertc = this.getAlertc();
            i = 0;
            while (i < listeAlertc.size()) {
                alertc = listeAlertc.get(i);
                long distanceAlertc = alertc.getDistanceAlertc();
                if (distanceAlertc >= distanceMin && distanceAlertc < distanceMax && !alertc.equals(alertcAEviter) && distanceAlertc < distanceOk) {
                    distanceOk = alertc.getDistanceAlertc();
                    alertcProche = alertc;
                }
                ++i;
            }
            return alertcProche;
        }
        return null;
    }

    public LocalisantAlertc getAlertcMax() {
        return this.getAlertcMax(null, -1L, Long.MAX_VALUE);
    }

    public LocalisantAlertc getAlertcMax(long distanceMax) {
        return this.getAlertcMax(null, -1L, distanceMax);
    }

    public LocalisantAlertc getAlertcMax(long distanceMin, long distanceMax) {
        return this.getAlertcMax(null, distanceMin, distanceMax);
    }

    public LocalisantAlertc getAlertcMax(LocalisantAlertc alertcAEviter) {
        return this.getAlertcMax(alertcAEviter, -1L, Long.MAX_VALUE);
    }

    public LocalisantAlertc getAlertcMax(LocalisantAlertc alertcAEviter, long distanceMinimum, long distanceMaximum) {
        if (this.estAlertc()) {
            int i = 0;
            long distanceMin = distanceMinimum;
            long distanceMax = distanceMaximum;
            long distanceOk = -1L;
            LocalisantAlertc alertc = null;
            LocalisantAlertc alertProche = null;
            Vector<LocalisantAlertc> listeAlertc = this.getAlertc();
            i = 0;
            while (i < listeAlertc.size()) {
                alertc = listeAlertc.get(i);
                long distanceAlertc = alertc.getDistanceAlertc();
                LocalisationInfo.ecrireLog("LOC ALERTC MAX " + alertc + " - " + distanceMinimum + " - " + distanceMaximum);
                if (distanceAlertc <= distanceMax && distanceAlertc > distanceMin && !alertc.equals(alertcAEviter) && distanceAlertc > distanceOk) {
                    distanceOk = distanceAlertc;
                    alertProche = alertc;
                }
                ++i;
            }
            return alertProche;
        }
        return null;
    }

    public GeoPoint getIntersectionPoint(InfoTroncon infoTroncon) throws Exception {
        return Geometry.getIntersectionPoint(this, infoTroncon);
    }

    public boolean estUnRondPoint() {
        return LocalisationInfo.estTronconRondPoint(this.troncon);
    }

    public boolean estADoubleSens() {
        return LocalisationInfo.estTronconDoubleSens(this.troncon);
    }

    public boolean estASensUnique() {
        return LocalisationInfo.estTronconSensUnique(this.troncon);
    }

    public float[] inverserCoordonnees(float[] listePoints) {
        int nbPoints = listePoints.length;
        float[] listePointsInverse = new float[nbPoints];
        int i = nbPoints - 1;
        while (i >= 0) {
            listePointsInverse[nbPoints - 1 - i] = listePoints[i];
            --i;
        }
        return listePointsInverse;
    }

    public boolean estNull() {
        return this.troncon == null && this.couche == null;
    }

    public boolean equals(InfoTroncon troncon) {
        try {
            return !this.estNull() && !troncon.estNull() && this.idgdf.equals(troncon.getIdgdf());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equals(Enregistrement troncon) {
        try {
            return !this.estNull() && troncon != null && this.idgdf.equals(troncon.getValeur(0));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setValeurs(String[] valeurs) {
        this.valeurs = valeurs;
    }
}

