/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation;

import cartoj.IFichierDon;
import gls.localisation.InfoDepartement;
import gls.localisation.LocalisationInfo;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;

public class InfoDepartements
extends Vector<InfoDepartement> {
    public InfoDepartements() {
        this(false);
    }

    public InfoDepartements(boolean filtre) {
        TreeMap departements = new TreeMap(new Comparator<InfoDepartement>(){
            Collator compareOperator = Collator.getInstance(Locale.FRENCH);

            @Override
            public int compare(InfoDepartement arg0, InfoDepartement arg1) {
                return this.compareOperator.compare(arg0.getNom(), arg1.getNom());
            }
        });
        if (LocalisationInfo.aCoucheDepartement) {
            IFichierDon donDepartement = LocalisationInfo.getDonDepartement();
            int i = 0;
            while (i < donDepartement.getNbval()) {
                InfoDepartement infoDepartement = new InfoDepartement(donDepartement.getEnreg(i));
                if (infoDepartement.estValide()) {
                    this.add(infoDepartement);
                    departements.put(infoDepartement, new Vector());
                }
                ++i;
            }
            if (filtre) {
                this.removeAllElements();
                for (InfoDepartement tmp : departements.keySet()) {
                    this.add(tmp);
                }
            }
        }
    }

    public InfoDepartements(String[] listeNumeros) {
        if (listeNumeros != null && listeNumeros.length > 0) {
            int i = 0;
            while (i < listeNumeros.length) {
                InfoDepartement infoDepartement = LocalisationInfo.getListeDepartements().getDepartement(listeNumeros[i]);
                if (infoDepartement != null && infoDepartement.estValide()) {
                    this.add(infoDepartement);
                }
                ++i;
            }
        }
    }

    public boolean estVide() {
        return !LocalisationInfo.aCoucheDepartement || this.isEmpty();
    }

    public InfoDepartement getDepartement(int numero) {
        return this.getDepartement(String.valueOf(numero));
    }

    public InfoDepartement getDepartement(String numero) {
        InfoDepartement infoDepartement = null;
        if (!LocalisationInfo.estNulle(numero)) {
            InfoDepartement infoDepartementTmp = null;
            boolean trouve = false;
            int i = 0;
            boolean fin = this.size() == 0;
            while (!trouve && !fin) {
                infoDepartementTmp = (InfoDepartement)this.get(i);
                LocalisationInfo.ecrireLogDebug("NUM DPT " + infoDepartementTmp.getNumero() + " -- " + numero);
                if (infoDepartementTmp.getNumero().equals(numero)) {
                    infoDepartement = infoDepartementTmp;
                    trouve = true;
                }
                boolean bl = fin = ++i == this.size();
            }
        }
        return infoDepartement;
    }
}

