/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation;

import cartoj.Enregistrement;
import gls.outils.GLS;

public class InfoDepartement {
    private Enregistrement departement;
    private String nom;
    private String numero;

    public InfoDepartement() {
        this.initialisation();
    }

    public InfoDepartement(Enregistrement enregistrement) {
        this.initialisation(enregistrement);
    }

    private void initialisation() {
        this.initialisation(null, null, null);
    }

    private void initialisation(Enregistrement enregistrement) {
        if (enregistrement != null) {
            try {
                this.initialisation(enregistrement, enregistrement.getValeur(0), enregistrement.getValeur(1));
            }
            catch (Exception e) {
                this.initialisation();
            }
        } else {
            this.initialisation();
        }
    }

    private void initialisation(Enregistrement enregistrement, String nom, String numero) {
        this.nom = nom;
        this.numero = numero;
        this.departement = enregistrement;
    }

    public boolean estValide() {
        return this.departement != null && !GLS.estVide(this.nom) && !GLS.estVide(this.numero);
    }

    public String getNom() {
        return this.nom;
    }

    public String getNumero() {
        return this.numero;
    }

    public String toString() {
        return String.valueOf(this.nom) + " (" + this.numero + ")";
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof InfoDepartement) {
                return this.equals((InfoDepartement)object);
            }
            if (object instanceof String) {
                return GLS.egal((Object)this.nom, object) || GLS.egal(object, (Object)this.numero);
            }
            return false;
        }
        return false;
    }

    public boolean equals(InfoDepartement infoDepartement) {
        if (infoDepartement != null) {
            return this.numero.equals(infoDepartement.getNumero());
        }
        return false;
    }

    public Enregistrement getDepartement() {
        return this.departement;
    }

    public void setDepartement(Enregistrement departement) {
        this.departement = departement;
    }
}

