/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation;

import gls.geometry.GeoPositionnement;
import gls.localisation.InfoTroncon;
import gls.localisation.Localisation;
import gls.localisation.LocalisationInfo;
import gls.localisation.alertc.GestionAlertc;
import gls.localisation.alertc.LocalisantAlertc;
import gls.localisation.exception.ErreurAlertc;
import gls.localisation.exception.ErreurPR;
import gls.localisation.pr.EntitePr;
import gls.localisation.pr.GestionPr;
import gls.localisation.pr.LocalisantPr;
import gls.localisation.recherche.Recherche;
import gls.localisation.tri.TriRoute;
import java.util.Vector;

public class GestionRoute {
    private Localisation localisation = null;

    public GestionRoute(Localisation localisation) {
        this.localisation = localisation;
    }

    public void traitementReferentiels() {
        this.traitementAlertc();
        this.traitementPrpk();
    }

    public void traitementAlertc() {
        if (this.localisation != null) {
            if (LocalisationInfo.estLocalisableParAlertc && this.localisation.getRechercheAlertc()) {
                this.localisation.setEstRouteAlertc(this.localisation.getTriRoute().getTronconDepart().getValeur(5).equals("1"));
                LocalisationInfo.ecrireLog("+--> est alertc " + this.localisation.getEstRouteAlertc());
                if (this.localisation.getEstRouteAlertc() && LocalisationInfo.gestionFinRoute && !this.localisation.getTriRoute().estRocade()) {
                    try {
                        this.verificationExtrimiteRouteAlertc(this.localisation);
                    }
                    catch (ErreurAlertc erreur) {
                        LocalisationInfo.ecrireLog("#--> ERREUR ALERTC " + erreur);
                        this.localisation.setEstRouteAlertc(false);
                    }
                    catch (Exception erreur) {
                        LocalisationInfo.ecrireLog("#--> ERREUR ALERTC INCONNUE " + erreur);
                        erreur.printStackTrace();
                        this.localisation.setEstRouteAlertc(false);
                    }
                }
                if (this.localisation.getEstRouteAlertc()) {
                    try {
                        this.gestionSensAlertc(this.localisation.getTriRoute());
                    }
                    catch (ErreurAlertc erreur) {
                        LocalisationInfo.ecrireLog(erreur.toString());
                    }
                    catch (Exception erreur) {
                        LocalisationInfo.ecrireLog("ERREUR INCONNUE " + erreur.toString());
                    }
                }
                LocalisationInfo.ecrireLog("+--> est alert apres " + this.localisation.getEstRouteAlertc());
            } else {
                this.localisation.setEstRouteAlertc(false);
            }
        }
    }

    public void traitementPrpk() {
        if (this.localisation != null) {
            if (LocalisationInfo.estLocalisableParPrpk && this.localisation.getRecherchePrpk()) {
                try {
                    this.gestionSensPrpk(this.localisation.getTriRoute());
                }
                catch (ErreurPR erreur) {
                    LocalisationInfo.ecrireLog(erreur.toString());
                }
                catch (Exception erreur) {
                    LocalisationInfo.ecrireLog("ERREUR INCONNUE " + erreur.toString());
                }
                if (this.localisation.getEstRoutePrpk() && LocalisationInfo.gestionFinRoute && !this.localisation.getTriRoute().estRocade()) {
                    try {
                        this.traitementFinRoutePrpk(this.localisation);
                    }
                    catch (ErreurPR erreur) {
                        LocalisationInfo.ecrireLog(erreur.toString());
                    }
                    catch (Exception erreur) {
                        LocalisationInfo.ecrireLog("ERREUR INCONNUE " + erreur.toString());
                    }
                }
            } else {
                this.localisation.setEstRoutePrpk(false);
            }
        }
    }

    public void verificationExtrimiteRouteAlertc(Localisation localisation) throws ErreurAlertc, Exception {
        TriRoute triRoute = localisation.getTriRoute();
        if (!triRoute.estRocade()) {
            InfoTroncon premierTroncon = triRoute.getPremierTroncon();
            InfoTroncon dernierTroncon = triRoute.getDernierTroncon();
            LocalisantAlertc premierPointAlertc = null;
            LocalisantAlertc dernierPointAlertc = null;
            if (premierTroncon.estAlertc()) {
                premierPointAlertc = premierTroncon.getAlertcMin();
                if (InfoTroncon.estAlertcDebut(premierTroncon, premierPointAlertc, false)) {
                    LocalisationInfo.ecrireLog("LE POINT ALERTC DE DEBUT EST BIEN PLACE " + premierTroncon.getIdgdf());
                } else {
                    premierPointAlertc.setDistanceAlertc(premierTroncon.getAbscisseMinimum());
                    premierTroncon.ajouterAlertc(premierPointAlertc);
                    LocalisationInfo.ecrireLog("LE POINT ALERTC " + premierPointAlertc + " ETAIT MAL PLACE SUR LE PREMIER TRONCON " + premierTroncon.getIdgdf());
                }
            } else {
                InfoTroncon premierTronconAlertc = triRoute.getPremierTronconAlertc();
                premierPointAlertc = premierTronconAlertc.getAlertcMin();
                premierPointAlertc.setDistanceAlertc(premierTroncon.getAbscisseMinimum());
                premierTronconAlertc.deplacerAlertc(premierPointAlertc, premierTroncon);
                LocalisationInfo.ecrireLog("LE POINT ALERTC " + premierPointAlertc + " A ETE DEPLACE DU TRONCON " + premierTronconAlertc.getIdgdf() + " AU TRONCON " + premierTroncon.getIdgdf());
            }
            if (premierPointAlertc == null) {
                throw new ErreurAlertc("AUCUN POINT ALERTC TROUVE EN DEBUT DE ROUTE");
            }
            if (dernierTroncon.estAlertc()) {
                dernierPointAlertc = dernierTroncon.getAlertcMax();
                if (InfoTroncon.estAlertcFin(dernierTroncon, dernierPointAlertc, false)) {
                    LocalisationInfo.ecrireLog("LE POINT ALERTC DE FIN EST BIEN PLACE " + dernierTroncon.getIdgdf());
                } else {
                    dernierPointAlertc.setDistanceAlertc(dernierTroncon.getAbscisseMaximum());
                    dernierTroncon.ajouterAlertc(dernierPointAlertc);
                    LocalisationInfo.ecrireLog("LE POINT ALERTC " + dernierPointAlertc + " ETAIT MAL PLACE SUR LE DERNIER TRONCON " + dernierTroncon.getIdgdf());
                }
            } else {
                InfoTroncon dernierTronconAlertc = triRoute.getDernierTronconAlertc();
                dernierPointAlertc = dernierTronconAlertc.getAlertcMax();
                dernierPointAlertc.setDistanceAlertc(dernierTroncon.getAbscisseMaximum());
                dernierTronconAlertc.deplacerAlertc(dernierPointAlertc, dernierTroncon);
                LocalisationInfo.ecrireLog("LE POINT ALERTC " + dernierPointAlertc + " A ETE DEPLACE DU TRONCON " + dernierTronconAlertc.getIdgdf() + " AU TRONCON " + dernierTroncon.getIdgdf());
            }
            if (dernierPointAlertc == null) {
                throw new ErreurAlertc("AUCUN POINT ALERTC TROUVE EN FIN DE ROUTE");
            }
            if (premierPointAlertc.equals(dernierPointAlertc.getEntiteAlertc())) {
                LocalisationInfo.ecrireLog("ERREUR LES POINTS ALERTC DE DEBUT ET DE FIN DE ROUTE SONT LES MEMES " + premierPointAlertc + " --> " + dernierPointAlertc);
            } else {
                LocalisationInfo.ecrireLog("LA ROUTE EST LOCALISABLE EN ALERTC " + premierPointAlertc + " --> " + dernierPointAlertc);
            }
        } else {
            LocalisationInfo.ecrireLog("LA ROUTE EST UNE ROCADE - LA RECHERCHE DES POINTS ALERTC N'EST PAS NECESSAIRE");
        }
    }

    public void traitementFinRouteAlertc(Localisation localisation) throws ErreurAlertc, Exception {
        boolean sensRouteAlertcOk;
        boolean estRouteAlertc;
        block91: {
            int distanceAlertcFinOk;
            String distanceAlertcFinOkTroncon;
            InfoTroncon tronconFin;
            double tmpDistance;
            double distanceSelectionnee;
            int indiceLocalisant;
            boolean distanceLocalisantTrouve;
            int iDistance;
            boolean estTronconAlertc;
            int distanceAlertcDebutOk;
            String distanceAlertcDebutOkTroncon;
            InfoTroncon tronconDebut;
            Vector tmpListeLocalisant = null;
            Vector tmpDistanceLocalisant = null;
            String premierLocalisant = null;
            String dernierLocalisant = null;
            estRouteAlertc = false;
            sensRouteAlertcOk = false;
            boolean routeMiseAJour = false;
            TriRoute tri = localisation.getTriRoute();
            boolean miseAJourFinRoute = LocalisationInfo.gestionFinRoute;
            Vector listeTronconPrecedent = tri.getTronconsPrecedent();
            Vector listeTronconSuivant = tri.getTronconsSuivant();
            InfoTroncon tronconCourant = tri.getTronconDepart();
            boolean finRoutePrecedent = listeTronconPrecedent.size() == 0;
            boolean finRouteSuivant = listeTronconSuivant.size() == 0;
            LocalisationInfo.ecrireLog("!--> Traitement de la fin de la route -- " + tronconCourant.getIdgdf());
            if (!finRoutePrecedent) {
                tronconDebut = (InfoTroncon)listeTronconPrecedent.get(listeTronconPrecedent.size() - 1);
                tmpDistanceLocalisant = tronconDebut.getAbscissesReferentiel(9);
                if (tronconDebut.estInverse()) {
                    distanceAlertcDebutOkTroncon = tronconDebut.getValeur(4);
                    distanceAlertcDebutOk = tronconDebut.getLongueur();
                } else {
                    distanceAlertcDebutOkTroncon = "0";
                    distanceAlertcDebutOk = 0;
                }
            } else {
                tronconDebut = tronconCourant;
                tmpDistanceLocalisant = tronconCourant.getAbscissesReferentiel(9);
                if (tronconCourant.estInverse()) {
                    distanceAlertcDebutOkTroncon = tronconDebut.getValeur(4);
                    distanceAlertcDebutOk = tronconDebut.getLongueur();
                } else {
                    distanceAlertcDebutOkTroncon = "0";
                    distanceAlertcDebutOk = 0;
                }
            }
            LocalisationInfo.ecrireLog("+--> Init fin de route OK - " + tronconDebut.getIdgdf() + " -- " + tronconDebut.getNum());
            boolean bl = estTronconAlertc = tmpDistanceLocalisant.size() != 0;
            if (estTronconAlertc) {
                iDistance = -1;
                distanceLocalisantTrouve = false;
                indiceLocalisant = -1;
                distanceSelectionnee = Double.MAX_VALUE;
                LocalisationInfo.ecrireLog("+--> Premier troncon alertc");
                while (!distanceLocalisantTrouve && iDistance < tmpDistanceLocalisant.size() - 1) {
                    if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) < distanceSelectionnee)) continue;
                    if (tmpDistance != (double)distanceAlertcDebutOk) {
                        indiceLocalisant = iDistance;
                        distanceSelectionnee = tmpDistance;
                        continue;
                    }
                    indiceLocalisant = iDistance;
                    distanceLocalisantTrouve = true;
                }
                LocalisationInfo.ecrireLog("+--> Recherche distance premier troncon alertc ok " + distanceLocalisantTrouve);
                if (indiceLocalisant != -1) {
                    tmpListeLocalisant = tronconDebut.getReferentiels(8);
                    premierLocalisant = (String)tmpListeLocalisant.get(indiceLocalisant);
                }
                if (miseAJourFinRoute) {
                    if (!distanceLocalisantTrouve) {
                        if (indiceLocalisant != -1) {
                            this.miseAJourDistanceAlertc(tronconDebut, indiceLocalisant, tmpDistanceLocalisant, distanceAlertcDebutOkTroncon);
                            LocalisationInfo.ecrireLog("!--> Le troncon a \u00e9t\u00e9 mis \u00e0 jour - Fin de route g\u00e9r\u00e9e - Aucun troncon avant");
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur mise \u00e0 jour troncon fin de route # " + tronconDebut.getIdgdf() + "  #  " + tronconDebut.getAbscissesReferentiel(9));
                        }
                    } else {
                        LocalisationInfo.ecrireLog("+--> La route a un point alertc bien place au debut de la route");
                    }
                }
            } else {
                int iTroncon = -1;
                InfoTroncon tronconTmp = null;
                int tailleTroncon = listeTronconPrecedent.size();
                LocalisationInfo.ecrireLog("+--> Premier troncon non alertc " + tailleTroncon);
                if (tailleTroncon > 1) {
                    iTroncon = tailleTroncon - 1;
                    while (iTroncon > 0 && !estTronconAlertc) {
                        tronconTmp = (InfoTroncon)listeTronconPrecedent.get(--iTroncon);
                        LocalisationInfo.ecrireLog("+--> Num troncon tmp " + tronconTmp.getNum() + " -- " + tronconTmp.getIdgdf());
                        tmpDistanceLocalisant = tronconTmp.getAbscissesReferentiel(9);
                        boolean bl2 = estTronconAlertc = tmpDistanceLocalisant.size() != 0;
                    }
                }
                if (estTronconAlertc) {
                    LocalisationInfo.ecrireLog("+--> Troncon avant alertc trouve " + tmpDistanceLocalisant.size());
                    iDistance = -1;
                    indiceLocalisant = -1;
                    distanceSelectionnee = Double.MAX_VALUE;
                    while (iDistance < tmpDistanceLocalisant.size() - 1) {
                        LocalisationInfo.ecrireLog("+--> Distance alertc tmp # " + (String)tmpDistanceLocalisant.get(++iDistance));
                        tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(iDistance));
                        if (!(tmpDistance < distanceSelectionnee)) continue;
                        indiceLocalisant = iDistance;
                        distanceSelectionnee = tmpDistance;
                    }
                    LocalisationInfo.ecrireLog("+--> Recherche distance alertc ok ");
                    if (indiceLocalisant != -1) {
                        tmpListeLocalisant = tronconTmp.getReferentiels(8);
                        premierLocalisant = (String)tmpListeLocalisant.get(indiceLocalisant);
                    }
                    if (miseAJourFinRoute) {
                        if (indiceLocalisant != -1) {
                            this.miseAJourDonneesAlertcTroncon(tronconDebut, (String)tmpListeLocalisant.get(indiceLocalisant), distanceAlertcDebutOkTroncon);
                            tmpDistanceLocalisant.remove(indiceLocalisant);
                            tmpListeLocalisant.remove(indiceLocalisant);
                            this.miseAJourDistanceAlertc(tronconTmp, tmpDistanceLocalisant, tmpListeLocalisant);
                            LocalisationInfo.ecrireLog("!--> Le troncon a \u00e9t\u00e9 mis \u00e0 jour - " + tronconTmp.getIdgdf() + " Fin de route g\u00e9r\u00e9e - Troncon avant " + tronconTmp.getReferentiels(8));
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur mise \u00e0 jour troncon fin de route # " + tronconDebut.getIdgdf() + "  #  " + tronconTmp.getAbscissesReferentiel(9));
                        }
                    }
                } else {
                    LocalisationInfo.ecrireLog("+--> Traitement du troncon selectionne");
                    if (tailleTroncon != 0) {
                        tmpDistanceLocalisant = tronconCourant.getAbscissesReferentiel(9);
                        estTronconAlertc = tmpDistanceLocalisant.size() != 0;
                    }
                    LocalisationInfo.ecrireLog("+--> Recherche distance alertc sur le troncon selectionne " + estTronconAlertc);
                    if (estTronconAlertc) {
                        iDistance = -1;
                        indiceLocalisant = -1;
                        distanceSelectionnee = Double.MAX_VALUE;
                        LocalisationInfo.ecrireLog("+--> Troncon selectionne alertc");
                        while (iDistance < tmpDistanceLocalisant.size() - 1) {
                            if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) < distanceSelectionnee)) continue;
                            indiceLocalisant = iDistance;
                            distanceSelectionnee = tmpDistance;
                        }
                        if (indiceLocalisant != -1) {
                            tmpListeLocalisant = tronconCourant.getReferentiels(8);
                            premierLocalisant = (String)tmpListeLocalisant.get(indiceLocalisant);
                        }
                        if (miseAJourFinRoute) {
                            if (indiceLocalisant != -1) {
                                this.miseAJourDonneesAlertcTroncon(tronconDebut, (String)tmpListeLocalisant.get(indiceLocalisant), distanceAlertcDebutOkTroncon);
                                tmpDistanceLocalisant.remove(indiceLocalisant);
                                tmpListeLocalisant.remove(indiceLocalisant);
                                this.miseAJourDistanceAlertc(tronconCourant, tmpDistanceLocalisant, tmpListeLocalisant);
                                LocalisationInfo.ecrireLog("!--> Le troncon a \u00e9t\u00e9 mis \u00e0 jour - Fin de route g\u00e9r\u00e9e - Troncon selectionne " + tronconCourant.getReferentiels(8) + " -- " + tronconCourant.getAbscissesReferentiel(9));
                            } else {
                                LocalisationInfo.ecrireLog("#--> Erreur mise \u00e0 jour troncon fin de route # " + tronconTmp.getIdgdf() + "  #  " + tronconTmp.getAbscissesReferentiel(9));
                            }
                        }
                    } else {
                        tronconTmp = null;
                        tailleTroncon = listeTronconSuivant.size();
                        LocalisationInfo.ecrireLog("+--> Troncon selectionne non alertc " + tailleTroncon);
                        if (tailleTroncon > 0) {
                            iTroncon = -1;
                            while (iTroncon < tailleTroncon - 1 && !estTronconAlertc) {
                                boolean bl3 = estTronconAlertc = (tmpDistanceLocalisant = (tronconTmp = (InfoTroncon)listeTronconSuivant.get(++iTroncon)).getAbscissesReferentiel(9)).size() != 0;
                            }
                            if (estTronconAlertc) {
                                LocalisationInfo.ecrireLog("+--> Troncon suivant alertc OK");
                                iDistance = -1;
                                indiceLocalisant = -1;
                                distanceSelectionnee = Double.MAX_VALUE;
                                while (iDistance < tmpDistanceLocalisant.size() - 1) {
                                    if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) < distanceSelectionnee)) continue;
                                    indiceLocalisant = iDistance;
                                    distanceSelectionnee = tmpDistance;
                                }
                                if (indiceLocalisant != -1) {
                                    tmpListeLocalisant = tronconTmp.getReferentiels(8);
                                    premierLocalisant = (String)tmpListeLocalisant.get(indiceLocalisant);
                                }
                                if (miseAJourFinRoute) {
                                    if (indiceLocalisant != -1) {
                                        this.miseAJourDonneesAlertcTroncon(tronconDebut, (String)tmpListeLocalisant.get(indiceLocalisant), distanceAlertcDebutOkTroncon);
                                        tmpDistanceLocalisant.remove(indiceLocalisant);
                                        tmpListeLocalisant.remove(indiceLocalisant);
                                        this.miseAJourDistanceAlertc(tronconTmp, tmpDistanceLocalisant, tmpListeLocalisant);
                                        LocalisationInfo.ecrireLog("!--> Le troncon a \u00e9t\u00e9 mis \u00e0 jour - Fin de route g\u00e9r\u00e9e - Troncon apres " + tronconTmp.getReferentiels(8) + " -- " + tronconTmp.getAbscissesReferentiel(9));
                                        LocalisationInfo.ecrireLog("!--> Troncon debut apres " + tronconDebut.getReferentiels(8) + " -- " + tronconDebut.getAbscissesReferentiel(9));
                                    } else {
                                        LocalisationInfo.ecrireLog("#--> Erreur mise \u00e0 jour troncon fin de route # " + tronconTmp.getIdgdf() + "  #  " + tronconTmp.getAbscissesReferentiel(9));
                                    }
                                }
                            } else {
                                LocalisationInfo.ecrireLog("#--> ERREUR ALERTC DEBUT ROUTE # IMPOSSIBLE DE METTRE A JOUR LE TRONCON POUR LA FIN DE ROUTE # " + tronconDebut.getIdgdf() + " # LA ROUTE NE CONTIENT AUCUN POINT ALERTC");
                            }
                        } else {
                            LocalisationInfo.ecrireLog("#--> ERREUR ALERTC DEBUT ROUTE # IMPOSSIBLE DE METTRE A JOUR LE TRONCON POUR LA FIN DE ROUTE # " + tronconDebut.getIdgdf() + " # LA ROUTE NE CONTIENT AUCUN POINT ALERTC");
                        }
                    }
                }
            }
            LocalisationInfo.ecrireLog("+--> Nb troncon suivant " + listeTronconSuivant.size());
            if (!finRouteSuivant) {
                tronconFin = (InfoTroncon)listeTronconSuivant.get(listeTronconSuivant.size() - 1);
                tmpDistanceLocalisant = tronconFin.getAbscissesReferentiel(9);
                if (tronconFin.estInverse()) {
                    distanceAlertcFinOkTroncon = "0";
                    distanceAlertcFinOk = 0;
                } else {
                    distanceAlertcFinOkTroncon = tronconFin.getValeur(4);
                    distanceAlertcFinOk = tronconFin.getLongueur();
                }
            } else {
                tronconFin = tronconCourant;
                tmpDistanceLocalisant = tronconCourant.getAbscissesReferentiel(9);
                if (tronconCourant.estInverse()) {
                    distanceAlertcFinOkTroncon = "0";
                    distanceAlertcFinOk = 0;
                } else {
                    distanceAlertcFinOkTroncon = tronconFin.getValeur(4);
                    distanceAlertcFinOk = tronconFin.getLongueur();
                }
            }
            boolean bl4 = estTronconAlertc = tmpDistanceLocalisant.size() != 0;
            if (estTronconAlertc) {
                LocalisationInfo.ecrireLog("+--> Le dernier troncon est alertc");
                iDistance = -1;
                distanceLocalisantTrouve = false;
                indiceLocalisant = -1;
                distanceSelectionnee = -1.0;
                while (!distanceLocalisantTrouve && iDistance < tmpDistanceLocalisant.size() - 1) {
                    if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) > distanceSelectionnee)) continue;
                    if (tmpDistance != (double)distanceAlertcFinOk) {
                        indiceLocalisant = iDistance;
                        distanceSelectionnee = tmpDistance;
                        continue;
                    }
                    indiceLocalisant = iDistance;
                    distanceLocalisantTrouve = true;
                }
                if (indiceLocalisant != -1) {
                    tmpListeLocalisant = tronconFin.getReferentiels(8);
                    dernierLocalisant = (String)tmpListeLocalisant.get(indiceLocalisant);
                }
                if (miseAJourFinRoute) {
                    if (!distanceLocalisantTrouve) {
                        if (indiceLocalisant != -1) {
                            this.miseAJourDistanceAlertc(tronconFin, indiceLocalisant, tmpDistanceLocalisant, distanceAlertcFinOkTroncon);
                            routeMiseAJour = true;
                            LocalisationInfo.ecrireLog("!--> Le troncon a \u00e9t\u00e9 mis \u00e0 jour - Fin de route g\u00e9r\u00e9e - Aucun troncon avant");
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur mise \u00e0 jour troncon fin de route # " + tronconFin.getIdgdf() + "  #  " + tronconFin.getAbscissesReferentiel(9));
                        }
                    } else {
                        routeMiseAJour = true;
                        LocalisationInfo.ecrireLog("+--> La route a un point alertc bien place \u00e0 la fin de la route");
                    }
                }
            } else {
                LocalisationInfo.ecrireLog("+--> Le dernier troncon n'est pas alertc");
                int iTroncon = -1;
                InfoTroncon tronconTmp = null;
                int tailleTroncon = listeTronconSuivant.size();
                if (tailleTroncon > 1) {
                    iTroncon = tailleTroncon - 1;
                    while (iTroncon > 0 && !estTronconAlertc) {
                        boolean bl5 = estTronconAlertc = (tmpDistanceLocalisant = (tronconTmp = (InfoTroncon)listeTronconSuivant.get(--iTroncon)).getAbscissesReferentiel(9)).size() != 0;
                    }
                } else {
                    estTronconAlertc = false;
                }
                if (estTronconAlertc) {
                    iDistance = -1;
                    indiceLocalisant = -1;
                    distanceSelectionnee = -1.0;
                    while (iDistance < tmpDistanceLocalisant.size() - 1) {
                        if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) > distanceSelectionnee)) continue;
                        indiceLocalisant = iDistance;
                        distanceSelectionnee = tmpDistance;
                    }
                    if (indiceLocalisant != -1) {
                        tmpListeLocalisant = tronconTmp.getReferentiels(8);
                        dernierLocalisant = (String)tmpListeLocalisant.get(indiceLocalisant);
                    }
                    if (miseAJourFinRoute) {
                        if (indiceLocalisant != -1) {
                            this.miseAJourDonneesAlertcTroncon(tronconFin, (String)tmpListeLocalisant.get(indiceLocalisant), distanceAlertcFinOkTroncon);
                            tmpDistanceLocalisant.remove(indiceLocalisant);
                            tmpListeLocalisant.remove(indiceLocalisant);
                            this.miseAJourDistanceAlertc(tronconTmp, tmpDistanceLocalisant, tmpListeLocalisant);
                            routeMiseAJour = true;
                            LocalisationInfo.ecrireLog("!--> Le troncon a \u00e9t\u00e9 mis \u00e0 jour - Fin de route g\u00e9r\u00e9e - Troncon avant " + tronconTmp.getReferentiels(8));
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur mise \u00e0 jour troncon fin de route # " + tronconTmp.getIdgdf() + "  #  " + tronconTmp.getAbscissesReferentiel(9));
                        }
                    }
                } else {
                    estTronconAlertc = tailleTroncon != 0 ? (tmpDistanceLocalisant = tronconCourant.getAbscissesReferentiel(9)).size() != 0 : false;
                    if (estTronconAlertc) {
                        iDistance = -1;
                        indiceLocalisant = -1;
                        distanceSelectionnee = -1.0;
                        while (iDistance < tmpDistanceLocalisant.size() - 1) {
                            if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) > distanceSelectionnee)) continue;
                            indiceLocalisant = iDistance;
                            distanceSelectionnee = tmpDistance;
                        }
                        if (indiceLocalisant != -1) {
                            tmpListeLocalisant = tronconCourant.getReferentiels(8);
                            dernierLocalisant = (String)tmpListeLocalisant.get(indiceLocalisant);
                        }
                        if (miseAJourFinRoute) {
                            if (indiceLocalisant != -1) {
                                this.miseAJourDonneesAlertcTroncon(tronconFin, (String)tmpListeLocalisant.get(indiceLocalisant), distanceAlertcFinOkTroncon);
                                tmpDistanceLocalisant.remove(indiceLocalisant);
                                tmpListeLocalisant.remove(indiceLocalisant);
                                this.miseAJourDistanceAlertc(tronconCourant, tmpDistanceLocalisant, tmpListeLocalisant);
                                routeMiseAJour = true;
                                LocalisationInfo.ecrireLog("!--> Le troncon a \u00e9t\u00e9 mis \u00e0 jour - Fin de route g\u00e9r\u00e9e - Troncon selectionne " + tronconFin.getReferentiels(8));
                            } else {
                                LocalisationInfo.ecrireLog("#--> Erreur mise \u00e0 jour troncon fin de route # " + tronconTmp.getIdgdf() + "  #  " + tronconTmp.getAbscissesReferentiel(9));
                            }
                        }
                    } else {
                        tronconTmp = null;
                        tailleTroncon = listeTronconPrecedent.size();
                        if (tailleTroncon > 0) {
                            iTroncon = -1;
                            while (iTroncon < tailleTroncon - 1 && !estTronconAlertc) {
                                boolean bl6 = estTronconAlertc = (tmpDistanceLocalisant = (tronconTmp = (InfoTroncon)listeTronconPrecedent.get(++iTroncon)).getReferentiels(9)).size() != 0;
                            }
                            if (estTronconAlertc) {
                                iDistance = -1;
                                indiceLocalisant = -1;
                                distanceSelectionnee = -1.0;
                                while (iDistance < tmpDistanceLocalisant.size() - 1) {
                                    if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) > distanceSelectionnee)) continue;
                                    indiceLocalisant = iDistance;
                                    distanceSelectionnee = tmpDistance;
                                }
                                if (indiceLocalisant != -1) {
                                    tmpListeLocalisant = tronconTmp.getReferentiels(8);
                                    dernierLocalisant = (String)tmpListeLocalisant.get(indiceLocalisant);
                                }
                                if (miseAJourFinRoute) {
                                    if (indiceLocalisant != -1) {
                                        this.miseAJourDonneesAlertcTroncon(tronconFin, (String)tmpListeLocalisant.get(indiceLocalisant), distanceAlertcFinOkTroncon);
                                        tmpDistanceLocalisant.remove(indiceLocalisant);
                                        tmpListeLocalisant.remove(indiceLocalisant);
                                        this.miseAJourDistanceAlertc(tronconTmp, tmpDistanceLocalisant, tmpListeLocalisant);
                                        routeMiseAJour = true;
                                        LocalisationInfo.ecrireLog("!--> Le troncon a \u00e9t\u00e9 mis \u00e0 jour - Fin de route g\u00e9r\u00e9e - Troncon apres " + tronconTmp.getReferentiels(8) + " -- " + tronconTmp.getAbscissesReferentiel(9));
                                        LocalisationInfo.ecrireLog("!--> Troncon fin apres " + tronconFin.getReferentiels(8) + " -- " + tronconFin.getAbscissesReferentiel(9));
                                    } else {
                                        LocalisationInfo.ecrireLog("#--> Erreur mise \u00e0 jour troncon fin de route # " + tronconTmp.getIdgdf() + "  #  " + tronconTmp.getAbscissesReferentiel(9));
                                    }
                                }
                            } else {
                                LocalisationInfo.ecrireLog("#--> ERREUR ALERTC FIN ROUTE # IMPOSSIBLE DE METTRE A JOUR LE TRONCON POUR LA FIN DE ROUTE # " + tronconFin.getIdgdf() + " # LA ROUTE NE CONTIENT AUCUN POINT ALERTC");
                            }
                        } else {
                            LocalisationInfo.ecrireLog("#--> ERREUR ALERTC FIN ROUTE # IMPOSSIBLE DE METTRE A JOUR LE TRONCON POUR LA FIN DE ROUTE # " + tronconFin.getIdgdf() + " # LA ROUTE NE CONTIENT AUCUN POINT ALERTC");
                        }
                    }
                }
            }
            if (premierLocalisant != null && dernierLocalisant != null) {
                try {
                    LocalisationInfo.ecrireLog("+--> Localisants alertc " + premierLocalisant + " --- " + dernierLocalisant);
                    LocalisantAlertc alertcDebut = new LocalisantAlertc(premierLocalisant, null);
                    LocalisantAlertc alertcFin = new LocalisantAlertc(dernierLocalisant, null);
                    LocalisationInfo.ecrireLog("+--> Localisants alertc " + alertcDebut + " --- " + alertcFin);
                    if (alertcDebut.getEntiteAlertc().getLocalisant() != alertcFin.getEntiteAlertc().getLocalisant()) {
                        estRouteAlertc = true;
                        LocalisationInfo.ecrireLog("+--> Sens Alertc Route " + sensRouteAlertcOk);
                        break block91;
                    }
                    estRouteAlertc = false;
                }
                catch (Exception e) {
                    LocalisationInfo.ecrireLog("#--> ERREUR SENS ALERTC FIN " + e.toString());
                    estRouteAlertc = false;
                }
            } else {
                estRouteAlertc = false;
            }
        }
        LocalisationInfo.ecrireLog("!--> Traitement termin\u00e9 <--!");
        localisation.setEstRouteAlertc(estRouteAlertc);
        localisation.getSens().setSensRouteAlertcOk(sensRouteAlertcOk);
    }

    public void traitementFinRoutePrpk(Localisation localisation) throws ErreurPR, Exception {
        if (localisation != null) {
            InfoTroncon tronconFin;
            double tmpDistance;
            double distanceSelectionnee;
            int indiceLocalisant;
            boolean distanceLocalisantTrouve;
            int iDistance;
            Vector tmpDistanceLocalisant;
            InfoTroncon tronconDebut;
            TriRoute tri = localisation.getTriRoute();
            if (tri == null) {
                throw new ErreurPR("#--> LE TRI N'A PAS ETE INITIALISE # TRAITEMENT FIN DE ROUTE PR IMPOSSIBLE");
            }
            boolean estRoutePrpk = false;
            boolean sensRoutePrpkOk = false;
            Vector tmpPrpkDebut = null;
            Vector tmpPrpkFin = null;
            Vector tmpDistancePrpkDebut = null;
            Vector tmpDistancePrpkFin = null;
            boolean prpkDebutMisAJour = false;
            boolean prpkFinMisAJour = false;
            int indicePrpkDebut = -1;
            int indicePrpkFin = -1;
            InfoTroncon tronconPrpkDebut = null;
            InfoTroncon tronconPrpkFin = null;
            boolean routeMiseAJour = false;
            Vector listeTronconPrecedent = tri.getTronconsPrecedent();
            Vector listeTronconSuivant = tri.getTronconsSuivant();
            InfoTroncon tronconCourant = tri.getTronconDepart();
            boolean finRoutePrecedent = listeTronconPrecedent.size() == 0;
            boolean finRouteSuivant = listeTronconSuivant.size() == 0;
            LocalisationInfo.ecrireLog("!--> Traitement de la fin de la route -- " + tronconCourant.getIdgdf());
            if (!finRoutePrecedent) {
                tronconDebut = (InfoTroncon)listeTronconPrecedent.get(listeTronconPrecedent.size() - 1);
                tmpDistanceLocalisant = tronconDebut.getAbscissesReferentiel(7);
            } else {
                tronconDebut = tronconCourant;
                tmpDistanceLocalisant = tronconCourant.getAbscissesReferentiel(7);
            }
            estRoutePrpk = true;
            LocalisationInfo.ecrireLog("+--> Init fin de route OK");
            boolean estTronconPrpk = tmpDistanceLocalisant.size() != 0;
            LocalisationInfo.ecrireLog("+--> Tmp distance prpk troncon : " + tmpDistanceLocalisant.size());
            if (estTronconPrpk) {
                iDistance = -1;
                distanceLocalisantTrouve = false;
                indiceLocalisant = -1;
                distanceSelectionnee = Double.MAX_VALUE;
                LocalisationInfo.ecrireLog("+--> Premier troncon prpk");
                while (!distanceLocalisantTrouve && iDistance < tmpDistanceLocalisant.size() - 1) {
                    if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) < distanceSelectionnee)) continue;
                    indiceLocalisant = iDistance;
                    if (tmpDistance != 0.0) {
                        distanceSelectionnee = tmpDistance;
                        continue;
                    }
                    distanceLocalisantTrouve = true;
                }
                LocalisationInfo.ecrireLog("+--> Recherche distance premier troncon prpk ok " + distanceLocalisantTrouve);
                if (!distanceLocalisantTrouve) {
                    prpkDebutMisAJour = true;
                    LocalisationInfo.ecrireLog("!--> Le troncon du debut a un prpk mal place en debut de route");
                } else {
                    prpkDebutMisAJour = false;
                    LocalisationInfo.ecrireLog("+--> La route a un prpk bien place au debut de la route");
                }
                tmpDistancePrpkDebut = tmpDistanceLocalisant;
                indicePrpkDebut = indiceLocalisant;
                tronconPrpkDebut = tronconDebut;
                tmpPrpkDebut = tronconPrpkDebut.getReferentiels(6);
            } else {
                int iTroncon = -1;
                InfoTroncon tronconTmp = null;
                int tailleTroncon = listeTronconPrecedent.size();
                LocalisationInfo.ecrireLog("+--> Premier troncon non prpk " + tailleTroncon);
                if (tailleTroncon > 1) {
                    iTroncon = tailleTroncon - 1;
                    while (iTroncon > 0 && !estTronconPrpk) {
                        boolean bl = estTronconPrpk = (tmpDistanceLocalisant = (tronconTmp = (InfoTroncon)listeTronconPrecedent.get(--iTroncon)).getAbscissesReferentiel(7)).size() != 0;
                    }
                }
                if (estTronconPrpk) {
                    LocalisationInfo.ecrireLog("+--> Troncon avant alertc trouve " + tmpDistanceLocalisant.size());
                    iDistance = -1;
                    indiceLocalisant = -1;
                    distanceSelectionnee = Double.MAX_VALUE;
                    while (iDistance < tmpDistanceLocalisant.size() - 1) {
                        LocalisationInfo.ecrireLog("+--> Distance alertc tmp # " + (String)tmpDistanceLocalisant.get(++iDistance));
                        tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(iDistance));
                        if (!(tmpDistance < distanceSelectionnee)) continue;
                        indiceLocalisant = iDistance;
                        distanceSelectionnee = tmpDistance;
                    }
                    LocalisationInfo.ecrireLog("+--> Recherche distance prpk ok");
                    prpkDebutMisAJour = true;
                    indicePrpkDebut = indiceLocalisant;
                    tronconPrpkDebut = tronconTmp;
                    tmpDistancePrpkDebut = tmpDistanceLocalisant;
                    tmpPrpkDebut = tronconPrpkDebut.getReferentiels(6);
                    LocalisationInfo.ecrireLog("!--> Le prpk a ete trouve avant " + tronconTmp.getValeur(6));
                } else {
                    LocalisationInfo.ecrireLog("+--> Traitement du troncon selectionne");
                    if (tailleTroncon != 0) {
                        tmpDistanceLocalisant = tronconCourant.getAbscissesReferentiel(7);
                        estTronconPrpk = tmpDistanceLocalisant.size() != 0;
                    }
                    LocalisationInfo.ecrireLog("+--> Recherche distance alertc sur le troncon selectionne " + estTronconPrpk);
                    if (estTronconPrpk) {
                        iDistance = -1;
                        indiceLocalisant = -1;
                        distanceSelectionnee = Double.MAX_VALUE;
                        LocalisationInfo.ecrireLog("+--> Troncon selectionne prpk");
                        while (iDistance < tmpDistanceLocalisant.size() - 1) {
                            if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) < distanceSelectionnee)) continue;
                            indiceLocalisant = iDistance;
                            distanceSelectionnee = tmpDistance;
                        }
                        prpkDebutMisAJour = true;
                        indicePrpkDebut = indiceLocalisant;
                        tronconPrpkDebut = tronconCourant;
                        tmpDistancePrpkDebut = tmpDistanceLocalisant;
                        tmpPrpkDebut = tronconPrpkDebut.getReferentiels(6);
                        LocalisationInfo.ecrireLog("!--> Le prpk a ete trouve sur le troncon selectionne " + tronconCourant.getValeur(6));
                    } else {
                        tronconTmp = null;
                        tailleTroncon = listeTronconSuivant.size();
                        LocalisationInfo.ecrireLog("+--> Troncon selectionne non alertc " + tailleTroncon);
                        if (tailleTroncon > 0) {
                            iTroncon = -1;
                            while (iTroncon < tailleTroncon - 1 && !estTronconPrpk) {
                                boolean bl = estTronconPrpk = (tmpDistanceLocalisant = (tronconTmp = (InfoTroncon)listeTronconSuivant.get(++iTroncon)).getAbscissesReferentiel(7)).size() != 0;
                            }
                            if (estTronconPrpk) {
                                LocalisationInfo.ecrireLog("+--> Troncon suivant alertc OK");
                                iDistance = -1;
                                indiceLocalisant = -1;
                                distanceSelectionnee = Double.MAX_VALUE;
                                while (iDistance < tmpDistanceLocalisant.size() - 1) {
                                    if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) < distanceSelectionnee)) continue;
                                    indiceLocalisant = iDistance;
                                    distanceSelectionnee = tmpDistance;
                                }
                                prpkDebutMisAJour = true;
                                indicePrpkDebut = indiceLocalisant;
                                tronconPrpkDebut = tronconTmp;
                                tmpDistancePrpkDebut = tmpDistanceLocalisant;
                                tmpPrpkDebut = tronconPrpkDebut.getReferentiels(6);
                                LocalisationInfo.ecrireLog("!--> Le prpk a ete trouve apres " + tronconTmp.getValeur(6));
                            } else {
                                estRoutePrpk = false;
                                LocalisationInfo.ecrireLog("#--> ERREUR PRPK DEBUT ROUTE # IMPOSSIBLE DE METTRE A JOUR LE TRONCON POUR LE DEBUT DE ROUTE # " + tronconDebut.getIdgdf() + " # LA ROUTE NE CONTIENT AUCUN PRPK");
                            }
                        } else {
                            estRoutePrpk = false;
                            LocalisationInfo.ecrireLog("#--> ERREUR PRPK DEBUT ROUTE # IMPOSSIBLE DE METTRE A JOUR LE TRONCON POUR LE DEBUT DE ROUTE # " + tronconDebut.getIdgdf() + " # LA ROUTE NE CONTIENT AUCUN PRPK");
                        }
                    }
                }
            }
            LocalisationInfo.ecrireLog("+--> Traitement du dernier prpk");
            if (!finRouteSuivant) {
                tronconFin = (InfoTroncon)listeTronconSuivant.get(listeTronconSuivant.size() - 1);
                tmpDistanceLocalisant = tronconFin.getAbscissesReferentiel(7);
            } else {
                tronconFin = tronconCourant;
                tmpDistanceLocalisant = tronconCourant.getAbscissesReferentiel(7);
            }
            double longueurTronconFin = tronconFin.getLongueur();
            boolean bl = estTronconPrpk = tmpDistanceLocalisant.size() != 0;
            if (estTronconPrpk) {
                LocalisationInfo.ecrireLog("+--> Le dernier troncon est prpk");
                iDistance = -1;
                distanceLocalisantTrouve = false;
                indiceLocalisant = -1;
                distanceSelectionnee = -1.0;
                LocalisationInfo.ecrireLog("+--> tronconfin " + tronconFin.getValeur(7));
                while (!distanceLocalisantTrouve && iDistance < tmpDistanceLocalisant.size() - 1) {
                    tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance));
                    LocalisationInfo.ecrireLog("+--> tmpDistance " + tmpDistance + " -- dist sel " + distanceSelectionnee);
                    if (!(tmpDistance > distanceSelectionnee)) continue;
                    indiceLocalisant = iDistance;
                    if (tmpDistance != longueurTronconFin) {
                        distanceSelectionnee = tmpDistance;
                        continue;
                    }
                    distanceLocalisantTrouve = true;
                }
                LocalisationInfo.ecrireLog("+--> iloc " + indiceLocalisant);
                if (!distanceLocalisantTrouve) {
                    prpkFinMisAJour = true;
                    LocalisationInfo.ecrireLog("+--> Il y a un point sur le troncon de fin");
                } else {
                    prpkFinMisAJour = false;
                    LocalisationInfo.ecrireLog("+--> La route a un point alertc bien place \u00e0 la fin de la route");
                }
                indicePrpkFin = indiceLocalisant;
                tronconPrpkFin = tronconFin;
                tmpDistancePrpkFin = tmpDistanceLocalisant;
                tmpPrpkFin = tronconPrpkFin.getReferentiels(6);
                LocalisationInfo.ecrireLog("+--> Test");
            } else {
                LocalisationInfo.ecrireLog("+--> Le dernier troncon n'est pas prpk");
                int iTroncon = -1;
                InfoTroncon tronconTmp = null;
                int tailleTroncon = listeTronconSuivant.size();
                if (tailleTroncon > 1) {
                    iTroncon = tailleTroncon - 1;
                    while (iTroncon > 0 && !estTronconPrpk) {
                        boolean bl2 = estTronconPrpk = (tmpDistanceLocalisant = (tronconTmp = (InfoTroncon)listeTronconSuivant.get(--iTroncon)).getAbscissesReferentiel(7)).size() != 0;
                    }
                } else {
                    estTronconPrpk = false;
                }
                if (estTronconPrpk) {
                    iDistance = -1;
                    indiceLocalisant = -1;
                    distanceSelectionnee = -1.0;
                    while (iDistance < tmpDistanceLocalisant.size() - 1) {
                        if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) > distanceSelectionnee)) continue;
                        indiceLocalisant = iDistance;
                        distanceSelectionnee = tmpDistance;
                    }
                    prpkFinMisAJour = true;
                    indicePrpkFin = indiceLocalisant;
                    tronconPrpkFin = tronconTmp;
                    tmpDistancePrpkFin = tmpDistanceLocalisant;
                    tmpPrpkFin = tronconTmp.getReferentiels(6);
                    LocalisationInfo.ecrireLog("!--> Le troncon contenant le prpk de fin a ete trouve apres " + tronconPrpkFin.getIdgdf());
                } else {
                    LocalisationInfo.ecrireLog("+--> Recherche si il y a un prpk sur le troncon selectionne ");
                    estTronconPrpk = tailleTroncon != 0 ? (tmpDistanceLocalisant = tronconCourant.getAbscissesReferentiel(7)).size() != 0 : false;
                    if (estTronconPrpk) {
                        LocalisationInfo.ecrireLog("+--> Recherche du prpk de fin sur le troncon selectionne " + tmpDistanceLocalisant.size());
                        iDistance = -1;
                        indiceLocalisant = -1;
                        distanceSelectionnee = -1.0;
                        while (iDistance < tmpDistanceLocalisant.size() - 1) {
                            if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) > distanceSelectionnee)) continue;
                            indiceLocalisant = iDistance;
                            distanceSelectionnee = tmpDistance;
                        }
                        LocalisationInfo.ecrireLog("+--> Indice " + indiceLocalisant + " -- " + distanceSelectionnee);
                        prpkFinMisAJour = true;
                        indicePrpkFin = indiceLocalisant;
                        tronconPrpkFin = tronconCourant;
                        tmpDistancePrpkFin = tmpDistanceLocalisant;
                        tmpPrpkFin = tronconCourant.getReferentiels(6);
                        LocalisationInfo.ecrireLog("!--> Le troncon contenant le prpk de fin a ete trouve sur le troncon selectionne " + tronconPrpkFin.getIdgdf());
                    } else {
                        tronconTmp = null;
                        tailleTroncon = listeTronconPrecedent.size();
                        if (tailleTroncon > 0) {
                            iTroncon = -1;
                            while (iTroncon < tailleTroncon - 1 && !estTronconPrpk) {
                                boolean bl3 = estTronconPrpk = (tmpDistanceLocalisant = (tronconTmp = (InfoTroncon)listeTronconPrecedent.get(++iTroncon)).getAbscissesReferentiel(7)).size() != 0;
                            }
                            if (estTronconPrpk) {
                                iDistance = -1;
                                indiceLocalisant = -1;
                                distanceSelectionnee = -1.0;
                                while (iDistance < tmpDistanceLocalisant.size() - 1) {
                                    if (!((tmpDistance = Double.parseDouble((String)tmpDistanceLocalisant.get(++iDistance))) > distanceSelectionnee)) continue;
                                    indiceLocalisant = iDistance;
                                    distanceSelectionnee = tmpDistance;
                                }
                                prpkFinMisAJour = true;
                                indicePrpkFin = indiceLocalisant;
                                tronconPrpkFin = tronconTmp;
                                tmpDistancePrpkFin = tmpDistanceLocalisant;
                                tmpPrpkFin = tronconPrpkFin.getReferentiels(6);
                                LocalisationInfo.ecrireLog("!--> Le troncon contenant le prpk de fin a ete trouve avant " + tronconPrpkFin.getIdgdf());
                            } else {
                                LocalisationInfo.ecrireLog("#--> ERREUR PRPK FIN ROUTE # IMPOSSIBLE DE METTRE A JOUR LE TRONCON POUR LA FIN DE ROUTE # " + tronconFin.getIdgdf() + " # LA ROUTE NE CONTIENT AUCUN PRPK");
                            }
                        } else {
                            LocalisationInfo.ecrireLog("#--> ERREUR PRPK FIN ROUTE # IMPOSSIBLE DE METTRE A JOUR LE TRONCON POUR LA FIN DE ROUTE # " + tronconFin.getIdgdf() + " # LA ROUTE NE CONTIENT AUCUN PRPK");
                        }
                    }
                }
            }
            if (indicePrpkDebut != -1 && indicePrpkFin != -1) {
                EntitePr dernierPrpk;
                EntitePr premierPrpk;
                try {
                    premierPrpk = indicePrpkDebut != -1 ? new EntitePr((String)tmpPrpkDebut.get(indicePrpkDebut)) : null;
                }
                catch (Exception e) {
                    throw new ErreurPR("#--> ERREUR OBTENTION PRPK DEBUT # " + e.toString());
                }
                try {
                    dernierPrpk = indicePrpkFin != -1 ? new EntitePr((String)tmpPrpkFin.get(indicePrpkFin)) : null;
                }
                catch (Exception e) {
                    throw new ErreurPR("#--> ERREUR OBTENTION PRPK FIN # " + e.toString());
                }
                LocalisationInfo.ecrireLog("!--> Affichage des prpk de d\u00e9but et de fin de route avant ! " + premierPrpk + " --- " + dernierPrpk);
                if (premierPrpk == null || premierPrpk.estNulle() || dernierPrpk == null || dernierPrpk.estNulle()) {
                    throw new ErreurPR("#--> ERREUR PR # " + premierPrpk + " -- " + dernierPrpk);
                }
                if (localisation.getSens().getSensRoutePrpkOk()) {
                    LocalisationInfo.ecrireLog("!--> Le sens des prpk est le meme que celui de la route");
                    if (!prpkDebutMisAJour) {
                        LocalisationInfo.ecrireLog("!--> Gestion debut de route prpk ok : PR " + premierPrpk + " bien place");
                    } else {
                        String distancePrpk = tronconDebut.estInverse() ? tronconDebut.getValeur(4) : "0";
                        if (tronconDebut.equals(tronconPrpkDebut)) {
                            if (premierPrpk.getPr() <= 0) {
                                this.miseAJourDistancePrpk(tronconDebut, indicePrpkDebut, tmpDistancePrpkDebut, distancePrpk);
                            } else {
                                premierPrpk.setPr(premierPrpk.getPr() - 1);
                                tmpDistancePrpkDebut.add(distancePrpk);
                                tmpPrpkDebut.add(premierPrpk.toString());
                                this.miseAJourDistancePrpk(tronconDebut, tmpDistancePrpkDebut, tmpPrpkDebut);
                            }
                        } else {
                            if (premierPrpk.getPr() > 0) {
                                premierPrpk.setPr(premierPrpk.getPr() - 1);
                            } else {
                                premierPrpk.setPr(0);
                                tmpDistancePrpkDebut.remove(indicePrpkDebut);
                                tmpPrpkDebut.remove(indicePrpkDebut);
                                this.miseAJourDistancePrpk(tronconPrpkDebut, tmpDistancePrpkDebut, tmpPrpkDebut);
                            }
                            this.miseAJourDonneesPrpkTroncon(tronconDebut, premierPrpk.toString(), distancePrpk);
                        }
                        LocalisationInfo.ecrireLog("!--> Le premier troncon a ete mis \u00e0 jour - la gestion des prpk est d\u00e9sormais effective sur toute la route : PR " + premierPrpk);
                    }
                    if (tri.estASensVariable() && LocalisationInfo.creationPrVirtuelFinRouteSensVariable) {
                        LocalisationInfo.ecrireLog("+--> Gestion des pr sur les routes \u00e0 double sens prfin");
                        String distancePrpk = tronconFin.estInverse() ? "0" : tronconFin.getValeur(4);
                        if (!prpkFinMisAJour) {
                            LocalisationInfo.ecrireLog("!--> Gestion fin de route prpk ok : PR " + dernierPrpk + " bien place");
                        } else {
                            if (tronconFin.equals(tronconPrpkFin)) {
                                LocalisationInfo.ecrireLog("+--> Dernier prpk sur troncon fin");
                                if (dernierPrpk.getPr() <= 0) {
                                    this.miseAJourDistancePrpk(tronconFin, indicePrpkFin, tmpDistancePrpkFin, distancePrpk);
                                } else {
                                    dernierPrpk.setPr(dernierPrpk.getPr() + 1);
                                    tmpDistancePrpkFin.add(distancePrpk);
                                    tmpPrpkFin.add(dernierPrpk.toString());
                                    this.miseAJourDistancePrpk(tronconFin, tmpDistancePrpkFin, tmpPrpkFin);
                                }
                            } else {
                                LocalisationInfo.ecrireLog("+--> Dernier prpk sur autre troncon");
                                if (dernierPrpk.getPr() > 0) {
                                    dernierPrpk.setPr(dernierPrpk.getPr() + 1);
                                } else {
                                    dernierPrpk.setPr(0);
                                    tmpDistancePrpkFin.remove(indicePrpkFin);
                                    tmpPrpkFin.remove(indicePrpkFin);
                                    this.miseAJourDistancePrpk(tronconPrpkFin, tmpDistancePrpkFin, tmpPrpkFin);
                                }
                                this.miseAJourDonneesPrpkTroncon(tronconFin, String.valueOf(dernierPrpk), distancePrpk);
                            }
                            LocalisationInfo.ecrireLog("!--> Le dernier troncon a ete mis \u00e0 jour - la gestion des prpk est d\u00e9sormais effective sur toute la route : PR " + dernierPrpk);
                        }
                    }
                } else {
                    LocalisationInfo.ecrireLog("!--> Le sens des prpk est inverse a celui de la route");
                    String distancePrpk = tronconFin.estInverse() ? "0" : tronconFin.getValeur(4);
                    if (!prpkFinMisAJour) {
                        LocalisationInfo.ecrireLog("!--> Gestion fin de route prpk ok : PR " + dernierPrpk + " bien place");
                    } else {
                        if (tronconFin.equals(tronconPrpkFin)) {
                            LocalisationInfo.ecrireLog("+--> Dernier prpk sur troncon fin");
                            if (dernierPrpk.getPr() <= 0) {
                                this.miseAJourDistancePrpk(tronconFin, indicePrpkFin, tmpDistancePrpkFin, distancePrpk);
                            } else {
                                dernierPrpk.setPr(dernierPrpk.getPr() - 1);
                                tmpDistancePrpkFin.add(distancePrpk);
                                tmpPrpkFin.add(String.valueOf(dernierPrpk));
                                this.miseAJourDistancePrpk(tronconFin, tmpDistancePrpkFin, tmpPrpkFin);
                            }
                        } else {
                            LocalisationInfo.ecrireLog("+--> Dernier prpk sur autre troncon");
                            if (dernierPrpk.getPr() > 0) {
                                dernierPrpk.setPr(dernierPrpk.getPr() - 1);
                            } else {
                                dernierPrpk.setPr(0);
                                tmpDistancePrpkFin.remove(indicePrpkFin);
                                tmpPrpkFin.remove(indicePrpkFin);
                                this.miseAJourDistancePrpk(tronconPrpkFin, tmpDistancePrpkFin, tmpPrpkFin);
                            }
                            this.miseAJourDonneesPrpkTroncon(tronconFin, dernierPrpk.toString(), distancePrpk);
                        }
                        LocalisationInfo.ecrireLog("!--> Le dernier troncon a ete mis \u00e0 jour - la gestion des prpk est d\u00e9sormais effective sur toute la route : PR " + dernierPrpk);
                    }
                    if (tri.estASensVariable() && LocalisationInfo.creationPrVirtuelFinRouteSensVariable) {
                        LocalisationInfo.ecrireLog("+--> Gestion des pr sur les routes \u00e0 double sens prdeb");
                        distancePrpk = tronconDebut.estInverse() ? tronconDebut.getValeur(4) : "0";
                        if (!prpkDebutMisAJour) {
                            LocalisationInfo.ecrireLog("!--> Gestion debut de route prpk ok : PR " + premierPrpk + " bien place");
                        } else {
                            if (tronconDebut.equals(tronconPrpkDebut)) {
                                if (premierPrpk.getPr() <= 0) {
                                    this.miseAJourDistancePrpk(tronconDebut, indicePrpkDebut, tmpDistancePrpkDebut, distancePrpk);
                                } else {
                                    premierPrpk.setPr(premierPrpk.getPr() + 1);
                                    tmpDistancePrpkDebut.add(distancePrpk);
                                    tmpPrpkDebut.add(premierPrpk.toString());
                                    this.miseAJourDistancePrpk(tronconDebut, tmpDistancePrpkDebut, tmpPrpkDebut);
                                }
                            } else {
                                if (premierPrpk.getPr() > 0) {
                                    premierPrpk.setPr(premierPrpk.getPr() + 1);
                                } else {
                                    premierPrpk.setPr(0);
                                    tmpDistancePrpkDebut.remove(indicePrpkDebut);
                                    tmpPrpkDebut.remove(indicePrpkDebut);
                                    this.miseAJourDistancePrpk(tronconPrpkDebut, tmpDistancePrpkDebut, tmpPrpkDebut);
                                }
                                this.miseAJourDonneesPrpkTroncon(tronconDebut, premierPrpk.toString(), distancePrpk);
                            }
                            LocalisationInfo.ecrireLog("!--> Le premier troncon a ete mis \u00e0 jour - la gestion des prpk est d\u00e9sormais effective sur toute la route : PR " + premierPrpk);
                        }
                    }
                }
            }
        }
    }

    public void gestionSensPrpk(TriRoute tri) throws ErreurPR {
        LocalisationInfo.ecrireLog("+--> Gestion du sens pr");
        if (tri != null) {
            GeoPositionnement positionPr;
            LocalisantPr prPrecedent = null;
            LocalisantPr prSuivant = null;
            LocalisationInfo.ecrireLog("+--> Recherche du pr precedent");
            prPrecedent = GestionPr.getPrPrecedent(tri);
            if (prPrecedent == null) {
                LocalisationInfo.ecrireLog("+--> Aucun pr precedent trouve");
                prPrecedent = GestionPr.getPrSuivant(tri);
                if (prPrecedent != null) {
                    LocalisationInfo.ecrireLog("+--> Recherche position pr suivant " + prPrecedent);
                    positionPr = Recherche.getPositionAtPR(tri, prPrecedent);
                    prSuivant = GestionPr.getPrSuivant(tri, positionPr, prPrecedent);
                }
            } else {
                LocalisationInfo.ecrireLog("+--> Recherche du pr suivant");
                prSuivant = GestionPr.getPrSuivant(tri, tri.getGeoPositionnement(), prPrecedent);
                if (prSuivant == null) {
                    prSuivant = prPrecedent;
                    positionPr = Recherche.getPositionAtPR(tri, prSuivant);
                    prPrecedent = GestionPr.getPrPrecedent(tri, positionPr, prSuivant);
                }
            }
            LocalisationInfo.ecrireLog("+--> Affichage test " + prPrecedent + " -- " + prSuivant + " -- ");
            if (prPrecedent != null && !prPrecedent.estNulle() && prSuivant != null && !prSuivant.estNulle()) {
                LocalisationInfo.ecrireLog("+--> Affichage pr " + prPrecedent.toString() + " -- " + prSuivant.toString());
                try {
                    this.localisation.getSens().setSensRoutePrpkOk(GestionPr.getSensPr(prPrecedent, prSuivant));
                }
                catch (ErreurPR erreurPR) {
                    this.localisation.setEstRoutePrpk(false);
                    throw erreurPR;
                }
                LocalisationInfo.ecrireLogInfo("LE SENS DES PR EST " + (this.localisation.getSens().getSensRoutePrpkOk() ? "POSITIF" : "NEGATIF"));
            } else if (tri.getNbPr() == 1) {
                try {
                    if (this.localisation.getTri().aPrDebut() || this.localisation.getTri().aPrFin()) {
                        this.localisation.getSens().setSensRoutePrpkOk(this.localisation.getTri().estAvant(this.localisation.getTri().getPremierPositionnement(), this.localisation.getTri().getPremierTronconPr().getPositionnement(tri.getPrMin())));
                    } else {
                        this.localisation.getSens().setSensRoutePrpkOk(this.localisation.getTri().estAvant(this.localisation.getTri().getPremierTronconPr().getPositionnement(tri.getPrMin())));
                    }
                    LocalisationInfo.ecrireLogInfo("LE SENS DES PR EST INDEFINISSABLE IL SERA DONC LE MEME QUE LE SENS DE CHAINAGE" + (this.localisation.getSens().getSensRoutePrpkOk() ? "POSITIF" : "NEGATIF"));
                }
                catch (Exception e) {
                    this.localisation.setEstRoutePrpk(false);
                    throw new ErreurPR("#--> ERREUR SENS PR - ROUTE A 1 SEUL PR NON LOCALISABLE");
                }
            } else {
                this.localisation.setEstRoutePrpk(false);
                throw new ErreurPR("#--> ERREUR SENS PR");
            }
            this.localisation.setEstRoutePrpk(true);
        }
    }

    public void gestionSensAlertc(TriRoute tri) throws ErreurAlertc {
        LocalisationInfo.ecrireLog("+--> Gestion du sens alertc");
        if (tri != null) {
            LocalisantAlertc alertcPrecedent = null;
            LocalisantAlertc alertcSuivant = null;
            LocalisationInfo.ecrireLog("+--> Recherche du point alertc precedent");
            alertcPrecedent = GestionAlertc.getAlertcPrecedent(tri, tri.getGeoPositionnement(), tri.getAlertcMax());
            if (alertcPrecedent != null) {
                LocalisationInfo.ecrireLog("+--> Recherche du point alertc suivant");
                alertcSuivant = GestionAlertc.getAlertcSuivant(tri, tri.getGeoPositionnement(), alertcPrecedent);
            }
            LocalisationInfo.ecrireLog("+--> Affichage test " + alertcPrecedent + " -- " + alertcSuivant + " -- ");
            if (alertcPrecedent != null && !alertcPrecedent.estVide() && alertcSuivant != null && !alertcSuivant.estVide()) {
                LocalisationInfo.ecrireLog("+--> Affichage alertc " + alertcPrecedent.toString() + " -- " + alertcSuivant.toString());
                try {
                    this.localisation.getSens().setSensRouteAlertcOk(GestionAlertc.getSensAlertc(alertcPrecedent, alertcSuivant));
                }
                catch (ErreurAlertc erreurAlertc) {
                    this.localisation.setEstRouteAlertc(false);
                    throw erreurAlertc;
                }
            } else {
                this.localisation.setEstRouteAlertc(false);
                throw new ErreurAlertc("#--> ERREUR SENS ALERTC");
            }
            LocalisationInfo.ecrireLogInfo("LE SENS DES POINTS ALERTC EST " + (this.localisation.getSens().getSensRouteAlertcOk() ? "POSITIF" : "NEGATIF"));
            this.localisation.setEstRouteAlertc(true);
        }
    }

    private void miseAJourDonneesAlertcTroncon(InfoTroncon troncon, String champLocalisant, String champDistance) {
        String[] donneesTronconCreation = troncon.getValeurs();
        LocalisationInfo.ecrireLog("+--> Distance alertc -- " + donneesTronconCreation[9] + " *** " + champDistance);
        LocalisationInfo.ecrireLog("+--> Localisant alertc -- " + donneesTronconCreation[8] + " *** " + champLocalisant);
        LocalisationInfo.ecrireLog("+--> Num troncon -- " + troncon.getNum());
        donneesTronconCreation[9] = champDistance;
        donneesTronconCreation[8] = champLocalisant;
        troncon.modifier(donneesTronconCreation, LocalisationInfo.appliquerChangementFinRoute);
    }

    private void miseAJourDonneesAlertcTroncon(InfoTroncon troncon, String champDistance) {
        String[] donneesTronconCreation = troncon.getValeurs();
        LocalisationInfo.ecrireLog("+--> Distance alertc -- " + donneesTronconCreation[9] + " *** " + champDistance);
        donneesTronconCreation[9] = champDistance;
        troncon.modifier(donneesTronconCreation, LocalisationInfo.appliquerChangementFinRoute);
        LocalisationInfo.ecrireLog("+--> Troncon mis \u00e0 jour");
    }

    private String miseAJourDistanceAlertc(InfoTroncon troncon, int indiceDistance, Vector tmpDistanceAlertc, String nouvelleValeur) {
        String donneesDistanceAlertc = "";
        if (tmpDistanceAlertc.size() != 0) {
            tmpDistanceAlertc.setElementAt(nouvelleValeur, indiceDistance);
            int i = 0;
            while (i < tmpDistanceAlertc.size() - 1) {
                donneesDistanceAlertc = String.valueOf(donneesDistanceAlertc) + (String)tmpDistanceAlertc.get(i) + ";";
                ++i;
            }
            donneesDistanceAlertc = String.valueOf(donneesDistanceAlertc) + (String)tmpDistanceAlertc.get(tmpDistanceAlertc.size() - 1);
        }
        this.miseAJourDonneesAlertcTroncon(troncon, donneesDistanceAlertc);
        return donneesDistanceAlertc;
    }

    private String miseAJourDistanceAlertc(InfoTroncon troncon, Vector tmpDistanceAlertc, Vector tmpLocalisantAlertc) {
        String donneesDistanceAlertc = "";
        String donneesLocalisantAlertc = "";
        if (tmpDistanceAlertc.size() != 0) {
            int i = 0;
            while (i < tmpDistanceAlertc.size() - 1) {
                donneesDistanceAlertc = donneesDistanceAlertc.concat(String.valueOf((String)tmpDistanceAlertc.get(i)) + ";");
                donneesLocalisantAlertc = donneesLocalisantAlertc.concat(String.valueOf((String)tmpLocalisantAlertc.get(i)) + ";");
                ++i;
            }
            donneesDistanceAlertc = donneesDistanceAlertc.concat((String)tmpDistanceAlertc.get(tmpDistanceAlertc.size() - 1));
            donneesLocalisantAlertc = donneesLocalisantAlertc.concat((String)tmpLocalisantAlertc.get(tmpLocalisantAlertc.size() - 1));
        }
        this.miseAJourDonneesAlertcTroncon(troncon, donneesLocalisantAlertc, donneesDistanceAlertc);
        return donneesDistanceAlertc;
    }

    private void miseAJourDonneesPrpkTroncon(InfoTroncon troncon, String champLocalisant, String champDistance) {
        String[] donneesTronconCreation = troncon.getValeurs();
        LocalisationInfo.ecrireLog("+--> Distance prpk -- " + donneesTronconCreation[7] + " *** " + champDistance);
        LocalisationInfo.ecrireLog("+--> Localisant prpk -- " + donneesTronconCreation[6] + " *** " + champLocalisant);
        donneesTronconCreation[7] = champDistance;
        donneesTronconCreation[6] = champLocalisant;
        LocalisationInfo.ecrireLogDebug("+--> Idgdf " + troncon.getIdgdf());
        troncon.modifier(donneesTronconCreation, LocalisationInfo.appliquerChangementFinRoute);
    }

    private void miseAJourDonneesPrpkTroncon(InfoTroncon troncon, String champDistance) {
        String[] donneesTronconCreation = troncon.getValeurs();
        LocalisationInfo.ecrireLog("+--> Distance alertc -- " + donneesTronconCreation[7] + " *** " + champDistance);
        donneesTronconCreation[7] = champDistance;
        troncon.modifier(donneesTronconCreation, LocalisationInfo.appliquerChangementFinRoute);
        LocalisationInfo.ecrireLog("+--> Troncon mis \u00e0 jour");
    }

    private String miseAJourDistancePrpk(InfoTroncon troncon, int indiceDistance, Vector tmpDistancePrpk, String nouvelleValeur) {
        String donneesDistancePrpk = "";
        if (tmpDistancePrpk.size() != 0) {
            tmpDistancePrpk.setElementAt(nouvelleValeur, indiceDistance);
            int i = 0;
            while (i < tmpDistancePrpk.size() - 1) {
                donneesDistancePrpk = String.valueOf(donneesDistancePrpk) + (String)tmpDistancePrpk.get(i) + ";";
                ++i;
            }
            donneesDistancePrpk = String.valueOf(donneesDistancePrpk) + (String)tmpDistancePrpk.get(tmpDistancePrpk.size() - 1);
        }
        this.miseAJourDonneesPrpkTroncon(troncon, donneesDistancePrpk);
        return donneesDistancePrpk;
    }

    private String miseAJourDistancePrpk(InfoTroncon troncon, int indice, Vector tmpDistancePrpk, String nouvelleValeurDistance, Vector tmpLocalisantPrpk, String nouvelleValeurLocalisant) {
        int i;
        String donneesDistancePrpk = "";
        String donneesLocalisantPrpk = "";
        if (tmpDistancePrpk.size() != 0) {
            tmpDistancePrpk.setElementAt(nouvelleValeurDistance, indice);
            i = 0;
            while (i < tmpDistancePrpk.size() - 1) {
                donneesDistancePrpk = String.valueOf(donneesDistancePrpk) + (String)tmpDistancePrpk.get(i) + ";";
                ++i;
            }
            donneesDistancePrpk = String.valueOf(donneesDistancePrpk) + (String)tmpDistancePrpk.get(tmpDistancePrpk.size() - 1);
        }
        if (tmpLocalisantPrpk.size() != 0) {
            tmpLocalisantPrpk.setElementAt(nouvelleValeurLocalisant, indice);
            i = 0;
            while (i < tmpLocalisantPrpk.size() - 1) {
                donneesLocalisantPrpk = String.valueOf(donneesLocalisantPrpk) + (String)tmpLocalisantPrpk.get(i) + ";";
                ++i;
            }
            donneesLocalisantPrpk = String.valueOf(donneesLocalisantPrpk) + (String)tmpLocalisantPrpk.get(tmpLocalisantPrpk.size() - 1);
        }
        this.miseAJourDonneesPrpkTroncon(troncon, donneesLocalisantPrpk, donneesDistancePrpk);
        return donneesDistancePrpk;
    }

    private String miseAJourDistancePrpk(InfoTroncon troncon, Vector tmpDistancePrpk, Vector tmpLocalisantPrpk) {
        String donneesDistancePrpk = "";
        String donneesLocalisantPrpk = "";
        if (tmpDistancePrpk.size() != 0) {
            int i = 0;
            while (i < tmpDistancePrpk.size() - 1) {
                donneesDistancePrpk = donneesDistancePrpk.concat(String.valueOf((String)tmpDistancePrpk.get(i)) + ";");
                donneesLocalisantPrpk = donneesLocalisantPrpk.concat(String.valueOf((String)tmpLocalisantPrpk.get(i)) + ";");
                ++i;
            }
            donneesDistancePrpk = donneesDistancePrpk.concat((String)tmpDistancePrpk.get(tmpDistancePrpk.size() - 1));
            donneesLocalisantPrpk = donneesLocalisantPrpk.concat((String)tmpLocalisantPrpk.get(tmpLocalisantPrpk.size() - 1));
        }
        this.miseAJourDonneesPrpkTroncon(troncon, donneesLocalisantPrpk, donneesDistancePrpk);
        return donneesDistancePrpk;
    }

    private String getLocalisantAtIndex(String champ, int index) {
        Vector listeLocalisant = LocalisationInfo.recupDonneesLocalisation(champ);
        if (index < listeLocalisant.size() && index != -1) {
            return (String)listeLocalisant.get(index);
        }
        return "";
    }
}

