/*
 * Decompiled with CFR 0.152.
 */
package gls.jpeg;

import gls.outils.fichier.Fichier;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CompressRecursif {
    private static final int IMAGE_WIDTH = 640;

    public static void compress(String dir) throws Exception {
        CompressRecursif.compress(dir, 0L, 640, 0.4f);
    }

    public static void compress(String dir, long minSize, int newWidth, float jpegQuality) throws Exception {
        Vector<File> fs = Fichier.getFichiersRecursifs(new File(dir), new FileNameExtensionFilter("images", "jpeg", "jpg"));
        System.out.println(String.valueOf(fs.size()) + " fichiers trouv\u00e9s.");
        for (File f : fs) {
            if (f.length() <= minSize) continue;
            System.out.println("traitement de " + f.getAbsolutePath() + " (" + f.length() / 1000L + "ko avant compression)");
            File tmp = new File(f.getParent(), String.valueOf(f.getName()) + ".tmp");
            BufferedImage originalImage = ImageIO.read(f);
            int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
            double ratio = 1.0 * (double)originalImage.getHeight() / (double)originalImage.getWidth();
            int height = (int)((double)newWidth * ratio);
            BufferedImage resizeImageHintJpg = CompressRecursif.resizeImageWithHint(originalImage, type, newWidth, height);
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(jpegQuality);
            FileImageOutputStream output = new FileImageOutputStream(tmp);
            writer.setOutput(output);
            IIOImage image = new IIOImage(resizeImageHintJpg, null, null);
            writer.write(null, image, iwp);
            writer.dispose();
            output.flush();
            output.close();
            f.delete();
            tmp.renameTo(f);
        }
    }

    private static BufferedImage resizeImageWithHint(BufferedImage originalImage, int type, int w, int h) {
        BufferedImage resizedImage = new BufferedImage(w, h, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, w, h, null);
        g.dispose();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return resizedImage;
    }
}

