/*
 * Decompiled with CFR 0.152.
 */
package gls.gps.module;

import gls.gps.module.DonneeGps;
import gls.gps.module.KmlRecorder;
import gls.gps.module.miseAjourFenetre;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class fenetre
extends JFrame
implements ActionListener,
ItemListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    public DonneeGps _donneeGps;
    public JLabel valeurLatitude;
    public JLabel valeurLongitude;
    public JLabel valeurAltitude;
    public JLabel valeurVitesse;
    public JLabel valeurAngle;
    public JLabel valeurHDop;
    public JLabel valeurVDop;
    public JLabel valeurPDop;
    public JLabel valeurSat;
    private miseAjourFenetre maj;
    KmlRecorder _kvalide;
    KmlRecorder _kinvalide;
    private boolean kml;
    private boolean log;

    public fenetre() {
        this.addWindowListener(this);
        this._donneeGps = new DonneeGps();
        this.log = false;
        this.kml = false;
        this.build();
    }

    public void setDonnee(DonneeGps newdonnee) {
        if (newdonnee != null) {
            this.setTitle("*" + this.getTitle());
            this._donneeGps = newdonnee;
            this.valeurLatitude.setText(String.valueOf(this._donneeGps.getLatitude()));
            this.valeurLongitude.setText(String.valueOf(this._donneeGps.getLongitude()));
            this.valeurAltitude.setText(String.valueOf(this._donneeGps.getAltitude()));
            this.valeurVitesse.setText(String.valueOf(this._donneeGps.getVitesse()));
            this.valeurAngle.setText(String.valueOf(this._donneeGps.getDirection()));
            this.valeurHDop.setText(String.valueOf(this._donneeGps.getHdop()));
            this.valeurVDop.setText(String.valueOf(this._donneeGps.getVdop()));
            this.valeurPDop.setText(String.valueOf(this._donneeGps.getPdop()));
            this.valeurSat.setText(String.valueOf(String.valueOf(this._donneeGps.getUsedSatellite())) + "/" + String.valueOf(this._donneeGps.getNbSatellite()));
            String temps = String.valueOf(this._donneeGps.getHeure());
            String date = String.valueOf(this._donneeGps.getDate());
            while (temps.length() < 6) {
                temps = "0" + temps;
            }
            try {
                temps = String.valueOf(temps.substring(0, 2)) + "h" + temps.substring(2, 4) + "m" + temps.substring(4, 6) + "s UTC";
            }
            catch (StringIndexOutOfBoundsException e) {
                temps = "heure invalide";
            }
            while (date.length() < 6) {
                date = "0" + date;
            }
            try {
                date = String.valueOf(date.substring(0, 2)) + "/" + date.substring(2, 4) + "/20" + date.substring(4, 6);
            }
            catch (StringIndexOutOfBoundsException e) {
                date = "date invalide";
            }
            if (this.kml) {
                if (this._donneeGps.isTresFiable()) {
                    this._kvalide.addPoint(this._donneeGps.getLatitude(), this._donneeGps.getLongitude(), this._donneeGps.getVitesse(), temps, this._donneeGps.getPdop());
                } else {
                    this._kinvalide.addPoint(this._donneeGps.getLatitude(), this._donneeGps.getLongitude(), this._donneeGps.getVitesse(), temps, this._donneeGps.getPdop());
                }
            }
            this.repaint();
            this.setTitle("en cours... [" + date + "," + temps + "]");
        } else {
            System.out.println("stop!!!!");
            this.maj.stop();
            this.getMenuBar().getMenu(1).setEnabled(false);
            this.getMenuBar().getMenu(0).setEnabled(true);
            this.repaint();
        }
    }

    private void build() {
        this.setTitle("Test du module GPS");
        this.setMenuBar(this.createMenu());
        this.setSize(360, 200);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setContentPane(this.buildContentPane());
    }

    private MenuBar createMenu() {
        MenuBar m = new MenuBar();
        Menu lancer = new Menu("lancer l'aquisition");
        Menu arreter = new Menu("arreter l'acquisition");
        Menu option = new Menu("Options");
        Vector liste = null;
        for (String portName : liste) {
            MenuItem it = new MenuItem("Port " + portName);
            it.addActionListener(this);
            it.setName(portName);
            lancer.add(it);
        }
        MenuItem it = new MenuItem("Mode test/debug");
        it.addActionListener(this);
        it.setName("COM0");
        lancer.add(it);
        arreter.setEnabled(false);
        m.add(lancer);
        arreter.setName("STOP");
        arreter.addActionListener(this);
        arreter.add(new MenuItem("arreter l'acquisition maintenant"));
        m.add(arreter);
        CheckboxMenuItem all = new CheckboxMenuItem("Enregistrer log + kml");
        all.setName("RECall");
        all.addItemListener(this);
        all.setState(true);
        option.add(all);
        CheckboxMenuItem log = new CheckboxMenuItem("Enregistrer log seulement");
        log.setName("REClog");
        log.addItemListener(this);
        option.add(log);
        CheckboxMenuItem kml = new CheckboxMenuItem("Enregistrer kml seulement");
        kml.setName("RECkml");
        kml.addItemListener(this);
        option.add(kml);
        CheckboxMenuItem none = new CheckboxMenuItem("Ne pas enregistrer");
        none.setName("RECnone");
        none.addItemListener(this);
        option.add(none);
        m.add(option);
        return m;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this._donneeGps.egnosActif()) {
            g.setColor(Color.GREEN);
            g.fillOval(320, 55, 20, 20);
            g.setColor(Color.RED);
            g.drawString(String.valueOf(this._donneeGps.getNumStationEgnos()), 319, 69);
        } else {
            g.setColor(Color.RED);
            g.fillOval(320, 55, 20, 20);
        }
        if (this._donneeGps.isTresFiable()) {
            g.setColor(Color.GREEN);
            g.fillOval(180, 162, 25, 25);
        } else if (this._donneeGps.isFiable()) {
            g.setColor(Color.ORANGE);
            g.fillOval(180, 162, 25, 25);
        } else {
            g.setColor(Color.RED);
            g.fillOval(180, 162, 25, 25);
        }
    }

    private JPanel buildContentPane() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JLabel labelLatitude = new JLabel("Latitude : ");
        panel.add(labelLatitude);
        labelLatitude.setBounds(10, 10, 70, 20);
        this.valeurLatitude = new JLabel("0");
        panel.add(this.valeurLatitude);
        this.valeurLatitude.setBounds(80, 10, 100, 20);
        JLabel labellongitude = new JLabel("Longitude : ");
        panel.add(labellongitude);
        labellongitude.setBounds(10, 30, 70, 20);
        this.valeurLongitude = new JLabel("0");
        panel.add(this.valeurLongitude);
        this.valeurLongitude.setBounds(80, 30, 100, 20);
        JLabel labelAltitude = new JLabel("Altitude : ");
        panel.add(labelAltitude);
        labelAltitude.setBounds(10, 50, 70, 20);
        this.valeurAltitude = new JLabel("0");
        panel.add(this.valeurAltitude);
        this.valeurAltitude.setBounds(80, 50, 100, 20);
        JLabel labelVitesse = new JLabel("Vitesse : ");
        panel.add(labelVitesse);
        labelVitesse.setBounds(10, 70, 70, 20);
        this.valeurVitesse = new JLabel("0 Km/h");
        panel.add(this.valeurVitesse);
        this.valeurVitesse.setBounds(80, 70, 100, 20);
        JLabel labelAngle = new JLabel("Angle : ");
        panel.add(labelAngle);
        labelAngle.setBounds(10, 90, 70, 20);
        this.valeurAngle = new JLabel("0 \u00ef\u00bf\u00bd");
        panel.add(this.valeurAngle);
        this.valeurAngle.setBounds(80, 90, 100, 20);
        JLabel labelEtatEgnos = new JLabel("Etat EGNOS : ");
        panel.add(labelEtatEgnos);
        labelEtatEgnos.setBounds(230, 10, 90, 20);
        JLabel labelSat = new JLabel("Sat en vue : ");
        panel.add(labelSat);
        labelSat.setBounds(230, 30, 90, 20);
        this.valeurSat = new JLabel("0");
        panel.add(this.valeurSat);
        this.valeurSat.setBounds(320, 30, 100, 20);
        JLabel labelVDop = new JLabel("VDOP : ");
        panel.add(labelVDop);
        labelVDop.setBounds(230, 50, 90, 20);
        this.valeurVDop = new JLabel("0.0");
        panel.add(this.valeurVDop);
        this.valeurVDop.setBounds(320, 50, 100, 20);
        JLabel labelHDop = new JLabel("HDOP : ");
        panel.add(labelHDop);
        labelHDop.setBounds(230, 70, 90, 20);
        this.valeurHDop = new JLabel("0.0");
        panel.add(this.valeurHDop);
        this.valeurHDop.setBounds(320, 70, 100, 20);
        JLabel labelPDop = new JLabel("PDOP : ");
        panel.add(labelPDop);
        labelPDop.setBounds(230, 90, 90, 20);
        this.valeurPDop = new JLabel("0.0");
        panel.add(this.valeurPDop);
        this.valeurPDop.setBounds(320, 90, 100, 20);
        JLabel labelFiable = new JLabel("Fiabilit\u00ef\u00bf\u00bd du signal : ");
        panel.add(labelFiable);
        labelFiable.setBounds(60, 120, 200, 20);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        System.out.println("clic : " + ((MenuItem)arg0.getSource()).getName());
        if (((MenuItem)arg0.getSource()).getLabel().startsWith("Port ")) {
            this.getMenuBar().getMenu(0).setEnabled(false);
            this.getMenuBar().getMenu(2).setEnabled(false);
            int i = 0;
            while (i < this.getMenuBar().getMenu(2).getItemCount()) {
                CheckboxMenuItem bouton = (CheckboxMenuItem)this.getMenuBar().getMenu(2).getItem(i);
                if (bouton.getState()) {
                    if (bouton.getName().startsWith("RECall")) {
                        this.log = true;
                        this.kml = true;
                    }
                    if (bouton.getName().startsWith("RECkml")) {
                        this.kml = true;
                    }
                    if (bouton.getName().startsWith("REClog")) {
                        this.log = true;
                    }
                    if (bouton.getName().startsWith("RECnone")) {
                        this.log = false;
                        this.kml = false;
                    }
                }
                ++i;
            }
            this.maj = new miseAjourFenetre(this);
            this.maj.start(((MenuItem)arg0.getSource()).getName(), this.log);
            if (this.kml) {
                this._kvalide = new KmlRecorder("valide");
                this._kinvalide = new KmlRecorder("invalide");
            }
            this.getMenuBar().getMenu(1).setEnabled(true);
            this.getMenuBar().getMenu(0).setEnabled(false);
        }
        if (((MenuItem)arg0.getSource()).getName().startsWith("STOP")) {
            System.out.println("stop!!!!");
            this.maj.stop();
            if (this._kvalide != null) {
                this._kvalide.FermerFichier();
            }
            if (this._kinvalide != null) {
                this._kinvalide.FermerFichier();
            }
            this._kvalide = null;
            this._kinvalide = null;
            this.getMenuBar().getMenu(1).setEnabled(false);
            this.getMenuBar().getMenu(0).setEnabled(true);
            this.getMenuBar().getMenu(2).setEnabled(true);
            this.setTitle("Test du module GPS");
        }
    }

    private int fermerFenetre() {
        if (this.maj != null) {
            this.maj.stop();
        }
        if (this._kvalide != null) {
            this._kvalide.FermerFichier();
        }
        if (this._kinvalide != null) {
            this._kinvalide.FermerFichier();
        }
        this._kvalide = null;
        this._kinvalide = null;
        if (this.maj != null) {
            this.maj.stop();
            System.exit(0);
        }
        return 0;
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        CheckboxMenuItem bouton = (CheckboxMenuItem)arg0.getSource();
        int i = 0;
        while (i < this.getMenuBar().getMenu(2).getItemCount()) {
            CheckboxMenuItem bouton2 = (CheckboxMenuItem)this.getMenuBar().getMenu(2).getItem(i);
            bouton2.setState(false);
            ++i;
        }
        bouton.setState(true);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        if (this._kvalide != null) {
            this._kvalide.FermerFichier();
        }
        if (this._kinvalide != null) {
            this._kinvalide.FermerFichier();
        }
        this._kvalide = null;
        this._kinvalide = null;
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

