/*
 * Decompiled with CFR 0.152.
 */
package gls.gps.module;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;

public class KmlRecorder {
    private File _file;
    private FileWriter _fileWriter;
    private String nomEnregistrement;

    public KmlRecorder() {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy_HH'h'mm'min'ss's'");
        this._file = new File(String.valueOf(System.getProperty("user.dir")) + File.separatorChar + format.format(new Date()) + ".kml");
        try {
            this._file.createNewFile();
            this._fileWriter = new FileWriter(this._file);
            this.ecrireEntete();
            this._fileWriter.flush();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "impossible de cr\u00e9er le fichier KML", "Erreur lors de l'enregistrement du fichier KML", 0);
        }
    }

    public KmlRecorder(String FileName) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy_HH'h'mm'min'ss's'");
        this._file = new File(String.valueOf(System.getProperty("user.dir")) + File.separatorChar + format.format(new Date()) + "_" + FileName + ".kml");
        try {
            this._file.createNewFile();
            this._fileWriter = new FileWriter(this._file);
            this.ecrireEntete();
            this._fileWriter.flush();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "impossible de cr\u00e9er le fichier KML", "Erreur lors de l'enregistrement du fichier KML", 0);
        }
    }

    private void ecrireEntete() throws IOException {
        this._fileWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<kml xmlns=\"http://www.opengis.net/kml/2.2\">\r\n");
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy' \u00e0 'HH'h'mm'min'ss's'");
        this.nomEnregistrement = "Enregistrement du " + format.format(new Date());
        this._fileWriter.write("<Document><Folder><name>" + this.nomEnregistrement + "</name>\r\n");
    }

    public void addPoint(double Latitude, double Longitude, double Speed, String date, float PDOP) {
        try {
            this._fileWriter.write("<Placemark>\r\n");
            this._fileWriter.write("<description>Pdop : " + PDOP + "\n\rVitesse : " + Speed + "km/h</description>\n");
            this._fileWriter.write("<Point><coordinates>" + Longitude + "," + Latitude + "</coordinates></Point>\r\n</Placemark>\r\n");
            this._fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void FermerFichier() {
        try {
            this._fileWriter.write("</Folder></Document></kml>\r\n");
            this._fileWriter.flush();
            this._fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

