/*
 * Decompiled with CFR 0.152.
 */
package gls.gps.module;

import gls.gps.module.ConnexionSerie;
import gls.gps.module.DonneeGps;
import gls.gps.module.GpsInterruptedException;
import gls.gps.module.TrameNMEA;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class Gps
extends Thread {
    private static final Logger log = Logger.getLogger(Gps.class);
    protected ConnexionSerie _portCom;
    private String _lastGGA;
    private String _lastGSA;
    private String _lastRMC;
    private File _log;
    private FileWriter _logWriter;
    private boolean _mustLog;
    private int _nbFiable;
    private boolean _mustStop;

    public DonneeGps getLastValue() {
        return this.getLastValue(true);
    }

    public DonneeGps getLastValue(boolean verifierValiditeRmc) {
        DonneeGps d = new DonneeGps(this._lastGGA, this._lastRMC, this._lastGSA, this._nbFiable, verifierValiditeRmc);
        this._nbFiable = d.isFiable() ? ++this._nbFiable : 0;
        return d;
    }

    private void attendre(int millisecond) {
        try {
            Thread.sleep(millisecond);
        }
        catch (InterruptedException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    protected void initialisation() {
        try {
            this._portCom.Write("$PASHS,PWR,ON\r\n");
            this._portCom.Write("$PASHQ,PRT\r\n");
            this._portCom.Write("$PASHQ,RID\r\n");
            this.attendre(50);
            this._portCom.Write("$PASHS,NME,ALL,A,OFF\r\n");
            this._portCom.Write("$PASHS,OUT,A\r\n");
            this._portCom.Write("$PASHS,OUT,A,NMEA\r\n");
            this._portCom.Write("$PASHS,NME,GGA,A,ON\r\n");
            this._portCom.Write("$PASHS,NME,GSA,A,ON\r\n");
            this._portCom.Write("$PASHS,NME,RMC,A,ON\r\n");
            this.attendre(50);
            this._portCom.Write("PASHS,PEM,10\r\n");
            this._portCom.Write("$PSRF151,01*0F\r\n");
            this._portCom.Write("$PSRF108,01*03\r\n");
            this.attendre(50);
            byte[] byArray = new byte[16];
            byArray[0] = -75;
            byArray[1] = 98;
            byArray[2] = 6;
            byArray[3] = 22;
            byArray[4] = 8;
            byArray[6] = 3;
            byArray[7] = 7;
            byArray[8] = 1;
            byArray[10] = 81;
            byArray[11] = 8;
            byArray[14] = -120;
            byArray[15] = 53;
            this._portCom.Write(byArray);
            byte[] byArray2 = new byte[8];
            byArray2[0] = -75;
            byArray2[1] = 98;
            byArray2[2] = 6;
            byArray2[3] = 22;
            byArray2[6] = 28;
            byArray2[7] = 90;
            this._portCom.Write(byArray2);
            byte[] byArray3 = new byte[44];
            byArray3[0] = -75;
            byArray3[1] = 98;
            byArray3[2] = 6;
            byArray3[3] = 36;
            byArray3[4] = 36;
            byArray3[6] = -1;
            byArray3[7] = -1;
            byArray3[9] = 2;
            byArray3[14] = 16;
            byArray3[15] = 39;
            byArray3[18] = 10;
            byArray3[20] = -6;
            byArray3[22] = -6;
            byArray3[24] = 100;
            byArray3[26] = 44;
            byArray3[27] = 1;
            byArray3[42] = 20;
            byArray3[43] = 103;
            this._portCom.Write(byArray3);
            this.attendre(1000);
            System.out.println("ack : " + this._portCom.ReadBuffer());
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (GpsInterruptedException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public boolean start(String port, int vitesse, boolean activerLog) {
        this._mustStop = false;
        this._mustLog = activerLog;
        this._nbFiable = 0;
        if (this._mustLog) {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy_HH'h'mm'min'ss's'");
            this._log = new File(String.valueOf(System.getProperty("user.dir")) + File.separatorChar + port.replace('/', '_') + "_" + format.format(new Date()) + ".log");
            try {
                this._log.createNewFile();
                this._logWriter = new FileWriter(this._log);
                this._logWriter.append("#log r\u00ef\u00bf\u00bdalis\u00ef\u00bf\u00bd par le module GPS de G\u00ef\u00bf\u00bdolocSystem\r\n#seules les trames GGA, RMC et GSA seront enregistr\u00ef\u00bf\u00bdes\r\n\r\n");
                this._logWriter.flush();
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        if (port.equals("COM0")) {
            this._lastGGA = "$GPGGA,121500.00,4437.06797,N,00109.59304,W,2,07,1.1,007.63,M,50.3,M,0,0120*72";
            this._lastGSA = "$GPGSA,A,3,11,23,17,04,20,13,32,,,,,,02.7,01.1,02.5*02";
            this._lastRMC = "$GPRMC,121500.00,A,4437.0680,N,00109.5930,W,45.4,159.4,200309,02,W,D*22";
            return true;
        }
        this._lastGGA = "$GPGGA,000000.00,,,,,0,00,99.99,,,,,,*69";
        this._lastGSA = "$GPGSA,A,1,,,,,,,,,,,,,99.99,99.99,99.99*30";
        this._lastRMC = "$GPRMC,151700.00,V,,,,,,,160409,,,N*75";
        try {
            this._portCom = new ConnexionSerie(port, vitesse, 8, 0, 1);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
        if (this._portCom.isOpen()) {
            this.lancer();
            return true;
        }
        return false;
    }

    public void lancer() {
        this.start();
    }

    public void arreter() {
        this._mustStop = true;
    }

    public void traiterTrames() {
        try {
            Vector<String> trames = this._portCom.getBuffer();
            if (!trames.isEmpty() && !TrameNMEA.isValide(trames.lastElement())) {
                trames.removeElementAt(trames.size() - 1);
            }
            for (String trame : trames) {
                this.traiterTrame(trame);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            this.lectureBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this._logWriter.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this._portCom.Write("$PASHS,NME,ALL,A,OFF\r\n");
            this._portCom.Write("$PASHS,OUT,A\r\n");
            this._portCom.Fermer();
        }
        catch (NullPointerException e) {
            System.out.println("impossible de fermer le port COM");
        }
        catch (IOException iOException) {
        }
        catch (GpsInterruptedException gpsInterruptedException) {
            // empty catch block
        }
    }

    protected void traiterTrame(String trame) {
        if (trame != null && !trame.equals("")) {
            this.enregistrerTrame(trame);
            if (trame.startsWith("$GPGGA")) {
                this._lastGGA = trame;
            } else if (trame.startsWith("$GPGSA")) {
                this._lastGSA = trame;
            } else if (trame.startsWith("$GPRMC")) {
                this._lastRMC = trame;
            }
        }
    }

    protected void lectureBuffer() throws IOException {
        String trame = "";
        try {
            trame = this._portCom.readLine();
        }
        catch (Exception e) {
            trame = "";
        }
        while (trame != null && !this._mustStop) {
            this.traiterTrame(trame);
            try {
                trame = this._portCom.readLine();
            }
            catch (Exception e) {
                trame = "";
            }
            if (!trame.equals("")) continue;
            this.attendre(100);
        }
    }

    protected void enregistrerTrame(String trame) {
        if (this._mustLog) {
            try {
                this._logWriter.append(String.valueOf(System.currentTimeMillis()) + " " + trame + "\n");
                this._logWriter.flush();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "erreur : " + e.getMessage(), "Erreur lors de l'\u00ef\u00bf\u00bdcriture du log", 2);
                this._mustLog = false;
            }
        }
    }

    private void traitementCartoDynamique(String trame) {
    }
}

