/*
 * Decompiled with CFR 0.152.
 */
package gls.gps.module;

import gls.gps.module.ConstantesGps;
import gls.gps.module.TrameNMEA;

public class DonneeGps
implements ConstantesGps {
    public static boolean VERIFIER_VALIDITE_RMC = true;
    private int _date;
    private int _heure;
    private double _latitude;
    private double _longitude;
    private float _altitude;
    private float _vitesse;
    private float _direction;
    private int _modeEgnos;
    private int _nbSatellite;
    int _nbUsedSatellite;
    private float _hdop;
    private float _vdop;
    private float _pdop;
    private boolean _validiteRmc;
    private int _numeroStationEgnos;
    private int nbPrecedenteValide;

    public DonneeGps() {
    }

    private double MintoDegree(double v) {
        double partieDecimale = v - (double)((int)v);
        partieDecimale = 100.0 * partieDecimale / 60.0;
        return (double)((int)v) + partieDecimale;
    }

    public DonneeGps(String gga, String rmc, String gsa, int nbValide) {
        this(gga, rmc, gsa, nbValide, VERIFIER_VALIDITE_RMC);
    }

    public DonneeGps(String gga, String rmc, String gsa, int nbValide, boolean verifierValiditeRmc) {
        TrameNMEA Tgga = new TrameNMEA();
        Tgga.setString(gga);
        TrameNMEA Trmc = new TrameNMEA();
        Trmc.setString(rmc);
        TrameNMEA Tgsa = new TrameNMEA();
        Tgsa.setString(gsa);
        this.nbPrecedenteValide = nbValide;
        if (Tgga.getType().startsWith("$GPGGA") && Tgga.isValide()) {
            try {
                this._heure = (int)Float.parseFloat(Tgga.getNextValue());
            }
            catch (NumberFormatException e) {
                this._heure = 0;
            }
            try {
                this._latitude = this.MintoDegree(Double.parseDouble(Tgga.getNextValue()) / 100.0);
            }
            catch (NumberFormatException e) {
                this._latitude = 0.0;
            }
            if (Tgga.getNextValue().startsWith("S")) {
                this._latitude = -this._latitude;
            }
            try {
                this._longitude = this.MintoDegree(Double.parseDouble(Tgga.getNextValue()) / 100.0);
            }
            catch (NumberFormatException e) {
                this._longitude = 0.0;
            }
            if (Tgga.getNextValue().startsWith("W")) {
                this._longitude = -this._longitude;
            }
            try {
                this._modeEgnos = Integer.parseInt(Tgga.getNextValue());
            }
            catch (NumberFormatException e) {
                this._modeEgnos = 0;
            }
            try {
                this._nbSatellite = Integer.parseInt(Tgga.getNextValue());
            }
            catch (NumberFormatException e) {
                this._nbSatellite = 0;
            }
            Tgga.getNextValue();
            try {
                this._altitude = Float.parseFloat(Tgga.getNextValue());
            }
            catch (NumberFormatException e) {
                this._altitude = 0.0f;
            }
            Tgga.getNextValue();
            Tgga.getNextValue();
            Tgga.getNextValue();
            if (this.egnosActif()) {
                try {
                    this._numeroStationEgnos = Integer.parseInt(Tgga.getNextValue());
                }
                catch (NumberFormatException e) {
                    this._numeroStationEgnos = 0;
                }
            }
        }
        if (Trmc.getType().startsWith("$GPRMC")) {
            Trmc.getNextValue();
            this._validiteRmc = Trmc.getNextValue().startsWith("A");
            if (!verifierValiditeRmc || this._validiteRmc) {
                Trmc.getNextValue();
                Trmc.getNextValue();
                Trmc.getNextValue();
                Trmc.getNextValue();
                try {
                    this._vitesse = Float.parseFloat(Trmc.getNextValue());
                }
                catch (NumberFormatException e) {
                    this._vitesse = 0.0f;
                }
                try {
                    this._direction = Float.parseFloat(Trmc.getNextValue());
                }
                catch (NumberFormatException e) {
                    this._direction = 0.0f;
                }
                try {
                    this._date = Integer.parseInt(Trmc.getNextValue());
                }
                catch (NumberFormatException e) {
                    this._date = 0;
                }
            } else {
                this._validiteRmc = false;
            }
        }
        if (Tgsa.getType().startsWith("$GPGSA")) {
            Tgsa.getNextValue();
            Tgsa.getNextValue();
            this._nbUsedSatellite = 0;
            int i = 2;
            while (i < 14) {
                if (Tgsa.getNextValue().length() > 0) {
                    ++this._nbUsedSatellite;
                }
                ++i;
            }
            try {
                this._pdop = Float.parseFloat(Tgsa.getNextValue());
                this._hdop = Float.parseFloat(Tgsa.getNextValue());
                this._vdop = Float.parseFloat(Tgsa.getNextValue());
            }
            catch (NumberFormatException e) {
                this._pdop = 0.0f;
                this._hdop = 0.0f;
                this._vdop = 0.0f;
            }
        }
    }

    public void setAltitude(int altitude) {
        this._altitude = altitude;
    }

    public void setVitesse(int vitesse) {
        this._vitesse = vitesse;
    }

    public int getDate() {
        return this._date;
    }

    public int getHeure() {
        return this._heure;
    }

    public double getLatitude() {
        return this._latitude;
    }

    public double getLongitude() {
        return this._longitude;
    }

    public float getAltitude() {
        return this._altitude;
    }

    public float getVitesse() {
        return this._vitesse * 1.852f;
    }

    public float getDirection() {
        return this._direction;
    }

    public boolean isTresFiable() {
        return this.isFiable() && this.nbPrecedenteValide > 3;
    }

    public boolean isAssezFiable() {
        return this._hdop < 2.6f && this._vdop < 3.2f && this._pdop < 3.6f;
    }

    public boolean isFiable() {
        return this._hdop < 1.3f && this._vdop < 1.6f && this._pdop < 1.8f && this.egnosActif();
    }

    public boolean egnosActif() {
        boolean actif = this._modeEgnos == 2;
        return actif;
    }

    public boolean gpsActif() {
        boolean actif = this._modeEgnos > 0;
        return actif;
    }

    public int getNbSatellite() {
        return this._nbSatellite;
    }

    public int getUsedSatellite() {
        return this._nbUsedSatellite;
    }

    public int getNumStationEgnos() {
        return this._numeroStationEgnos;
    }

    public float getHdop() {
        return this._hdop;
    }

    public float getVdop() {
        return this._vdop;
    }

    public float getPdop() {
        return this._pdop;
    }

    public String toString() {
        String ret = "============ Donn\u00e9e NMEA ===============\n";
        ret = String.valueOf(ret) + "~~~~~DATE : " + this.getDate() + "~~~~~\n";
        ret = String.valueOf(ret) + "latitude : " + this.getLatitude() + "\n";
        ret = String.valueOf(ret) + "longitude : " + this.getLongitude() + "\n";
        ret = String.valueOf(ret) + "altitude : " + this.getAltitude() + "\n";
        ret = String.valueOf(ret) + "Vitesse : " + this.getVitesse() + "km/h\n";
        if (this.egnosActif()) {
            ret = String.valueOf(ret) + "Egnos est : ACTIF\n";
            ret = String.valueOf(ret) + "numero de la station EGNOS : " + this.getNumStationEgnos() + "\n";
        } else {
            ret = String.valueOf(ret) + "Egnos est : INACTIF\n";
        }
        ret = String.valueOf(ret) + this.getNbSatellite() + " satellite(s) en vue\n";
        ret = String.valueOf(ret) + "HDOP : " + this.getHdop() + "; VDOP : " + this.getVdop() + "; PDOP : " + this.getPdop() + "\n";
        return ret;
    }

    public boolean isRmcValide() {
        return this._validiteRmc;
    }
}

