/*
 * Decompiled with CFR 0.152.
 */
package gls.geometry.conversion;

import gls.geometry.GeoPoint;
import gls.geometry.conversion.Ellipsoid;
import gls.geometry.conversion.LLtoUTM;

public class UTMtoLL {
    private static final double PI = 3.14159265;
    private static final double QUARTPI = 0.7853981625;
    private static final double degversrad = 0.017453292500000002;
    private static final double rad2deg = 57.29577957855229;
    private int ZONE_FRANCE;
    private int zone;
    private String hemisphere;
    public static final Ellipsoid[] ellipsoid = new Ellipsoid[]{new Ellipsoid(-1, "Placeholder", 0.0, 0.0), new Ellipsoid(1, "Airy", 6377563.0, 0.00667054), new Ellipsoid(2, "Australian National", 6378160.0, 0.006694542), new Ellipsoid(3, "Bessel 1841", 6377397.0, 0.006674372), new Ellipsoid(4, "Bessel 1841 (Nambia) ", 6377484.0, 0.006674372), new Ellipsoid(5, "Clarke 1866", 6378206.0, 0.006768658), new Ellipsoid(6, "Clarke 1880", 6378249.0, 0.006803511), new Ellipsoid(7, "Everest", 6377276.0, 0.006637847), new Ellipsoid(8, "Fischer 1960 (Mercury) ", 6378166.0, 0.006693422), new Ellipsoid(9, "Fischer 1968", 6378150.0, 0.006693422), new Ellipsoid(10, "GRS 1967", 6378160.0, 0.006694605), new Ellipsoid(11, "GRS 1980", 6378137.0, 0.00669438), new Ellipsoid(12, "Helmert 1906", 6378200.0, 0.006693422), new Ellipsoid(13, "Hough", 6378270.0, 0.00672267), new Ellipsoid(14, "International", 6378388.0, 0.00672267), new Ellipsoid(15, "Krassovsky", 6378245.0, 0.006693422), new Ellipsoid(16, "Modified Airy", 6377340.0, 0.00667054), new Ellipsoid(17, "Modified Everest", 6377304.0, 0.006637847), new Ellipsoid(18, "Modified Fischer 1960", 6378155.0, 0.006693422), new Ellipsoid(19, "South American 1969", 6378160.0, 0.006694542), new Ellipsoid(20, "WGS 60", 6378165.0, 0.006693422), new Ellipsoid(21, "WGS 66", 6378145.0, 0.006694542), new Ellipsoid(22, "WGS-72", 6378135.0, 0.006694318), new Ellipsoid(23, "WGS-84", 6378137.0, 0.00669438)};

    public UTMtoLL(int zone) {
        this.zone = this.ZONE_FRANCE = 30;
        this.hemisphere = "N";
        this.zone = zone;
    }

    public UTMtoLL(int zone, String hemisphere) {
        this.zone = this.ZONE_FRANCE = 30;
        this.hemisphere = "N";
        this.zone = zone;
        this.hemisphere = hemisphere;
    }

    public GeoPoint UTM2LL(int ReferenceEllipsoid, double UTMNorthing, double UTMEasting) {
        boolean NorthernHemisphere;
        double k0 = 0.9996;
        double a = UTMtoLL.ellipsoid[ReferenceEllipsoid].RadEquatorial;
        double eccSquared = UTMtoLL.ellipsoid[ReferenceEllipsoid].eccentricitycarre;
        double e1 = (1.0 - Math.sqrt(1.0 - eccSquared)) / (1.0 + Math.sqrt(1.0 - eccSquared));
        int ZoneNumber = this.zone;
        String UTMZone = String.valueOf(String.valueOf(30)) + UTMtoLL.UTMDesignationLettre(UTMNorthing);
        char ZoneLetter = UTMtoLL.UTMDesignationLettre(UTMNorthing);
        double x = UTMEasting - 500000.0;
        double y = UTMNorthing;
        if (ZoneLetter - 78 >= 0) {
            NorthernHemisphere = true;
        } else {
            NorthernHemisphere = false;
            y -= 1.0E7;
        }
        if (this.hemisphere.equals("S")) {
            NorthernHemisphere = false;
            y -= 1.0E7;
        } else {
            NorthernHemisphere = true;
        }
        double LongOrigin = (ZoneNumber - 1) * 6 - 180 + 3;
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double M = y / k0;
        double mu = M / (a * (1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0));
        double phi1Rad = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
        double phi1 = phi1Rad * 57.29577957855229;
        double N1 = a / Math.sqrt(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
        double T1 = Math.tan(phi1Rad) * Math.tan(phi1Rad);
        double C1 = eccPrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
        double R1 = a * (1.0 - eccSquared) / Math.pow(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
        double D = x / (N1 * k0);
        double Lat = phi1Rad - N1 * Math.tan(phi1Rad) / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * eccPrimeSquared) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * eccPrimeSquared - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0);
        double Longi = (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * eccPrimeSquared + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / Math.cos(phi1Rad);
        Longi = LongOrigin + Longi * 57.29577957855229;
        return new GeoPoint(Longi, Lat *= 57.29577957855229);
    }

    public static GeoPoint UTM2LL(int ReferenceEllipsoid, double UTMNorthing, double UTMEasting, int zone) {
        double k0 = 0.9996;
        double a = UTMtoLL.ellipsoid[ReferenceEllipsoid].RadEquatorial;
        double eccSquared = UTMtoLL.ellipsoid[ReferenceEllipsoid].eccentricitycarre;
        double e1 = (1.0 - Math.sqrt(1.0 - eccSquared)) / (1.0 + Math.sqrt(1.0 - eccSquared));
        int ZoneNumber = zone;
        String UTMZone = String.valueOf(String.valueOf(30)) + UTMtoLL.UTMDesignationLettre(UTMNorthing);
        char ZoneLetter = UTMtoLL.UTMDesignationLettre(UTMNorthing);
        double x = UTMEasting - 500000.0;
        double y = UTMNorthing;
        if (ZoneLetter - 78 >= 0) {
            boolean NorthernHemisphere = true;
        } else {
            boolean NorthernHemisphere = false;
            y -= 1.0E7;
        }
        double LongOrigin = (ZoneNumber - 1) * 6 - 180 + 3;
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double M = y / k0;
        double mu = M / (a * (1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0));
        double phi1Rad = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
        double phi1 = phi1Rad * 57.29577957855229;
        double N1 = a / Math.sqrt(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
        double T1 = Math.tan(phi1Rad) * Math.tan(phi1Rad);
        double C1 = eccPrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
        double R1 = a * (1.0 - eccSquared) / Math.pow(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
        double D = x / (N1 * k0);
        double Lat = phi1Rad - N1 * Math.tan(phi1Rad) / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * eccPrimeSquared) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * eccPrimeSquared - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0);
        double Longi = (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * eccPrimeSquared + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / Math.cos(phi1Rad);
        Longi = LongOrigin + Longi * 57.29577957855229;
        return new GeoPoint(Longi, Lat *= 57.29577957855229);
    }

    public static char UTMDesignationLettre(double Lat) {
        int DesignationLettre = 84.0 >= Lat && Lat >= 72.0 ? 88 : (72.0 > Lat && Lat >= 64.0 ? 87 : (64.0 > Lat && Lat >= 56.0 ? 86 : (56.0 > Lat && Lat >= 48.0 ? 85 : (48.0 > Lat && Lat >= 40.0 ? 84 : (40.0 > Lat && Lat >= 32.0 ? 83 : (32.0 > Lat && Lat >= 24.0 ? 82 : (24.0 > Lat && Lat >= 16.0 ? 81 : (16.0 > Lat && Lat >= 8.0 ? 80 : (8.0 > Lat && Lat >= 0.0 ? 78 : (0.0 > Lat && Lat >= -8.0 ? 77 : (-8.0 > Lat && Lat >= -16.0 ? 76 : (-16.0 > Lat && Lat >= -24.0 ? 75 : (-24.0 > Lat && Lat >= -32.0 ? 74 : (-32.0 > Lat && Lat >= -40.0 ? 72 : (-40.0 > Lat && Lat >= -48.0 ? 71 : (-48.0 > Lat && Lat >= -56.0 ? 70 : (-56.0 > Lat && Lat >= -64.0 ? 69 : (-64.0 > Lat && Lat >= -72.0 ? 68 : (-72.0 > Lat && Lat >= -80.0 ? 67 : 90)))))))))))))))))));
        return (char)DesignationLettre;
    }

    public static void main(String[] a) {
        System.out.println("aya");
        double X = -5.7259;
        double Y = 45.114944;
        GeoPoint p = new GeoPoint(X, Y);
        System.out.println("val p avant ll2utm : " + p);
        LLtoUTM ll2utm = new LLtoUTM(30);
        UTMtoLL utm2ll = new UTMtoLL(30);
        p.set(ll2utm.LL2UTM(23, p.getY(), p.getX()));
        System.out.println("val p apres ll2utm : " + p);
        p.set(utm2ll.UTM2LL(23, p.getY(), p.getX()));
        System.out.println("val p apres utm2ll : " + p);
    }
}

