/*
 * Decompiled with CFR 0.152.
 */
package gls.geometry.conversion;

import gls.geometry.GeoPoint;
import gls.geometry.conversion.Ellipsoid;

public class LLtoUTM {
    private int ZONE_FRANCE;
    private int zone;
    private static final double PI = 3.14159265;
    private static final double QUARTPI = 0.7853981625;
    private static final double degversrad = 0.017453292500000002;
    private static final double radversdeg = 57.29577957855229;
    public static final Ellipsoid[] ellipsoid = new Ellipsoid[]{new Ellipsoid(-1, "Placeholder", 0.0, 0.0), new Ellipsoid(1, "Airy", 6377563.0, 0.00667054), new Ellipsoid(2, "Australian National", 6378160.0, 0.006694542), new Ellipsoid(3, "Bessel 1841", 6377397.0, 0.006674372), new Ellipsoid(4, "Bessel 1841 (Nambia) ", 6377484.0, 0.006674372), new Ellipsoid(5, "Clarke 1866", 6378206.0, 0.006768658), new Ellipsoid(6, "Clarke 1880", 6378249.0, 0.006803511), new Ellipsoid(7, "Everest", 6377276.0, 0.006637847), new Ellipsoid(8, "Fischer 1960 (Mercury) ", 6378166.0, 0.006693422), new Ellipsoid(9, "Fischer 1968", 6378150.0, 0.006693422), new Ellipsoid(10, "GRS 1967", 6378160.0, 0.006694605), new Ellipsoid(11, "GRS 1980", 6378137.0, 0.00669438), new Ellipsoid(12, "Helmert 1906", 6378200.0, 0.006693422), new Ellipsoid(13, "Hough", 6378270.0, 0.00672267), new Ellipsoid(14, "International", 6378388.0, 0.00672267), new Ellipsoid(15, "Krassovsky", 6378245.0, 0.006693422), new Ellipsoid(16, "Modified Airy", 6377340.0, 0.00667054), new Ellipsoid(17, "Modified Everest", 6377304.0, 0.006637847), new Ellipsoid(18, "Modified Fischer 1960", 6378155.0, 0.006693422), new Ellipsoid(19, "South American 1969", 6378160.0, 0.006694542), new Ellipsoid(20, "WGS 60", 6378165.0, 0.006693422), new Ellipsoid(21, "WGS 66", 6378145.0, 0.006694542), new Ellipsoid(22, "WGS-72", 6378135.0, 0.006694318), new Ellipsoid(23, "WGS-84", 6378137.0, 0.00669438)};

    public LLtoUTM(int zone) {
        this.zone = this.ZONE_FRANCE = 30;
        this.zone = zone;
    }

    public GeoPoint LL2UTM(int ReferenceEllipsoide, double Lat, double Longi) {
        return this.LL2UTM(ReferenceEllipsoide, Lat, Longi, this.zone);
    }

    public GeoPoint LL2UTM(int ReferenceEllipsoide, double Lat, double Longi, int zone) {
        double a = LLtoUTM.ellipsoid[ReferenceEllipsoide].RadEquatorial;
        double ecccarre = LLtoUTM.ellipsoid[ReferenceEllipsoide].eccentricitycarre;
        double k0 = 0.9996;
        int xTmp = (int)((Longi + 180.0) / 360.0);
        double LongTemp = Longi + 180.0 - (double)(xTmp * 360) - 180.0;
        double LatRad = Lat * 0.017453292500000002;
        double LongRad = LongTemp * 0.017453292500000002;
        int NumeroZone = (int)((LongTemp + 180.0) / 6.0 + 1.0);
        if (Lat >= 56.0 && Lat < 64.0 && LongTemp >= 3.0 && LongTemp < 12.0) {
            NumeroZone = 32;
        }
        if (Lat >= 72.0 && Lat < 84.0) {
            if (LongTemp >= 0.0 && LongTemp < 9.0) {
                NumeroZone = 31;
            } else if (LongTemp >= 9.0 && LongTemp < 21.0) {
                NumeroZone = 33;
            } else if (LongTemp >= 21.0 && LongTemp < 33.0) {
                NumeroZone = 35;
            } else if (LongTemp >= 33.0 && LongTemp < 42.0) {
                NumeroZone = 37;
            }
        }
        NumeroZone = zone;
        double LongOrigine = (NumeroZone - 1) * 6 - 180 + 3;
        double LongOrigineRad = LongOrigine * 0.017453292500000002;
        String UTMZone = String.valueOf(String.valueOf(NumeroZone)) + this.UTMDesignationLettre(Lat);
        double eccPrimaireCarre = ecccarre / (1.0 - ecccarre);
        double N = a / Math.sqrt(1.0 - ecccarre * Math.sin(LatRad) * Math.sin(LatRad));
        double T = Math.tan(LatRad) * Math.tan(LatRad);
        double C = eccPrimaireCarre * Math.cos(LatRad) * Math.cos(LatRad);
        double A = Math.cos(LatRad) * (LongRad - LongOrigineRad);
        double M = a * ((1.0 - ecccarre / 4.0 - 3.0 * ecccarre * ecccarre / 64.0 - 5.0 * ecccarre * ecccarre * ecccarre / 256.0) * LatRad - (3.0 * ecccarre / 8.0 + 3.0 * ecccarre * ecccarre / 32.0 + 45.0 * ecccarre * ecccarre * ecccarre / 1024.0) * Math.sin(2.0 * LatRad) + (15.0 * ecccarre * ecccarre / 256.0 + 45.0 * ecccarre * ecccarre * ecccarre / 1024.0) * Math.sin(4.0 * LatRad) - 35.0 * ecccarre * ecccarre * ecccarre / 3072.0 * Math.sin(6.0 * LatRad));
        double UTMEst = k0 * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * eccPrimaireCarre) * A * A * A * A * A / 120.0) + 500000.0;
        double UTMNord = k0 * (M + N * Math.tan(LatRad) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * eccPrimaireCarre) * A * A * A * A * A * A / 720.0));
        if (Lat < 0.0) {
            UTMNord += 1.0E7;
        }
        return new GeoPoint(UTMEst, UTMNord);
    }

    char UTMDesignationLettre(double Lat) {
        int DesignationLettre = 84.0 >= Lat && Lat >= 72.0 ? 88 : (72.0 > Lat && Lat >= 64.0 ? 87 : (64.0 > Lat && Lat >= 56.0 ? 86 : (56.0 > Lat && Lat >= 48.0 ? 85 : (48.0 > Lat && Lat >= 40.0 ? 84 : (40.0 > Lat && Lat >= 32.0 ? 83 : (32.0 > Lat && Lat >= 24.0 ? 82 : (24.0 > Lat && Lat >= 16.0 ? 81 : (16.0 > Lat && Lat >= 8.0 ? 80 : (8.0 > Lat && Lat >= 0.0 ? 78 : (0.0 > Lat && Lat >= -8.0 ? 77 : (-8.0 > Lat && Lat >= -16.0 ? 76 : (-16.0 > Lat && Lat >= -24.0 ? 75 : (-24.0 > Lat && Lat >= -32.0 ? 74 : (-32.0 > Lat && Lat >= -40.0 ? 72 : (-40.0 > Lat && Lat >= -48.0 ? 71 : (-48.0 > Lat && Lat >= -56.0 ? 70 : (-56.0 > Lat && Lat >= -64.0 ? 69 : (-64.0 > Lat && Lat >= -72.0 ? 68 : (-72.0 > Lat && Lat >= -80.0 ? 67 : 90)))))))))))))))))));
        return (char)DesignationLettre;
    }
}

