/*
 * Decompiled with CFR 0.152.
 */
package gls.geometry;

import gls.geometry.ConstantesSensGeographique;
import gls.geometry.GeoPoint;

public class SensGeographique
implements ConstantesSensGeographique {
    public static int getSensGeographique(GeoPoint ptDeb, GeoPoint ptFin) {
        double xdeb = ptDeb.getX();
        double ydeb = ptDeb.getY();
        double xfin = ptFin.getX();
        double yfin = ptFin.getY();
        double X = xfin - xdeb;
        double Y = yfin - ydeb;
        int sensGeo = -1;
        if (X == 0.0) {
            sensGeo = -1;
        } else {
            double YX = Y / X;
            double tan3927 = 0.414214638;
            double tan1178 = 0.784213387;
            if (-tan3927 <= YX && YX <= tan3927 && X > 0.0) {
                sensGeo = 0;
            } else if (-tan1178 <= YX && YX <= -tan3927 && X > 0.0) {
                sensGeo = 5;
            } else if ((tan1178 <= YX || YX <= -tan1178) && Y < 0.0) {
                sensGeo = 2;
            } else if (tan3927 <= YX && YX <= tan1178 && X < 0.0) {
                sensGeo = 4;
            } else if (-tan3927 <= YX && YX <= tan3927 && X < 0.0) {
                sensGeo = 3;
            } else if (-tan1178 <= YX && YX <= -tan3927 && X < 0.0) {
                sensGeo = 7;
            } else if ((tan1178 <= YX || YX <= -tan1178) && Y > 0.0) {
                sensGeo = 1;
            } else if (tan3927 <= YX && YX <= tan1178 && X > 0.0) {
                sensGeo = 6;
            }
        }
        return sensGeo;
    }

    public static String getSensGeographiqueEnClair(GeoPoint ptDeb, GeoPoint ptFin) {
        return SensGeographique.enClair(SensGeographique.getSensGeographique(ptDeb, ptFin));
    }

    public static String enClair(int sensGeo) {
        switch (sensGeo) {
            case -1: {
                return "";
            }
            case 0: {
                return "Est";
            }
            case 1: {
                return "Nord";
            }
            case 2: {
                return "Sud";
            }
            case 3: {
                return "Ouest";
            }
            case 4: {
                return "Sud-Ouest";
            }
            case 5: {
                return "Sud-Est";
            }
            case 6: {
                return "Nord-Est";
            }
            case 7: {
                return "Ouest";
            }
        }
        return "";
    }
}

