/*
 * Decompiled with CFR 0.152.
 */
package gls.geometry;

import gls.geometry.GeoPoint;
import java.util.List;

public class PGGeometryConverter {
    public static String convertUtmToLL(List<GeoPoint> coordonnees) throws Exception {
        StringBuffer geomFromText = new StringBuffer("st_geometryfromtext('LINESTRING (");
        int i = coordonnees.size() - 1;
        while (i >= 0) {
            GeoPoint point = coordonnees.get(i);
            GeoPoint pointLL = point.toNewLL();
            geomFromText.append(String.valueOf(pointLL.getX()) + " " + pointLL.getY() + (i == 0 ? "" : ", "));
            --i;
        }
        geomFromText.append(")', ").append("4326").append(")");
        return geomFromText.toString();
    }

    public static String convert(List<double[]> coordonneesX, List<double[]> coordonneesY, String projectionOrigine, String projectionDest) throws Exception {
        if (coordonneesX.size() == 1) {
            if (projectionOrigine == null) {
                return PGGeometryConverter.convertLinestring(coordonneesX.get(0), coordonneesY.get(0));
            }
            return PGGeometryConverter.convertLinestring(coordonneesX.get(0), coordonneesY.get(0), projectionOrigine, projectionDest);
        }
        return PGGeometryConverter.convertMultiLinestring(coordonneesX, coordonneesY, projectionOrigine, projectionDest);
    }

    public static String convertLinestring(double[] coordonneesX, double[] coordonneesY, String projection, String projectionDest) throws Exception {
        StringBuffer geomFromText = new StringBuffer("st_geometryfromtext('LINESTRING (");
        int i = 0;
        while (i < coordonneesX.length) {
            geomFromText.append(String.valueOf(i == 0 ? "" : ", ") + coordonneesX[i] + " " + coordonneesY[i]);
            ++i;
        }
        geomFromText.append(")', ").append(projection).append(")");
        return "st_transform(" + geomFromText + " , " + projectionDest + ")";
    }

    public static String convertLinestring(double[] coordonneesX, double[] coordonneesY) throws Exception {
        StringBuffer geomFromText = new StringBuffer("LINESTRING (");
        int i = 0;
        while (i < coordonneesX.length) {
            geomFromText.append(String.valueOf(i == 0 ? "" : ", ") + coordonneesX[i] + " " + coordonneesY[i]);
            ++i;
        }
        geomFromText.append(")");
        return geomFromText.toString();
    }

    private static String convertMultiLinestring(List<double[]> coordonneesX, List<double[]> coordonneesY, String projection, String projectionDest) {
        StringBuffer geomFromText = new StringBuffer("st_geometryfromtext('MULTILINESTRING (");
        int i = 0;
        while (i < coordonneesX.size()) {
            double[] coordX = coordonneesX.get(i);
            double[] coordY = coordonneesY.get(i);
            geomFromText.append(String.valueOf(i == 0 ? "" : ",") + "(");
            int j = 0;
            while (j < coordX.length) {
                geomFromText.append(String.valueOf(coordX[j]) + " " + coordY[j] + (j == 0 ? "" : ", "));
                ++j;
            }
            geomFromText.append(")");
            ++i;
        }
        geomFromText.append(")', ").append(projection).append(")");
        return geomFromText.toString();
    }
}

