/*
 * Decompiled with CFR 0.152.
 */
package gls.geometry;

import commun.UnPoint;
import java.util.ArrayList;
import org.postgis.LineString;
import org.postgis.Point;

public class GeometryUtil {
    public LineString lateralizeLine(LineString ligne, double distance, int sens) {
        ArrayList<Point> result = new ArrayList<Point>();
        int srid_line = ligne.srid;
        double longueur = ligne.length();
        if (longueur == 0.0) {
            ligne.setSrid(srid_line);
            return ligne;
        }
        int nbPoints = ligne.numPoints();
        int i = 0;
        while (i < nbPoints) {
            Point resultatp1;
            Point point = ligne.getPoint(i);
            double llpoint = this.lineLocatePoint(ligne, point);
            if (llpoint >= 1.0) {
                llpoint = 1.0;
            }
            Point pointp = this.lineinterpolatepoint(ligne, llpoint);
            Point point1 = llpoint * longueur - distance < 0.0 ? this.lineinterpolatepoint(ligne, 0.0) : this.lineinterpolatepoint(ligne, (llpoint * longueur - distance) / longueur);
            Point point2 = (llpoint * longueur + distance) / longueur >= 1.0 ? this.lineinterpolatepoint(ligne, 1.0) : this.lineinterpolatepoint(ligne, (llpoint * longueur + distance) / longueur);
            if (sens != 0) {
                double xPoint1 = point1.x;
                double xPoint2 = point2.x;
                if (xPoint1 == xPoint2) {
                    resultatp1 = new Point(pointp.x + (double)(-sens) * distance, pointp.y);
                    resultatp1.srid = srid_line;
                } else {
                    int sensp = (int)((xPoint2 - xPoint1) / Math.abs(xPoint2 - xPoint1) * (double)(-sens));
                    resultatp1 = new Point(pointp.x + (double)sensp * distance * Math.cos(1.5707963267948966 - Math.atan((point2.y - point1.y) / (xPoint1 - xPoint2))), pointp.y + (double)sensp * distance * Math.sin(1.5707963267948966 - Math.atan((point2.y - point1.y) / (xPoint1 - xPoint2))));
                }
            } else {
                resultatp1 = new Point(point.x, point.y);
            }
            UnPoint p = new UnPoint(resultatp1.x, resultatp1.y).toLL(30, "N");
            resultatp1 = new Point((double)p.x, (double)p.y);
            result.add(resultatp1);
            ++i;
        }
        LineString resultat = new LineString(result.toArray(new Point[result.size()]));
        resultat.srid = 4326;
        return resultat;
    }

    private Point lineinterpolatepoint(LineString ligne, double llpoint) {
        double distance = ligne.length();
        double distanceEnCours = 0.0;
        if (llpoint == 0.0) {
            return ligne.getFirstPoint();
        }
        if (llpoint == 1.0) {
            return ligne.getLastPoint();
        }
        int nbPoints = ligne.getPoints().length;
        int i = 1;
        while (i < nbPoints) {
            Point pMoinsUn = ligne.getPoint(i - 1);
            Point p = ligne.getPoint(i);
            if ((distanceEnCours += this.distanceLineaire(pMoinsUn.x, pMoinsUn.y, p.x, p.y)) / distance > llpoint) {
                return pMoinsUn;
            }
            ++i;
        }
        return ligne.getLastPoint();
    }

    private double lineLocatePoint(LineString ligne, Point point) {
        double distance = ligne.length();
        double distanceEnCours = 0.0;
        int nbPoints = ligne.getPoints().length;
        int i = 0;
        while (i < nbPoints) {
            Point pMoinsUn;
            Point p = ligne.getPoint(i);
            if (p.equals(point)) {
                if (i == 0) {
                    return 0.0;
                }
                pMoinsUn = ligne.getPoint(i - 1);
                return (distanceEnCours += this.distanceLineaire(pMoinsUn.x, pMoinsUn.y, p.x, p.y)) / distance;
            }
            if (i != 0) {
                pMoinsUn = ligne.getPoint(i - 1);
                distanceEnCours += this.distanceLineaire(pMoinsUn.x, pMoinsUn.y, p.x, p.y);
            }
            if (i == ligne.getPoints().length) {
                return 1.0;
            }
            ++i;
        }
        return 1.0;
    }

    public double distanceLineaire(int srid, double lat1, double lon1, double lat2, double lon2) {
        int R = 6371000;
        double sinDeltaLat = Math.sin(Math.toRadians(lat2 - lat1) / 2.0);
        double sinDeltaLon = Math.sin(Math.toRadians(lon2 - lon1) / 2.0);
        double normedDist = sinDeltaLat * sinDeltaLat + sinDeltaLon * sinDeltaLon * Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2));
        return 1.2742E7 * Math.asin(Math.sqrt(normedDist));
    }

    public double distanceLineaire(double x1, double y1, double x2, double y2) {
        return Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
    }
}

