/*
 * Decompiled with CFR 0.152.
 */
package gls.geometry;

import cartoj.Couche;
import cartoj.Enregistrement;
import cartoj.IFichierCont;
import gls.geometry.GeoPoint;
import gls.localisation.InfoTroncon;
import gls.localisation.LocalisationInfo;
import gls.localisation.tri.Tri;
import gls.outils.GLS;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.PGgeometry;
import org.postgis.Point;

public class Geometry {
    public static final String SEPARATEUR_COORDONNEES = ";";
    public static final String SEPARATEUR_POINTS = ":";

    public static final double distance(float _x1, float _y1, float _x2, float _y2) {
        Point2D.Float p1 = new Point2D.Float();
        p1.x = _x1;
        p1.y = _y1;
        return p1.distance(_x2, _y2);
    }

    public static double toRadians(double degrees) {
        double radians = degrees * Math.PI / 180.0;
        return radians;
    }

    public static double getEchelle(int hauteur, int largeur, int hauteurMax, int largeurMax) {
        double scaleX = (double)largeur / (double)largeurMax;
        double scaleY = (double)hauteur / (double)hauteurMax;
        return Math.max(scaleX, scaleY);
    }

    public static double getEchelle(double hauteur, double largeur, double hauteurMax, double largeurMax) {
        double scaleX = largeur / largeurMax;
        double scaleY = hauteur / hauteurMax;
        return Math.max(scaleX, scaleY);
    }

    public static double distanceLL(double lat1, double lng1, double lat2, double lng2) {
        double earthRadius = 6378000.0;
        double dLat = Geometry.toRadians(lat2 - lat1);
        double dLng = Geometry.toRadians(lng2 - lng1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Geometry.toRadians(lat1)) * Math.cos(Geometry.toRadians(lat2)) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double dist = earthRadius * c;
        return dist;
    }

    public static int calculerLongueur(Couche couche, Enregistrement enregistrement) {
        return Geometry.calculerLongueur(couche.getCont().getX(enregistrement.getNum()), couche.getCont().getY(enregistrement.getNum()));
    }

    public static int calculerLongueur(Vector<GeoPoint> points) {
        int distance = 0;
        if (!GLS.estVide(points)) {
            int i = 0;
            while (i < points.size() - 1) {
                distance = (int)((double)distance + points.get(i).distance(points.get(i + 1)));
                ++i;
            }
        }
        return distance;
    }

    public static int calculerLongueur(float[] listeX, float[] listeY) {
        int distance = 0;
        int i = 0;
        while (i < listeX.length - 1) {
            distance = (int)((double)distance + Geometry.distance(listeX[i], listeY[i], listeX[i + 1], listeY[i + 1]));
            ++i;
        }
        return distance;
    }

    public static int calculerLongueurLL(float[] listeX, float[] listeY) {
        int distance = 0;
        int i = 0;
        while (i < listeX.length - 1) {
            distance = (int)((double)distance + Geometry.distanceLL(listeX[i], listeY[i], listeX[i + 1], listeY[i + 1]));
            ++i;
        }
        return distance;
    }

    public static Point2D.Double getCoordonneesEnregistrement(IFichierCont cont, Enregistrement enregistrement) {
        if (enregistrement != null && cont != null) {
            float[] listeX = cont.getX(enregistrement.getNum());
            float[] listeY = cont.getY(enregistrement.getNum());
            Point2D.Double point = new Point2D.Double(listeX[0], listeY[0]);
            return point;
        }
        return null;
    }

    public static double[] getCoordonneesEnregistrementDouble(IFichierCont cont, Enregistrement enregistrement) {
        if (enregistrement != null && cont != null) {
            float[] listeX = cont.getX(enregistrement.getNum());
            float[] listeY = cont.getY(enregistrement.getNum());
            double[] point = new double[]{listeX[0], listeY[0]};
            return point;
        }
        return null;
    }

    public static float[][] getListeCoordonneesEnregistrement(IFichierCont cont, Enregistrement enregistrement) {
        if (enregistrement != null && cont != null) {
            float[] listeX = cont.getX(enregistrement.getNum());
            float[] listeY = cont.getY(enregistrement.getNum());
            float[][] points = new float[][]{listeX, listeY};
            return points;
        }
        return null;
    }

    public static float[][] toLL(float[][] ligneUtm) {
        float[][] ligneLL = null;
        if (ligneUtm != null) {
            float[] listeX = new float[ligneUtm[0].length];
            float[] listeY = new float[ligneUtm[1].length];
            ligneLL = new float[2][];
            int i = 0;
            while (i < listeX.length) {
                GeoPoint p = new GeoPoint(ligneUtm[0][i], ligneUtm[1][i]).toLL();
                listeX[i] = (float)p.getX();
                listeY[i] = (float)p.getY();
                ++i;
            }
            ligneLL[0] = listeX;
            ligneLL[1] = listeY;
        }
        return ligneLL;
    }

    public static String[] getFloatToString(float[][][] coordonnees) {
        if (coordonnees != null && coordonnees.length > 0) {
            String[] coord = new String[coordonnees.length];
            try {
                int ii = 0;
                while (ii < coordonnees.length) {
                    StringBuffer sb = new StringBuffer();
                    int taille = coordonnees[ii][0].length;
                    if (taille > 0) {
                        int i = 0;
                        while (i < taille - 1) {
                            sb.append(coordonnees[ii][0][i]);
                            sb.append(SEPARATEUR_COORDONNEES);
                            sb.append(coordonnees[ii][1][i]);
                            sb.append(SEPARATEUR_POINTS);
                            ++i;
                        }
                        sb.append(coordonnees[ii][0][taille - 1]);
                        sb.append(SEPARATEUR_COORDONNEES);
                        sb.append(coordonnees[ii][1][taille - 1]);
                    }
                    coord[ii] = sb.toString();
                    ++ii;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return coord;
        }
        return null;
    }

    public static String getFloatToString(float[][] coordonnees) {
        if (coordonnees != null) {
            StringBuffer sb = new StringBuffer();
            try {
                int taille = coordonnees[0].length;
                if (taille > 0) {
                    int i = 0;
                    while (i < taille - 1) {
                        sb.append(coordonnees[0][i]);
                        sb.append(SEPARATEUR_COORDONNEES);
                        sb.append(coordonnees[1][i]);
                        sb.append(SEPARATEUR_POINTS);
                        ++i;
                    }
                    sb.append(coordonnees[0][taille - 1]);
                    sb.append(SEPARATEUR_COORDONNEES);
                    sb.append(coordonnees[1][taille - 1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sb.toString();
        }
        return "";
    }

    public static String getFloatToString(float[] x, float[] y) {
        if (x != null && y != null && x.length == y.length) {
            StringBuffer sb = new StringBuffer();
            try {
                int taille = x.length;
                if (taille > 0) {
                    int i = 0;
                    while (i < taille - 1) {
                        sb.append(x[i]);
                        sb.append(" ");
                        sb.append(y[i]);
                        sb.append(",");
                        ++i;
                    }
                    sb.append(x[taille - 1]);
                    sb.append(" ");
                    sb.append(y[taille - 1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sb.toString();
        }
        return "";
    }

    public static String getFloatToStringUTM(float[] x, float[] y) {
        if (x != null && y != null && x.length == y.length) {
            StringBuffer sb = new StringBuffer();
            try {
                int taille = x.length;
                if (taille > 0) {
                    int i = 0;
                    while (i < taille - 1) {
                        GeoPoint p = new GeoPoint(x[i], y[i]).toUTM();
                        sb.append(p.getX());
                        sb.append(" ");
                        sb.append(p.getY());
                        sb.append(",");
                        ++i;
                    }
                    GeoPoint p = new GeoPoint(x[taille - 1], y[taille - 1]).toUTM();
                    sb.append(p.getX());
                    sb.append(" ");
                    sb.append(p.getY());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sb.toString();
        }
        return "";
    }

    public static GeoPoint getProjectionPointTroncon(InfoTroncon troncon, GeoPoint point) {
        try {
            return Geometry.initialiserPositionnement(troncon.getX(), troncon.getY(), point);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static GeoPoint getProjectionPointTroncon(IFichierCont fichierCont, Enregistrement troncon, GeoPoint point) {
        int numTroncon = troncon.getNum();
        GeoPoint monPoint = new GeoPoint(point.getX(), point.getY());
        return Geometry.initialiserPositionnement(fichierCont.getX(numTroncon), fichierCont.getY(numTroncon), monPoint);
    }

    public static GeoPoint initialiserPositionnement(float[] trX, float[] trY, GeoPoint point) {
        GeoPoint pProjectionTmp;
        double distance = point.distance(new GeoPoint(trX[0], trY[0]));
        int indice = 0;
        int i = 1;
        while (i < trX.length) {
            double dist = point.distance(trX[i], trY[i]);
            if (dist <= distance) {
                distance = dist;
                indice = i;
            }
            ++i;
        }
        GeoPoint pProche = new GeoPoint(trX[indice], trY[indice]);
        int indiceNbPoints = trX.length - 1;
        if (distance > 0.0) {
            if (indice == 0) {
                pProjectionTmp = point.projection(trX[indice], trY[indice], trX[indice + 1], trY[indice + 1]);
                if (!pProjectionTmp.estDansLePlan(trX[indice], trY[indice], trX[indice + 1], trY[indice + 1])) {
                    pProjectionTmp = Geometry.rechercherProjectionProche(point, trX, trY, indiceNbPoints);
                    if (pProjectionTmp == null) {
                        pProjectionTmp = pProche;
                    } else {
                        indice = pProjectionTmp.tag_int;
                    }
                }
            } else if (indice == indiceNbPoints) {
                indice = trX.length > 2 ? (pProche.equals(trX[indice - 1], trY[indice - 1]) ? (indice -= 2) : --indice) : --indice;
                pProjectionTmp = point.projection(trX[indice], trY[indice], trX[indice + 1], trY[indice + 1]);
                if (!pProjectionTmp.estDansLePlan(trX[indice], trY[indice], trX[indice + 1], trY[indice + 1])) {
                    pProjectionTmp = Geometry.rechercherProjectionProche(point, trX, trY, indiceNbPoints);
                    if (pProjectionTmp == null) {
                        pProjectionTmp = new GeoPoint(trX[indiceNbPoints], trY[indiceNbPoints]);
                    } else {
                        indice = pProjectionTmp.tag_int;
                    }
                }
            } else {
                pProjectionTmp = point.projection(trX[indice], trY[indice], trX[indice + 1], trY[indice + 1]);
                if (!pProjectionTmp.estDansLePlan(trX[indice], trY[indice], trX[indice + 1], trY[indice + 1])) {
                    if (pProche.equals(trX[indice - 1], trY[indice - 1])) {
                        if (indice == 1) {
                            pProjectionTmp = Geometry.rechercherProjectionProche(point, trX, trY, indiceNbPoints);
                            if (pProjectionTmp == null) {
                                pProjectionTmp = pProche;
                            } else {
                                indice = pProjectionTmp.tag_int;
                            }
                        } else {
                            pProjectionTmp = point.projection(trX[indice - 2], trY[indice - 2], trX[indice], trY[indice]);
                            if (!pProjectionTmp.estDansLePlan(trX[indice - 2], trY[indice - 2], trX[indice], trY[indice])) {
                                pProjectionTmp = Geometry.rechercherProjectionProche(point, trX, trY, indiceNbPoints);
                                if (pProjectionTmp == null) {
                                    pProjectionTmp = pProche;
                                } else {
                                    indice = pProjectionTmp.tag_int;
                                }
                            } else {
                                indice -= 2;
                            }
                        }
                    } else {
                        pProjectionTmp = point.projection(trX[indice - 1], trY[indice - 1], trX[indice], trY[indice]);
                        if (!pProjectionTmp.estDansLePlan(trX[indice - 1], trY[indice - 1], trX[indice], trY[indice])) {
                            pProjectionTmp = Geometry.rechercherProjectionProche(point, trX, trY, indiceNbPoints);
                            if (pProjectionTmp == null) {
                                pProjectionTmp = pProche;
                            } else {
                                indice = pProjectionTmp.tag_int;
                            }
                        } else {
                            --indice;
                        }
                    }
                }
            }
        } else {
            pProjectionTmp = new GeoPoint(trX[indice], trY[indice]);
            if (indice == indiceNbPoints) {
                --indice;
            }
        }
        pProjectionTmp.tag_string = point.tag_string;
        pProjectionTmp.tag_int = indice;
        point = pProjectionTmp;
        point.tag_int = indice;
        return pProjectionTmp;
    }

    /*
     * Unable to fully structure code
     */
    public static GeoPoint getIntersectionPoint(InfoTroncon troncon1, InfoTroncon troncon2) throws Exception {
        fin = false;
        trouve = false;
        fin2 = false;
        i = 0;
        j = 0;
        tronconX1 = troncon1.getX();
        tronconY1 = troncon1.getY();
        tronconX2 = troncon2.getX();
        tronconY2 = troncon2.getY();
        point = null;
        ** GOTO lbl22
        {
            try {
                point = Geometry.getIntersectionPoint(tronconX1[i], tronconY1[i], tronconX1[i + 1], tronconY1[i + 1], tronconX2[j], tronconY2[j], tronconX2[j + 1], tronconY2[j + 1]);
            }
            catch (Exception var12_12) {
                // empty catch block
            }
            trouve = point != null;
            v0 = fin2 = ++j >= tronconX2.length - 1;
            do {
                if (!fin2 && !trouve) continue block2;
                v1 = fin = ++i >= tronconX1.length - 1;
lbl22:
                // 2 sources

            } while (!fin && !trouve);
        }
        if (!trouve) {
            throw new Exception();
        }
        return new GeoPoint(point);
    }

    public Point2D.Float getIntersectionPoint(Line2D.Float line1, Line2D.Float line2) throws Exception {
        return Geometry.getIntersectionPoint(line1.getX1(), line1.getY1(), line1.getX2(), line1.getY2(), line2.getX1(), line2.getY1(), line2.getX2(), line2.getY2());
    }

    public static Point2D.Float getIntersectionPoint(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) throws Exception {
        if (!Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) {
            throw new Exception("NO INTERSECTION");
        }
        double qx = x3;
        double sx = x4 - qx;
        double py = y1;
        double ry = y2 - py;
        double qy = y3;
        double sy = y4 - qy;
        double px = x1;
        double rx = x2 - px;
        double det = sx * ry - sy * rx;
        if (det == 0.0) {
            throw new Exception("DET NULL INTERSECTION");
        }
        double z = (sx * (qy - py) + sy * (px - qx)) / det;
        Point2D.Float p = z == 0.0 || z == 1.0 ? Geometry.getIntersectionPointExtreme(x1, y1, x2, y2, x3, y3, x4, y4) : new Point2D.Float((float)(px + z * rx), (float)(py + z * ry));
        if (!GeoPoint.estDansLePlan(p.x, p.y, (float)x1, (float)y1, (float)x2, (float)y2)) {
            throw new Exception("POINT PAS DANS LE PLAN");
        }
        return p;
    }

    public static Point2D.Float getIntersectionPointExtreme(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) throws Exception {
        if (x1 == x3 && y1 == y3 || x1 == x4 && y1 == y4) {
            return new Point2D.Float((float)x1, (float)y1);
        }
        if (x2 == x3 && y2 == y3 || x2 == x4 && y2 == y4) {
            return new Point2D.Float((float)x2, (float)y2);
        }
        throw new Exception("ERREUR POINT EXTREME");
    }

    public static Vector<GeoPoint> epurerListePoints(Vector<GeoPoint> listePoints) {
        GeoPoint p1 = listePoints.get(listePoints.size() - 1);
        int i = listePoints.size() - 2;
        while (i >= 0) {
            GeoPoint p2 = listePoints.get(i);
            if (p2.equals(p1)) {
                listePoints.remove(i + 1);
            }
            p1 = p2;
            --i;
        }
        return listePoints;
    }

    public static Vector<GeoPoint> toGeoPoints(float[] listeX, float[] listeY, boolean convertirUtm) {
        if (listeX != null && listeY != null && listeX.length == listeY.length) {
            Vector<GeoPoint> points = new Vector<GeoPoint>();
            int i = 0;
            while (i < listeX.length) {
                GeoPoint point = new GeoPoint(listeX[i], listeY[i]);
                if (convertirUtm) {
                    point.toUTM();
                }
                points.add(point);
                ++i;
            }
            return points;
        }
        return null;
    }

    public static Vector<GeoPoint> toGeoPoints(float[] listeX, float[] listeY) {
        return Geometry.toGeoPoints(listeX, listeY, false);
    }

    public boolean estIntersecte(Shape sh, float[] x, float[] y) {
        boolean flag = true;
        int i = 0;
        while (i < x.length - 1 && flag) {
            Line2D.Float ligne = new Line2D.Float(x[i], y[i], x[i + 1], y[i + 1]);
            Area area = new Area(sh);
            area.intersect(new Area(ligne));
            flag = area.isEmpty();
            ++i;
        }
        return !flag;
    }

    public static Vector toGeoPoints(float[][] listePoints) {
        if (listePoints != null && listePoints.length == 2 && listePoints[0].length == listePoints[1].length) {
            Vector<GeoPoint> points = new Vector<GeoPoint>();
            int i = 0;
            while (i < listePoints[0].length) {
                GeoPoint point = new GeoPoint(listePoints[0][i], listePoints[1][i]);
                points.add(point);
                ++i;
            }
            return points;
        }
        return null;
    }

    public static Vector<Point2D.Double> toPoint2D(Vector<GeoPoint> points) {
        if (points != null) {
            Vector<Point2D.Double> points2D = new Vector<Point2D.Double>();
            for (GeoPoint point : points) {
                points2D.add(point.toPoint2D());
            }
            return points2D;
        }
        return null;
    }

    public static Vector<Point2D.Double> getStringToPoints(String lignePoints) {
        Vector<Point2D.Double> points = new Vector<Point2D.Double>();
        StringBuffer ligne = new StringBuffer();
        String[] stringArray = lignePoints.split(SEPARATEUR_POINTS);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lignePoint = stringArray[n2];
            String[] p = lignePoint.split(SEPARATEUR_COORDONNEES);
            if (!GLS.estVide(p) && p.length >= 2) {
                points.add(new Point2D.Double(GLS.getDouble(p[0]), GLS.getDouble(p[1])));
            }
            ++n2;
        }
        return points;
    }

    public static float[][] getStringToFloat(String lignePoints) throws Exception {
        String[] ligneCoordonnees = lignePoints.split(SEPARATEUR_POINTS);
        float[][] points = new float[2][ligneCoordonnees.length];
        int i = 0;
        String[] stringArray = ligneCoordonnees;
        int n = ligneCoordonnees.length;
        int n2 = 0;
        while (n2 < n) {
            String lignePoint = stringArray[n2];
            String[] p = lignePoint.split(SEPARATEUR_COORDONNEES);
            if (GLS.estVide(p) || p.length < 2) {
                throw new Exception("COORDONNEES INVALIDES " + lignePoint);
            }
            points[0][i] = Float.valueOf(p[0]).floatValue();
            points[1][i] = Float.valueOf(p[1]).floatValue();
            ++i;
            ++n2;
        }
        return points;
    }

    public static Vector<GeoPoint> getStringToGeopoints(String lignePoints) {
        Vector<GeoPoint> points = new Vector<GeoPoint>();
        String[] stringArray = lignePoints.split(SEPARATEUR_POINTS);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lignePoint = stringArray[n2];
            String[] p = lignePoint.split(SEPARATEUR_COORDONNEES);
            if (!GLS.estVide(p) && p.length >= 2) {
                GeoPoint point = new GeoPoint();
                point.set(GLS.getDouble(p[0]), GLS.getDouble(p[1]));
                if (p.length >= 3) {
                    point.setZ(GLS.getDouble(p[2]));
                }
                points.add(point);
            }
            ++n2;
        }
        return points;
    }

    public static double[] getStringToDoubleSDO(String lignePoints) {
        Vector<Double> ligne = new Vector<Double>();
        String[] stringArray = lignePoints.split(SEPARATEUR_POINTS);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lignePoint = stringArray[n2];
            String[] p = lignePoint.split(SEPARATEUR_COORDONNEES);
            if (!GLS.estVide(p) && p.length == 2) {
                ligne.add(GLS.getDouble(p[0]));
                ligne.add(GLS.getDouble(p[1]));
            }
            ++n2;
        }
        double[] pointsSDO = new double[ligne.size()];
        int i = 0;
        while (i < ligne.size()) {
            pointsSDO[i] = (Double)ligne.get(i);
            ++i;
        }
        return pointsSDO;
    }

    public static String getGeopointsToString(Vector<GeoPoint> points) {
        return Geometry.getGeopointsToString(points, false);
    }

    public static String getGeopointsToString(Vector<GeoPoint> points, boolean forceAltitude) {
        StringBuffer ligne = new StringBuffer();
        if (!GLS.estVide(points)) {
            int i = 0;
            while (i < points.size() - 1) {
                ligne.append(Geometry.getPointToString(points.get(i), forceAltitude));
                ligne.append(SEPARATEUR_POINTS);
                ++i;
            }
            if (points.size() == 1) {
                ligne.append(Geometry.getPointToString(points.firstElement(), forceAltitude));
                ligne.append(SEPARATEUR_POINTS);
            }
            ligne.append(Geometry.getPointToString(points.lastElement(), forceAltitude));
        }
        return ligne.toString();
    }

    public static String getPointsToString(Vector<Point2D.Double> points) {
        StringBuffer ligne = new StringBuffer();
        if (!GLS.estVide(points)) {
            int i = 0;
            while (i < points.size() - 1) {
                ligne.append(Geometry.getPointToString(points.get(i)));
                ligne.append(SEPARATEUR_POINTS);
                ++i;
            }
            if (points.size() == 1) {
                ligne.append(Geometry.getPointToString(points.firstElement()));
                ligne.append(SEPARATEUR_POINTS);
            }
            ligne.append(Geometry.getPointToString(points.lastElement()));
        }
        return ligne.toString();
    }

    public static float[][] getPointsToFloat(PGgeometry geom) {
        if (geom != null) {
            if (geom.getGeometry() instanceof LineString) {
                return Geometry.getPointsToFloat((LineString)geom.getGeometry());
            }
            if (geom.getGeometry() instanceof Point) {
                return Geometry.getPointToFloat((Point)geom.getGeometry());
            }
            if (geom.getGeometry() instanceof MultiLineString) {
                return Geometry.getPointsToFloat((MultiLineString)geom.getGeometry());
            }
            return null;
        }
        return null;
    }

    public static float[][] getPointsToFloat(LineString ligne) {
        float[][] listePoints = null;
        if (!GLS.estVide(ligne.getPoints())) {
            Point[] points = ligne.getPoints();
            listePoints = new float[2][points.length];
            int i = 0;
            while (i < points.length) {
                listePoints[0][i] = (float)points[i].getX();
                listePoints[1][i] = (float)points[i].getY();
                ++i;
            }
        }
        return listePoints;
    }

    public static float[][] getPointsToFloat(MultiLineString ligne) {
        float[][] listePoints = null;
        int nbPointsTotal = 0;
        LineString[] lineStringArray = ligne.getLines();
        int n = lineStringArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineString l = lineStringArray[n2];
            nbPointsTotal += l.getPoints().length;
            ++n2;
        }
        int p = 0;
        listePoints = new float[2][nbPointsTotal];
        LineString[] lineStringArray2 = ligne.getLines();
        int n3 = lineStringArray2.length;
        n = 0;
        while (n < n3) {
            LineString l = lineStringArray2[n];
            Point[] points = l.getPoints();
            int i = 0;
            while (i < points.length) {
                listePoints[0][p] = (float)points[i].getX();
                listePoints[1][p] = (float)points[i].getY();
                ++p;
                ++i;
            }
            ++n;
        }
        return listePoints;
    }

    public static String getPointsToString(PGgeometry geom) {
        if (geom != null && geom.getGeometry() instanceof LineString) {
            return Geometry.getPointsToString((LineString)geom.getGeometry());
        }
        return null;
    }

    public static String getPointsToString(LineString ligne) {
        StringBuffer ligneTexte = new StringBuffer();
        if (!GLS.estVide(ligne.getPoints())) {
            Point[] points;
            Point[] pointArray = points = ligne.getPoints();
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                Point point = pointArray[n2];
                ligneTexte.append(Geometry.getPointToString(point));
                ligneTexte.append(SEPARATEUR_POINTS);
                ++n2;
            }
            if (points.length == 1) {
                ligneTexte.append(Geometry.getPointToString(ligne.getPoint(0)));
                ligneTexte.append(SEPARATEUR_POINTS);
            }
            ligneTexte.append(Geometry.getPointToString(points[points.length - 1]));
        }
        return ligneTexte.toString();
    }

    public static float[][] getLineToFloat(LineString ligne) {
        float[][] ligneFloat = new float[2][];
        if (!GLS.estVide(ligne.getPoints())) {
            Point[] points = ligne.getPoints();
            ligneFloat[0] = new float[points.length];
            ligneFloat[1] = new float[points.length];
            int i = 0;
            while (i < points.length) {
                ligneFloat[0][i] = (float)points[i].getX();
                ligneFloat[1][i] = (float)points[i].getY();
                ++i;
            }
        }
        return ligneFloat;
    }

    public static float[][] getPointToFloat(Point point) {
        float[][] ligneFloat = new float[2][];
        if (point != null) {
            ligneFloat[0] = new float[2];
            ligneFloat[1] = new float[2];
            int i = 0;
            while (i < 2) {
                ligneFloat[0][i] = (float)point.getX();
                ligneFloat[1][i] = (float)point.getY();
                ++i;
            }
        }
        return ligneFloat;
    }

    public static String getPointToString(GeoPoint point) {
        return Geometry.getPointToString(point, false);
    }

    public static String getPointToString(GeoPoint point, boolean forceAltitude) {
        if (point.getZ() > -1.0 || forceAltitude || point.tag_double > 0.0) {
            return Geometry.getPointToString(point.getX(), point.getY(), point.getZ(), point.tag_double);
        }
        return String.valueOf(point.getX()) + SEPARATEUR_COORDONNEES + point.getY();
    }

    public static String getPointToString(double x, double y, double z, double m) {
        return String.valueOf(x) + SEPARATEUR_COORDONNEES + y + SEPARATEUR_COORDONNEES + z + SEPARATEUR_COORDONNEES + m;
    }

    public static String getPointToString(double x, double y, double z) {
        return String.valueOf(x) + SEPARATEUR_COORDONNEES + y + SEPARATEUR_COORDONNEES + z;
    }

    public static String getPointToString(Point2D.Double point) {
        return String.valueOf(point.getX()) + SEPARATEUR_COORDONNEES + point.getY();
    }

    public static String getPointToString(Point point) {
        return String.valueOf(point.getX()) + SEPARATEUR_COORDONNEES + point.getY() + SEPARATEUR_COORDONNEES + point.getZ();
    }

    public static float[][] toFloat(Vector<GeoPoint> listePoints) {
        if (listePoints != null) {
            float[][] pts = new float[2][];
            if (listePoints.size() != 1) {
                pts[0] = new float[listePoints.size()];
                pts[1] = new float[listePoints.size()];
                int i = 0;
                while (i < listePoints.size()) {
                    GeoPoint p = listePoints.get(i);
                    pts[0][i] = (float)p.getX();
                    pts[1][i] = (float)p.getY();
                    ++i;
                }
            } else {
                pts[0] = new float[2];
                pts[1] = new float[2];
                GeoPoint p = listePoints.get(0);
                int i = 0;
                while (i < 2) {
                    pts[0][i] = (float)p.getX();
                    pts[1][i] = (float)p.getY();
                    ++i;
                }
            }
            return pts;
        }
        return null;
    }

    public static float[][] toFloatLL(GeoPoint point) {
        Vector<GeoPoint> l = new Vector<GeoPoint>(1);
        l.add(point);
        return Geometry.toFloatLL(l);
    }

    public static float[][] toFloatLL(Vector<GeoPoint> listePoints) {
        if (listePoints != null) {
            float[][] pts = new float[2][];
            if (listePoints.size() != 1) {
                pts[0] = new float[listePoints.size()];
                pts[1] = new float[listePoints.size()];
                int i = 0;
                while (i < listePoints.size()) {
                    GeoPoint p = listePoints.get(i).toNewLL();
                    pts[0][i] = (float)p.getX();
                    pts[1][i] = (float)p.getY();
                    ++i;
                }
            } else {
                pts[0] = new float[2];
                pts[1] = new float[2];
                GeoPoint p = listePoints.get(0).toNewLL();
                int i = 0;
                while (i < 2) {
                    pts[0][i] = (float)p.getX();
                    pts[1][i] = (float)p.getY();
                    ++i;
                }
            }
            return pts;
        }
        return null;
    }

    public static float[][] toFloat(float x, float y) {
        float[][] pt = new float[2][1];
        pt[0][0] = x;
        pt[1][0] = y;
        return pt;
    }

    public static float[][] toFloat(GeoPoint point) {
        if (point != null) {
            return Geometry.toFloat((float)point.getX(), (float)point.getY());
        }
        return null;
    }

    public static GeoPoint rechercherProjectionProche(GeoPoint point, float[] trX, float[] trY, int indiceNbPoints) {
        GeoPoint pProjTmp = null;
        GeoPoint pProj = null;
        double distTmp = 0.0;
        double dist = 0.0;
        int i = 0;
        while (i < indiceNbPoints) {
            pProjTmp = point.projection(trX[i], trY[i], trX[i + 1], trY[i + 1]);
            if (pProjTmp.estDansLePlan(trX[i], trY[i], trX[i + 1], trY[i + 1])) {
                distTmp = pProjTmp.distance(point);
                if (pProj != null) {
                    if (distTmp < dist) {
                        pProj = pProjTmp;
                        dist = distTmp;
                        pProj.tag_int = i;
                    }
                } else {
                    pProj = pProjTmp;
                    dist = distTmp;
                    pProj.tag_int = i;
                }
            }
            ++i;
        }
        return pProj;
    }

    public static GeoPoint rechercherPointDistance(InfoTroncon troncon, double distance) {
        if (troncon != null) {
            return Geometry.rechercherPointDistance(troncon.getX(), troncon.getY(), distance);
        }
        return null;
    }

    public static GeoPoint rechercherPointDistance(float[] listeXTroncon, float[] listeYTroncon, double distanceAParcourir) {
        if (listeXTroncon != null && listeYTroncon != null) {
            double tmpDistance = -1.0;
            double distanceRecalcul = 0.0;
            GeoPoint nouveauPoint = null;
            int i = 1;
            boolean distanceAtteinte = false;
            boolean finTroncon = false;
            double distanceParcourue = 0.0;
            while (!distanceAtteinte && !finTroncon) {
                tmpDistance = GeoPoint.distance(listeXTroncon[i - 1], listeYTroncon[i - 1], listeXTroncon[i], listeYTroncon[i]);
                distanceAtteinte = (distanceParcourue += tmpDistance) > distanceAParcourir;
                boolean bl = finTroncon = ++i == listeXTroncon.length;
            }
            if (distanceAtteinte) {
                GeoPoint p1 = new GeoPoint(listeXTroncon[i - 2], listeYTroncon[i - 2]);
                GeoPoint p2 = new GeoPoint(listeXTroncon[i - 1], listeYTroncon[i - 1]);
                distanceRecalcul = distanceParcourue - distanceAParcourir;
                nouveauPoint = GeoPoint.recalculLongueur(p1, p2, 0.0, tmpDistance, tmpDistance - distanceRecalcul);
            } else {
                LocalisationInfo.ecrireLog("#--> ERREUR DISTANCE NON ATTEINTE POINT EVENEMENT " + distanceParcourue + " _ " + distanceAParcourir);
                nouveauPoint = new GeoPoint(listeXTroncon[i - 1], listeYTroncon[i - 1]);
            }
            return nouveauPoint;
        }
        return null;
    }

    public static int rechercherPointProche(float[] trX, float[] trY, GeoPoint p) {
        double dxyi = 0.0;
        GeoPoint p1 = new GeoPoint(trX[0], trY[0]);
        GeoPoint pN = new GeoPoint(trX[trX.length - 1], trY[trY.length - 1]);
        double dxy0 = p.distance(p1);
        double dxyN = p.distance(pN);
        int i = 1;
        while (dxyi <= dxy0 && i < trX.length) {
            dxyi = GeoPoint.distance(trX[0], trY[0], trX[i], trY[i]);
            if (dxyi >= dxy0) {
                return i - 1;
            }
            ++i;
        }
        return 0;
    }

    public static int getSensGeographique(InfoTroncon troncon) {
        return Geometry.getSensGeographique(troncon.getPremierPoint(), troncon.getDernierPoint());
    }

    public static int getSensGeographique(GeoPoint ptDeb, GeoPoint ptFin) {
        double xdeb = ptDeb.getX();
        double ydeb = ptDeb.getY();
        double xfin = ptFin.getX();
        double yfin = ptFin.getY();
        double X = xfin - xdeb;
        double Y = yfin - ydeb;
        int sensGeo = 0;
        if (X == 0.0) {
            sensGeo = 0;
        } else {
            double YX = Y / X;
            double tan3927 = 0.414214638;
            double tan1178 = 0.784213387;
            if (-tan3927 <= YX && YX <= tan3927 && X > 0.0) {
                sensGeo = -2;
            } else if (-tan1178 <= YX && YX <= -tan3927 && X > 0.0) {
                sensGeo = -2;
            } else if ((tan1178 <= YX || YX <= -tan1178) && Y < 0.0) {
                sensGeo = 1;
            } else if (tan3927 <= YX && YX <= tan1178 && X < 0.0) {
                sensGeo = 1;
            } else if (-tan3927 <= YX && YX <= tan3927 && X < 0.0) {
                sensGeo = 2;
            } else if (-tan1178 <= YX && YX <= -tan3927 && X < 0.0) {
                sensGeo = 2;
            } else if ((tan1178 <= YX || YX <= -tan1178) && Y > 0.0) {
                sensGeo = -1;
            } else if (tan3927 <= YX && YX <= tan1178 && X > 0.0) {
                sensGeo = -1;
            }
        }
        return sensGeo;
    }

    public static boolean getSensCirculation(Tri tri) {
        return Geometry.getSensCirculation(tri.getPremierPoint(), tri.getDernierPoint());
    }

    public static boolean getSensCirculation(GeoPoint ptDeb, GeoPoint ptFin) {
        return Geometry.getSensGeographique(ptDeb, ptFin) > 0;
    }
}

