/*
 * Decompiled with CFR 0.152.
 */
package gls.geometry;

import cartoj.Enregistrement;
import cartoj.ICouche;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPoints;
import gls.geometry.Geometry;
import gls.localisation.InfoTroncon;
import gls.localisation.recherche.Recherche;
import gls.localisation.tri.Tri;
import gls.outils.GLS;
import java.util.Vector;

public class GeoPositionnement {
    private double distanceProjectionMaximum = Double.MAX_VALUE;
    private GeoPoint pointClic;
    private GeoPoint point;
    private int indicePoint;
    private InfoTroncon troncon;
    private int distanceDebut;
    private int distanceFin;
    private double distanceProjection;
    private GeoPoints pointsDebut;
    private GeoPoints pointsFin;
    private Object objet;
    private int indiceTri;

    public GeoPositionnement() {
    }

    public GeoPositionnement(GeoPoint point) {
        this.setPointClic(point);
    }

    public GeoPositionnement(GeoPoint point, Enregistrement troncon, ICouche couche) {
        this.repositionner(point, new InfoTroncon(troncon, couche));
    }

    public GeoPositionnement(GeoPoint point, InfoTroncon troncon) {
        this.repositionner(point, troncon);
    }

    public GeoPositionnement(InfoTroncon troncon, double distance) {
        this.repositionnerAtDistance(troncon, distance);
    }

    public void repositionner() {
        this.repositionner(this.point, this.troncon);
    }

    public void repositionner(GeoPoint point) {
        this.repositionner(point, this.troncon);
    }

    public void repositionner(InfoTroncon troncon) {
        this.repositionner(this.pointClic, troncon);
    }

    public static int getDepartement(InfoTroncon troncon, double distance) {
        GeoPositionnement position = new GeoPositionnement(troncon, distance);
        if (position != null) {
            return Recherche.getDepartementAtPoint(position.getPoint());
        }
        return -1;
    }

    public int getDepartement() {
        return Recherche.getDepartementAtPoint(this.point);
    }

    public boolean repositionnerSiPlusProche(Tri tri) {
        boolean repositionner = false;
        if (tri != null && tri.getNbTroncons() > 0) {
            int i = 0;
            while (i < tri.getNbTroncons()) {
                repositionner = this.repositionnerSiPlusProche(tri.getTronconSansException(i));
                ++i;
            }
        }
        return repositionner;
    }

    public boolean repositionnerSiPlusProche(Vector<InfoTroncon> troncons) {
        boolean repositionner = false;
        if (!GLS.estVide(troncons)) {
            for (InfoTroncon troncon : troncons) {
                repositionner = this.repositionnerSiPlusProche(troncon);
            }
        }
        return repositionner;
    }

    public boolean repositionnerSiPlusProche(InfoTroncon troncon) {
        if (this.pointClic != null && troncon != null) {
            GeoPoint pointTmp;
            double distanceTmp;
            if (this.distanceProjection == -1.0) {
                this.distanceProjection = Double.MAX_VALUE;
            }
            if ((distanceTmp = (pointTmp = Geometry.getProjectionPointTroncon(troncon, this.pointClic)).distance(this.pointClic)) < this.distanceProjectionMaximum && distanceTmp < this.distanceProjection) {
                this.point = pointTmp;
                this.distanceProjection = distanceTmp;
                this.indicePoint = this.point.tag_int;
                this.troncon = troncon;
                this.calculerDistance();
                return true;
            }
        }
        return false;
    }

    public void repositionnerAtDistance(InfoTroncon troncon, double distance) {
        if (troncon != null && distance > -1.0) {
            if (distance == 0.0) {
                this.repositionnerPremierPoint(troncon);
            } else if (distance == (double)troncon.getLongueur()) {
                this.repositionnerDernierPoint(troncon);
            } else {
                this.repositionner(Geometry.rechercherPointDistance(troncon, distance), troncon);
            }
        }
    }

    public void repositionnerAtDistance(double distance) {
        this.repositionnerAtDistance(this.troncon, distance);
    }

    public void initialisationListePoints() {
        if (this.pointsDebut != null) {
            this.pointsDebut.clear();
        } else {
            this.pointsDebut = new GeoPoints();
        }
        if (this.pointsFin != null) {
            this.pointsFin.clear();
        } else {
            this.pointsFin = new GeoPoints();
        }
    }

    public void initialiserPositionnement() {
        this.point = null;
        this.troncon = null;
        this.distanceDebut = -1;
        this.distanceFin = -1;
        this.indicePoint = -1;
        this.distanceProjection = Double.MAX_VALUE;
        this.pointsDebut = null;
        this.pointsFin = null;
    }

    public void initialiser() {
        this.initialiserPositionnement();
        this.pointClic = null;
    }

    public boolean estPositionne() {
        return this.troncon != null && this.point != null && this.distanceProjection < this.distanceProjectionMaximum;
    }

    public boolean estProjetee() {
        return this.troncon != null && this.distanceProjection != -1.0;
    }

    public boolean estVide() {
        return !this.estPositionne();
    }

    public void calculerDistance() {
        if (this.troncon != null && this.point != null) {
            double tmpDistance;
            float[] listeXTroncon = this.troncon.getX();
            float[] listeYTroncon = this.troncon.getY();
            this.initialisationListePoints();
            this.pointsDebut.ajouter(new GeoPoint(listeXTroncon[this.point.tag_int], listeYTroncon[this.point.tag_int]));
            double distance = tmpDistance = this.point.distance(listeXTroncon[this.point.tag_int], listeYTroncon[this.point.tag_int]);
            int i = this.point.tag_int;
            while (i > 0) {
                this.pointsDebut.ajouterAuDebut(new GeoPoint(listeXTroncon[i - 1], listeYTroncon[i - 1]));
                tmpDistance = GeoPoint.distance(listeXTroncon[i], listeYTroncon[i], listeXTroncon[i - 1], listeYTroncon[i - 1]);
                distance += tmpDistance;
                --i;
            }
            this.distanceDebut = (int)distance > this.troncon.getLongueur() ? this.troncon.getLongueur() : (int)distance;
            this.pointsFin.ajouter(new GeoPoint(listeXTroncon[this.point.tag_int + 1], listeYTroncon[this.point.tag_int + 1]));
            distance = tmpDistance = this.point.distance(listeXTroncon[this.point.tag_int + 1], listeYTroncon[this.point.tag_int + 1]);
            i = this.point.tag_int + 2;
            while (i < listeXTroncon.length) {
                this.pointsFin.ajouter(new GeoPoint(listeXTroncon[i], listeYTroncon[i]));
                tmpDistance = GeoPoint.distance(listeXTroncon[i - 1], listeYTroncon[i - 1], listeXTroncon[i], listeYTroncon[i]);
                distance += tmpDistance;
                ++i;
            }
            this.distanceFin = this.distanceDebut + (int)distance != this.troncon.getLongueur() ? this.troncon.getLongueur() - this.distanceDebut : (int)distance;
        } else {
            this.distanceDebut = -1;
            this.distanceFin = -1;
        }
    }

    public void repositionner(GeoPoint point, InfoTroncon troncon) {
        if (troncon != null && point != null) {
            this.pointClic = new GeoPoint(point.getX(), point.getY());
            this.point = Geometry.getProjectionPointTroncon(troncon, point);
            this.distanceProjection = this.pointClic.distance(this.point);
            this.indicePoint = this.point.tag_int;
            this.troncon = troncon;
            this.calculerDistance();
        } else {
            this.initialiser();
        }
    }

    public void repositionnerPremierPoint(InfoTroncon troncon) {
        this.troncon = troncon;
        this.pointClic = this.point = troncon.getPremierPoint();
        this.distanceProjection = 0.0;
        this.indicePoint = 0;
        this.calculerDistance();
    }

    public void repositionnerDernierPoint(InfoTroncon troncon) {
        this.troncon = troncon;
        this.pointClic = this.point = troncon.getDernierPoint();
        this.distanceProjection = 0.0;
        this.indicePoint = troncon.getNbPoints() - 1;
        this.point.tag_int = this.indicePoint - 1;
        this.calculerDistance();
    }

    public void inverser(boolean inverser) {
        if (this.troncon != null && this.troncon.estInverse() != inverser) {
            this.troncon.setInverse(inverser);
        }
        this.repositionner();
    }

    public void setPoint(GeoPoint point) {
        this.point = point;
    }

    public void setIndicePoint(int indicePoint) {
        this.indicePoint = indicePoint;
    }

    public void setTroncon(InfoTroncon troncon) {
        this.troncon = troncon;
    }

    public void setDistanceDebut(double distanceDebut) {
        this.distanceDebut = (int)distanceDebut;
    }

    public void setDistanceFin(double distanceFin) {
        this.distanceFin = (int)distanceFin;
    }

    public GeoPoint getPoint() {
        return this.point;
    }

    public int getIndicePoint() {
        return this.indicePoint;
    }

    public InfoTroncon getTroncon() {
        return this.troncon;
    }

    public int getDistanceDebut() {
        return this.distanceDebut;
    }

    public int getDistanceFin() {
        return this.distanceFin;
    }

    public int getDistanceDebutReelle() {
        if (this.estPositionne()) {
            if (this.troncon.estInverse()) {
                return this.distanceFin;
            }
            return this.distanceDebut;
        }
        return -1;
    }

    public int getDistanceFinReelle() {
        if (this.estPositionne()) {
            if (this.troncon.estInverse()) {
                return this.distanceDebut;
            }
            return this.distanceFin;
        }
        return -1;
    }

    public int getLongueur() {
        if (this.troncon != null && !this.troncon.estNull()) {
            return this.troncon.getLongueur();
        }
        return -1;
    }

    public void setPointClic(GeoPoint pointClic) {
        this.pointClic = pointClic;
        if (this.troncon != null) {
            this.repositionner();
        } else {
            this.distanceProjection = Double.MAX_VALUE;
        }
    }

    public void setDistanceProjection(double distanceProjection) {
        this.distanceProjection = distanceProjection;
    }

    public GeoPoint getPointClic() {
        return this.pointClic;
    }

    public double getDistanceProjection() {
        return this.distanceProjection;
    }

    public String toString() {
        return "(" + this.distanceDebut + " -- " + this.point + " -- " + this.distanceFin + ") " + (this.troncon != null ? String.valueOf(this.troncon.getIdgdf()) + "(" + this.troncon.estInverse() + " - " + this.troncon.getDF() + ") -- " + this.troncon.getAbscisseMinimum() + " <--> " + this.troncon.getAbscisseMaximum() : "t null");
    }

    public GeoPoints getPointsDebut() {
        return this.pointsDebut;
    }

    public void setPointsDebut(GeoPoints pointsDebut) {
        this.pointsDebut = pointsDebut;
    }

    public GeoPoints getPointsFin() {
        return this.pointsFin;
    }

    public void setPointsFin(GeoPoints pointsFin) {
        this.pointsFin = pointsFin;
    }

    public Object getObjet() {
        return this.objet;
    }

    public void setObjet(Object objet) {
        this.objet = objet;
    }

    public double getDistanceProjectionMaximum() {
        return this.distanceProjectionMaximum;
    }

    public void setDistanceProjectionMaximum(double distanceProjectionMaximum) {
        this.distanceProjectionMaximum = distanceProjectionMaximum;
    }

    public int getIndiceTri() {
        return this.indiceTri;
    }

    public void setIndiceTri(int indiceTri) {
        this.indiceTri = indiceTri;
    }
}

