/*
 * Decompiled with CFR 0.152.
 */
package gls.geometry;

import gls.geometry.conversion.LLtoUTM;
import gls.geometry.conversion.UTMtoLL;
import gls.localisation.LocalisationInfo;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.DecimalFormat;

public class GeoPoint
implements Serializable {
    private double x;
    private double y;
    private float z;
    private float d;
    public int tag_int;
    public double tag_double;
    public String tag_string;

    public GeoPoint(float _X, float _Y, double _d) {
        this.x = _X;
        this.y = _Y;
        this.d = (float)_d;
    }

    public GeoPoint(String monX, String monY) {
        try {
            this.x = Double.parseDouble(monX);
            this.y = Double.parseDouble(monY);
        }
        catch (Exception e) {
            System.out.println("#--> ERREUR CONVERSION STRING GeoPoint X Y # " + e.toString());
            this.x = 0.0;
            this.y = 0.0;
        }
    }

    public GeoPoint(String point) {
        try {
            int pos = point.indexOf(";");
            String strX = point.substring(0, pos).trim();
            String strY = point.substring(pos + 1).trim();
            this.x = Float.parseFloat(strX);
            this.y = Float.parseFloat(strY);
        }
        catch (Exception e) {
            System.out.println("#--> ERREUR CONVERSION 1 STRING GeoPoint X Y # " + e.toString());
            this.x = 0.0;
            this.y = 0.0;
        }
    }

    public GeoPoint(Point2D.Float p) {
        this.x = p.x;
        this.y = p.y;
    }

    public GeoPoint(double _X, double _Y, double _d) {
        this.d = (float)_d;
        this.x = _X;
        this.y = _Y;
    }

    public String getSigneX() {
        return this.x >= 0.0 ? "+" : "-";
    }

    public String getSigneY() {
        return this.y >= 0.0 ? "+" : "-";
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = (float)z;
    }

    public static final GeoPoint LOL2LL(String lol) {
        String signeX = String.valueOf(lol.charAt(0));
        String signeY = String.valueOf(lol.charAt(11));
        String tmpX = lol.substring(2, 10);
        String tmpY = lol.substring(13);
        float lolX = Float.parseFloat(tmpX);
        float lolY = Float.parseFloat(tmpY);
        if (!signeX.equals("+")) {
            lolX *= -1.0f;
        }
        if (!signeY.equals("+")) {
            lolY *= -1.0f;
        }
        return new GeoPoint(lolX, lolY);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public static final GeoPoint LOL2UTM(String lol) {
        return GeoPoint.LOL2LL(lol).toUTM();
    }

    public String toLOL() {
        DecimalFormat decFormatX = new DecimalFormat("0.000000");
        DecimalFormat decFormatY = new DecimalFormat("00.00000");
        return (String.valueOf(this.getSigneX()) + '/' + decFormatX.format(Math.abs(this.x)) + '/' + this.getSigneY() + '/' + decFormatY.format(Math.abs(this.y))).replace(',', '.');
    }

    public static final double distance(float _x1, float _y1, float _x2, float _y2) {
        return Math.sqrt((_x2 - _x1) * (_x2 - _x1) + (_y2 - _y1) * (_y2 - _y1));
    }

    public static boolean intersect(GeoPoint pA, GeoPoint p1, GeoPoint p2) {
        return GeoPoint.intersect((float)pA.x, (float)pA.y, (float)p1.x, (float)p1.y, (float)p2.x, (float)p2.y);
    }

    public static boolean intersect(float xA, float yA, float x1, float y1, float x2, float y2) {
        double tmpY1;
        double tmpY2;
        double tmpX1;
        double tmpX2;
        if (x1 > x2) {
            tmpX2 = x1;
            tmpX1 = x2;
            tmpY2 = y1;
            tmpY1 = y2;
        } else {
            tmpX1 = x1;
            tmpX2 = x2;
            tmpY1 = y1;
            tmpY2 = y2;
        }
        if (GeoPoint.estDansLePlan(xA, yA, x1, y1, x2, y2)) {
            double a = (tmpY2 - tmpY1) / (tmpX2 - tmpX1);
            double b = (a * tmpX1 - tmpY1) * -1.0;
            boolean intersect = (double)yA == a * (double)xA + b;
            return intersect;
        }
        return false;
    }

    public boolean estDansLePlan(float x1, float y1, float x2, float y2) {
        return GeoPoint.estDansLePlan((float)this.x, (float)this.y, x1, y1, x2, y2);
    }

    public static boolean estDansLePlan(float xA, float yA, float x1, float y1, float x2, float y2) {
        return Math.min(x1, x2) <= xA && xA <= Math.max(x1, x2) && Math.min(y1, y2) <= yA && yA <= Math.max(y1, y2);
    }

    public boolean intersect(float x1, float y1, float x2, float y2) {
        return GeoPoint.intersect((float)this.x, (float)this.y, x1, y1, x2, y2);
    }

    public static final double distance(GeoPoint _p1, GeoPoint _p2) {
        return GeoPoint.distance((float)_p1.x, (float)_p1.y, (float)_p2.x, (float)_p2.y);
    }

    public double distance(GeoPoint p2) {
        return GeoPoint.distance((float)this.x, (float)this.y, (float)p2.x, (float)p2.y);
    }

    public static double distance(GeoPoint p1, float x2, float y2) {
        return GeoPoint.distance((float)p1.x, (float)p1.y, x2, y2);
    }

    public double distance(float x1, float y1) {
        return GeoPoint.distance((float)this.x, (float)this.y, x1, y1);
    }

    public GeoPoint(double _X, double _Y) {
        this.d = 0.0f;
        this.x = _X;
        this.y = _Y;
    }

    public GeoPoint(float _X, float _Y) {
        this.x = _X;
        this.y = _Y;
        this.d = 0.0f;
    }

    public GeoPoint() {
        this.x = 0.0;
        this.y = 0.0;
        this.d = 0.0f;
    }

    public boolean isNull() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public boolean isNull2() {
        return this.x == 0.0 || this.y == 0.0;
    }

    public GeoPoint toUTM(double _x, double _y) {
        LLtoUTM ll2utm = new LLtoUTM(LocalisationInfo.zoneUTM);
        this.set(ll2utm.LL2UTM(23, _y, _x));
        return this;
    }

    public static GeoPoint projection(GeoPoint pX, GeoPoint pA, GeoPoint pB) {
        double a = (pA.y - pB.y) / (pA.x - pB.x);
        double b = pA.y - a * pA.x;
        double mx = ((pX.x + a * pX.y) / a - b) / (a + 1.0 / a);
        double my = a * mx + b;
        if (Double.isNaN(mx) || Double.isNaN(my)) {
            return pX;
        }
        return new GeoPoint(mx, my);
    }

    public static GeoPoint projection(float x1, float y1, float xA, float yA, float xB, float yB) {
        float a = (yA - yB) / (xA - xB);
        float b = yA - a * xA;
        float mx = ((x1 + a * y1) / a - b) / (a + 1.0f / a);
        float my = a * mx + b;
        if (Float.isNaN(mx) || Float.isNaN(my)) {
            return new GeoPoint(x1, y1);
        }
        return new GeoPoint(mx, my);
    }

    public GeoPoint projection(float xA, float yA, float xB, float yB) {
        return GeoPoint.projection((float)this.x, (float)this.y, xA, yA, xB, yB);
    }

    public GeoPoint projection(GeoPoint pA, GeoPoint pB) {
        return GeoPoint.projection(this, pA, pB);
    }

    public static GeoPoint recalculLongueur(float x1, float y1, float x2, float y2, double distance1, double distance2, double distance) {
        x1 = (float)((double)x1 + (distance - distance1) / (distance2 - distance1) * (double)(x2 - x1));
        y1 = (float)((double)y1 + (distance - distance1) / (distance2 - distance1) * (double)(y2 - y1));
        return new GeoPoint(x1, y1);
    }

    public static GeoPoint recalculLongueur(GeoPoint p1, GeoPoint p2, double distance1, double distance2, double distance) {
        return GeoPoint.recalculLongueur((float)p1.x, (float)p1.y, (float)p2.x, (float)p2.y, distance1, distance2, distance);
    }

    public Point2D.Double toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    public Point2D.Float toPoint2F() {
        return new Point2D.Float((float)this.x, (float)this.y);
    }

    public GeoPoint toUTM(int refellips, double _x, double _y) {
        LLtoUTM ll2utm = new LLtoUTM(LocalisationInfo.zoneUTM);
        this.set(ll2utm.LL2UTM(refellips, _y, _x));
        return this;
    }

    public GeoPoint toUTM(int refellips) {
        LLtoUTM ll2utm = new LLtoUTM(LocalisationInfo.zoneUTM);
        this.set(ll2utm.LL2UTM(refellips, this.y, this.x));
        return this;
    }

    public final GeoPoint toNewUTM() {
        LLtoUTM ll2utm = new LLtoUTM(LocalisationInfo.zoneUTM);
        return ll2utm.LL2UTM(23, this.y, this.x);
    }

    public final GeoPoint toNewLL() {
        UTMtoLL utm2ll = new UTMtoLL(LocalisationInfo.zoneUTM, LocalisationInfo.hemisphereUTM);
        return utm2ll.UTM2LL(23, this.y, this.x);
    }

    public GeoPoint toUTM() {
        LLtoUTM ll2utm = new LLtoUTM(LocalisationInfo.zoneUTM);
        this.set(ll2utm.LL2UTM(23, this.y, this.x));
        return this;
    }

    public GeoPoint toUTMZone(int zone) {
        LLtoUTM ll2utm = new LLtoUTM(zone);
        this.set(ll2utm.LL2UTM(23, this.y, this.x));
        return this;
    }

    public final GeoPoint toLL() {
        UTMtoLL utm2ll = new UTMtoLL(LocalisationInfo.zoneUTM, LocalisationInfo.hemisphereUTM);
        this.set(utm2ll.UTM2LL(23, this.y, this.x));
        return this;
    }

    private double MintoDegree(double v) {
        String tmpV = String.valueOf(v);
        int posV = tmpV.indexOf(46);
        if (posV == -1) {
            posV = tmpV.indexOf(44);
        }
        long tmpVal = Long.valueOf(tmpV.substring(posV + 1, tmpV.length()));
        tmpV = String.valueOf(tmpV.substring(0, posV + 1)) + String.valueOf(tmpVal / 60L * 1000L);
        return Double.valueOf(tmpV);
    }

    private double MintoDegree(String v) {
        int posV;
        int coeff = 1;
        if (v.charAt(0) == '-') {
            coeff = -1;
        }
        if ((posV = v.indexOf(46)) == -1) {
            posV = v.indexOf(44);
        }
        String minuteString = v.substring(posV - 2, v.length());
        long degree = Math.abs(Long.valueOf(v.substring(0, posV - 2)));
        double minute = Double.valueOf(minuteString);
        double result = (double)coeff * ((double)degree + minute / 60.0);
        return result;
    }

    public void set(GeoPoint _p) {
        this.x = _p.x;
        this.y = _p.y;
    }

    public void set(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public void set(float _x, float _y) {
        this.x = _x;
        this.y = _y;
    }

    public GeoPoint toDegrees() {
        this.set(this.MintoDegree(this.x), this.MintoDegree(this.y));
        return this;
    }

    public String toString() {
        return String.valueOf(this.x) + ";" + this.y;
    }

    public boolean egal(GeoPoint p) {
        return this.egal(p.x, p.y);
    }

    public boolean egal(float px, float py) {
        return this.x == (double)px && this.y == (double)py;
    }

    public boolean egal(double pX, double pY) {
        return this.x == pX && this.y == pY;
    }

    public boolean equals(Object p) {
        if (p instanceof GeoPoint) {
            return this.x == ((GeoPoint)p).getX() && this.y == ((GeoPoint)p).getY();
        }
        return false;
    }

    public boolean equals(float px, float py) {
        return this.x == (double)px && this.y == (double)py;
    }

    public boolean equals(double pX, double pY) {
        return this.x == pX && this.y == pY;
    }

    public GeoPoint toDegrees(String latitude, String longitude) {
        this.set(this.MintoDegree(latitude), this.MintoDegree(longitude));
        return this;
    }
}

