/*
 * Decompiled with CFR 0.152.
 */
package gls.csv.lecteur;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVLecteur {
    public static final String SEPARATEUR = ";";
    private static final String VIDE = "";
    private static Pattern pattern;
    private String nomFichier = null;
    private BufferedReader fichierCVS = null;
    private Vector<String> entete = null;
    private int nombreLignes = -1;
    private String enteteLu = null;
    private String separateur = ";";
    private String ligneEnCours = "";

    public CSVLecteur(String nomFichier) throws Exception {
        pattern = Pattern.compile(this.setRegex());
        this.initialisationFichier(nomFichier);
    }

    public CSVLecteur(String nomFichier, char separateur) throws Exception {
        pattern = Pattern.compile(this.setRegex());
        this.separateur = String.valueOf(separateur);
        this.initialisationFichier(nomFichier);
    }

    public void process(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            Vector<String> vector = this.parse(line);
        }
    }

    public Vector<String> parse(String line) {
        Vector<String> v = new Vector<String>();
        if (line.endsWith(this.separateur)) {
            line = line.concat(this.separateur);
        }
        Matcher m = pattern.matcher(line);
        while (m.find()) {
            String match = m.group();
            if (match == null) break;
            if (match.endsWith(this.separateur)) {
                match = match.substring(0, match.length() - 1);
            }
            if (match.startsWith("\"")) {
                match = match.substring(1, match.length() - 1);
            }
            if (match.length() == 0) {
                match = null;
            }
            v.add(match);
        }
        return v;
    }

    public Vector<String> getEntete() throws IOException {
        if (this.entete == null) {
            if (this.enteteLu == null) {
                while ((this.enteteLu = this.fichierCVS.readLine()) != null && this.enteteLu.equals(VIDE)) {
                }
            }
            this.entete = this.parse(this.enteteLu);
        }
        return this.entete;
    }

    public int compterNombreLignes() throws Exception {
        if (this.nombreLignes == -1) {
            int nbLigne = 0;
            while (this.fichierCVS.readLine() != null) {
                ++nbLigne;
            }
            this.nombreLignes = nbLigne - 1;
        }
        return this.nombreLignes;
    }

    private void initialisationFichier(String nomFichier) throws Exception {
        if (this.fichierCVS != null) {
            this.fichierCVS.close();
        }
        this.nomFichier = nomFichier;
        this.fichierCVS = new BufferedReader(new FileReader(nomFichier));
        this.compterNombreLignes();
        this.fichierCVS.close();
        this.fichierCVS = new BufferedReader(new FileReader(nomFichier));
        this.getEntete();
    }

    public Vector<String> lireLigne() throws Exception {
        String ligne = this.fichierCVS.readLine();
        Vector<String> valeurs = null;
        if (ligne != null) {
            this.ligneEnCours = ligne;
            valeurs = this.parse(ligne);
        }
        return valeurs;
    }

    public String getNomFichier() {
        return this.nomFichier;
    }

    public static void main(String[] args) throws Exception {
        CSVLecteur lecteur = new CSVLecteur("D:/Donnees/donnees/TEST/LienSupCom/lien_virgule.csv");
        lecteur.setSeparateur(",");
    }

    public void reinitialisation() throws Exception {
        this.initialisationFichier(this.nomFichier);
    }

    public String getSeparateur() {
        return this.separateur;
    }

    public void setSeparateur(String separateur) {
        this.entete = null;
        this.separateur = separateur;
        pattern = Pattern.compile(this.setRegex());
    }

    private String setRegex() {
        return "\"([^\"]+?)\"" + this.separateur + "?|([^" + this.separateur + "]+)" + this.separateur + "?|" + this.separateur;
    }

    public String getLigneEnCours() {
        return this.ligneEnCours;
    }

    public String getEnteteLu() {
        return this.enteteLu;
    }
}

