/*
 * Decompiled with CFR 0.152.
 */
package gls.console.imp;

import gls.console.Console;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.rtf.RTFEditorKit;

public class ConsoleImp
extends JTextPane
implements Console {
    public static int INCREMENT = 2;
    private SimpleAttributeSet style = new SimpleAttributeSet();
    private SimpleAttributeSet hrefStyle = new SimpleAttributeSet();
    private Hashtable actions;
    private boolean hadEverBeenFixed = false;
    private Document doc;
    private boolean smileyEnabled = true;
    private boolean keyWordEnabled = false;
    private int fontSize = 12;
    private int matchIndex = 0;
    private int currentPosition;

    public ConsoleImp() {
        StyleConstants.setFontSize(this.style, this.fontSize);
        StyleConstants.setFontFamily(this.style, "Verdana");
        this.setContentType("text/rtf");
        this.setEditorKit(new RTFEditorKit());
        this.setEditable(false);
        this.doc = this.getDocument();
        this.currentPosition = this.doc.getLength();
    }

    public void append(String msg, boolean bold) {
        this.append(msg, Color.black, bold, false);
    }

    public void append(String msg, boolean bold, boolean ajoutEnTete) {
        this.append(msg, Color.black, bold, ajoutEnTete);
    }

    public void append(String msg, Color color, boolean isBold, boolean ajoutEnTete) {
        this.append(msg, color, Color.white, isBold, ajoutEnTete);
    }

    public void append(String msg, Color color, boolean isBold) {
        this.append(msg, color, Color.white, isBold, false);
    }

    public void append(String msg, Color color, Color bgColor, boolean isBold) {
        this.append(msg, color, bgColor, isBold, false);
    }

    public void append(String msg, Color color, Color bgColor, boolean isBold, boolean ajoutEnTete) {
        int len;
        StyleConstants.setForeground(this.style, color);
        StyleConstants.setBackground(this.style, bgColor);
        StyleConstants.setBold(this.style, isBold);
        this.currentPosition = len = ajoutEnTete ? 0 : this.doc.getLength();
        try {
            this.doc.insertString(len, msg, this.style);
            this.setEditable(true);
            this.setEditable(false);
            this.doc.insertString(this.doc.getLength(), "", this.style);
        }
        catch (Exception e) {
            System.err.println("Failed to append msg [" + e.getMessage() + "]");
        }
        this.fixMe();
    }

    @Override
    public void remove(int taille) {
        int len;
        this.currentPosition = len = this.doc.getLength();
        try {
            this.doc.remove(len - taille, taille);
            this.setEditable(true);
            this.setEditable(false);
            this.doc.insertString(this.doc.getLength(), "", this.style);
        }
        catch (Exception e) {
            System.err.println("Failed to remove [" + e.getMessage() + "]");
        }
        this.fixMe();
    }

    public void setSmileyEnabled(boolean flag) {
        this.smileyEnabled = flag;
    }

    public void setFontFamily(String family) {
        StyleConstants.setFontFamily(this.style, family);
        StyleConstants.setFontFamily(this.hrefStyle, family);
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        if (this.style != null && this.hrefStyle != null) {
            StyleConstants.setFontSize(this.style, this.fontSize);
            StyleConstants.setFontSize(this.hrefStyle, this.fontSize);
        }
    }

    public void increaseSize() {
        this.fontSize += INCREMENT;
        this.selectAll();
        StyleConstants.setFontSize(this.style, this.fontSize);
        StyleConstants.setFontSize(this.hrefStyle, this.fontSize);
    }

    public void decreaseSize() {
        this.fontSize -= INCREMENT;
        StyleConstants.setFontSize(this.style, this.fontSize);
        StyleConstants.setFontSize(this.hrefStyle, this.fontSize);
        this.selectAll();
    }

    public void fixMe() {
        this.setCaretPosition(this.doc.getLength());
        if (!this.hadEverBeenFixed) {
            Dimension d = this.getSize();
            this.setSize((int)d.getHeight(), (int)d.getWidth());
            this.hadEverBeenFixed = true;
        }
    }

    @Override
    public void afficherMessage(String message) {
        this.append(String.valueOf(message) + "\n", true, false);
    }

    @Override
    public void afficherMessageErreur(String message) {
        this.append(String.valueOf(message) + "\n", Color.red, Color.yellow, true, false);
    }

    @Override
    public void afficherMessageInformation(String message) {
        this.append(String.valueOf(message) + "\n", Color.yellow, Color.blue, true, false);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("test");
        f.setSize(100, 100);
        ConsoleImp c = new ConsoleImp();
        c.scrollRectToVisible(new Rectangle(10, 10));
        JScrollPane scroll = new JScrollPane(22, 30);
        scroll.getViewport().add(c);
        f.getContentPane().add(scroll);
        f.setVisible(true);
        c.append("Erreur\n", Color.red, Color.yellow, true, true);
        c.append("Top\n", false);
        c.append("Top\n", true);
        c.append("Erreur\n", Color.red, Color.yellow, true, true);
        c.append("Top\n", false);
        c.append("Top\n", true);
        c.append("Erreur\n", Color.red, Color.yellow, true, true);
        c.append("Top\n", false);
        c.append("Tirelipinpomsurlechiwawa\n", true);
        c.remove(10);
    }
}

