/*
 * Decompiled with CFR 0.152.
 */
package gls.comparator;

import gls.outils.GLS;
import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;

public class MyCollator
extends Collator
implements Serializable {
    public static String NOUVELLES_REGLES = "& ' ' < '.' < '_' = '-' < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9 < a = A = \u00e0 = \u00e4 = \u00e2 = \u00c0 = \u00c2 = \u00c0 = \u00c6 < b = B < c = C = \u00c7 < d = D < e = E = \u00e9 = \u00e8 = \u00ea = \u00eb = \u00c8 = \u00c9 = \u00ca = \u00cb < F = f < g = G < h = H < i = I = \u00ee = \u00ef < j = J < k = K < l = L < M = m < n = N < o = O < p = P < q = Q < r = R < s = S < t = T < u = U  = \u00f9 = \u00fb = \u00fc = \u00da = \u00db = \u00d9 < v = V < w = W < x = X < y = \u00ff = Y = \u00dd < z = Z";
    public static int COLLATOR_STRENGH = 0;
    public static Locale LOCALE = Locale.FRENCH;
    private static Collator collator = MyCollator.create();

    public static Collator create() {
        RuleBasedCollator r1 = (RuleBasedCollator)Collator.getInstance(Locale.FRANCE);
        r1.setStrength(COLLATOR_STRENGH);
        String en_USRules = r1.getRules();
        RuleBasedCollator r2 = null;
        try {
            r2 = new RuleBasedCollator(String.valueOf(en_USRules) + NOUVELLES_REGLES);
            r2.setStrength(COLLATOR_STRENGH);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        return r2;
    }

    @Override
    public int hashCode() {
        return collator.hashCode();
    }

    @Override
    public int compare(String arg0, String arg1) {
        if (arg0 != null && arg1 != null) {
            return collator.compare(arg0.replace(' ', '_'), arg1.replace(' ', '_'));
        }
        return -1;
    }

    @Override
    public CollationKey getCollationKey(String arg0) {
        return collator.getCollationKey(arg0);
    }

    public static String[] sortInteger(String[] array) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String elt = stringArray[n2];
            map.put(GLS.getInt(elt), elt);
            ++n2;
        }
        Iterator it = map.keySet().iterator();
        String[] eltTrie = new String[map.keySet().size()];
        int i = 0;
        while (it.hasNext()) {
            eltTrie[i++] = GLS.getString(it.next());
        }
        return eltTrie;
    }

    public static Vector<String> sortInteger(Vector<String> array) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        for (String elt : array) {
            map.put(GLS.getInt(elt), elt);
        }
        Iterator it = map.keySet().iterator();
        Vector<String> eltTrie = new Vector<String>();
        while (it.hasNext()) {
            eltTrie.add(GLS.getString(it.next()));
        }
        return eltTrie;
    }

    public static Vector<String> sortIntegerPositif(Vector<String> array) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        for (String elt : array) {
            int i = GLS.getInt(elt);
            if (i <= -1) continue;
            map.put(i, elt);
        }
        Iterator it = map.keySet().iterator();
        Vector<String> eltTrie = new Vector<String>();
        while (it.hasNext()) {
            eltTrie.add(GLS.getString(it.next()));
        }
        return eltTrie;
    }

    public static String[] sort(String[] array) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String elt = stringArray[n2];
            map.put(elt, elt);
            ++n2;
        }
        Iterator it = map.keySet().iterator();
        String[] eltTrie = new String[map.keySet().size()];
        int i = 0;
        while (it.hasNext()) {
            eltTrie[i++] = (String)it.next();
        }
        return eltTrie;
    }

    public static Vector sort(Vector array) {
        TreeMap map = new TreeMap();
        for (Object elt : array) {
            map.put(elt.toString(), elt);
        }
        Iterator it = map.values().iterator();
        Vector eltTrie = new Vector(map.keySet().size());
        boolean i = false;
        while (it.hasNext()) {
            eltTrie.add(it.next());
        }
        return eltTrie;
    }
}

