/*
 * Decompiled with CFR 0.152.
 */
package gls.carto.mapinfo;

import gls.carto.mapinfo.ConstantesMapInfo;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPoints;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCSV;
import gls.outils.fichier.MonFichier;
import java.util.HashMap;

public class FichierKeyMID
extends FichierCSV
implements ConstantesMapInfo {
    private HashMap<String, Object> tableGeometrie = new HashMap();
    private MonFichier fichierMif;
    private boolean fichierMifOk = false;

    public FichierKeyMID() throws Exception {
        this(',');
    }

    public FichierKeyMID(char separateur) throws Exception {
        this(Fichier.choixFichier("mid"), separateur, 0);
    }

    public FichierKeyMID(String cheminFichier) {
        super(cheminFichier, ',', 0);
    }

    public FichierKeyMID(String cheminFichier, char separateur) {
        super(cheminFichier, separateur, 0);
    }

    public FichierKeyMID(String cheminFichier, char separateur, int indiceChampCle) {
        super(cheminFichier, separateur, indiceChampCle);
    }

    @Override
    public boolean estValeursValide(String[] valeurs) {
        return true;
    }

    public boolean estLigneNombreColonne(String ligne) {
        return !GLS.estVide(ligne) && ligne.toLowerCase().startsWith("Columns ".toLowerCase());
    }

    public boolean estLigneDebutDonnees(String ligne) {
        return !GLS.estVide(ligne) && ligne.toLowerCase().startsWith("Data".toLowerCase());
    }

    public String getNomColonne(String ligne) {
        String tmp = ligne.trim();
        if (!GLS.estVide(tmp)) {
            return tmp.substring(0, tmp.indexOf(" "));
        }
        return "";
    }

    public boolean estLigneSeparateur(String ligne) {
        return ligne.startsWith("Delimiter ");
    }

    protected void miseAJourSeparateur(String ligne) {
        try {
            this.SEPARATEUR = ligne.substring("Delimiter ".length()).replaceAll("\"", "");
            this.separateur = this.SEPARATEUR.charAt(0);
        }
        catch (Exception e) {
            this.SEPARATEUR = ",";
            this.separateur = (char)44;
        }
    }

    @Override
    public void initialiser() throws Exception {
        this.fichierMif = new MonFichier(Fichier.changerExtension(this.chemin, "mif"), 2);
        if (this.fichierMif.isReady()) {
            String ligne;
            boolean trouve = false;
            do {
                if (this.estLigneSeparateur(ligne = this.fichierMif.lire())) {
                    this.miseAJourSeparateur(ligne);
                }
                trouve = this.estLigneNombreColonne(ligne);
            } while (this.fichierMif.isReady() && !trouve);
            this.nbChamps = trouve ? GLS.getInt(ligne.substring("Columns ".length())) : -1;
            if (this.nbChamps != -1) {
                this.champs = new String[this.nbChamps];
                int i = 0;
                while (i < this.nbChamps) {
                    if (this.fichierMif.isReady()) {
                        ligne = this.fichierMif.lire();
                        this.champs[i] = this.getNomColonne(ligne);
                    }
                    ++i;
                }
            }
            do {
                ligne = this.fichierMif.lire();
                trouve = this.estLigneDebutDonnees(ligne);
            } while (this.fichierMif.isReady() && !trouve);
            this.fichierMifOk = trouve;
        } else {
            this.fichierMifOk = false;
        }
    }

    @Override
    public void ajouter(String[] ligne) {
        super.ajouter(ligne);
        if (this.fichierMifOk) {
            this.ajouterProchaineGeometrie(ligne[this.indiceChampCle]);
        }
    }

    public static boolean estGeometrieVide(String[] ligne) {
        return GLS.estVide(ligne) || FichierKeyMID.estGeometrieVide(ligne[0]);
    }

    public static boolean estGeometrieVide(String ligne) {
        return GLS.estVide(ligne) || ligne.indexOf("none") != -1;
    }

    protected boolean estLignePonctuelle(String ligne) {
        return ligne.toLowerCase().startsWith("point ");
    }

    protected boolean estLigneLineaire(String ligne) {
        return ligne.toLowerCase().startsWith("pline ");
    }

    protected boolean estLigneGeometriqueVide(String ligne) {
        return ligne.toLowerCase().startsWith("none");
    }

    protected boolean estLigneGeometrique(String ligne) {
        return !GLS.estVide(ligne) && (this.estLignePonctuelle(ligne) || this.estLigneLineaire(ligne) || this.estLigneGeometriqueVide(ligne));
    }

    protected GeoPoint getObjetPoint(String ligne) {
        String[] coordonnees = ligne.substring("point ".length()).split(" ");
        GeoPoint point = null;
        point = coordonnees != null && coordonnees.length == 2 ? new GeoPoint(coordonnees[0], coordonnees[1]) : null;
        return point;
    }

    private int getNbSommet(String ligne) throws Exception {
        if (!GLS.estVide(ligne) && ligne.toLowerCase().startsWith("pline ")) {
            return GLS.getInt(ligne.substring("pline ".length()).trim());
        }
        throw new Exception("ERREUR LE NOMBRE DE LIGNE EST INCORRECTE");
    }

    protected GeoPoints getObjetLigne(String ligne) {
        GeoPoints points;
        int nbSommets;
        try {
            nbSommets = this.getNbSommet(ligne);
            points = new GeoPoints();
        }
        catch (Exception e) {
            nbSommets = -1;
            points = null;
        }
        int i = 0;
        while (i < nbSommets) {
            String[] coordonnees;
            try {
                coordonnees = this.fichierMif.lire().split(" ");
            }
            catch (Exception e) {
                coordonnees = null;
            }
            if (coordonnees != null && coordonnees.length == 2) {
                points.ajouter(new GeoPoint(coordonnees[0], coordonnees[1]));
            }
            ++i;
        }
        return points;
    }

    public Object getGeometrie(String cle) throws Exception {
        Object objet = this.tableGeometrie.containsKey(cle) ? this.tableGeometrie.get(cle) : null;
        if (objet != null) {
            return objet;
        }
        throw new Exception("ERREUR LA GEOMETRIE EST NULLE");
    }

    public GeoPoint getPoint(String cle) throws Exception {
        Object objet = this.getGeometrie(cle);
        if (objet instanceof GeoPoint) {
            return (GeoPoint)objet;
        }
        throw new Exception("ERREUR CETTE GEOMETRIE N'EST PAS DE TYPE POINT");
    }

    public GeoPoints getLigne(String cle) throws Exception {
        Object objet = this.getGeometrie(cle);
        if (objet instanceof GeoPoints) {
            return (GeoPoints)objet;
        }
        throw new Exception("ERREUR CETTE GEOMETRIE N'EST PAS DE TYPE LIGNE");
    }

    public String getPointMif(String cle) {
        try {
            return this.getPointMif(this.getPoint(cle));
        }
        catch (Exception e) {
            return "none";
        }
    }

    public String[] getObjetMif(Object objet) {
        if (objet == null) {
            return LIGNE_GEOMETRIQUE_VIDE;
        }
        if (objet instanceof GeoPoint) {
            return new String[]{this.getPointMif((GeoPoint)objet)};
        }
        if (objet instanceof GeoPoints) {
            return this.getPointsMif((GeoPoints)objet);
        }
        return LIGNE_GEOMETRIQUE_VIDE;
    }

    public String getPointMif(GeoPoint point) {
        if (point != null && !point.isNull()) {
            return "point ".concat(String.valueOf(point.getX())).concat(" ").concat(String.valueOf(point.getY()));
        }
        return "none";
    }

    public String[] getPointsMif(GeoPoints points) {
        if (!GLS.estVide(points)) {
            String[] ligne = new String[points.size() + 1];
            ligne[0] = "Pline ".concat(GLS.getString(points.size()));
            int i = 0;
            while (i < points.size()) {
                ligne[i + 1] = String.valueOf(((GeoPoint)points.get(i)).getX()).concat(" ").concat(String.valueOf(((GeoPoint)points.get(i)).getY()));
                ++i;
            }
            return ligne;
        }
        return LIGNE_GEOMETRIQUE_VIDE;
    }

    protected void ajouterProchaineGeometrie(String cle) {
        boolean trouve = false;
        while (this.fichierMif.isReady() && !trouve) {
            try {
                String ligne = this.fichierMif.lire();
                if (!this.estLigneGeometrique(ligne)) continue;
                trouve = true;
                this.tableGeometrie.put(cle, this.getObjetGeometrie(ligne));
            }
            catch (Exception e) {
                GLS.getLogs().error((Object)"ERREUR INTEGRATION GEOMETRIE ", (Throwable)e);
            }
        }
    }

    public Object getProchaineGeometrie() {
        Object geometry = null;
        if (this.fichierMifOk) {
            boolean trouve = false;
            while (this.fichierMif.isReady() && !trouve) {
                try {
                    String ligne = this.fichierMif.lire();
                    if (!this.estLigneGeometrique(ligne)) continue;
                    trouve = true;
                    geometry = this.getObjetGeometrie(ligne);
                }
                catch (Exception e) {
                    GLS.getLogs().error((Object)"ERREUR INTEGRATION GEOMETRIE ", (Throwable)e);
                }
            }
        }
        return geometry;
    }

    protected Object getObjetGeometrie(String ligne) {
        if (this.estLignePonctuelle(ligne)) {
            return this.getObjetPoint(ligne);
        }
        if (this.estLigneLineaire(ligne)) {
            return this.getObjetLigne(ligne);
        }
        return null;
    }

    @Override
    public void charger() throws Exception {
        super.charger();
        if (this.fichierMifOk && this.fichierMif != null) {
            this.fichierMif.fermer();
        }
    }

    public static void main(String ... strings) {
        try {
            FichierKeyMID fKM = new FichierKeyMID();
            fKM.initialiser();
            fKM.charger();
            fKM.getPointMif("991461592");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

