/*
 * Decompiled with CFR 0.152.
 */
package gls.carto;

import gls.localisation.LocalisationInfo;
import gls.outils.ConstantesGLS;
import gls.outils.Couleur;
import gls.outils.GLS;
import gls.outils.fichier.FichierCONFIG;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class StyleCouche {
    public static Logger log = Logger.getLogger(StyleCouche.class);
    public static final int TYPE_COUCHED = 1;
    public static final int TYPE_COUCHEU = 2;
    public static final int TYPE_COUCHE_RASTER_ECW = 3;
    public static final int TYPE_COUCHE_RASTER_WMS = 4;
    public static final String VAL_COUCHED = "D";
    public static final String VAL_COUCHEU = "U";
    public static final String VAL_COUCHER_RASTER_ECW = "RASTER_ECW";
    public static final String VAL_COUCHER_RASTER_WMS = "RASTER_WMS";
    public static final float ZOOM_ERREUR = -1.0f;
    public static final float INT_ERREUR = -1.0f;
    public static final Font FONT_DEFAUT = new Font("Arial", 1, 10);
    public static final Color COULEUR_FONT_DEFAUT = Color.black;
    private static final String separateurChamps = ";";
    private static final int FONT_SIZE_DEFAUT = 8;
    private static final Color FONT_COLOR_DEFAUT = Color.black;
    private int fontSize = 8;
    private String fontPolice = "Serif";
    private int fontOption = 0;
    private Color fontColor = FONT_COLOR_DEFAUT;
    private int typeCouche;
    private String[] noms;
    private int positionEtiquette;
    private int nbIcone;
    private float zoomAffichage = 1.0f;
    private float zoomAffichageMin = Float.MAX_VALUE;
    private String repertoire = null;
    private String fichierWMS = null;
    private Color[] couleursInterieures;
    private Color[] couleursExterieures;
    private int[] epaisseurs;
    private String[] valeurs;
    private String[] images;
    private int etiquette;
    private int indiceChamp;
    private Color couleurFont;
    private Font font;
    private String[] libelle = null;
    private boolean pointille = false;
    private boolean transparent = false;
    private float transparence = 0.0f;
    private float zoomAffichageLibelle = Float.MIN_VALUE;
    private boolean fontOptionUnderline = false;
    private boolean fontOptionGras;
    private boolean fontOptionItalic;
    private Color[] fontCouleurEncadre;
    private boolean aFontCouleurEncadre;
    private boolean lateralisation = true;
    private double distance = 20.0;
    private int champsSens = -1;
    private int lateraliteSens = 1;
    private String valeurSensPositif;
    private boolean libelleFondTransparent = false;

    public StyleCouche() {
    }

    public static final StyleCouche getInstance() {
        return new StyleCouche("", 1.0f, Color.blue, Color.blue, 1, "", -1);
    }

    public static final StyleCouche getInstance(String nom) {
        return new StyleCouche(nom, 1.0f, Color.blue, Color.blue, 1, "", -1);
    }

    public static StyleCouche chargerFichierStyle(String fichier, String chemin) {
        return StyleCouche.chargerFichierStyle(fichier, null, chemin);
    }

    public static StyleCouche chargerFichierStyle(String fichier, FichierCONFIG config) {
        return StyleCouche.chargerFichierStyle(fichier, config, String.valueOf(config.getString("cheminParametres", "parametres/")) + config.getString("carte") + "/carto/");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static StyleCouche chargerFichierStyle(String fichier, FichierCONFIG config, String chemin) {
        FichierCONFIG fichierStyle = new FichierCONFIG(String.valueOf(chemin) + fichier + ".style");
        log.debug((Object)("CHARGEMENT DU FICHIER: " + chemin + fichier + ".style"));
        StyleCouche styleCouche = new StyleCouche();
        if (!fichierStyle.estVide()) {
            block169: {
                String[] listeLigneCouleur;
                String valeur;
                if (fichierStyle.rechercherValeur("type").equals(VAL_COUCHEU)) {
                    block168: {
                        Color[] listeCouleurs;
                        String[] listeLigneCouleur2;
                        String[] val;
                        String valeur2;
                        block167: {
                            block166: {
                                block165: {
                                    block164: {
                                        block163: {
                                            styleCouche.setTypeCouche(2);
                                            valeur2 = fichierStyle.rechercherValeur("zoom");
                                            if (config != null && valeur2.startsWith("zoom")) {
                                                valeur2 = config.rechercherValeur(valeur2);
                                            }
                                            if (!valeur2.equals("")) {
                                                try {
                                                    styleCouche.setZoomAffichage(Float.parseFloat(valeur2));
                                                }
                                                catch (Exception e) {
                                                    LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur2);
                                                    styleCouche.setZoomAffichage(-1.0f);
                                                }
                                            } else {
                                                LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur2);
                                                styleCouche.setZoomAffichage(-1.0f);
                                            }
                                            if (!GLS.estNulle(fichierStyle.getIndiceChamp("zoomMin"))) {
                                                valeur2 = fichierStyle.rechercherValeur("zoomMin");
                                                if (config != null && valeur2.startsWith("zoom")) {
                                                    valeur2 = config.rechercherValeur(valeur2);
                                                }
                                                if (!valeur2.equals("")) {
                                                    try {
                                                        styleCouche.setZoomAffichageMin(Float.parseFloat(valeur2));
                                                    }
                                                    catch (Exception e) {
                                                        LocalisationInfo.ecrireLog("#--> Erreur style zoom min" + valeur2);
                                                        styleCouche.setZoomAffichageMin(Float.MAX_VALUE);
                                                    }
                                                } else {
                                                    LocalisationInfo.ecrireLog("#--> Erreur style zoom min" + valeur2);
                                                    styleCouche.setZoomAffichageMin(Float.MAX_VALUE);
                                                }
                                            }
                                            valeur2 = fichierStyle.rechercherValeur("champ");
                                            try {
                                                styleCouche.setIndiceChamp(Integer.parseInt(valeur2));
                                            }
                                            catch (Exception e) {
                                                LocalisationInfo.ecrireLog("#--> Erreur style champ " + valeur2);
                                                styleCouche = null;
                                                return null;
                                            }
                                            valeur2 = fichierStyle.rechercherValeur("valeur");
                                            try {
                                                val = valeur2.split(separateurChamps);
                                                if (val != null && val.length > 0) {
                                                    styleCouche.setValeur(val);
                                                    break block163;
                                                }
                                                LocalisationInfo.ecrireLog("#--> Erreur style valeurs " + valeur2);
                                                styleCouche = null;
                                                return null;
                                            }
                                            catch (Exception e) {
                                                LocalisationInfo.ecrireLog("#--> Erreur style valeurs " + valeur2);
                                                styleCouche = null;
                                                return null;
                                            }
                                        }
                                        try {
                                            listeLigneCouleur2 = fichierStyle.getTableauString("couleur1");
                                            if (!ConstantesGLS.estVide(listeLigneCouleur2)) {
                                                int i = 0;
                                                while (i < listeLigneCouleur2.length) {
                                                    if (config != null && listeLigneCouleur2[i].startsWith("couleur")) {
                                                        listeLigneCouleur2[i] = config.rechercherValeur(listeLigneCouleur2[i]);
                                                    }
                                                    ++i;
                                                }
                                                Color[] listeCouleurs2 = Couleur.convertCouleurs(listeLigneCouleur2);
                                                if (listeCouleurs2 != null) {
                                                    styleCouche.setCouleursInterieures(listeCouleurs2);
                                                    break block164;
                                                }
                                                LocalisationInfo.ecrireLog("#--> Erreur style: couleur1");
                                                styleCouche = null;
                                                return null;
                                            }
                                            LocalisationInfo.ecrireLog("#--> Erreur style: couleur1");
                                            styleCouche = null;
                                            return null;
                                        }
                                        catch (Exception e) {
                                            LocalisationInfo.ecrireLog("#--> Erreur style couleur1 " + valeur2);
                                            styleCouche = null;
                                            return null;
                                        }
                                    }
                                    try {
                                        listeLigneCouleur2 = fichierStyle.getTableauString("couleur2");
                                        if (listeLigneCouleur2 != null && listeLigneCouleur2.length > 0) {
                                            int i = 0;
                                            while (i < listeLigneCouleur2.length) {
                                                if (config != null && listeLigneCouleur2[i].startsWith("couleur")) {
                                                    listeLigneCouleur2[i] = config.rechercherValeur(listeLigneCouleur2[i]);
                                                }
                                                ++i;
                                            }
                                            listeCouleurs = Couleur.convertCouleurs(listeLigneCouleur2);
                                            if (listeCouleurs != null) {
                                                styleCouche.setCouleursExterieures(listeCouleurs);
                                                break block165;
                                            }
                                            LocalisationInfo.ecrireLog("#--> Erreur style: couleur2");
                                            styleCouche = null;
                                            return null;
                                        }
                                        LocalisationInfo.ecrireLog("#--> Erreur style: couleur2");
                                        styleCouche = null;
                                        return null;
                                    }
                                    catch (Exception e) {
                                        LocalisationInfo.ecrireLog("#--> Erreur style couleur2 " + valeur2);
                                        styleCouche = null;
                                        return null;
                                    }
                                }
                                styleCouche.setPositionEtiquette(fichierStyle.getInt("positionEtiquette", 0));
                                styleCouche.setnbIcone(fichierStyle.getInt("nbIcone", 0));
                                valeur2 = fichierStyle.rechercherValeur("epaisseur");
                                try {
                                    val = valeur2.split(separateurChamps);
                                    if (val != null && val.length > 0) {
                                        int[] listeEpaisseurs = new int[val.length];
                                        int i = 0;
                                        while (i < val.length) {
                                            int tmp = Couleur.getNumeroCouleur(val[i]);
                                            if ((float)tmp == -1.0f) {
                                                LocalisationInfo.ecrireLog("#--> Erreur style: epaisseur");
                                                styleCouche = null;
                                                return null;
                                            }
                                            listeEpaisseurs[i] = tmp;
                                            ++i;
                                        }
                                        styleCouche.setEpaisseurs(listeEpaisseurs);
                                        break block166;
                                    }
                                    LocalisationInfo.ecrireLog("#--> Erreur style: epaisseur");
                                    styleCouche = null;
                                    return null;
                                }
                                catch (Exception e) {
                                    LocalisationInfo.ecrireLog("#--> Erreur style epaisseur " + valeur2);
                                    styleCouche = null;
                                    return null;
                                }
                            }
                            valeur2 = fichierStyle.rechercherValeur("image");
                            try {
                                val = valeur2.split(separateurChamps);
                                if (val != null && val.length > 0) {
                                    styleCouche.setImages(val);
                                    break block167;
                                }
                                styleCouche = null;
                                return null;
                            }
                            catch (Exception e) {
                                LocalisationInfo.ecrireLog("#--> Erreur style valeurs " + valeur2);
                                styleCouche = null;
                                return null;
                            }
                        }
                        valeur2 = fichierStyle.rechercherValeur("libelle");
                        try {
                            val = valeur2.split(separateurChamps);
                            if (val != null && !valeur2.equals("") && val.length > 0) {
                                styleCouche.setLibelleChamp(val);
                            }
                        }
                        catch (Exception val2) {
                            // empty catch block
                        }
                        styleCouche.setEtiquette(Couleur.getNumeroCouleur(fichierStyle.rechercherValeur("etiquette")));
                        valeur2 = fichierStyle.rechercherValeur("font-police");
                        if (!valeur2.equals("")) {
                            styleCouche.setFontPolice(valeur2);
                        }
                        if (!(valeur2 = fichierStyle.rechercherValeur("font-size")).equals("")) {
                            try {
                                styleCouche.setFontSize(Integer.valueOf(valeur2));
                            }
                            catch (Exception e) {
                                styleCouche.setFontSize(8);
                            }
                        }
                        if (!(valeur2 = fichierStyle.rechercherValeur("font-option")).equals("")) {
                            styleCouche.setFontOption(valeur2);
                        }
                        if ((listeLigneCouleur2 = fichierStyle.getTableauString("font-color")) != null && listeLigneCouleur2.length > 0) {
                            int i = 0;
                            while (i < listeLigneCouleur2.length) {
                                if (config != null && listeLigneCouleur2[i].startsWith("couleur")) {
                                    listeLigneCouleur2[i] = config.rechercherValeur(listeLigneCouleur2[i]);
                                }
                                ++i;
                            }
                            listeCouleurs = Couleur.convertCouleurs(listeLigneCouleur2);
                            try {
                                styleCouche.setCouleurFont(listeCouleurs[0]);
                            }
                            catch (Exception e) {
                                styleCouche.setCouleurFont(FONT_COLOR_DEFAUT);
                            }
                        }
                        if (!GLS.estNulle(fichierStyle.getIndiceChamp("zoomLibelle"))) {
                            valeur2 = fichierStyle.rechercherValeur("zoomLibelle");
                            if (config != null && valeur2.startsWith("zoom")) {
                                valeur2 = config.rechercherValeur(valeur2);
                            }
                            if (!valeur2.equals("")) {
                                try {
                                    styleCouche.setZoomAffichageLibelle(Float.parseFloat(valeur2));
                                }
                                catch (Exception e) {
                                    LocalisationInfo.ecrireLog("#--> Erreur style zoomLibelle " + valeur2);
                                }
                            } else {
                                LocalisationInfo.ecrireLog("#--> Erreur style zoomLibelle " + valeur2);
                            }
                        }
                        if (!(valeur2 = fichierStyle.rechercherValeur("libelleFondTransparent")).equals("")) {
                            try {
                                styleCouche.setLibelleFondTransparent(valeur2.equals("1"));
                            }
                            catch (Exception e) {
                                styleCouche.setLibelleFondTransparent(false);
                            }
                        }
                        if (!(valeur2 = fichierStyle.rechercherValeur("font-encadre")).equals("")) {
                            try {
                                styleCouche.setAFontCouleurEncadre(valeur2.equals("1"));
                            }
                            catch (Exception e) {
                                styleCouche.setAFontCouleurEncadre(false);
                            }
                        }
                        try {
                            String[] listeLigneCouleurEncadre = fichierStyle.getTableauString("font-couleur-encadre");
                            if (listeLigneCouleurEncadre == null || listeLigneCouleurEncadre.length <= 0) break block168;
                            int i = 0;
                            while (i < listeLigneCouleurEncadre.length) {
                                if (config != null && listeLigneCouleurEncadre[i].startsWith("couleur")) {
                                    listeLigneCouleurEncadre[i] = config.rechercherValeur(listeLigneCouleurEncadre[i]);
                                }
                                ++i;
                            }
                            Color[] listeCouleurs3 = Couleur.convertCouleurs(listeLigneCouleurEncadre);
                            if (listeCouleurs3 != null) {
                                styleCouche.setFontCouleurEncadre(listeCouleurs3);
                                break block168;
                            }
                            LocalisationInfo.ecrireLog("#--> Erreur style: font-couleur-encadre");
                            styleCouche = null;
                            return null;
                        }
                        catch (Exception e) {
                            LocalisationInfo.ecrireLog("#--> Erreur style valeurs " + valeur2);
                            styleCouche = null;
                            return null;
                        }
                    }
                    if (styleCouche.getValeurs().length + 1 == styleCouche.getEpaisseurs().length && styleCouche.getValeurs().length + 1 == styleCouche.getCouleursExterieures().length && styleCouche.getValeurs().length + 1 == styleCouche.getCouleursInterieures().length && styleCouche.getValeurs().length + 1 == styleCouche.getImages().length) {
                        return styleCouche;
                    }
                    LocalisationInfo.ecrireLog("#--> ERREUR NOMBRE PARAMETRE COUCHEU");
                    styleCouche = null;
                    return null;
                }
                if (fichierStyle.rechercherValeur("type").equals(VAL_COUCHER_RASTER_ECW)) {
                    String valeur3;
                    styleCouche.setTypeCouche(3);
                    if (!GLS.estNulle(fichierStyle.getIndiceChamp("zoom"))) {
                        valeur3 = fichierStyle.rechercherValeur("zoom");
                        if (config != null && valeur3.startsWith("zoom")) {
                            valeur3 = config.rechercherValeur(valeur3);
                        }
                        if (!valeur3.equals("")) {
                            try {
                                styleCouche.setZoomAffichage(Float.parseFloat(valeur3));
                            }
                            catch (Exception e) {
                                LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur3);
                                styleCouche.setZoomAffichage(-1.0f);
                            }
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur3);
                            styleCouche.setZoomAffichage(-1.0f);
                        }
                    }
                    if (!GLS.estNulle(fichierStyle.getIndiceChamp("zoomMin"))) {
                        valeur3 = fichierStyle.rechercherValeur("zoomMin");
                        if (config != null && valeur3.startsWith("zoomMin")) {
                            valeur3 = config.rechercherValeur(valeur3);
                        }
                        if (!valeur3.equals("")) {
                            try {
                                styleCouche.setZoomAffichageMin(Float.parseFloat(valeur3));
                            }
                            catch (Exception e) {
                                LocalisationInfo.ecrireLog("#--> Erreur style zoom min" + valeur3);
                                styleCouche.setZoomAffichageMin(Float.MAX_VALUE);
                            }
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur style zoom min" + valeur3);
                            styleCouche.setZoomAffichageMin(Float.MAX_VALUE);
                        }
                    }
                    if (!GLS.estNulle(fichierStyle.getIndiceChamp("repertoire"))) {
                        valeur3 = fichierStyle.rechercherValeur("repertoire");
                        if (!valeur3.equals("")) {
                            try {
                                styleCouche.setRepertoire(valeur3);
                            }
                            catch (Exception e) {
                                LocalisationInfo.ecrireLog("#--> Erreur style repertoire " + valeur3);
                                return null;
                            }
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur3);
                            styleCouche.setRepertoire("");
                        }
                    }
                    if (styleCouche.getRepertoire() != null) {
                        return styleCouche;
                    }
                    return null;
                }
                if (fichierStyle.rechercherValeur("type").equals(VAL_COUCHER_RASTER_WMS)) {
                    String valeur4;
                    styleCouche.setTypeCouche(4);
                    if (!GLS.estNulle(fichierStyle.getIndiceChamp("zoom"))) {
                        valeur4 = fichierStyle.rechercherValeur("zoom");
                        if (config != null && valeur4.startsWith("zoom")) {
                            valeur4 = config.rechercherValeur(valeur4);
                        }
                        if (!valeur4.equals("")) {
                            try {
                                styleCouche.setZoomAffichage(Float.parseFloat(valeur4));
                            }
                            catch (Exception e) {
                                LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur4);
                                styleCouche.setZoomAffichage(-1.0f);
                            }
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur4);
                            styleCouche.setZoomAffichage(-1.0f);
                        }
                    }
                    if (!GLS.estNulle(fichierStyle.getIndiceChamp("zoomMin"))) {
                        valeur4 = fichierStyle.rechercherValeur("zoomMin");
                        if (config != null && valeur4.startsWith("zoomMin")) {
                            valeur4 = config.rechercherValeur(valeur4);
                        }
                        if (!valeur4.equals("")) {
                            try {
                                styleCouche.setZoomAffichageMin(Float.parseFloat(valeur4));
                            }
                            catch (Exception e) {
                                LocalisationInfo.ecrireLog("#--> Erreur style zoom min" + valeur4);
                                styleCouche.setZoomAffichageMin(Float.MAX_VALUE);
                            }
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur style zoom min" + valeur4);
                            styleCouche.setZoomAffichageMin(Float.MAX_VALUE);
                        }
                    }
                    if (!GLS.estNulle(fichierStyle.getIndiceChamp("fichierWMS"))) {
                        valeur4 = fichierStyle.rechercherValeur("fichierWMS");
                        if (!valeur4.equals("")) {
                            try {
                                styleCouche.setFichierWMS(valeur4);
                            }
                            catch (Exception e) {
                                LocalisationInfo.ecrireLog("#--> Erreur style fichierWMS " + valeur4);
                                return null;
                            }
                        } else {
                            LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur4);
                            styleCouche.setFichierWMS("");
                        }
                    }
                    if (styleCouche.getFichierWMS() != null) {
                        return styleCouche;
                    }
                    return null;
                }
                styleCouche.setTypeCouche(1);
                if (!GLS.estNulle(fichierStyle.getIndiceChamp("zoom"))) {
                    valeur = fichierStyle.rechercherValeur("zoom");
                    if (config != null && valeur.startsWith("zoom")) {
                        valeur = config.rechercherValeur(valeur);
                    }
                    if (!valeur.equals("")) {
                        try {
                            styleCouche.setZoomAffichage(Float.parseFloat(valeur));
                        }
                        catch (Exception e) {
                            LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur);
                            styleCouche.setZoomAffichage(-1.0f);
                        }
                    } else {
                        LocalisationInfo.ecrireLog("#--> Erreur style zoom " + valeur);
                        styleCouche.setZoomAffichage(-1.0f);
                    }
                }
                if (!GLS.estNulle(fichierStyle.getIndiceChamp("positionEtiquette"))) {
                    styleCouche.setPositionEtiquette(fichierStyle.getInt("positionEtiquette", 0));
                }
                if (!GLS.estNulle(fichierStyle.getIndiceChamp("nbIcone"))) {
                    styleCouche.setnbIcone(fichierStyle.getInt("nbIcone", 0));
                }
                if (!GLS.estNulle(fichierStyle.getIndiceChamp("couleur1"))) {
                    valeur = fichierStyle.rechercherValeur("couleur1");
                    if (config != null && valeur.startsWith("couleur")) {
                        valeur = config.rechercherValeur(valeur);
                    }
                    try {
                        styleCouche.setCouleurInterieure(Couleur.convertCouleur(valeur));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!GLS.estNulle(fichierStyle.getIndiceChamp("couleur2"))) {
                    valeur = fichierStyle.rechercherValeur("couleur2");
                    if (config != null && valeur.startsWith("couleur")) {
                        valeur = config.rechercherValeur(valeur);
                    }
                    try {
                        styleCouche.setCouleurExterieure(Couleur.convertCouleur(valeur));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!GLS.estNulle(fichierStyle.getIndiceChamp("epaisseur"))) {
                    valeur = fichierStyle.rechercherValeur("epaisseur");
                    try {
                        styleCouche.setEpaisseur(Couleur.getNumeroCouleur(valeur));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!GLS.estNulle(fichierStyle.getIndiceChamp("image"))) {
                    valeur = fichierStyle.rechercherValeur("image");
                    try {
                        styleCouche.setImage(valeur);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!GLS.estNulle(fichierStyle.getIndiceChamp("etiquette"))) {
                    styleCouche.setEtiquette(Couleur.getNumeroCouleur(fichierStyle.rechercherValeur("etiquette")));
                } else {
                    styleCouche.setEtiquette(-1);
                }
                if (!GLS.estNulle(fichierStyle.getIndiceChamp("zoomLibelle"))) {
                    valeur = fichierStyle.rechercherValeur("zoomLibelle");
                    if (config != null && valeur.startsWith("zoom")) {
                        valeur = config.rechercherValeur(valeur);
                    }
                    if (!valeur.equals("")) {
                        try {
                            styleCouche.setZoomAffichageLibelle(Float.parseFloat(valeur));
                        }
                        catch (Exception e) {
                            LocalisationInfo.ecrireLog("#--> Erreur style zoomLibelle " + valeur);
                        }
                    } else {
                        LocalisationInfo.ecrireLog("#--> Erreur style zoomLibelle " + valeur);
                    }
                }
                if (!(valeur = fichierStyle.rechercherValeur("font-police")).equals("")) {
                    styleCouche.setFontPolice(valeur);
                }
                if (!(valeur = fichierStyle.rechercherValeur("font-size")).equals("")) {
                    try {
                        styleCouche.setFontSize(Integer.valueOf(valeur));
                    }
                    catch (Exception e) {
                        styleCouche.setFontSize(8);
                    }
                }
                if (!(valeur = fichierStyle.rechercherValeur("font-option")).equals("")) {
                    styleCouche.setFontOption(valeur);
                }
                if ((listeLigneCouleur = fichierStyle.getTableauString("font-color")) != null && listeLigneCouleur.length > 0) {
                    int i = 0;
                    while (i < listeLigneCouleur.length) {
                        if (config != null && listeLigneCouleur[i].startsWith("couleur")) {
                            listeLigneCouleur[i] = config.rechercherValeur(listeLigneCouleur[i]);
                        }
                        ++i;
                    }
                    Color[] listeCouleurs = Couleur.convertCouleurs(listeLigneCouleur);
                    try {
                        styleCouche.setCouleurFont(listeCouleurs[0]);
                    }
                    catch (Exception e) {
                        styleCouche.setCouleurFont(FONT_COLOR_DEFAUT);
                    }
                }
                if (!(valeur = fichierStyle.rechercherValeur("libelleFondTransparent")).equals("")) {
                    try {
                        styleCouche.setLibelleFondTransparent(valeur.equals("1"));
                    }
                    catch (Exception e) {
                        styleCouche.setLibelleFondTransparent(false);
                    }
                }
                if (!(valeur = fichierStyle.rechercherValeur("font-encadre")).equals("")) {
                    try {
                        styleCouche.setAFontCouleurEncadre(valeur.equals("1"));
                    }
                    catch (Exception e) {
                        styleCouche.setAFontCouleurEncadre(false);
                    }
                }
                try {
                    String[] listeLigneCouleurEncadre = fichierStyle.getTableauString("font-couleur-encadre");
                    if (listeLigneCouleurEncadre == null || listeLigneCouleurEncadre.length <= 0) break block169;
                    int i = 0;
                    while (i < listeLigneCouleurEncadre.length) {
                        if (config != null && listeLigneCouleurEncadre[i].startsWith("couleur")) {
                            listeLigneCouleurEncadre[i] = config.rechercherValeur(listeLigneCouleurEncadre[i]);
                        }
                        ++i;
                    }
                    Color[] listeCouleurs = Couleur.convertCouleurs(listeLigneCouleurEncadre);
                    if (listeCouleurs != null) {
                        styleCouche.setFontCouleurEncadre(listeCouleurs);
                        break block169;
                    }
                    LocalisationInfo.ecrireLog("#--> Erreur style: font-couleur-encadre");
                    styleCouche = null;
                    return null;
                }
                catch (Exception e) {
                    LocalisationInfo.ecrireLog("#--> Erreur style valeurs " + valeur);
                    styleCouche = null;
                    return null;
                }
            }
            if (!GLS.estNulle(fichierStyle.getIndiceChamp("pointille"))) {
                styleCouche.setPointille(fichierStyle.rechercherValeur("pointille").equals("1"));
            } else {
                styleCouche.setPointille(false);
            }
            if (!GLS.estNulle(fichierStyle.getIndiceChamp("transparent"))) {
                styleCouche.setTransparent(fichierStyle.rechercherValeur("transparent").equals("1"));
            } else {
                styleCouche.setTransparent(false);
            }
            if (!GLS.estNulle(fichierStyle.getIndiceChamp("transparence"))) {
                styleCouche.setTransparence(Float.parseFloat(fichierStyle.rechercherValeur("transparence")));
            }
            return styleCouche;
        }
        LocalisationInfo.ecrireLog("#--> Erreur style: fichier style vide");
        return null;
    }

    public StyleCouche(String nom, float zoomAffichage, Color couleurInterieure, Color couleurExterieure, int epaisseur, String image, int etiquette) {
        this(new String[]{nom}, zoomAffichage, couleurInterieure, couleurExterieure, epaisseur, image, etiquette, FONT_DEFAUT, COULEUR_FONT_DEFAUT);
    }

    public StyleCouche(String[] noms, float zoomAffichage, Color couleurInterieure, Color couleurExterieure, int epaisseur, String image, int etiquette) {
        this(noms, zoomAffichage, couleurInterieure, couleurExterieure, epaisseur, image, etiquette, FONT_DEFAUT, COULEUR_FONT_DEFAUT);
    }

    public StyleCouche(String[] noms, float zoomAffichage, Color couleurInterieure, Color couleurExterieure, int epaisseur, String image, int etiquette, Font font, Color couleurFont) {
        this.typeCouche = 1;
        this.noms = noms;
        this.couleursExterieures = new Color[]{couleurExterieure};
        this.couleursInterieures = new Color[]{couleurInterieure};
        this.epaisseurs = new int[]{epaisseur};
        this.images = new String[]{image};
        this.etiquette = etiquette;
        this.zoomAffichage = zoomAffichage;
        this.font = font;
        this.couleurFont = couleurFont;
        this.positionEtiquette = 0;
        this.nbIcone = 1;
    }

    public StyleCouche(String nom, float zoomAffichage, int indiceChamp, String[] valeurs, Color[] couleursInterieures, Color[] couleursExterieures, int[] epaisseurs, String[] images, int etiquette) {
        this(new String[]{nom}, zoomAffichage, indiceChamp, valeurs, couleursInterieures, couleursExterieures, epaisseurs, images, etiquette, FONT_DEFAUT, COULEUR_FONT_DEFAUT);
    }

    public StyleCouche(String[] noms, float zoomAffichage, int indiceChamp, String[] valeurs, Color[] couleursInterieures, Color[] couleursExterieures, int[] epaisseurs, String[] images, int etiquette) {
        this(noms, zoomAffichage, indiceChamp, valeurs, couleursInterieures, couleursExterieures, epaisseurs, images, etiquette, FONT_DEFAUT, COULEUR_FONT_DEFAUT);
    }

    public StyleCouche(String[] noms, float zoomAffichage, int indiceChamp, String[] valeurs, Color[] couleursInterieures, Color[] couleursExterieures, int[] epaisseurs, String[] images, int etiquette, Font font, Color couleurFont) {
        this.typeCouche = 2;
        this.noms = noms;
        this.zoomAffichage = zoomAffichage;
        this.couleursExterieures = couleursExterieures;
        this.couleursInterieures = couleursInterieures;
        this.epaisseurs = epaisseurs;
        this.valeurs = valeurs;
        this.images = images;
        this.etiquette = etiquette;
        this.indiceChamp = indiceChamp;
        this.font = font;
        this.couleurFont = couleurFont;
        this.positionEtiquette = 0;
        this.nbIcone = 1;
        this.initialisationLibelles();
    }

    public int getPositionEtiquette() {
        return this.positionEtiquette;
    }

    public void setPositionEtiquette(int positionEtiquette) {
        this.positionEtiquette = positionEtiquette;
    }

    public int getNbIcone() {
        return this.nbIcone;
    }

    public void setnbIcone(int nbIcone) {
        this.nbIcone = nbIcone;
    }

    public void initialisationLibelles() {
        if (this.images != null) {
            this.libelle = new String[this.images.length];
            int i = 0;
            while (i < this.libelle.length) {
                this.libelle[i] = " ";
                ++i;
            }
        }
    }

    public void miseAJour(StyleCouche styleCouche) {
        if (styleCouche != null) {
            if (styleCouche.getTypeCouche() == 2) {
                if (styleCouche.getZoomAffichage() >= 0.0f) {
                    this.zoomAffichage = styleCouche.getZoomAffichage();
                }
                if (styleCouche.getValeurs() != null && styleCouche.getCouleursExterieures() != null && styleCouche.getCouleursInterieures() != null && styleCouche.getEpaisseurs() != null && styleCouche.getImages() != null && styleCouche.getValeurs().length + 1 == styleCouche.getCouleursExterieures().length) {
                    this.valeurs = styleCouche.getValeurs();
                    this.couleursExterieures = styleCouche.getCouleursExterieures();
                    this.couleursInterieures = styleCouche.getCouleursInterieures();
                    this.epaisseurs = styleCouche.getEpaisseurs();
                    this.images = styleCouche.getImages();
                    this.positionEtiquette = styleCouche.getPositionEtiquette();
                    this.nbIcone = styleCouche.getNbIcone();
                    this.typeCouche = 2;
                    this.zoomAffichageLibelle = styleCouche.getZoomAffichageLibelle();
                }
                if ((float)styleCouche.getEtiquette() != -1.0f) {
                    this.etiquette = styleCouche.getEtiquette();
                }
                if ((float)styleCouche.getIndiceChamp() != -1.0f) {
                    this.indiceChamp = styleCouche.getIndiceChamp();
                }
                if (styleCouche.getLibelleChamp() != null) {
                    this.libelle = styleCouche.getLibelleChamp();
                }
                this.zoomAffichageLibelle = styleCouche.getZoomAffichageLibelle();
                this.zoomAffichageMin = styleCouche.getZoomAffichageMin();
                this.positionEtiquette = styleCouche.getPositionEtiquette();
                this.nbIcone = styleCouche.getNbIcone();
                this.fontColor = styleCouche.getCouleurFont();
                this.fontSize = styleCouche.getFontSize();
                this.fontPolice = styleCouche.getFontPolice();
                this.fontOption = styleCouche.getFontOption();
                this.fontOptionUnderline = styleCouche.isFontOptionUnderline();
                this.fontOptionGras = styleCouche.isFontOptionGras();
                this.fontOptionItalic = styleCouche.isFontOptionItalic();
                this.couleurFont = styleCouche.getCouleurFont();
                this.aFontCouleurEncadre = styleCouche.aFontCouleurEncadre();
                this.fontCouleurEncadre = styleCouche.getFontCouleurEncadre();
                this.libelleFondTransparent = styleCouche.getaLibelleFondTransparent();
            } else if (styleCouche.getTypeCouche() == 3) {
                this.typeCouche = 3;
                this.repertoire = styleCouche.getRepertoire();
                this.zoomAffichage = styleCouche.getZoomAffichage();
                this.zoomAffichageMin = styleCouche.getZoomAffichageMin();
            } else if (styleCouche.getTypeCouche() == 4) {
                this.typeCouche = 4;
                this.fichierWMS = styleCouche.getFichierWMS();
                this.zoomAffichage = styleCouche.getZoomAffichage();
                this.zoomAffichageMin = styleCouche.getZoomAffichageMin();
            } else {
                this.typeCouche = 1;
                if (styleCouche.getZoomAffichage() >= 0.0f) {
                    this.zoomAffichage = styleCouche.getZoomAffichage();
                }
                if (styleCouche.getCouleurExterieure() != null) {
                    this.couleursExterieures = styleCouche.getCouleursExterieures();
                }
                if (styleCouche.getCouleurInterieure() != null) {
                    this.couleursInterieures = styleCouche.getCouleursInterieures();
                }
                if (styleCouche.getEpaisseur() > 0) {
                    this.epaisseurs = styleCouche.getEpaisseurs();
                }
                if (!GLS.estVide(styleCouche.getImages())) {
                    this.images = styleCouche.getImages();
                }
                if ((float)styleCouche.getEtiquette() != -1.0f) {
                    this.etiquette = styleCouche.getEtiquette();
                }
                this.zoomAffichageLibelle = styleCouche.getZoomAffichageLibelle();
                this.positionEtiquette = styleCouche.getPositionEtiquette();
                this.nbIcone = styleCouche.getNbIcone();
                this.pointille = styleCouche.isPointille();
                this.transparent = styleCouche.isTransparent();
                this.transparence = styleCouche.getTransparence();
                this.fontColor = styleCouche.getCouleurFont();
                this.fontSize = styleCouche.getFontSize();
                this.fontPolice = styleCouche.getFontPolice();
                this.fontOption = styleCouche.getFontOption();
                this.fontOptionUnderline = styleCouche.isFontOptionUnderline();
                this.fontOptionGras = styleCouche.isFontOptionGras();
                this.fontOptionItalic = styleCouche.isFontOptionItalic();
                this.couleurFont = styleCouche.getCouleurFont();
                this.aFontCouleurEncadre = styleCouche.aFontCouleurEncadre();
                this.fontCouleurEncadre = styleCouche.getFontCouleurEncadre();
                this.libelleFondTransparent = styleCouche.getaLibelleFondTransparent();
            }
        }
    }

    public boolean equals(String nom) {
        if (this.noms != null && this.noms.length > 0) {
            int i = 0;
            while (i < this.noms.length) {
                if (this.noms[i].equals(nom)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setNom(String nom) {
        this.noms = new String[]{nom};
    }

    public String getNom() {
        if (!GLS.estVide(this.noms)) {
            return this.noms[0];
        }
        return null;
    }

    public void setNoms(String[] noms) {
        this.noms = noms;
    }

    public String[] getNoms() {
        return this.noms;
    }

    public void setTypeCouche(int typeCouche) {
        this.typeCouche = typeCouche;
    }

    public int getTypeCouche() {
        return this.typeCouche;
    }

    public void setZoomAffichage(float zoomAffichage) {
        this.zoomAffichage = zoomAffichage;
    }

    public float getZoomAffichage() {
        return this.zoomAffichage;
    }

    public void setCouleurInterieure(Color couleurInterieure) {
        this.couleursInterieures = new Color[]{couleurInterieure};
    }

    public void setCouleurExterieure(Color couleurExterieure) {
        this.couleursExterieures = new Color[]{couleurExterieure};
    }

    public void setEpaisseur(int epaisseur) {
        this.epaisseurs = new int[]{epaisseur};
    }

    public void setCouleursInterieures(Color[] couleursInterieures) {
        this.couleursInterieures = couleursInterieures;
    }

    public void setCouleursExterieures(Color[] couleursExterieures) {
        this.couleursExterieures = couleursExterieures;
    }

    public void setEpaisseurs(int[] epaisseurs) {
        this.epaisseurs = epaisseurs;
    }

    public void setValeur(String[] valeurs) {
        this.valeurs = valeurs;
    }

    public void setIndiceChamp(int indiceChamp) {
        this.indiceChamp = indiceChamp;
    }

    public Color getCouleurInterieure() {
        if (this.couleursInterieures != null && this.couleursInterieures.length == 1) {
            return this.couleursInterieures[0];
        }
        return null;
    }

    public Color getCouleurExterieure() {
        if (this.couleursExterieures != null && this.couleursExterieures.length == 1) {
            return this.couleursExterieures[0];
        }
        return null;
    }

    public int getEpaisseur() {
        if (this.epaisseurs != null && this.epaisseurs.length == 1) {
            return this.epaisseurs[0];
        }
        return -1;
    }

    public Color[] getCouleursInterieures() {
        return this.couleursInterieures;
    }

    public Color[] getCouleursExterieures() {
        return this.couleursExterieures;
    }

    public int[] getEpaisseurs() {
        return this.epaisseurs;
    }

    public String[] getValeurs() {
        return this.valeurs;
    }

    public int getIndiceChamp() {
        return this.indiceChamp;
    }

    public String[] getLibelleChamp() {
        if (this.libelle != null) {
            return this.libelle;
        }
        String[] libelle = new String[this.valeurs.length + 1];
        int i = 0;
        while (i < libelle.length) {
            libelle[i] = "";
            ++i;
        }
        return libelle;
    }

    public void setLibelleChamp(String[] valeur) {
        this.libelle = valeur;
    }

    public void setImage(String image) {
        this.images = new String[]{image};
    }

    public String getImage() {
        if (this.images != null && this.images.length == 1 && !this.images[0].equals("")) {
            return this.images[0];
        }
        return "";
    }

    public void setImages(String[] images) {
        this.images = images;
    }

    public void setEtiquette(int etiquette) {
        this.etiquette = etiquette;
    }

    public String[] getImages() {
        return this.images;
    }

    public int getEtiquette() {
        return this.etiquette;
    }

    public Color getCouleurFont() {
        return this.couleurFont;
    }

    public void setCouleurFont(Color couleurFont) {
        this.couleurFont = couleurFont;
    }

    public Font getFont() {
        try {
            Font fontTmp = new Font(this.fontPolice, this.fontOption, this.fontSize);
            Hashtable<TextAttribute, Number> map = new Hashtable<TextAttribute, Number>();
            if (this.fontOptionUnderline) {
                map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.fontOptionGras) {
                map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRABOLD);
            }
            if (this.fontOptionItalic) {
                map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            map.put(TextAttribute.SIZE, this.fontSize);
            this.font = fontTmp.deriveFont(map);
            return fontTmp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Font("Arial", 1, 20);
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public float getZoomAffichageLibelle() {
        if (this.zoomAffichageLibelle == Float.MIN_VALUE) {
            return this.zoomAffichage;
        }
        return this.zoomAffichageLibelle;
    }

    public float setZoomAffichageLibelle(float zoomAffichageLibelle) {
        this.zoomAffichageLibelle = zoomAffichageLibelle;
        return this.zoomAffichageLibelle;
    }

    public boolean isPointille() {
        return this.pointille;
    }

    public void setPointille(boolean pointille) {
        this.pointille = pointille;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public float getTransparence() {
        return this.transparence;
    }

    public void setTransparence(float transparence) {
        this.transparence = transparence;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public int getFontOption() {
        return this.fontOption;
    }

    public void setFontOption(String fontOption) {
        String[] fontOptions;
        String[] stringArray = fontOptions = fontOption.split(separateurChamps);
        int n = fontOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String opt = stringArray[n2];
            if (opt.equals("G")) {
                this.fontOptionGras = true;
                this.fontOption |= 1;
            }
            if (opt.equals("I")) {
                this.fontOptionItalic = true;
                this.fontOption |= 2;
            }
            if (opt.equals(VAL_COUCHEU)) {
                this.fontOptionUnderline = true;
            }
            ++n2;
        }
    }

    public String getFontPolice() {
        return this.fontPolice;
    }

    public void setFontPolice(String fontPolice) {
        this.fontPolice = fontPolice;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public boolean isFontOptionUnderline() {
        return this.fontOptionUnderline;
    }

    public void setFontOptionUnderline(boolean fontOptionUnderline) {
        this.fontOptionUnderline = fontOptionUnderline;
    }

    public boolean isFontOptionGras() {
        return this.fontOptionGras;
    }

    public void setFontOptionGras(boolean fontOptionGras) {
        this.fontOptionGras = fontOptionGras;
    }

    public boolean isFontOptionItalic() {
        return this.fontOptionItalic;
    }

    public void setFontOptionItalic(boolean fontOptionItalic) {
        this.fontOptionItalic = fontOptionItalic;
    }

    public Color[] getFontCouleurEncadre() {
        return this.fontCouleurEncadre;
    }

    public void setFontCouleurEncadre(Color[] fontCouleurEncadre) {
        this.fontCouleurEncadre = fontCouleurEncadre;
    }

    public boolean aFontCouleurEncadre() {
        return this.aFontCouleurEncadre;
    }

    public void setAFontCouleurEncadre(boolean aFontCouleurEncadre) {
        this.aFontCouleurEncadre = aFontCouleurEncadre;
    }

    public float getZoomAffichageMin() {
        return this.zoomAffichageMin;
    }

    public void setZoomAffichageMin(float zoomAffichageMin) {
        this.zoomAffichageMin = zoomAffichageMin;
    }

    public String getRepertoire() {
        return this.repertoire;
    }

    public void setRepertoire(String repertoire) {
        this.repertoire = repertoire;
    }

    public String getFichierWMS() {
        return this.fichierWMS;
    }

    public void setFichierWMS(String fichierWMS) {
        this.fichierWMS = fichierWMS;
    }

    public boolean getaLibelleFondTransparent() {
        return this.libelleFondTransparent;
    }

    public void setLibelleFondTransparent(boolean libelleFondTransparent) {
        this.libelleFondTransparent = libelleFondTransparent;
    }
}

