/*
 * Decompiled with CFR 0.152.
 */
package gls.carto;

import cartoj.Couche;
import cartoj.CoucheD;
import cartoj.FichierProjet;
import cartoj.ICouche;
import gls.localisation.LocalisationInfo;
import gls.outils.Extension;
import gls.outils.GLS;
import gls.outils.OutilsCartoJ;
import gls.outils.fichier.FichierCONFIG;
import gls.outils.ui.carto.ConstantesCarto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChargementCarto
implements ConstantesCarto {
    private FichierCONFIG config;
    private static final boolean AUTORISER_SAISIE_SANS_ROUTE = true;
    protected String cheminCarto;
    protected String cheminConfigCarto;
    protected String cheminImageTypeCarto;
    protected String nomCarto;
    protected Map<String, ICouche> couches;
    private static ChargementCarto instance = null;

    public static FichierCONFIG getConfigLocalisation(Extension extension) {
        FichierCONFIG config = new FichierCONFIG();
        if (extension != null) {
            for (Object k : extension.getChamps()) {
                config.ajouterNouvelleValeur(GLS.getString(k), GLS.getString(extension.getValeur(k.toString())));
            }
        }
        return config;
    }

    public static ChargementCarto instanceOf() {
        if (instance == null) {
            instance = new ChargementCarto();
        }
        return instance;
    }

    private ChargementCarto() {
    }

    public void charger(String cheminParametres, String nomCarto, Extension configuration) throws Exception {
        this.nomCarto = nomCarto;
        this.cheminCarto = cheminParametres.concat(GLS.getString(this.getRepertoireCarto(), "/"));
        this.cheminConfigCarto = cheminParametres.concat(GLS.getString(this.getRepertoireConfig(), "/"));
        this.cheminImageTypeCarto = cheminParametres.concat(GLS.getString(this.getRepertoireCheminTypeEvenement(), "/"));
        FichierProjet fichierProjet = new FichierProjet(String.valueOf(this.cheminCarto) + GLS.getString(this.getNomFichierPrj(), nomCarto) + ".prj", this.cheminCarto);
        this.couches = new HashMap<String, ICouche>();
        int i = 0;
        while (i < fichierProjet.getNbcont()) {
            String nom = OutilsCartoJ.getNomCoucheFichierCont(fichierProjet.getFichierCont(i));
            CoucheD c = new CoucheD(fichierProjet, i, nom);
            this.couches.put(nom, (ICouche)c);
            ++i;
        }
        this.initialisationLocalisationInfoApres(ChargementCarto.getConfigLocalisation(configuration));
    }

    public void charger(String cheminParametres, String nomCarto, List<Couche> couchesList, Extension configuration) throws Exception {
        this.nomCarto = nomCarto;
        this.cheminCarto = cheminParametres.concat(GLS.getString(this.getRepertoireCarto(), "/"));
        this.cheminConfigCarto = cheminParametres.concat(GLS.getString(this.getRepertoireConfig(), "/"));
        this.cheminImageTypeCarto = cheminParametres.concat(GLS.getString(this.getRepertoireCheminTypeEvenement(), "/"));
        this.couches = new HashMap<String, ICouche>();
        for (Couche c : couchesList) {
            this.couches.put(c.getNom(), (ICouche)c);
        }
        this.initialisationLocalisationInfoApres(ChargementCarto.getConfigLocalisation(configuration));
    }

    protected String getNomFichierConfig() {
        return this.nomCarto;
    }

    protected String getNomFichierPrj() {
        return this.nomCarto;
    }

    protected String getRepertoireCarto() {
        return this.nomCarto.concat("/carto/");
    }

    protected String getRepertoireConfig() {
        return this.nomCarto.concat("/config/");
    }

    protected String getRepertoireCheminTypeEvenement() {
        return this.nomCarto.concat("/images/type/");
    }

    protected void initialisationLocalisationInfoApres(FichierCONFIG config) {
        this.config = config;
        LocalisationInfo.initialiser(config, this.couches);
        LocalisationInfo.initialiserAlertc(this.cheminConfigCarto.concat(this.nomCarto).concat(".alertc"));
        LocalisationInfo.departementPrObligatoire = false;
        LocalisationInfo.estLocalisableParPrpk = config.getBoolean("recherchePr", true);
        LocalisationInfo.estLocalisableParAdresse = config.getBoolean("rechercheAdresse", false);
        LocalisationInfo.correctionAutoAbscissePr = true;
        LocalisationInfo.differenceMaximumCorrectionAutoAbscissePr = config.getInt("differenceMaximumCorrectionAutoAbscissePr", 400);
        LocalisationInfo.gestionRouteSansReferentiel = config.getBoolean("gestionRouteSansReferentiel", true);
        LocalisationInfo.MAP_MATCHING = config.getBoolean("mapMatching", true);
        LocalisationInfo.autoriserPrNonConsecutif = true;
        LocalisationInfo.gestionFinRoute = false;
        LocalisationInfo.margeRechercheRoute = config.getInt("distanceRechercheEvenements", 2000);
        LocalisationInfo.zoneUTM = config.getInt("zoneUTM", 30);
        LocalisationInfo.prSensRoute = true;
        LocalisationInfo.POSITION_DEFAUT = "q";
    }

    protected FichierCONFIG getConfig() {
        return this.config;
    }
}

