/*
 * Decompiled with CFR 0.152.
 */
package gls.carto;

import gls.outils.GLS;

public class ChampCarto {
    public static final int TAILLE_DEFAUT = 50;
    public static final char CHAMP_TEXTE = 'C';
    private static final int NB_CHAMPS = 2;
    private static final int CHAMP_NOM = 0;
    private static final int CHAMP_TAILLE = 1;
    private static final String SEPARATEUR = ",";
    private String nom;
    private int taille;
    private int indice;

    public ChampCarto(String valeur) throws Exception {
        this(GLS.getTableauString(valeur, SEPARATEUR));
    }

    public ChampCarto(String[] valeur) throws Exception {
        if (GLS.estVide(valeur) || valeur.length != 2) {
            throw new Exception("LA VALEUR DOIT AVOIR 2 CHAMPS");
        }
        this.initialiser(this.nom, GLS.getInt(valeur[1], 50));
    }

    public ChampCarto(String nom, int taille) throws Exception {
        this.initialiser(nom, taille);
    }

    public void initialiser(String nom, int taille) throws Exception {
        this.nom = nom;
        this.taille = taille;
        if (taille <= 0) {
            this.taille = 50;
        }
        if (GLS.estVide(this.nom)) {
            throw new Exception("LE CHAMP DOIT AVOIR UN NOM");
        }
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public int getTaille() {
        return this.taille;
    }

    public void setTaille(int taille) {
        this.taille = taille;
    }

    public int getIndice() {
        return this.indice;
    }

    public void setIndice(int indice) {
        this.indice = indice;
    }

    public boolean equals(Object objet) {
        return this.nom.equals(GLS.getString(objet));
    }

    public String toString() {
        return this.nom;
    }
}

