/*
 * Decompiled with CFR 0.152.
 */
package gls.application.version;

import gls.outils.GLS;
import gls.outils.Nombre;

public class Version {
    private int version;
    private int sousVersion;
    private int release;

    public Version(String version) {
        this.parse(version);
    }

    public Version(int version) {
        this(version, 0, 0);
    }

    public Version(int version, int sousVersion, int release) {
        this.version = version;
        this.sousVersion = sousVersion;
        this.release = release;
    }

    public void parse(String version) {
        String[] tabVersion;
        if (!GLS.estVide(version) && !GLS.estVide(tabVersion = version.split("\\."))) {
            this.version = GLS.getInt(tabVersion[0], 0);
            if (tabVersion.length > 1) {
                this.sousVersion = GLS.getInt(tabVersion[1], 0);
                if (tabVersion.length > 2) {
                    this.release = GLS.getInt(tabVersion[2], 0);
                }
            }
        }
    }

    public boolean equals(Object objet) {
        if (objet instanceof Version) {
            return this.equals((Version)objet);
        }
        return false;
    }

    public boolean equals(Version version) {
        return this.version == version.getVersion() && this.sousVersion == version.getSousVersion() && this.release == version.getRelease();
    }

    public boolean estSuperieure(Version version) {
        if (this.version > version.getVersion()) {
            return true;
        }
        if (this.version == version.getVersion()) {
            if (this.version > version.getSousVersion()) {
                return true;
            }
            if (this.sousVersion == version.getSousVersion()) {
                return this.release > version.getRelease();
            }
            return false;
        }
        return false;
    }

    public boolean estInferieure(Version version) {
        if (this.version < version.getVersion()) {
            return true;
        }
        if (this.version == version.getVersion()) {
            if (this.sousVersion < version.getSousVersion()) {
                return true;
            }
            if (this.sousVersion == version.getSousVersion()) {
                return this.release < version.getRelease();
            }
            return false;
        }
        return false;
    }

    public boolean estSuperieureOuEgale(Version version) {
        return this.equals(version) || this.estSuperieure(version);
    }

    public boolean estInferieureOuEgale(Version version) {
        return this.equals(version) || this.estInferieure(version);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getSousVersion() {
        return this.sousVersion;
    }

    public void setSousVersion(int sousVersion) {
        this.sousVersion = sousVersion;
    }

    public int getRelease() {
        return this.release;
    }

    public void setRelease(int release) {
        this.release = release;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.version);
        sb.append(".");
        sb.append(this.sousVersion);
        if (this.release > 0) {
            sb.append(".");
            Nombre.instanceOf();
            sb.append(Nombre.getRelease(this.release));
        }
        return sb.toString();
    }
}

