/*
 * Decompiled with CFR 0.152.
 */
import cartoj.Enregistrement;
import cartoj.ICouche;
import gls.comparator.CollatorFactory;
import gls.comparator.MyCollator;
import gls.geometry.GeoPoint;
import gls.localisation.Localisation;
import gls.localisation.recherche.Recherche;
import gls.outils.GLS;
import gls.outils.Nombre;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCONFIG;
import gls.outils.sql.ConnectionBDD;
import gls.outils.ui.carto.CartoLocalisation;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;

public class Test {
    public static void main(String ... strings) {
        Test t = new Test();
        t.test2();
    }

    private void test2() {
        String img = "data:/png;base64,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";
        img = img.replace("data:/png;base64,", "");
        img = img.replace("data:/gif;base64,", "");
        try {
            byte[] decodedImg = Base64.getDecoder().decode(img);
            Path destinationFile = Paths.get("c:/tmp/", "test.png");
            Files.write(destinationFile, decodedImg, new OpenOption[0]);
        }
        catch (Exception e) {
            System.out.println("ERR WRITE IMAGE ");
            e.printStackTrace();
        }
    }

    private void testListe() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("D\u00e9sordre");
        l.add("Type");
        l.add("Positionnement");
        if (!l.contains("D\u00e9sordre")) {
            l.add("D\u00e9sordre");
        }
    }

    private void test() {
        GLS.getNombre();
        String s = String.valueOf(Nombre.getNombre(2.89f, 2));
        System.out.println(s);
        GLS.getNombre();
        s = String.valueOf(Nombre.getNombre(0.25, 2));
        System.out.println(s);
        GLS.getNombre();
        s = String.valueOf(Nombre.getNombre(8.9602f, 2));
        System.out.println(s);
        GLS.getNombre();
        s = String.valueOf(Nombre.getNombre(0.09919999539852142, 2));
        System.out.println(s);
    }

    private void genereListeFichier() {
        try {
            String s = GLS.getString(Fichier.getFichiers(Fichier.choixDossier()));
            System.out.println(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void genererListeNomFichier() {
        String chemin = "D:\\projets\\prism\\panneaux AK\\";
        try {
            String[] stringArray = Fichier.getCheminsFichiers(chemin);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dossier = stringArray[n2];
                String cheminComplet = String.valueOf(chemin) + dossier + "\\";
                if (new File(cheminComplet).isDirectory()) {
                    Object[] fs;
                    Object[] objectArray = fs = Fichier.getFichiers(cheminComplet);
                    int n3 = fs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File f = objectArray[n4];
                        if (f.getName().startsWith("mini_")) {
                            f.renameTo(new File(String.valueOf(cheminComplet) + f.getName().replace("mini_", "")));
                        }
                        ++n4;
                    }
                    fs = Fichier.getFichiers(cheminComplet);
                    String s = String.valueOf(dossier) + " --> Autres:" + GLS.getString(fs, ";").replace(cheminComplet, "").replace(".png", "") + ";Autres";
                    System.out.println(s);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void modifierListeCommune() {
        try {
            CartoLocalisationTest carto = new CartoLocalisationTest("c:/prism_files/cd19/cartoj/", "cd19");
            ICouche cCom = carto.getCarte().getCouche("commune");
            ICouche cComZone = carto.getCarte().getCouche("zonecommune");
            cCom.getDon().setComparateur((Comparator)((MyCollator)CollatorFactory.create()));
            cComZone.getDon().setComparateur((Comparator)((MyCollator)CollatorFactory.create()));
            String url = "jdbc:postgresql://correze.prism-savh.com:5432/prism";
            String user = "prism";
            String passwd = "prism";
            ConnectionBDD conn = new ConnectionBDD(url, user, passwd);
            PreparedStatement p = conn.getConnection().prepareStatement("select * from prism.communes");
            ArrayList<String> listeErreurs = new ArrayList<String>();
            ResultSet rs = p.executeQuery();
            while (rs.next()) {
                String c = rs.getString("commune");
                Enregistrement enrCom = Recherche.getEnregistrement(cCom, 1, c);
                Enregistrement enrComZone = Recherche.getEnregistrement(cComZone, 0, c);
                if (enrCom != null) {
                    System.out.println("Remplacement " + enrCom.getValeurs()[1] + " --> " + c);
                } else {
                    System.out.println("Erreur " + c + " introuvable dans la couche commune");
                    listeErreurs.add(c);
                }
                if (enrComZone != null) {
                    System.out.println("Remplacement " + enrComZone.getValeurs()[0] + " --> " + c);
                    continue;
                }
                System.out.println("Erreur " + c + " introuvable dans la couche zonecommune");
                listeErreurs.add(c);
            }
            System.out.println("traitement termin\u00e9 " + listeErreurs.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class CartoLocalisationTest
    extends CartoLocalisation {
        public CartoLocalisationTest(String chemin, String nom) throws Exception {
            super(chemin, nom);
        }

        @Override
        protected FichierCONFIG getConfig() {
            return null;
        }

        @Override
        public void erreurLocalisation(Exception e) {
        }

        @Override
        public void localisationAt(Localisation localisation) {
        }

        @Override
        protected void chargerThemes() {
        }

        @Override
        public void clicOutilMetier(String outil) {
        }

        @Override
        public void clic(GeoPoint point, String outil) {
        }

        @Override
        public void clicDroit(GeoPoint point, String outil) {
        }
    }
}

