/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Promise;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.RemoteResource;
import net.schmizz.sshj.sftp.Request;
import net.schmizz.sshj.sftp.Requester;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPException;

public class RemoteFile
extends RemoteResource {
    public RemoteFile(Requester requester, String path, String handle) {
        super(requester, path, handle);
    }

    public FileAttributes fetchAttributes() throws IOException {
        return this.requester.request(this.newRequest(PacketType.FSTAT)).retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS).ensurePacketTypeIs(PacketType.ATTRS).readFileAttributes();
    }

    public long length() throws IOException {
        return this.fetchAttributes().getSize();
    }

    public void setLength(long len) throws IOException {
        this.setAttributes(new FileAttributes.Builder().withSize(len).build());
    }

    public int read(long fileOffset, byte[] to, int offset, int len) throws IOException {
        Response res = this.requester.request((Request)((Request)this.newRequest(PacketType.READ).putUInt64(fileOffset)).putUInt32(len)).retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS);
        switch (res.getType()) {
            case DATA: {
                int recvLen = res.readUInt32AsInt();
                System.arraycopy(res.array(), res.rpos(), to, offset, recvLen);
                return recvLen;
            }
            case STATUS: {
                res.ensureStatusIs(Response.StatusCode.EOF);
                return -1;
            }
        }
        throw new SFTPException("Unexpected packet: " + (Object)((Object)res.getType()));
    }

    public void write(long fileOffset, byte[] data, int off, int len) throws IOException {
        this.checkResponse(this.asyncWrite(fileOffset, data, off, len));
    }

    protected Promise<Response, SFTPException> asyncWrite(long fileOffset, byte[] data, int off, int len) throws IOException {
        return this.requester.request((Request)((Request)((Request)this.newRequest(PacketType.WRITE).putUInt64(fileOffset)).putUInt32(len - off)).putRawBytes(data, off, len));
    }

    private void checkResponse(Promise<Response, SFTPException> responsePromise) throws SFTPException {
        responsePromise.retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS).ensureStatusPacketIsOK();
    }

    public void setAttributes(FileAttributes attrs) throws IOException {
        this.requester.request((Request)this.newRequest(PacketType.FSETSTAT).putFileAttributes(attrs)).retrieve(this.requester.getTimeoutMs(), TimeUnit.MILLISECONDS).ensureStatusPacketIsOK();
    }

    public int getOutgoingPacketOverhead() {
        return 9 + this.handle.length() + 8 + 4 + 4;
    }

    public class RemoteFileInputStream
    extends InputStream {
        private final byte[] b = new byte[1];
        private long fileOffset;
        private long markPos;
        private long readLimit;

        public RemoteFileInputStream() {
            this(0);
        }

        public RemoteFileInputStream(int fileOffset) {
            this.fileOffset = fileOffset;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readLimit) {
            this.readLimit = readLimit;
            this.markPos = this.fileOffset;
        }

        @Override
        public void reset() throws IOException {
            this.fileOffset = this.markPos;
        }

        @Override
        public long skip(long n) throws IOException {
            this.fileOffset = Math.min(this.fileOffset + n, RemoteFile.this.length());
            return this.fileOffset;
        }

        @Override
        public int read() throws IOException {
            return this.read(this.b, 0, 1) == -1 ? -1 : this.b[0] & 0xFF;
        }

        @Override
        public int read(byte[] into, int off, int len) throws IOException {
            int read = RemoteFile.this.read(this.fileOffset, into, off, len);
            if (read != -1) {
                this.fileOffset += (long)read;
                if (this.markPos != 0L && (long)read > this.readLimit) {
                    this.markPos = 0L;
                }
            }
            return read;
        }
    }

    public class RemoteFileOutputStream
    extends OutputStream {
        private final byte[] b = new byte[1];
        private final int maxUnconfirmedWrites;
        private final Queue<Promise<Response, SFTPException>> unconfirmedWrites;
        private long fileOffset;

        public RemoteFileOutputStream() {
            this(0L);
        }

        public RemoteFileOutputStream(long startingOffset) {
            this(startingOffset, 0);
        }

        public RemoteFileOutputStream(long startingOffset, int maxUnconfirmedWrites) {
            this.fileOffset = startingOffset;
            this.maxUnconfirmedWrites = maxUnconfirmedWrites;
            this.unconfirmedWrites = new LinkedList<Promise<Response, SFTPException>>();
        }

        @Override
        public void write(int w) throws IOException {
            this.b[0] = (byte)w;
            this.write(this.b, 0, 1);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            if (this.unconfirmedWrites.size() > this.maxUnconfirmedWrites) {
                RemoteFile.this.checkResponse(this.unconfirmedWrites.remove());
            }
            this.unconfirmedWrites.add(RemoteFile.this.asyncWrite(this.fileOffset, buf, off, len));
            this.fileOffset += (long)len;
        }

        @Override
        public void flush() throws IOException {
            while (!this.unconfirmedWrites.isEmpty()) {
                RemoteFile.this.checkResponse(this.unconfirmedWrites.remove());
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

