/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Checksum;

public final class Adler32
implements Checksum {
    private static final int BASE = 65521;
    private static final int NMAX = 5552;
    private long s1 = 1L;
    private long s2 = 0L;

    @Override
    public void reset(long init) {
        this.s1 = init & 0xFFFFL;
        this.s2 = init >> 16 & 0xFFFFL;
    }

    @Override
    public void reset() {
        this.s1 = 1L;
        this.s2 = 0L;
    }

    @Override
    public long getValue() {
        return this.s2 << 16 | this.s1;
    }

    @Override
    public void update(byte[] buf, int index, int len) {
        int k;
        if (len == 1) {
            this.s1 += (long)(buf[index++] & 0xFF);
            this.s2 += this.s1;
            this.s1 %= 65521L;
            this.s2 %= 65521L;
            return;
        }
        int len1 = len / 5552;
        int len2 = len % 5552;
        while (len1-- > 0) {
            k = 5552;
            len -= k;
            while (k-- > 0) {
                this.s1 += (long)(buf[index++] & 0xFF);
                this.s2 += this.s1;
            }
            this.s1 %= 65521L;
            this.s2 %= 65521L;
        }
        k = len2;
        len -= k;
        while (k-- > 0) {
            this.s1 += (long)(buf[index++] & 0xFF);
            this.s2 += this.s1;
        }
        this.s1 %= 65521L;
        this.s2 %= 65521L;
    }

    @Override
    public Adler32 copy() {
        Adler32 foo = new Adler32();
        foo.s1 = this.s1;
        foo.s2 = this.s2;
        return foo;
    }

    static long combine(long adler1, long adler2, long len2) {
        long BASEL = 65521L;
        long rem = len2 % BASEL;
        long sum1 = adler1 & 0xFFFFL;
        long sum2 = rem * sum1;
        sum2 %= BASEL;
        sum2 += (adler1 >> 16 & 0xFFFFL) + (adler2 >> 16 & 0xFFFFL) + BASEL - rem;
        if ((sum1 += (adler2 & 0xFFFFL) + BASEL - 1L) >= BASEL) {
            sum1 -= BASEL;
        }
        if (sum1 >= BASEL) {
            sum1 -= BASEL;
        }
        if (sum2 >= BASEL << 1) {
            sum2 -= BASEL << 1;
        }
        if (sum2 >= BASEL) {
            sum2 -= BASEL;
        }
        return sum1 | sum2 << 16;
    }
}

