/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismbatch;

import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.IFileAttachment;
import com.geolocsystems.prismcentral.mail.Mail;
import com.geolocsystems.prismcentral.mail.SendMailServiceThread;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import gls.outils.GLS;
import java.util.ArrayList;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class ServiceTransmissionSynthesePatrouille {
    public static void main(String[] args) {
        int deltaHeureAvant = 9;
        if (!GLS.estVide((String[])args) && args.length > 0) {
            try {
                deltaHeureAvant = GLS.getInt((String)args[0], (int)9);
            }
            catch (Exception ex) {
                Log.error((Object)("Erreur int param " + GLS.getString((String[])args)), (Throwable)ex);
            }
        } else {
            deltaHeureAvant = 9;
        }
        ArrayList<Integer> codeModulesMetiers = new ArrayList<Integer>();
        if (!GLS.estVide((String[])args) && args.length > 1) {
            try {
                String[] modulesMetiers = GLS.getTableauString((String)args[1], (String[])ConstantesPrismCommun.CONFIG_MODULE_METIER_SYNTHESE_PATROUILLE_DEFAUT);
                if (!GLS.estVide((String[])modulesMetiers)) {
                    String[] stringArray = modulesMetiers;
                    int n = modulesMetiers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String mm = stringArray[n2];
                        int codeMm = GLS.getInt((String)mm, (int)-1);
                        if (codeMm != -1) {
                            codeModulesMetiers.add(codeMm);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception ex) {
                Log.error((Object)("Erreur liste param " + GLS.getString((String[])args)), (Throwable)ex);
            }
        } else {
            codeModulesMetiers.add(GLS.getInt((String)ConstantesPrismCommun.CONFIG_MODULE_METIER_SYNTHESE_PATROUILLE_DEFAUT[0], (int)-1));
        }
        if (!GLS.estVide(codeModulesMetiers) && deltaHeureAvant > 0) {
            try {
                if (!BusinessServiceFactory.getBusinessService().diffusionSynthesePatrouille(deltaHeureAvant, codeModulesMetiers)) {
                    ServiceTransmissionSynthesePatrouille.envoiMail("BATCH ServiceDiffusionSynthesePatrouille : Erreur envoi");
                } else {
                    Log.info((Object)"Diffusion de la synth\u00e8se des patrouilles termin\u00e9e");
                }
            }
            catch (Throwable t) {
                Log.error((Object)"Erreur de lancement de la diffusion de la synth\u00e8se des patrouilles ", (Throwable)t);
                ServiceTransmissionSynthesePatrouille.envoiMail("BATCH diffusion synth\u00e8se patrouille : Erreur DIFFUSION");
            }
            Log.info((Object)"Processus de g\u00e9n\u00e9ration des synth\u00e8ses termin\u00e9. Attente de la fin de l'envoi des mails");
            SendMailServiceThread.stop();
            Log.info((Object)"Envoi des mails termin\u00e9");
        } else {
            Log.error((Object)("Erreur de lancement de la diffusion de la synth\u00e8se des patrouilles - erreur CONFIG " + deltaHeureAvant + " -- " + codeModulesMetiers));
        }
        System.exit(0);
    }

    public static void envoiMail(String error) {
        try {
            String mailAdmin = null;
            String zoneRoutiere = "inconnu";
            try {
                zoneRoutiere = ConfigurationFactory.getInstance().get("zoneroutiere");
            }
            catch (Exception e) {
                Log.error((Object)"Erreur lors de la r\u00e9cup\u00e9ration de la zone routiere", (Throwable)e);
            }
            try {
                mailAdmin = ConfigurationFactory.getInstance().get("mail.admin", true);
            }
            catch (Exception e) {
                Log.error((Object)"Cl\u00e9 non trouv\u00e9e :mail.admin", (Throwable)e);
                mailAdmin = "thierry.daguinos@neogls.com,frederic.lambard@neogls.com";
            }
            try {
                Mail mail = new Mail(mailAdmin, "Erreur Batch : " + zoneRoutiere, String.valueOf(zoneRoutiere) + " -- " + error);
                ServiceTransmissionSynthesePatrouille.doSendMail(mail);
            }
            catch (Throwable e) {
                Log.error((Object)("Erreur dans l'envoi a " + mailAdmin), (Throwable)e);
            }
        }
        catch (Throwable e) {
            Log.error((Object)"Erreur de d\u00e9amrrage envoi mail", (Throwable)e);
        }
    }

    private static void doSendMail(Mail o) {
        try {
            IConfiguration config = ConfigurationFactory.getInstance();
            final String username = config.get("mail.smtp.username");
            final String password = config.get("mail.smtp.password");
            Properties props = new Properties();
            props.put("mail.smtp.auth", config.get("mail.smtp.auth"));
            props.put("mail.smtp.starttls.enable", config.get("mail.smtp.starttls.enable"));
            props.put("mail.smtp.ssl.trust", config.get("mail.smtp.ssl.trust"));
            props.put("mail.smtp.ssl.enable", config.get("mail.smtp.ssl"));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.host", config.get("mail.smtp.host"));
            props.put("mail.smtp.port", config.get("mail.smtp.port"));
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(config.get("mail.smtp.from")));
            message.setSender((Address)new InternetAddress(config.get("mail.smtp.from")));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)o.getTo()));
            message.setSubject(o.getObject(), "utf-8");
            message.setHeader("Content-Type", "text/plain; charset=UTF-8");
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)o.getBody(), "text/html; charset=utf-8");
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)body);
            for (IFileAttachment attachment : o.getAttachments()) {
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(new DataHandler((DataSource)new FileDataSource(attachment.getFile())));
                part.setFileName(attachment.getFileName());
                mp.addBodyPart((BodyPart)part);
            }
            message.setContent((Multipart)mp);
            Transport transport = session.getTransport("smtp");
            transport.connect(config.get("mail.smtp.host"), username, password);
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (Throwable t) {
            Log.error((Object)"Erreur envoi mail", (Throwable)t);
            throw new RuntimeException(t);
        }
    }
}

