/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismbatch;

import com.geolocsystems.prism.webservices.mce.vh.MCE;
import com.geolocsystems.prism.webservices.mce.vh.MceVhFactory;
import com.geolocsystems.prism.webservices.mce.vh.ObjectFactory;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.fichier.Fichier;
import gls.outils.ftp.FtpConnection;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.apache.log4j.Logger;

public class ServicePublicationMCEVehiculesHisto {
    private static final Logger log = Logger.getLogger(ServicePublicationMCEVehiculesHisto.class);
    private static IConfiguration newConfig;
    private static String FOURNISSEUR;
    private static String DATA_VEHICULES;
    private static String DATA_TRONCONS;
    private static String EXT_FILE_TMP;
    private static String EXT_FILE_XML;
    private static String REP_PUBLICATION;
    private static String FTP_HOSTNAME;
    private static String FTP_LOGIN;
    private static String FTP_PASSWORD;

    static {
        FOURNISSEUR = "MCE_GEOLOC";
        DATA_VEHICULES = "vehicules";
        DATA_TRONCONS = "troncons";
        EXT_FILE_TMP = "tmp";
        EXT_FILE_XML = "xml";
        REP_PUBLICATION = "";
        FTP_HOSTNAME = null;
        FTP_LOGIN = null;
        FTP_PASSWORD = null;
    }

    private static String generateFileName(boolean bVehicule, Date horodate) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("YYMMddHHmmss");
        sb.append(FOURNISSEUR);
        sb.append("_");
        if (bVehicule) {
            sb.append(DATA_VEHICULES);
        } else {
            sb.append(DATA_TRONCONS);
        }
        sb.append("_");
        sb.append(sdf.format(horodate));
        return sb.toString();
    }

    private void envoyerFichierFtp(String nomFichier) {
        FtpConnection ftpConnection = new FtpConnection(true, 1);
        boolean bConnecte = false;
        try {
            try {
                ftpConnection.connect(newConfig.get("mce.ftp_hosname"));
                ftpConnection.login(newConfig.get("mce.ftp_login"), newConfig.get("mce.ftp_password"));
                bConnecte = true;
                ftpConnection.uploadFile(String.valueOf(nomFichier) + "." + EXT_FILE_TMP, String.valueOf(REP_PUBLICATION) + nomFichier + "." + EXT_FILE_TMP);
                ftpConnection.renameFile(String.valueOf(nomFichier) + EXT_FILE_TMP, String.valueOf(nomFichier) + "." + EXT_FILE_XML);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                System.out.println("Erreur lors de la connexion au serveur FTP");
                try {
                    if (bConnecte) {
                        ftpConnection.logout();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    System.out.println("Erreur lors de la d\u00e9connexion au serveur FTP");
                }
                ftpConnection.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Erreur lors de la connexion au serveur FTP");
                try {
                    if (bConnecte) {
                        ftpConnection.logout();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    System.out.println("Erreur lors de la d\u00e9connexion au serveur FTP");
                }
                ftpConnection.disconnect();
            }
        }
        finally {
            try {
                if (bConnecte) {
                    ftpConnection.logout();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Erreur lors de la d\u00e9connexion au serveur FTP");
            }
            ftpConnection.disconnect();
        }
    }

    private void envoyerFichierFtps(String nomFichier) {
        SSHClient ssh = new SSHClient();
        ssh.addHostKeyVerifier(new HostKeyVerifier(){

            @Override
            public boolean verify(String h, int p, PublicKey k) {
                return true;
            }
        });
        try {
            try {
                try {
                    ssh.connect(newConfig.get("mce.ftp_hosname"));
                }
                catch (TransportException transportException) {
                    // empty catch block
                }
                ssh.authPassword(newConfig.get("mce.ftp_login"), newConfig.get("mce.ftp_password"));
                try (SFTPClient sftp = ssh.newSFTPClient();){
                    sftp.put(String.valueOf(REP_PUBLICATION) + nomFichier + "." + EXT_FILE_TMP, String.valueOf(nomFichier) + "." + EXT_FILE_TMP);
                    sftp.rename(String.valueOf(nomFichier) + "." + EXT_FILE_TMP, String.valueOf(nomFichier) + "." + EXT_FILE_XML);
                }
            }
            catch (IOException e) {
                log.error((Object)("Erreur lors de l'envoi du fichier " + nomFichier), (Throwable)e);
                try {
                    ssh.disconnect();
                }
                catch (IOException e2) {
                    log.error((Object)"Erreur lors de la d\u00e9connexion", (Throwable)e2);
                }
            }
            catch (Exception e) {
                log.error((Object)("Erreur lors de l'envoi du fichier " + nomFichier), (Throwable)e);
                try {
                    ssh.disconnect();
                }
                catch (IOException e3) {
                    log.error((Object)"Erreur lors de la d\u00e9connexion", (Throwable)e3);
                }
            }
        }
        finally {
            try {
                ssh.disconnect();
            }
            catch (IOException e) {
                log.error((Object)"Erreur lors de la d\u00e9connexion", (Throwable)e);
            }
        }
    }

    public void lancer() {
        String zone;
        boolean bFTPS = true;
        Date dateHisto = GLSDate.getDateHeure((int)24, (int)11, (int)2013, (int)13, (int)43, (int)32);
        try {
            zone = newConfig.get("zoneroutiere");
        }
        catch (Exception e) {
            log.error((Object)"Erreur plors de la r\u00e9cup\u00e9ration de la zone routiere", (Throwable)e);
            zone = null;
        }
        try {
            bFTPS = "1".equals(newConfig.get("mce.ftps"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!GLS.estVide((String)zone)) {
            List infosSaleuses;
            ObjectFactory factory;
            block18: {
                factory = new ObjectFactory();
                infosSaleuses = null;
                try {
                    try {
                        System.out.println("D\u00e9but d'envoi des informations VH - Liste v\u00e9hicules");
                        infosSaleuses = BusinessServiceFactory.getBusinessService().getVehiculesEnIntervention(IBusinessService.VehiculeFiltre.tous(), dateHisto);
                        for (VehiculeEnIntervention vehiculeEnIntervention : infosSaleuses) {
                            vehiculeEnIntervention.setFinPatrouille(-1L);
                        }
                        MCE mce = MceVhFactory.genererMceListeVehiculesEnIntervention(infosSaleuses);
                        JAXBContext context = JAXBContext.newInstance((String)"com.geolocsystems.prism.webservices.mce.vh");
                        JAXBElement<MCE> element = factory.createMCE(mce);
                        Marshaller marshaller = context.createMarshaller();
                        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                        marshaller.marshal((Object)element, (OutputStream)System.out);
                        String nomFichier = ServicePublicationMCEVehiculesHisto.generateFileName(true, new Date());
                        File fileTmp = new File(String.valueOf(REP_PUBLICATION) + nomFichier + "." + EXT_FILE_TMP);
                        marshaller.marshal((Object)element, fileTmp);
                        fileTmp.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Erreur d'envoi des informations VH - Liste v\u00e9hicules");
                        System.out.println("Fin d'envoi des informations VH - Liste v\u00e9hicules");
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    System.out.println("Fin d'envoi des informations VH - Liste v\u00e9hicules");
                    throw throwable;
                }
                System.out.println("Fin d'envoi des informations VH - Liste v\u00e9hicules");
            }
            try {
                try {
                    System.out.println("D\u00e9but d'envoi des informations VH - Liste tron\u00e7ons");
                    ArrayList<String> listeVehicules = new ArrayList<String>();
                    if (infosSaleuses != null && infosSaleuses.size() > 0) {
                        for (VehiculeEnIntervention infos : infosSaleuses) {
                            listeVehicules.add(infos.getCode());
                        }
                        Vector donneesVh = BusinessServiceFactory.getBusinessService().getTronconsCompletsPatrouilles(listeVehicules, dateHisto);
                        MCE mce = MceVhFactory.genererMceListeTronconsVH(donneesVh);
                        JAXBContext context = JAXBContext.newInstance((String)"com.geolocsystems.prism.webservices.mce.vh");
                        JAXBElement<MCE> element = factory.createMCE(mce);
                        Marshaller marshaller = context.createMarshaller();
                        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                        marshaller.marshal(element, (OutputStream)System.out);
                        String nomFichier = ServicePublicationMCEVehiculesHisto.generateFileName(false, new Date());
                        File fileTmp = new File(String.valueOf(REP_PUBLICATION) + nomFichier + "." + EXT_FILE_TMP);
                        marshaller.marshal(element, fileTmp);
                        fileTmp.delete();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Erreur d'envoi des informations VH - Liste tron\u00e7ons");
                    System.out.println("Fin d'envoi des informations VH - Liste tron\u00e7ons");
                }
            }
            finally {
                System.out.println("Fin d'envoi des informations VH - Liste tron\u00e7ons");
            }
        }
    }

    public ServicePublicationMCEVehiculesHisto() {
        try {
            System.out.println("Initialisation du fichier de configuration");
            newConfig = ConfigurationFactory.getInstance();
            FOURNISSEUR = newConfig.get("mce.fournisseur");
            DATA_VEHICULES = newConfig.get("mce.nom_fichier_vehicule");
            DATA_TRONCONS = newConfig.get("mce.nom_fichier_troncons");
            EXT_FILE_TMP = newConfig.get("mce.ext_fichier_tmp");
            EXT_FILE_XML = newConfig.get("mce.ext_fichier_xml");
            FTP_HOSTNAME = newConfig.get("mce.ftp_hosname");
            FTP_LOGIN = newConfig.get("mce.ftp_login");
            FTP_PASSWORD = newConfig.get("mce.ftp_password");
            REP_PUBLICATION = Fichier.completerChemin((String)newConfig.get("publication.chemin"));
        }
        catch (Exception e) {
            System.out.println("ERREUR FICHIER CONFIG " + e.getMessage());
            e.printStackTrace();
            newConfig = null;
        }
        if (newConfig == null) {
            System.out.println("Erreur dans l'initialisation de la configuration");
            System.exit(0);
        }
    }

    public static void main(String ... strings) {
        ServicePublicationMCEVehiculesHisto service = new ServicePublicationMCEVehiculesHisto();
        service.lancer();
    }
}

