/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prism.webservices.mce.vh;

import com.geolocsystems.prism.webservices.mce.vh.Capteurs;
import com.geolocsystems.prism.webservices.mce.vh.ConditionsConduiteEnum;
import com.geolocsystems.prism.webservices.mce.vh.Coordonnees;
import com.geolocsystems.prism.webservices.mce.vh.DateDebutFin;
import com.geolocsystems.prism.webservices.mce.vh.EtatTronconVHEnum;
import com.geolocsystems.prism.webservices.mce.vh.ListePoints;
import com.geolocsystems.prism.webservices.mce.vh.ListeVehicules;
import com.geolocsystems.prism.webservices.mce.vh.LocalisationTronconVH;
import com.geolocsystems.prism.webservices.mce.vh.MCE;
import com.geolocsystems.prism.webservices.mce.vh.Meteo;
import com.geolocsystems.prism.webservices.mce.vh.ObjectFactory;
import com.geolocsystems.prism.webservices.mce.vh.PR;
import com.geolocsystems.prism.webservices.mce.vh.PositionVehicule;
import com.geolocsystems.prism.webservices.mce.vh.TronconVH;
import com.geolocsystems.prism.webservices.mce.vh.TypePatrouilleEnum;
import com.geolocsystems.prism.webservices.mce.vh.VH;
import com.geolocsystems.prism.webservices.mce.vh.Vehicule;
import java.io.File;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class TestXML {
    private static String FOURNISSEUR = "MCE_GEOLOC";
    private static String DATA_VEHICULES = "vehicules";
    private static String DATA_TRONCONS = "troncons";
    private static String EXT_FILE_TMP = ".tmp";
    private static String EXT_FILE_XML = ".xml";

    private static String generateFileName(boolean bVehicule, Date horodate) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("YYMMddHHmmss");
        sb.append(FOURNISSEUR);
        sb.append("_");
        if (bVehicule) {
            sb.append(DATA_VEHICULES);
        } else {
            sb.append(DATA_TRONCONS);
        }
        sb.append("_");
        sb.append(sdf.format(horodate));
        return sb.toString();
    }

    private static XMLGregorianCalendar convertDatetoXMLDate(Date date) throws DatatypeConfigurationException {
        GregorianCalendar gregory = new GregorianCalendar();
        gregory.setTime(date);
        XMLGregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregory);
        return calendar;
    }

    public static MCE generateMceTroncons() throws DatatypeConfigurationException {
        ObjectFactory factory = new ObjectFactory();
        MCE mce = factory.createMCE();
        mce.setDate(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 12, 28, 0)));
        VH vh = new VH();
        mce.setVh(vh);
        List<TronconVH> listeTroncons = vh.getTronconVH();
        TronconVH tronconVh = new TronconVH();
        listeTroncons.add(tronconVh);
        tronconVh.setId("tr_1");
        tronconVh.setEtat(EtatTronconVHEnum.ENCOURS);
        DateDebutFin dateDebutFin = new DateDebutFin();
        dateDebutFin.setDebut(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 8, 0, 0)));
        dateDebutFin.setFin(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 15, 0, 0)));
        tronconVh.setDates(dateDebutFin);
        LocalisationTronconVH localisationTronconVH = new LocalisationTronconVH();
        tronconVh.setLocalisation(localisationTronconVH);
        localisationTronconVH.setAxe("D1091");
        PR pr = new PR();
        localisationTronconVH.setPrDebut(pr);
        pr.setPR(BigInteger.valueOf(34L));
        pr.setAbscisse(BigInteger.valueOf(0L));
        pr = new PR();
        localisationTronconVH.setPrFin(pr);
        pr.setPR(BigInteger.valueOf(35L));
        pr.setAbscisse(BigInteger.valueOf(450L));
        ListePoints listePoints = new ListePoints();
        localisationTronconVH.setPoints(listePoints);
        List<Coordonnees> listeCoord = listePoints.getCoordonnees();
        Coordonnees coordonnees = new Coordonnees();
        coordonnees.setX(3214.0f);
        coordonnees.setY(43242.0f);
        listeCoord.add(coordonnees);
        coordonnees = new Coordonnees();
        coordonnees.setX(3214.0f);
        coordonnees.setY(235423.0f);
        listeCoord.add(coordonnees);
        localisationTronconVH.setLongueur(1500.0f);
        tronconVh.setConditionsConduite(ConditionsConduiteEnum.C3);
        tronconVh.setVerglas(true);
        tronconVh.setDeneigement(true);
        tronconVh = new TronconVH();
        listeTroncons.add(tronconVh);
        tronconVh.setId("tr_2");
        tronconVh.setEtat(EtatTronconVHEnum.TERMINE);
        dateDebutFin = new DateDebutFin();
        dateDebutFin.setDebut(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 8, 0, 0)));
        dateDebutFin.setFin(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 15, 0, 0)));
        tronconVh.setDates(dateDebutFin);
        localisationTronconVH = new LocalisationTronconVH();
        tronconVh.setLocalisation(localisationTronconVH);
        localisationTronconVH.setAxe("D1091");
        pr = new PR();
        localisationTronconVH.setPrDebut(pr);
        pr.setPR(BigInteger.valueOf(34L));
        pr.setAbscisse(BigInteger.valueOf(0L));
        pr = new PR();
        localisationTronconVH.setPrFin(pr);
        pr.setPR(BigInteger.valueOf(35L));
        pr.setAbscisse(BigInteger.valueOf(450L));
        listePoints = new ListePoints();
        localisationTronconVH.setPoints(listePoints);
        listeCoord = listePoints.getCoordonnees();
        coordonnees = new Coordonnees();
        coordonnees.setX(3214.0f);
        coordonnees.setY(43242.0f);
        listeCoord.add(coordonnees);
        coordonnees = new Coordonnees();
        coordonnees.setX(3214.0f);
        coordonnees.setY(235423.0f);
        listeCoord.add(coordonnees);
        localisationTronconVH.setLongueur(1500.0f);
        tronconVh.setConditionsConduite(ConditionsConduiteEnum.C1);
        tronconVh.setVerglas(false);
        tronconVh.setDeneigement(false);
        return mce;
    }

    public static void main(String[] args) throws JAXBException, DatatypeConfigurationException {
        ObjectFactory factory = new ObjectFactory();
        MCE mce = factory.createMCE();
        mce.setDate(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 12, 28, 0)));
        ListeVehicules listeVehicules = new ListeVehicules();
        mce.setVehicules(listeVehicules);
        ListeVehicules.Vehicule vehicule = new ListeVehicules.Vehicule();
        listeVehicules.getVehicule().add(vehicule);
        vehicule.setDate(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 12, 29, 0)));
        vehicule.setCodeVehicule("12");
        Vehicule.Patrouille patrouille = new Vehicule.Patrouille();
        vehicule.setPatrouille(patrouille);
        patrouille.setId("123");
        patrouille.setActif(true);
        patrouille.setType(TypePatrouilleEnum.EIMS);
        patrouille.setCircuit(BigInteger.valueOf(1L));
        patrouille.setEquipier("Equipier1");
        DateDebutFin dateDebutFin = new DateDebutFin();
        dateDebutFin.setDebut(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 8, 0, 0)));
        dateDebutFin.setFin(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 15, 0, 0)));
        patrouille.setDates(dateDebutFin);
        PositionVehicule positionVehicule = new PositionVehicule();
        vehicule.setPosition(positionVehicule);
        Coordonnees coordonnees = new Coordonnees();
        positionVehicule.setCoordonnees(coordonnees);
        coordonnees.setX(31242.0f);
        coordonnees.setY(454432.0f);
        positionVehicule.setActif(true);
        positionVehicule.setAxe("D1091");
        PR pr = new PR();
        positionVehicule.setPr(pr);
        pr.setPR(BigInteger.valueOf(10L));
        pr.setAbscisse(BigInteger.valueOf(520L));
        positionVehicule.setAltitude(1800.0f);
        Capteurs capteurs = new Capteurs();
        capteurs.setDebitSel(BigInteger.valueOf(12L));
        capteurs.setDebitSaumure(BigInteger.valueOf(15L));
        capteurs.setLargeurTravail(Float.valueOf(1.5f));
        capteurs.setVitesse(BigInteger.valueOf(50L));
        capteurs.setKmParcourus(Float.valueOf(34.0f));
        capteurs.setKmSales(Float.valueOf(23.0f));
        capteurs.setLameBasse(true);
        vehicule.setCapteurs(capteurs);
        Meteo meteo = new Meteo();
        vehicule.setMeteo(meteo);
        meteo.setHumidite(Float.valueOf(25.0f));
        meteo.setTempAir(Float.valueOf(-3.0f));
        meteo.setTempSol(Float.valueOf(0.0f));
        vehicule = new ListeVehicules.Vehicule();
        listeVehicules.getVehicule().add(vehicule);
        vehicule.setDate(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 12, 28, 0)));
        vehicule.setCodeVehicule("23");
        patrouille = new Vehicule.Patrouille();
        vehicule.setPatrouille(patrouille);
        patrouille.setId("1523");
        patrouille.setActif(true);
        patrouille.setType(TypePatrouilleEnum.VH);
        patrouille.setCircuit(BigInteger.valueOf(1L));
        patrouille.setEquipier("Equipier2");
        dateDebutFin = new DateDebutFin();
        dateDebutFin.setDebut(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 9, 28, 0)));
        dateDebutFin.setFin(TestXML.convertDatetoXMLDate(new Date(2011, 11, 17, 14, 28, 0)));
        patrouille.setDates(dateDebutFin);
        positionVehicule = new PositionVehicule();
        vehicule.setPosition(positionVehicule);
        coordonnees = new Coordonnees();
        positionVehicule.setCoordonnees(coordonnees);
        coordonnees.setX(31242.0f);
        coordonnees.setY(454432.0f);
        positionVehicule.setActif(false);
        positionVehicule.setAxe("D1091");
        positionVehicule.setAltitude(1800.0f);
        capteurs = new Capteurs();
        capteurs.setKmParcourus(Float.valueOf(20.0f));
        JAXBContext context = JAXBContext.newInstance((String)"com.geolocsystems.prism.webservices.mce.vh");
        JAXBElement<MCE> element = factory.createMCE(mce);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(element, (OutputStream)System.out);
        File fileTmp = new File(String.valueOf(TestXML.generateFileName(true, new Date())) + EXT_FILE_TMP);
        File fileXml = new File(String.valueOf(TestXML.generateFileName(true, new Date())) + EXT_FILE_XML);
        marshaller.marshal(element, fileTmp);
        fileTmp.renameTo(fileXml);
        element = factory.createMCE(TestXML.generateMceTroncons());
        marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(element, (OutputStream)System.out);
        fileTmp = new File(String.valueOf(TestXML.generateFileName(false, new Date())) + EXT_FILE_TMP);
        fileXml = new File(String.valueOf(TestXML.generateFileName(false, new Date())) + EXT_FILE_XML);
        marshaller.marshal(element, fileTmp);
        fileTmp.renameTo(fileXml);
    }
}

