/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prism.webservices.mce.vh;

import com.geolocsystems.prism.webservices.mce.vh.Capteurs;
import com.geolocsystems.prism.webservices.mce.vh.ConditionsConduiteEnum;
import com.geolocsystems.prism.webservices.mce.vh.ConstantesMceVh;
import com.geolocsystems.prism.webservices.mce.vh.Coordonnees;
import com.geolocsystems.prism.webservices.mce.vh.DateDebutFin;
import com.geolocsystems.prism.webservices.mce.vh.EtatTronconVHEnum;
import com.geolocsystems.prism.webservices.mce.vh.ListePoints;
import com.geolocsystems.prism.webservices.mce.vh.ListeVehicules;
import com.geolocsystems.prism.webservices.mce.vh.LocalisationTronconVH;
import com.geolocsystems.prism.webservices.mce.vh.MCE;
import com.geolocsystems.prism.webservices.mce.vh.Meteo;
import com.geolocsystems.prism.webservices.mce.vh.ObjectFactory;
import com.geolocsystems.prism.webservices.mce.vh.PR;
import com.geolocsystems.prism.webservices.mce.vh.PositionVehicule;
import com.geolocsystems.prism.webservices.mce.vh.TronconVH;
import com.geolocsystems.prism.webservices.mce.vh.TypePatrouilleEnum;
import com.geolocsystems.prism.webservices.mce.vh.VH;
import com.geolocsystems.prism.webservices.mce.vh.Vehicule;
import com.geolocsystems.prismcentral.beans.TronconSuiviComplet;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import commun.UnPoint;
import gls.geometry.GeoPoint;
import gls.geometry.Geometry;
import gls.outils.Extension;
import gls.outils.GLS;
import gls.outils.GLSDate;
import java.awt.geom.Point2D;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;

public class MceVhFactory
implements ConstantesMceVh {
    private static final Logger log = Logger.getLogger(MceVhFactory.class);

    private static XMLGregorianCalendar convertDatetoXMLDate(Date date) throws DatatypeConfigurationException {
        GregorianCalendar gregory = new GregorianCalendar();
        gregory.setTime(date);
        XMLGregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregory);
        return calendar;
    }

    private static XMLGregorianCalendar convertDatetoXMLDate(Calendar gregory) throws DatatypeConfigurationException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(gregory.getTime());
        XMLGregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
        return calendar;
    }

    private static XMLGregorianCalendar maintenantXMLGregorianCalendar() throws DatatypeConfigurationException {
        GregorianCalendar gregory = new GregorianCalendar();
        XMLGregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregory);
        return calendar;
    }

    protected static XMLGregorianCalendar getDateTimeXMLGregorianCalendar(String date) throws Exception {
        if (!GLS.estVide((String)date)) {
            if (date.indexOf("P") != -1) {
                date = date.substring(0, date.length() - 3);
            }
        } else {
            return null;
        }
        log.debug((Object)("Date \u00e0 parser " + date));
        try {
            Calendar c = GLSDate.toDateDatex((String)date);
            return MceVhFactory.convertDatetoXMLDate(c);
        }
        catch (Exception e) {
            log.error((Object)(String.valueOf(date) + "\n"), (Throwable)e);
            return MceVhFactory.maintenantXMLGregorianCalendar();
        }
    }

    protected static Capteurs genererCapteurs(Extension parametresMce) {
        log.debug((Object)"<capteurs>");
        Capteurs capteurs = new Capteurs();
        if (parametresMce.getInt("VEHICULE_DEBITSEL", -1) == -1) {
            capteurs.setDebitSel(null);
        } else {
            capteurs.setDebitSel(BigInteger.valueOf(parametresMce.getInt("VEHICULE_DEBITSEL", -1)));
        }
        if (parametresMce.getInt("VEHICULE_DEBITSAUMURE", -1) == -1) {
            capteurs.setDebitSaumure(null);
        } else {
            capteurs.setDebitSaumure(BigInteger.valueOf(parametresMce.getInt("VEHICULE_DEBITSAUMURE", -1)));
        }
        if (parametresMce.getFloat("VEHICULE_LARGEURTRAVAIL", -1.0f) == -1.0f) {
            capteurs.setLargeurTravail(null);
        } else {
            capteurs.setLargeurTravail(Float.valueOf(parametresMce.getFloat("VEHICULE_LARGEURTRAVAIL", -1.0f)));
        }
        if (parametresMce.getInt("VEHICULE_VITESSEVEHICULE", -1) == -1) {
            capteurs.setVitesse(null);
        } else {
            capteurs.setVitesse(BigInteger.valueOf(parametresMce.getInt("VEHICULE_VITESSEVEHICULE", -1)));
        }
        if (parametresMce.getFloat("VEHICULE_KMPARCOURU", -1.0f) == -1.0f) {
            capteurs.setKmParcourus(null);
        } else {
            capteurs.setKmParcourus(Float.valueOf(parametresMce.getFloat("VEHICULE_KMPARCOURU", -1.0f)));
        }
        if (parametresMce.getFloat("VEHICULE_KMSALE", -1.0f) == -1.0f) {
            capteurs.setKmSales(null);
        } else {
            capteurs.setKmSales(Float.valueOf(parametresMce.getFloat("VEHICULE_KMSALE", -1.0f)));
        }
        if (parametresMce.getInt("VEHICULE_POSITIONLAME", -1) == -1) {
            capteurs.setLameBasse(null);
        } else {
            capteurs.setLameBasse(parametresMce.getBoolean("VEHICULE_POSITIONLAME", false));
        }
        log.debug((Object)"</capteurs>");
        return capteurs;
    }

    protected static PositionVehicule genererPositionVehicule(Extension parametresMce) throws Exception {
        log.debug((Object)"<positionVehicule>");
        PositionVehicule positionVehicule = new PositionVehicule();
        Coordonnees coordonnees = new Coordonnees();
        positionVehicule.setCoordonnees(coordonnees);
        GeoPoint point = new GeoPoint(parametresMce.getString("VEHICULE_XY"));
        UnPoint p = new UnPoint(point.getX(), point.getY()).toLL(30, "N");
        coordonnees.setX(p.x);
        coordonnees.setY(p.y);
        if (GLS.estVide((String)parametresMce.getString("FIN"))) {
            positionVehicule.setActif(true);
        } else {
            positionVehicule.setActif(false);
        }
        positionVehicule.setAxe(parametresMce.getString("VEHICULE_AXE"));
        PR pr = new PR();
        positionVehicule.setPr(pr);
        pr.setPR(BigInteger.valueOf(parametresMce.getInt("VEHICULE_PR", -1)));
        pr.setAbscisse(BigInteger.valueOf(parametresMce.getInt("VEHICULE_ABSCISSEPR", -1)));
        positionVehicule.setAltitude(parametresMce.getInt("VEHICULE_ALTITUDE", -1));
        log.debug((Object)"</positionVehicule>");
        return positionVehicule;
    }

    protected static Vehicule.Patrouille genererPatrouille(Extension parametresMce) throws Exception {
        log.debug((Object)"<patrouille>");
        Vehicule.Patrouille patrouille = new Vehicule.Patrouille();
        patrouille.setId(parametresMce.getString("ID"));
        if (GLS.estVide((String)parametresMce.getString("FIN"))) {
            patrouille.setActif(true);
        } else {
            patrouille.setActif(false);
        }
        if ("EIMS".equals(parametresMce.getString("TYPE"))) {
            patrouille.setType(TypePatrouilleEnum.EIMS);
        } else {
            patrouille.setType(TypePatrouilleEnum.VH);
        }
        patrouille.setCircuit(new BigInteger(parametresMce.getString("IDCIRCUIT")));
        patrouille.setEquipier(parametresMce.getString("VEHICULE_EQUIPIER"));
        DateDebutFin dateDebutFin = new DateDebutFin();
        dateDebutFin.setDebut(MceVhFactory.getDateTimeXMLGregorianCalendar(parametresMce.getString("DEBUT")));
        dateDebutFin.setFin(MceVhFactory.getDateTimeXMLGregorianCalendar(parametresMce.getString("FIN")));
        patrouille.setDates(dateDebutFin);
        log.debug((Object)"</patrouille>");
        return patrouille;
    }

    protected static ListeVehicules.Vehicule genererVehicule(Extension parametresMce) throws Exception {
        log.debug((Object)"<vehicule>");
        ListeVehicules.Vehicule vehicule = new ListeVehicules.Vehicule();
        vehicule.setDate(MceVhFactory.getDateTimeXMLGregorianCalendar(parametresMce.getString("DATE_DERNIERE_REMONTEE")));
        vehicule.setCodeVehicule(parametresMce.getString("VEHICULE_CODE_PARC"));
        vehicule.setPatrouille(MceVhFactory.genererPatrouille(parametresMce));
        vehicule.setPosition(MceVhFactory.genererPositionVehicule(parametresMce));
        vehicule.setCapteurs(MceVhFactory.genererCapteurs(parametresMce));
        Meteo meteo = new Meteo();
        vehicule.setMeteo(meteo);
        if (parametresMce.getFloat("VEHICULE_HUMIDITEAIR", -1.0f) == -1.0f) {
            meteo.setHumidite(null);
        } else {
            meteo.setHumidite(Float.valueOf(parametresMce.getFloat("VEHICULE_HUMIDITEAIR", -1.0f)));
        }
        if (parametresMce.getFloat("VEHICULE_TEMPERATUREAIR", -1.0f) == -1.0f) {
            meteo.setTempAir(null);
        } else {
            meteo.setTempAir(Float.valueOf(parametresMce.getFloat("VEHICULE_TEMPERATUREAIR", -1.0f)));
        }
        if (parametresMce.getFloat("VEHICULE_TEMPERATURESOL", -1.0f) == -1.0f) {
            meteo.setTempSol(null);
        } else {
            meteo.setTempSol(Float.valueOf(parametresMce.getFloat("VEHICULE_TEMPERATURESOL", -1.0f)));
        }
        log.debug((Object)"</vehicule>");
        return vehicule;
    }

    protected static TronconVH genererDonneeVH(Extension parametresMce) throws Exception {
        log.debug((Object)"<tronconVH>");
        TronconVH tronconVh = new TronconVH();
        tronconVh.setId(parametresMce.getString("TRONCON_ID"));
        if ("1".equals(parametresMce.getString("TRONCON_ETAT"))) {
            tronconVh.setEtat(EtatTronconVHEnum.ENCOURS);
        } else if ("2".equals(parametresMce.getString("TRONCON_ETAT"))) {
            tronconVh.setEtat(EtatTronconVHEnum.TERMINE);
        } else {
            tronconVh.setEtat(EtatTronconVHEnum.PERIME);
        }
        DateDebutFin dateDebutFin = new DateDebutFin();
        dateDebutFin.setDebut(MceVhFactory.getDateTimeXMLGregorianCalendar(parametresMce.getString("TRONCON_DATE_DEBUT")));
        dateDebutFin.setFin(MceVhFactory.getDateTimeXMLGregorianCalendar(parametresMce.getString("TRONCON_DATE_FIN")));
        tronconVh.setDates(dateDebutFin);
        LocalisationTronconVH localisationTronconVH = new LocalisationTronconVH();
        tronconVh.setLocalisation(localisationTronconVH);
        localisationTronconVH.setAxe(parametresMce.getString("TRONCON_AXE"));
        PR pr = new PR();
        localisationTronconVH.setPrDebut(pr);
        pr.setPR(BigInteger.valueOf(parametresMce.getInt("TRONCON_PRDEBUT", -1)));
        pr.setAbscisse(BigInteger.valueOf(parametresMce.getInt("TRONCON_DISTANCEPRDEBUT", -1)));
        pr = new PR();
        localisationTronconVH.setPrFin(pr);
        pr.setPR(BigInteger.valueOf(parametresMce.getInt("TRONCON_PRFIN", -1)));
        pr.setAbscisse(BigInteger.valueOf(parametresMce.getInt("TRONCON_DISTANCEPRFIN", -1)));
        ListePoints listePoints = new ListePoints();
        localisationTronconVH.setPoints(listePoints);
        List<Coordonnees> listeCoord = listePoints.getCoordonnees();
        Vector vCoord = Geometry.getStringToPoints((String)parametresMce.getString("TRONCON_COORDONNEES"));
        if (vCoord != null && vCoord.size() > 0) {
            int i = 0;
            while (i < vCoord.size()) {
                Coordonnees coordonnees = new Coordonnees();
                Point2D.Double coord = (Point2D.Double)vCoord.get(i);
                UnPoint p = new UnPoint(coord.getX(), coord.getY()).toLL(30, "N");
                coordonnees.setX(p.x);
                coordonnees.setY(p.y);
                listeCoord.add(coordonnees);
                ++i;
            }
        }
        localisationTronconVH.setLongueur(parametresMce.getInt("TRONCON_LONGUEUR", -1));
        if ("C4".equals(parametresMce.getString("TRONCON_CCH"))) {
            tronconVh.setConditionsConduite(ConditionsConduiteEnum.C4);
        } else if ("C1".equals(parametresMce.getString("TRONCON_CCH"))) {
            tronconVh.setConditionsConduite(ConditionsConduiteEnum.C1);
        } else if ("C2".equals(parametresMce.getString("TRONCON_CCH"))) {
            tronconVh.setConditionsConduite(ConditionsConduiteEnum.C2);
        } else if ("C3".equals(parametresMce.getString("TRONCON_CCH"))) {
            tronconVh.setConditionsConduite(ConditionsConduiteEnum.C3);
        } else {
            tronconVh.setConditionsConduite(null);
        }
        tronconVh.setVerglas(false);
        if ("0".equals(parametresMce.getString("TRONCON_DENEIGEMENT"))) {
            tronconVh.setDeneigement(false);
        } else {
            tronconVh.setDeneigement(true);
        }
        log.debug((Object)"</tronconVH>");
        return tronconVh;
    }

    protected static Extension informationSaleuseToExtension(Extension parametresMce, VehiculeEnIntervention infosSaleuse) {
        parametresMce.setValeur("DATE_DERNIERE_REMONTEE", (Object)GLSDate.toDateDatex((long)infosSaleuse.getDatePosition()));
        parametresMce.setValeur("VEHICULE_CODE_PARC", (Object)infosSaleuse.getCode());
        parametresMce.setValeur("VEHICULE_AXE", (Object)infosSaleuse.getAxe());
        parametresMce.setValeur("VEHICULE_PR", (Object)infosSaleuse.getPr());
        parametresMce.setValeur("VEHICULE_ABSCISSEPR", (Object)infosSaleuse.getAbspr());
        parametresMce.setValeur("VEHICULE_XY", (Object)(String.valueOf(infosSaleuse.getX()) + ";" + infosSaleuse.getY()));
        parametresMce.setValeur("VEHICULE_CCH", (Object)infosSaleuse.getCch());
        parametresMce.setValeur("VEHICULE_DEBITSEL", (Object)infosSaleuse.getDebitSel());
        parametresMce.setValeur("VEHICULE_DEBITSAUMURE", (Object)infosSaleuse.getDebitSaumure());
        parametresMce.setValeur("VEHICULE_LARGEURTRAVAIL", (Object)infosSaleuse.getLargeurTravail());
        parametresMce.setValeur("VEHICULE_VITESSEVEHICULE", (Object)infosSaleuse.getVitesse());
        parametresMce.setValeur("VEHICULE_KMPARCOURU", (Object)infosSaleuse.getKmParcouru());
        parametresMce.setValeur("VEHICULE_KMSALE", (Object)infosSaleuse.getKmSale());
        parametresMce.setValeur("VEHICULE_POSITIONLAME", (Object)infosSaleuse.getLameBaissee());
        parametresMce.setValeur("VEHICULE_TEMPERATURESOL", (Object)infosSaleuse.getTemperatureSol());
        parametresMce.setValeur("VEHICULE_TEMPERATUREAIR", (Object)infosSaleuse.getTemperatureAir());
        parametresMce.setValeur("VEHICULE_HUMIDITEAIR", (Object)infosSaleuse.getHumiditeAir());
        parametresMce.setValeur("VEHICULE_ALTITUDE", (Object)infosSaleuse.getAltitude());
        parametresMce.setValeur("VEHICULE_AGENT", (Object)infosSaleuse.getChauffeur());
        parametresMce.setValeur("VEHICULE_EQUIPIER", (Object)infosSaleuse.getChauffeur());
        parametresMce.setValeur("ID", (Object)infosSaleuse.getIdPatrouille());
        parametresMce.setValeur("IDCIRCUIT", (Object)infosSaleuse.getIdCircuit());
        if (infosSaleuse.getModuleMetier() == 1) {
            parametresMce.setValeur("TYPE", (Object)TypePatrouilleEnum.VH);
        } else {
            parametresMce.setValeur("TYPE", (Object)TypePatrouilleEnum.EIMS);
        }
        parametresMce.setValeur("DEBUT", (Object)GLSDate.toDateDatex((long)infosSaleuse.getDebutPatrouille()));
        if (infosSaleuse.getFinPatrouille() > 0L) {
            parametresMce.setValeur("FIN", (Object)GLSDate.toDateDatex((long)infosSaleuse.getFinPatrouille()));
        }
        return parametresMce;
    }

    protected static Extension donneeVHToExtension(Extension parametresMce, TronconSuiviComplet donneesVH) {
        parametresMce.setValeur("TRONCON_ID", (Object)donneesVH.getId());
        parametresMce.setValeur("TRONCON_ETAT", (Object)donneesVH.getEtat());
        parametresMce.setValeur("TRONCON_DATE_DEBUT", (Object)GLSDate.toDateDatex((long)donneesVH.getDateDebut()));
        parametresMce.setValeur("TRONCON_DATE_FIN", (Object)GLSDate.toDateDatex((long)donneesVH.getDateFin()));
        parametresMce.setValeur("TRONCON_AXE", (Object)donneesVH.getAxe());
        parametresMce.setValeur("TRONCON_PRDEBUT", (Object)donneesVH.getPrDebut());
        parametresMce.setValeur("TRONCON_PRFIN", (Object)donneesVH.getPrFin());
        parametresMce.setValeur("TRONCON_DISTANCEPRDEBUT", (Object)donneesVH.getDistancePrDebut());
        parametresMce.setValeur("TRONCON_DISTANCEPRFIN", (Object)donneesVH.getDistancePrFin());
        parametresMce.setValeur("TRONCON_LONGUEUR", (Object)donneesVH.getLongueur());
        parametresMce.setValeur("TRONCON_CCH", (Object)donneesVH.getCch());
        parametresMce.setValeur("TRONCON_VERGLAS", (Object)donneesVH.getSeuilSalage());
        parametresMce.setValeur("TRONCON_DENEIGEMENT", (Object)donneesVH.getDeneigement());
        parametresMce.setValeur("TRONCON_COORDONNEES", (Object)donneesVH.getCoordonnees());
        return parametresMce;
    }

    public static MCE genererMceListeVehiculesEnIntervention(List<VehiculeEnIntervention> infosSaleuses) throws Exception {
        ObjectFactory factory = new ObjectFactory();
        MCE mce = factory.createMCE();
        Extension parametresMce = new Extension();
        mce.setDate(MceVhFactory.maintenantXMLGregorianCalendar());
        ListeVehicules listeVehicules = new ListeVehicules();
        mce.setVehicules(listeVehicules);
        for (VehiculeEnIntervention informationsSaleuse : infosSaleuses) {
            parametresMce = new Extension();
            parametresMce = MceVhFactory.informationSaleuseToExtension(parametresMce, informationsSaleuse);
            listeVehicules.getVehicule().add(MceVhFactory.genererVehicule(parametresMce));
        }
        return mce;
    }

    public static MCE genererMceListeTronconsVH(Collection<TronconSuiviComplet> listeDonneesVH) throws Exception {
        ObjectFactory factory = new ObjectFactory();
        MCE mce = factory.createMCE();
        Extension parametresMce = new Extension();
        mce.setDate(MceVhFactory.maintenantXMLGregorianCalendar());
        VH vh = new VH();
        mce.setVh(vh);
        List<TronconVH> listeTroncons = vh.getTronconVH();
        for (TronconSuiviComplet donneeVH : listeDonneesVH) {
            if (donneeVH.getPrDebut() >= 0 && donneeVH.getPrFin() >= 0) {
                parametresMce = MceVhFactory.donneeVHToExtension(parametresMce, donneeVH);
                listeTroncons.add(MceVhFactory.genererDonneeVH(parametresMce));
                continue;
            }
            log.info((Object)("Tron\u00e7on non transmis : " + donneeVH.getAxe() + "," + donneeVH.getPrDebut() + "," + donneeVH.getPrFin()));
        }
        return mce;
    }
}

