/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prism.webservices.datex2;

import com.geolocsystems.prism.webservices.datex2.ConstantesDatex2v2;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.schema._2._2_0.holders.D2LogicalModelHolder;
import eu.datex2.wsdl.supplierPush._2_0.SupplierPushServiceLocator;
import eu.datex2.wsdl.supplierPush._2_0.SupplierPushSoapBindingStub;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.xml.XML;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.message.MessageElement;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.ext.Attributes2Impl;

public class Datex2V2Util
implements ConstantesDatex2v2 {
    private static Logger log = Logger.getLogger(Datex2V2Util.class);
    private static final String SOAP_END = "</soapenv:Body></soapenv:Envelope>";
    private static final String SOAP_START_BIS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><d2LogicalModel modelBaseVersion=\"2\" xmlns=\"http://datex2.eu/schema/2/2_0\">";

    public static boolean validerFichiersXMLDatex2(Vector<File> fichiersXML, File fichierXSD) throws Exception {
        boolean erreur = false;
        for (File fichierXML : fichiersXML) {
            try {
                Datex2V2Util.validerFichierXMLDatex2(fichierXML, fichierXSD);
            }
            catch (Exception e) {
                erreur = true;
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return !erreur;
    }

    public static void validerFichierXMLDatex2(File fichierXML, File fichierXSD) throws Exception {
        try {
            Vector erreurs = XML.validateXML((File)fichierXML, (File)fichierXSD);
            if (!GLS.estVide((List)erreurs)) {
                log.debug((Object)"#####################################################################");
                for (String erreur : erreurs) {
                    log.debug((Object)("### ERREUR XSD # " + GLS.getString((String)erreur)));
                }
                throw new Exception("# LE FICHIER DATEX2 " + fichierXML.getPath() + " N'EST PAS VALIDE");
            }
        }
        catch (Exception e) {
            throw new Exception("ERREUR XSD # " + e.getMessage());
        }
    }

    public static String serialiserHelper(D2LogicalModel sitRec, boolean soap) throws Exception {
        SupplierPushSoapBindingStub binding;
        try {
            binding = (SupplierPushSoapBindingStub)new SupplierPushServiceLocator().getsupplierPushSoapEndPoint();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            log.error((Object)jre);
            return jre.toString();
        }
        binding.setTimeout(10);
        try {
            binding.putDatex2Data(new D2LogicalModelHolder(sitRec));
        }
        catch (Exception e) {
            log.debug((Object)"Fin appel SOAP");
        }
        try {
            Message requestMessage = binding._getCall().getMessageContext().getRequestMessage();
            if (soap) {
                StringWriter writer = new StringWriter();
                SerializationContext ctx = new SerializationContext((Writer)writer, binding._getCall().getMessageContext());
                ctx.setPretty(true);
                requestMessage.getSOAPEnvelope().output(ctx);
                writer.close();
                String xml = writer.getBuffer().toString();
                return requestMessage.getSOAPEnvelope().toString();
            }
            String xml = requestMessage.getSOAPBody().getFirstChild().toString();
            return Datex2V2Util.verifierFichierXMLDatex2(xml);
        }
        catch (Exception e) {
            log.error((Object)"ERREUR SERIALISATION", (Throwable)e);
            throw new Exception("ERREUR SERIALISATION # " + e.getMessage().substring(e.getMessage().lastIndexOf(":") + 1));
        }
    }

    public static File serialiser(String nomFichier, D2LogicalModel sitRec) throws Exception {
        try {
            String cheminCompletFichier = nomFichier;
            String repertoireFichier = Fichier.getRepertoire((String)cheminCompletFichier);
            Fichier.verifierDossier((String)repertoireFichier);
            Fichier.effacerFichier((String)cheminCompletFichier);
            log.info((Object)("D\u00e9but \u00e9criture fichier " + cheminCompletFichier));
            log.debug((Object)("# S\u00e9rialisation " + cheminCompletFichier));
            File monFic = new File(cheminCompletFichier);
            monFic.createNewFile();
            FileOutputStream fos = new FileOutputStream(monFic);
            PrintWriter ecrivain = new PrintWriter(fos);
            try {
                try {
                    ecrivain.write("<?xml version='1.0' encoding='UTF-8'?>");
                    String s = Datex2V2Util.serialiserHelper(sitRec, true);
                    s = s.replaceFirst("xmlns=\"http://datex2.eu/schema/2/2_0\">", "xmlns=\"http://datex2.eu/schema/2/2_0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://datex2.eu/schema/2/2_0/DATEXIISchema_2_2_0.xsd\">");
                    ecrivain.write(s);
                }
                catch (Exception ex) {
                    throw new Exception(String.valueOf(nomFichier.substring(nomFichier.lastIndexOf("/") + 1)) + " # " + ex.getMessage());
                }
            }
            finally {
                ecrivain.flush();
                ecrivain.close();
                fos.close();
                ecrivain = null;
                fos = null;
            }
            log.info((Object)"Fin \u00e9criture fichier");
            return monFic;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static String serialiser(Object sitRec, Class sitRecClass) throws Exception {
        String className = sitRecClass.getSimpleName();
        Class[] parameterTypes = new Class[]{String.class, Class.class, QName.class};
        try {
            Method methodToCall = sitRecClass.getMethod("getSerializer", parameterTypes);
            BeanSerializer sez = (BeanSerializer)methodToCall.invoke(sitRec, "Axis SAX Mechanism", sitRecClass, new QName(className, "D2LogicalModel", ""));
            sez.serialize(new QName(className, "D2LogicalModel", ""), (Attributes)new Attributes2Impl(){}, sitRec, new SerializationContext(new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            }));
            return sez.toString();
        }
        catch (Exception e) {
            throw new Exception("Probl\u00e8me survenu lors de la s\u00e9rialisation", e);
        }
    }

    public static Object deserialiser(String xml, Class clazz) throws Exception {
        assert (xml != null) : "xml != null";
        assert (clazz != null) : "clazz != null";
        D2LogicalModel result = null;
        try {
            String temp = xml.substring(xml.toUpperCase().indexOf("<D2"));
            String temp2 = xml.substring(temp.toUpperCase().indexOf(">") + 1);
            SupplierPushSoapBindingStub clientSoap = new SupplierPushSoapBindingStub();
            MessageContext mc = clientSoap.getMessageContext();
            DeserializationContext dser = new DeserializationContext(new InputSource(new StringReader(SOAP_START_BIS + temp2 + SOAP_END)), mc, "response");
            dser.parse();
            MessageElement me = (MessageElement)dser.getEnvelope().getBodyElements().get(0);
            result = (D2LogicalModel)me.getObjectValue(clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String verifierFichierXMLDatex2(String xml) {
        String[][] stringArray = CORRECTION_DATEX2_XML;
        int n = CORRECTION_DATEX2_XML.length;
        int n2 = 0;
        while (n2 < n) {
            String[] correction = stringArray[n2];
            xml = xml.replaceAll(correction[0], correction[1]);
            ++n2;
        }
        return xml;
    }
}

