/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.export;

import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.beans.Partenaire;
import gls.outils.GLS;
import gls.outils.GLSDate;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PrismIG4ExportV2 {
    private static final String EXPORT_IG4 = "export_ig4";
    private static Logger cat1 = Logger.getLogger((String)"exportIG4");

    public static void main(String[] args) {
        Date iterationCourante = GregorianCalendar.getInstance().getTime();
        if (!GLS.estVide((String[])args)) {
            cat1.info((Object)("Lancement \u00e0 " + iterationCourante + " " + args[0]));
        } else {
            cat1.info((Object)("Lancement \u00e0 " + iterationCourante));
        }
        List partenaires = null;
        try {
            partenaires = BusinessServiceFactory.getBusinessService().getListePartenaire(ConstantesPrismCommun.EnumPartenaire.IG4_GAROU.getCode());
        }
        catch (Exception e1) {
            cat1.error((Object)"", (Throwable)e1);
            System.exit(1);
        }
        List<Partenaire> partenairesExternes = PrismIG4ExportV2.recherchePartenaireExterne(partenaires);
        GregorianCalendar gc = new GregorianCalendar();
        if (!GLS.estVide((String[])args) && args.length > 0) {
            try {
                GLS.getDate();
                String string = args[0];
                GLS.getDate();
                gc.setTimeInMillis(GLSDate.toDate((String)string, (DateFormat)GLSDate.formatDateJourPg).getTimeInMillis());
            }
            catch (Exception ex) {
                cat1.error((Object)("Erreur date param " + GLS.getString((String[])args)), (Throwable)ex);
            }
        } else {
            gc.add(5, -1);
        }
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        Date dateDeb = gc.getTime();
        gc.add(5, 1);
        Date dateFin = gc.getTime();
        cat1.debug((Object)("Nombre de partenaires externe: " + partenairesExternes.size()));
        if (!BusinessServiceFactory.getSuiviActiviteService().exportationV2(partenairesExternes, dateDeb, dateFin)) {
            System.exit(1);
        }
    }

    private static List<Partenaire> recherchePartenaireExterne(List<Partenaire> partenairesExternes) {
        Vector<Partenaire> partenairesATraiter = new Vector<Partenaire>();
        for (Partenaire partenaire : partenairesExternes) {
            if (!"CSV".equals(partenaire.getFormatEchange())) continue;
            partenairesATraiter.add(partenaire);
        }
        return partenairesATraiter;
    }
}

