/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentraldata.util.login;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismcentral.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

public class LoginLdapConnection
extends SocketFactory {
    private static SocketFactory blindFactory = null;

    static {
        TrustManager[] blindTrustMan = new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, blindTrustMan, new SecureRandom());
            blindFactory = sc.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    public static SocketFactory getDefault() {
        return new LoginLdapConnection();
    }

    @Override
    public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
        return blindFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return blindFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
        return blindFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return blindFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    public boolean login(String securityPrincipalPattern, String login, String password, String host, int port, String domainName) {
        boolean validateCert = false;
        Log.debug("Testing LDAPS connection with validateCert: " + validateCert);
        Hashtable<String, String> env = new Hashtable<String, String>();
        String url = "ldaps://" + host + ":" + port;
        String securityPrincipal = MetierCommun.getLdapSecurityPrincipal((String)login, (String)domainName, (String)securityPrincipalPattern);
        Log.info("LDAP security principal pattern - " + securityPrincipal);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", securityPrincipal);
        env.put("java.naming.security.credentials", password);
        if (url.startsWith("ldaps") && !validateCert) {
            env.put("java.naming.ldap.factory.socket", LoginLdapConnection.class.getName());
        }
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            ctx.close();
            return true;
        }
        catch (AuthenticationException e) {
            Log.error("The credentials could not be validated!" + login);
        }
        catch (NamingException e) {
            e.printStackTrace();
            Log.error("ERROR NAMING LDAP", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error("ERROR LDAP", e);
        }
        return false;
    }
}

