/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.ig4.Mission;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.IAdminDAO;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IScoopDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.beans.ig4.UserExport;
import com.geolocsystems.prismcentral.beans.ig4.VehiculeExport;
import com.geolocsystems.prismcentral.data.ISuiviActiviteService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCSV;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ScoopSynchroService
implements ISuiviActiviteService {
    protected IAdminDAO adminDal;
    protected IUserDAO userDal;
    protected IReferentielDAO referentielDal;
    private static final long serialVersionUID = 1832979256504127634L;
    protected static final String FICHIER_IMPORT_UTILISATEUR = "agents.csv";
    protected static final String FICHIER_IMPORT_MATERIEL = "vehicle.csv";
    protected static int LIGNE_NOM = 1;
    protected static int LIGNE_PRENOM = 2;
    protected static int LIGNE_CODE = 0;
    protected static int LIGNE_UA = 3;
    protected static int LIGNE_PROFIL = 4;
    protected int nbLignesEntete = 0;
    private IScoopDAO scoopDal;
    private IIconDAO iconDal = DAOFactory.getInstance().getIconDAO();

    public ScoopSynchroService() {
        this.userDal = DAOFactory.getInstance().getUserDAO(this.referentielDal);
        this.referentielDal = DAOFactory.getInstance().getReferentielDAO(this.iconDal);
        this.adminDal = DAOFactory.getInstance().getAdminDAO(this.referentielDal);
        try {
            this.scoopDal = DAOFactory.getInstance().getScoopDAO(this.adminDal, this.referentielDal, this.userDal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getZonesRoutiere() {
        return new String[]{"dirif"};
    }

    public boolean estZoneValide(String zone) {
        return GLS.estDansLaListe((String[])this.getZonesRoutiere(), (String)zone);
    }

    public boolean exportation(List<Partenaire> partenairesATraiter) {
        return true;
    }

    public boolean importation(List<Partenaire> partenairesATraiter) {
        try {
            if (!GLS.estVide(partenairesATraiter)) {
                for (Partenaire partenaire : partenairesATraiter) {
                    Log.debug("[" + partenaire.getLibelle() + "]" + "Traitement en cours");
                    GLS.getFichier();
                    if (!Fichier.estUrl((String)partenaire.getRepertoireReception()) && !new File(partenaire.getRepertoireReception()).exists()) {
                        new File(partenaire.getRepertoireReception()).mkdirs();
                    }
                    this.importUtilisateurs(partenaire.getRepertoireReception().concat(FICHIER_IMPORT_UTILISATEUR));
                    this.importVehicules(partenaire.getRepertoireReception().concat(FICHIER_IMPORT_MATERIEL));
                }
            }
        }
        catch (Exception e) {
            Log.error("ERREUR IMPORT IG4", e);
            return false;
        }
        return true;
    }

    public void importUtilisateurs(String fichierCSV) {
        FichierCSV f = null;
        if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
            f = new FichierCSV(fichierCSV, StandardCharsets.UTF_8);
            f.setNbLignesEntete(this.nbLignesEntete);
        } else {
            Log.error("ERREUR fichier impossible \u00e0 ouvrir");
        }
        if (f != null && f.isReady()) {
            Log.info("D\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            int indice = 0;
            try {
                f.setIndiceChampCle(indice);
                f.charger();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            this.scoopDal.supprimerCorrespondances("scoop.corres_utilisateur");
            ArrayList<UserExport> utilisateurs = new ArrayList<UserExport>();
            for (String[] ligne : f.values()) {
                try {
                    utilisateurs.add(this.convertirUtilisateur(ligne));
                }
                catch (Exception e) {
                    Log.error("ERREUR IMPORT UTILISATEUR ", e);
                }
            }
            boolean modif = false;
            for (UserExport u : utilisateurs) {
                this.scoopDal.supprimerCorrespondance("scoop.corres_utilisateur", u.getCode());
                this.scoopDal.ajouterCorrespondance("scoop.corres_utilisateur", u.getCode(), u.getCode(), u.getCodeServiceIg4());
                switch (this.scoopDal.getEtatImportation(u)) {
                    case 0: {
                        String password = this.getPassword(u);
                        String zoneRoutiere = ConfigurationFactory.getInstance().get("zoneroutiere");
                        this.scoopDal.ajouterUtilisateur(u, password, zoneRoutiere);
                        modif = true;
                        break;
                    }
                    case 1: {
                        this.scoopDal.modiferUtilisateur(u);
                        modif = true;
                        break;
                    }
                    case 2: {
                        Log.info("Aucun changement utilisateur " + u.getCode());
                    }
                }
            }
            boolean suppr = this.scoopDal.archiveUtilisateurs();
            if (suppr || modif) {
                this.adminDal.updateDateModificationAdmin("utilisateurs");
            }
        }
    }

    public String getProfil(PrismCentralUser user, String[] ligne) {
        if (ligne.length >= LIGNE_PROFIL && !GLS.estVide((String)ligne[LIGNE_PROFIL]) && this.scoopDal.getCorresProfil().containsKey(GLS.getInt((String)ligne[LIGNE_PROFIL]))) {
            return (String)this.scoopDal.getCorresProfil().get(GLS.getInt((String)ligne[LIGNE_PROFIL]));
        }
        return (String)this.scoopDal.getConfig().get("profil");
    }

    public String getPassword(PrismCentralUser user) {
        return MetierCommun.instanceOf().hashPassword((String)this.scoopDal.getConfig().get("mdp"));
    }

    public void importVehicules(String fichierCSV) {
        FichierCSV f = null;
        if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
            f = new FichierCSV(fichierCSV, StandardCharsets.UTF_8);
        } else {
            Log.error("ERREUR fichier impossible \u00e0 ouvrir");
        }
        if (f != null && f.isReady()) {
            Log.info("D\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            int indice = 0;
            try {
                f.setIndiceChampCle(indice);
                f.charger();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            this.scoopDal.supprimerCorrespondances("scoop.corres_vehicule");
            ArrayList<VehiculeExport> vehicules = new ArrayList<VehiculeExport>();
            for (String[] ligne : f.values()) {
                try {
                    this.scoopDal.verifierMarqueVehicule(ligne);
                    vehicules.add(this.convertirVehicule(ligne));
                }
                catch (Exception e) {
                    Log.error("ERREUR IMPORT VEHICULE ", e);
                }
            }
            boolean modif = false;
            for (VehiculeExport v : vehicules) {
                switch (this.scoopDal.getEtatImportation(v)) {
                    case 0: {
                        this.scoopDal.ajouterVehicule(v);
                        modif = true;
                        break;
                    }
                    case 1: {
                        this.scoopDal.modiferVehicule(v);
                        modif = true;
                        break;
                    }
                    case 2: {
                        Log.info("Aucun changement vehicule " + v.getCode());
                    }
                }
                this.scoopDal.supprimerCorrespondance("scoop.corres_vehicule", v.getCode());
                this.scoopDal.ajouterCorrespondance("scoop.corres_vehicule", v.getCode(), v.getCode(), v.getCodeServiceIg4());
            }
            boolean suppr = this.scoopDal.archiveVehicules();
            if (suppr || modif) {
                this.adminDal.updateDateModificationAdmin("vehicules");
            }
        }
    }

    protected UserExport convertirUtilisateur(String[] ligne) throws Exception {
        UserExport u = new UserExport();
        if (GLS.estVide((String)ligne[LIGNE_CODE])) {
            throw new Exception("UTILISATEUR NON INTEGRE - LE CODE EST NULL " + ligne[LIGNE_NOM]);
        }
        u.setNom(ligne[LIGNE_NOM].concat(" ").concat(ligne[LIGNE_PRENOM]).concat(" (").concat(ligne[LIGNE_CODE]).concat(")"));
        u.setCode(ligne[LIGNE_CODE]);
        Centre centre = null;
        String delegation = null;
        if (!GLS.estVide((String)ligne[LIGNE_UA])) {
            centre = this.getCentreParCode(ligne[LIGNE_UA], this.scoopDal.getCorresDelegationsCentre());
            if (centre == null) {
                throw new Exception("UTILISATEUR NON INTEGRE - LE CENTRE N'EXISTE PAS - " + ligne[LIGNE_UA]);
            }
        } else {
            throw new Exception("UTILISATEUR NON INTEGRE - L'UA N'EXISTE PAS - " + ligne[LIGNE_UA]);
        }
        delegation = centre.getDelegation();
        if (GLS.estVide((String)centre.getNom())) {
            if (GLS.estVide((String)delegation)) {
                u.setCentre(null);
                u.setDelegation(null);
            } else {
                u.setCentre(null);
                u.setDelegation(delegation);
            }
        } else {
            if (GLS.estVide((String)delegation)) {
                throw new Exception("UTILISATEUR NON INTEGRE - LA DELEGATION N'EXISTE PAS EN BASE POUR L'UA - " + ligne[LIGNE_UA]);
            }
            u.setDelegation(delegation);
            u.setCentre(centre.getNom());
        }
        Profil profil = new Profil();
        profil.setName(this.getProfil(u, ligne));
        u.setProfil(profil);
        u.setArchive(false);
        return u;
    }

    private VehiculeExport convertirVehicule(String[] ligne) throws Exception {
        int codeMarque;
        VehiculeExport v = new VehiculeExport();
        v.setImmatriculation(ligne[1]);
        v.setCode(ligne[0]);
        v.setDescription(ligne[2]);
        Centre centre = null;
        String delegation = null;
        if (!GLS.estVide((String)ligne[3])) {
            centre = this.getCentreParCode(ligne[3], this.scoopDal.getCorresDelegationsCentre());
            if (centre == null) {
                throw new Exception("VEHICULE NON INTEGRE - LE CENTRE N'EXISTE PAS - " + ligne[3]);
            }
            delegation = centre.getDelegation();
        }
        if (GLS.estVide((String)centre.getNom())) {
            if (GLS.estVide(delegation)) {
                v.setCentre(null);
                v.setDelegation(null);
            } else {
                v.setCentre(null);
                v.setDelegation(delegation);
            }
        } else {
            if (GLS.estVide(delegation)) {
                throw new Exception("VEHICULE NON INTEGRE - LA DELEGATION N'EXISTE PAS EN BASE POUR LE CENTRE - " + ligne[3]);
            }
            v.setDelegation(delegation);
            v.setCentre(centre.getNom());
        }
        v.setCodeServiceIg4(ligne[3]);
        try {
            codeMarque = this.adminDal.getMarqueVehicule((String)this.scoopDal.getConfig().get("marque_vehicule_defaut"));
        }
        catch (Exception e) {
            Log.error("ERREUR - VEHICULE NON INTEGRE - ERREUR RECUPERATION MARQUE - " + ligne[4], e);
            codeMarque = -1;
        }
        v.setArchive(false);
        if (codeMarque == -1) {
            throw new Exception("ERREUR - VEHICULE NON INTEGRE - LA MARQUE N'EXISTE PAS EN BASE - " + ligne[2]);
        }
        v.setType(codeMarque);
        return v;
    }

    public String getCorresInversee(String valeur, Map<String, String> map) throws Exception {
        if (map.containsValue(valeur)) {
            for (String k : map.keySet()) {
                if (!map.get(k).equals(valeur)) continue;
                return k;
            }
        }
        return null;
    }

    public Centre getCentreParCode(String valeur, Map<String, Centre> map) throws Exception {
        return map.get(valeur);
    }

    public String getCorres(String valeur, Map<String, String> map) throws Exception {
        if (map.containsKey(valeur)) {
            return map.get(valeur);
        }
        return null;
    }

    public boolean exportationV2(List<Partenaire> partenairesATraiter, Date dateDeb, Date dateFin) {
        return false;
    }

    public List<Mission> getMissions(Date dateDeb, Date dateFin) {
        return null;
    }
}

