/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.export.writer.BarreauxWriterXML;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.IAdminDAO;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IExportDAO;
import com.geolocsystems.prismcentral.DAO.IIG4DAO;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IPhotoDAO;
import com.geolocsystems.prismcentral.DAO.IPublicationDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.DatePublication;
import com.geolocsystems.prismcentral.beans.EvenementPublication;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.Synthese;
import com.geolocsystems.prismcentral.data.IPublicationService;
import com.geolocsystems.prismcentral.data.ISuiviActiviteService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jdom2.Content;
import org.jdom2.Element;

public class PublicationServiceDAO
implements IPublicationService {
    private static final long serialVersionUID = 7622227360604202262L;
    private IPublicationDAO publicationDAO;
    private IReferentielDAO referentielDAO;
    private IVehiculeDAO vehiculeDAO;
    private IIconDAO iconDal = DAOFactory.getInstance().getIconDAO();
    private IPhotoDAO photoDao;
    private IAdminDAO adminDAO;
    private IUserDAO userDAO;
    private IMcigDAO mciDAO;
    private IEvenementsDAO evtsDAO;
    private IIG4DAO ig4DAO;
    IExportDAO exportDal;
    static long sauvegardeDateDerniereMaj = GregorianCalendar.getInstance().getTimeInMillis();

    public PublicationServiceDAO() {
        this.referentielDAO = DAOFactory.getInstance().getReferentielDAO(this.iconDal);
        this.userDAO = DAOFactory.getInstance().getUserDAO(this.referentielDAO);
        this.vehiculeDAO = DAOFactory.getInstance().getVehiculeDAO(null);
        this.mciDAO = DAOFactory.getInstance().getMcigDAO(this.referentielDAO, this.vehiculeDAO);
        this.evtsDAO = DAOFactory.getInstance().getEvenementsDAO(this.referentielDAO, this.userDAO, this.mciDAO);
        this.adminDAO = DAOFactory.getInstance().getAdminDAO(this.referentielDAO);
        this.ig4DAO = DAOFactory.getInstance().getIG4DAO(this.adminDAO, this.referentielDAO, this.userDAO, this.evtsDAO, this.mciDAO, this.vehiculeDAO);
        this.publicationDAO = DAOFactory.getInstance().getPublicationDAO(this.referentielDAO, this.vehiculeDAO, this.ig4DAO);
        this.photoDao = DAOFactory.getInstance().getPhotoDAO();
        this.exportDal = DAOFactory.getInstance().getExportDAO();
    }

    public String getDerniereDatePublication() {
        String minute;
        String mois;
        Calendar cal = this.publicationDAO.getDerniereDatePublication();
        String jour = Integer.valueOf(cal.get(5)).toString();
        if (jour.length() < 2) {
            jour = "0" + jour;
        }
        if ((mois = Integer.valueOf(cal.get(2) + 1).toString()).length() < 2) {
            mois = "0" + mois;
        }
        String annee = Integer.valueOf(cal.get(1)).toString();
        String heure = Integer.valueOf(cal.get(11)).toString();
        if (heure.length() < 2) {
            heure = "0" + heure;
        }
        if ((minute = Integer.valueOf(cal.get(12)).toString()).length() < 2) {
            minute = "0" + minute;
        }
        return "Le " + jour + "/" + mois + "/" + annee + " \u00e0 " + heure + ":" + minute;
    }

    public List<EvenementPublication> getEvenementsPubliesEnCours() {
        return this.publicationDAO.getEvenementsPubliesEnCours();
    }

    public List<EvenementPublication> getEvenementsPubliesPrevisonnels() {
        return this.publicationDAO.getEvenementsPubliesPrevisonnels();
    }

    public Calendar getDatePublication() {
        return this.publicationDAO.getDerniereDatePublication();
    }

    public String getCoordonneesEvenementsJSON() {
        return this.publicationDAO.getCoordonneesEvenementsJSON();
    }

    public String getDerniereDatePublicationJSON(DatePublication datePublication) {
        return this.publicationDAO.getDerniereDatePublicationJSON(datePublication);
    }

    public String getDerniereDatePublicationJSON() {
        return this.publicationDAO.getDerniereDatePublicationJSON();
    }

    public String getEvenementsPubliesJSON(String status, String nature) {
        return this.publicationDAO.getEvenementsPubliesJSON(status, nature, null);
    }

    public String getEvenementsPubliesJSON(String status, String nature, String projection) {
        return this.publicationDAO.getEvenementsPubliesJSON(status, nature, projection);
    }

    public String getEvenementsPubliesJSON() {
        return this.publicationDAO.getEvenementsPubliesJSON();
    }

    public Map<String, Object> getConfigurationPublication() {
        return this.publicationDAO.getConfigurationPublication();
    }

    public String getConfigurationJSON() {
        return this.publicationDAO.getConfigurationJSON();
    }

    public void rechargerConfiguration() {
        this.publicationDAO.rechargerConfiguration();
    }

    public String getNaturesJSON() {
        return this.referentielDAO.getNaturesJSON();
    }

    public Extension getConfiguration() {
        return this.referentielDAO.getConfiguration();
    }

    public String getBarreauxJSON(boolean fromPublie) {
        return this.referentielDAO.getBarreauxJSON(fromPublie);
    }

    public String getMessageSyntheseJSON() {
        return this.publicationDAO.getMessageSyntheseJSON();
    }

    public String getMessageAlerteJSON() {
        return this.publicationDAO.getMessageAlerteJSON();
    }

    public String getEvenementsExport(Map m) {
        return this.publicationDAO.getEvenementsExport(m, this.photoDao);
    }

    public String getPositionsExport(Map m) {
        return this.publicationDAO.getPositionsExport(m);
    }

    public String getMissionsExport(ISuiviActiviteService s, Map m) {
        return this.publicationDAO.getMissionsExport(s, m);
    }

    private Vector<BarreauVH> filtrerBarreau(List<BarreauVH> barreaux, Date date) {
        Vector<BarreauVH> barreauxAEnvoyer = new Vector<BarreauVH>();
        for (BarreauVH barreau : barreaux) {
            if (date != null && !barreau.getMajDate().after(date) && !barreau.getMajDateServeur().after(date)) continue;
            barreauxAEnvoyer.add(barreau);
        }
        return barreauxAEnvoyer;
    }

    public String getBarreauxXMLString(String dateString, String formatEchange) {
        Date date;
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyyMMddHHmm");
        try {
            date = formatDate.parse(dateString);
        }
        catch (Exception e) {
            date = null;
        }
        List<BarreauVH> barreaux = this.referentielDAO.getBarreauxVH();
        Log.debug("Nombre de barreaux total: " + barreaux.size());
        Vector<BarreauVH> barreauxAEnvoyer = this.filtrerBarreau(barreaux, date);
        Log.debug("[Barreaux filtr\u00e9s]" + barreauxAEnvoyer.size());
        if (barreauxAEnvoyer.size() > 0) {
            BarreauxWriterXML barreauxWriter;
            Log.debug("Traitement en cours");
            if (!"WS_CD19".equals(formatEchange) && (barreauxWriter = this.exportationBarreauxWriterXML(barreauxAEnvoyer, formatEchange)) != null) {
                return barreauxWriter.getXmlString();
            }
        }
        Log.debug("Traitement termin\u00e9");
        return null;
    }

    public BarreauxWriterXML exportationBarreauxWriterXML(Vector<BarreauVH> barreauxAEnvoyer, String formatEchange) {
        BarreauxWriterXML barreauxWriter = null;
        Log.debug("Traitement en cours");
        if (barreauxAEnvoyer.size() > 0) {
            if ("XML_SERPEVH".equals(formatEchange)) {
                boolean selectionBarreauxParDelegation = false;
                try {
                    selectionBarreauxParDelegation = ConfigurationFactory.getInstance().getBoolean("vh.barreauxvh.delegation", true);
                }
                catch (Exception e) {
                    selectionBarreauxParDelegation = true;
                }
                Synthese synthese = this.referentielDAO.getSyntheseVH(ConfigurationFactory.getInstance().get("zoneroutiere"));
                barreauxWriter = new BarreauxWriterXML();
                Element racine = barreauxWriter.genererXMLSerpeVH();
                String nomZone = null;
                try {
                    nomZone = ConfigurationFactory.getInstance().get("zoneroutiere.serpevh", true);
                }
                catch (Exception e) {
                    nomZone = ConfigurationFactory.getInstance().get("zoneroutiere");
                }
                Element dir = barreauxWriter.genererXMLDirSerpeVH(nomZone, synthese.getCommentaire());
                racine.addContent((Content)dir);
                Log.debug("transmettreBarreauxSerpeVH : Envoi des barreaux \u00e0 TIPI VH " + selectionBarreauxParDelegation);
                List<Delegation> listeDelegations = this.referentielDAO.getDelegationsActives();
                for (Delegation delegation : listeDelegations) {
                    ArrayList<Object> listeBarreauxMaj;
                    if (selectionBarreauxParDelegation) {
                        listeBarreauxMaj = new ArrayList<BarreauVH>();
                        for (BarreauVH barreauVH : barreauxAEnvoyer) {
                            if (!delegation.getNom().equals(barreauVH.getDelegation())) continue;
                            listeBarreauxMaj.add(barreauVH);
                        }
                        if (listeBarreauxMaj.size() <= 0) continue;
                        dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(delegation.getNom(), listeBarreauxMaj));
                        continue;
                    }
                    if (delegation.getCentres() == null || delegation.getCentres().size() <= 0) continue;
                    for (Centre centre : delegation.getCentres()) {
                        listeBarreauxMaj = new ArrayList();
                        for (BarreauVH barreauVH : barreauxAEnvoyer) {
                            if (!centre.getNom().equals(barreauVH.getCentre())) continue;
                            listeBarreauxMaj.add(barreauVH);
                        }
                        if (listeBarreauxMaj.size() <= 0) continue;
                        dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(centre.getNom(), listeBarreauxMaj));
                    }
                }
            } else {
                barreauxWriter = new BarreauxWriterXML();
                barreauxWriter.genererXML(barreauxAEnvoyer);
            }
        }
        Log.debug("Traitement termin\u00e9");
        return barreauxWriter;
    }

    public void depublierTousEvenementsExternes() {
        this.publicationDAO.depublierTousEvenementsExternes();
    }

    public void depublierEvenementExterne(EvenementPublication evenement) {
        this.publicationDAO.depublierEvenementExterne(evenement);
    }

    public void publierEvenementExterne(EvenementPublication evenement) {
        this.publicationDAO.publierEvenementExterne(evenement);
    }

    public void verifierReferentielMaj() {
        try {
            long dateDerniereMaj = this.referentielDAO.getDerniereDateMajDonneesMetiers();
            Log.debug("V\u00e9rification de la mise \u00e0 jour du r\u00e9f\u00e9rentiel sauvegarde " + sauvegardeDateDerniereMaj + " -- derniere date " + dateDerniereMaj);
            if (sauvegardeDateDerniereMaj < dateDerniereMaj) {
                Log.debug("Mise \u00e0 jour du r\u00e9f\u00e9rentiel sauvegard\u00e9 ...");
                this.referentielDAO.update();
                this.exportDal.update();
                this.referentielDAO.getConfiguration();
                this.referentielDAO.getNatureMap();
                Log.debug("Mise \u00e0 jour du r\u00e9f\u00e9rentiel sauvegard\u00e9 termin\u00e9");
                sauvegardeDateDerniereMaj = dateDerniereMaj;
            }
        }
        catch (Exception e) {
            Log.error("Erreur controle m\u00e0j r\u00e9f\u00e9rentiel", e);
        }
    }
}

