/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.InfoTerritoire;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.IDescription;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.EvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.service.ImportEvenementService;
import fr.geo.convert.Lambert93;
import fr.geo.convert.WGS84;
import gls.geometry.GeoPoint;
import gls.outils.GLS;
import gls.outils.Util;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCSV;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportEvenementGenerique
extends ImportEvenementService {
    private static final long serialVersionUID = 2221315414473308558L;
    private Map<String, Integer> mapEntete = new HashMap<String, Integer>();
    private List<Integer> champsNonSystemes = new ArrayList<Integer>();
    private String[] entete;
    private static final String CODE_MCIG_UTILISATEUR_SYSTEM = "#PRISM#";
    private static final String CODE_UTILISATEUR_SYSTEM = "#PRISM#";
    public static final String CHAMP_CLE = "CLE";
    public static final String CHAMP_NATURE = "NATURE";
    public static final String CHAMP_DESCRIPTION = "DESCRIPTION";
    public static final String CHAMP_DATE_DEBUT = "DATE_DEBUT";
    public static final String CHAMP_DATE_FIN = "DATE_FIN";
    public static final String CHAMP_DATE_MAJ = "DATE_MAJ";
    public static final String CHAMP_AXE = "AXE";
    public static final String CHAMP_COMMUNE = "COMMUNE";
    public static final String CHAMP_PRDEB = "PR_DEBUT";
    public static final String CHAMP_ABSPRDEB = "ABS_PR_DEBUT";
    public static final String CHAMP_PRFIN = "PR_FIN";
    public static final String CHAMP_ABSPRFIN = "ABS_PR_FIN";
    public static final String CHAMP_X = "X";
    public static final String CHAMP_Y = "Y";
    public static final String CHAMP_PROJECTION = "PROJ";
    public static final String CHAMP_PROJECTION_L93 = "L93";
    public static final String CHAMP_PROJECTION_WGS84 = "WGS84";
    public static final String CHAMP_PROJECTION_UTM30 = "UTM30";
    public static final String[] CHAMPS_SYSTEMES = new String[]{"CLE", "NATURE", "COMMUNE", "DESCRIPTION", "DATE_DEBUT", "DATE_FIN", "X", "Y", "PROJ", "PR_DEBUT", "ABS_PR_DEBUT", "PR_FIN", "ABS_PR_FIN"};

    public static boolean estChampSysteme(String champ) {
        return MetierCommun.estDedans((String[])CHAMPS_SYSTEMES, (Object)champ);
    }

    @Override
    public String[] getZonesRoutiere() {
        return new String[]{"neogls", "direst"};
    }

    @Override
    public boolean estZoneValide(String zone) {
        return GLS.estDansLaListe((String[])this.getZonesRoutiere(), (String)zone);
    }

    @Override
    public boolean importEvenementsFichier(String fichierCSV) {
        this.timeStart = Calendar.getInstance().getTimeInMillis();
        FichierCSV f = null;
        if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
            f = new FichierCSV(fichierCSV);
            f.setNbLignesEntete(0);
        } else {
            Log.error("ERREUR fichier impossible \u00e0 ouvrir");
        }
        if (f != null && f.isReady()) {
            Log.info("D\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            this.champsNonSystemes.clear();
            boolean indice = false;
            try {
                this.entete = f.lire();
                int i = 0;
                while (i < this.entete.length) {
                    String champ = this.entete[i];
                    if (!GLS.estVide((String)champ)) {
                        this.mapEntete.put(champ, i);
                        if (!ImportEvenementGenerique.estChampSysteme(champ)) {
                            this.champsNonSystemes.add(i);
                        }
                    }
                    ++i;
                }
                f.setIndiceChampCle(this.mapEntete.get(CHAMP_CLE).intValue());
                f.charger();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            ArrayList<Evenement> evenements = new ArrayList<Evenement>();
            for (String[] ligne : f.values()) {
                if (this.estLigneValide(ligne)) {
                    try {
                        evenements.add(this.ligneToEvenement(ligne));
                    }
                    catch (Exception e) {
                        Log.error("ERREUR IMPORT EVENEMENT " + ligne[0] + " " + e.getMessage());
                    }
                    continue;
                }
                Log.debug("LIGNE NON INTEGREE " + ligne);
            }
            if (evenements.size() > 0) {
                this.sauvegarder(evenements);
                return true;
            }
        } else {
            this.entete = null;
        }
        return false;
    }

    @Override
    protected Nature getNatureEvenement(String[] ligne) {
        return (Nature)this.service.getNatures().get(ligne[this.mapEntete.get(CHAMP_NATURE)]);
    }

    private String getValeurChamp(String champ, String[] ligne) {
        return this.getValeurChamp(champ, ligne, "");
    }

    private String getValeurChamp(String champ, String[] ligne, String defaut) {
        if (this.mapEntete.containsKey(champ)) {
            return ligne[this.mapEntete.get(champ)];
        }
        return defaut;
    }

    private boolean estLocalisableParAxePr() {
        return this.mapEntete.containsKey(CHAMP_AXE) && this.mapEntete.containsKey(CHAMP_PRDEB);
    }

    private boolean estLocalisableParXY() {
        return this.mapEntete.containsKey(CHAMP_X) && this.mapEntete.containsKey(CHAMP_Y);
    }

    @Override
    public Evenement ligneToEvenement(String[] ligne) throws Exception {
        Evenement evenement = new Evenement();
        Nature n = (Nature)DeepCopy.copy((Object)this.getNatureEvenement(ligne));
        this.majEvenement(n, ligne);
        evenement.setValeurNature(n.extraireValeurs());
        ValeurChampCollectionChoixUnique d = evenement.getValeurNature().getDescription();
        ValeurChampLocalisation l = evenement.getValeurNature().getLocalisation();
        List listeDesc = (List)this.service.getDescriptionsNatureMap().get(n.getCode());
        String description = ligne[this.mapEntete.get(CHAMP_DESCRIPTION)];
        int iDesc = MetierCommun.getIndiceObjetListe((List)listeDesc, (Object)description);
        if (iDesc <= -1) {
            Log.error("erreur description nature impossible \u00e0 trouver " + ligne[this.mapEntete.get(CHAMP_DESCRIPTION)]);
            throw new RuntimeException();
        }
        IDescription desc = (IDescription)listeDesc.get(iDesc);
        d.setIndexSelectionnee(iDesc);
        d.setValeur(desc.getLibelle());
        evenement.setCodeUtilisateur(this.getCodeUtilisateur());
        evenement.setAnnule(false);
        evenement.setTermine(false);
        if (this.mapEntete.containsKey(CHAMP_DATE_DEBUT)) {
            evenement.setDateCreation(this.getDateFormat().parse(this.getValeurChamp(CHAMP_DATE_DEBUT, ligne)).getTime());
        } else {
            evenement.setDateCreation(Calendar.getInstance().getTimeInMillis());
        }
        evenement.setDateMaj(Calendar.getInstance().getTimeInMillis());
        if (this.mapEntete.containsKey(CHAMP_DATE_FIN)) {
            evenement.setDateFin(this.getDateFormat().parse(this.getValeurChamp(CHAMP_DATE_FIN, ligne)).getTime());
        } else {
            evenement.setDateFin(Calendar.getInstance().getTimeInMillis());
        }
        String champCle = this.getValeurChamp(CHAMP_CLE, ligne);
        if (!GLS.estVide((String)champCle)) {
            evenement.setIdSituation("SIT".concat(this.getValeurChamp(CHAMP_CLE, ligne)));
            evenement.setIdReference("REF".concat(this.getValeurChamp(CHAMP_CLE, ligne)));
            evenement.setCodeEvenement("K".concat(this.getValeurChamp(CHAMP_CLE, ligne)));
        } else {
            evenement.setIdSituation(GLS.genererNumeroUnique((String)"SIT"));
            evenement.setIdReference(GLS.genererNumeroUnique((String)"REF"));
            evenement.setCodeEvenement(GLS.genererNumeroUnique((String)"K"));
        }
        evenement.setNumVersion(1);
        if (this.estLocalisableParAxePr()) {
            l.setAxe(this.getValeurChamp(CHAMP_AXE, ligne));
            l.setCommune(this.getValeurChamp(CHAMP_COMMUNE, ligne));
            l.setPrDebut(GLS.getInt((String)this.getValeurChamp(CHAMP_PRDEB, ligne)));
            l.setAbsPrDebut(GLS.getInt((String)this.getValeurChamp(CHAMP_ABSPRDEB, ligne)));
            if (Util.isNullOrEmpty((String)this.getValeurChamp(CHAMP_PRFIN, ligne)) || Util.isNullOrEmpty((String)this.getValeurChamp(CHAMP_ABSPRFIN, ligne))) {
                l.setPrFin(-1);
                l.setAbsPrFin(-1);
            } else {
                l.setPrFin(GLS.getInt((String)this.getValeurChamp(CHAMP_PRFIN, ligne)));
                l.setAbsPrFin(GLS.getInt((String)this.getValeurChamp(CHAMP_ABSPRFIN, ligne)));
            }
        } else if (this.estLocalisableParXY()) {
            float x = (float)GLS.getDouble((String)this.getValeurChamp(CHAMP_X, ligne));
            float y = (float)GLS.getDouble((String)this.getValeurChamp(CHAMP_Y, ligne));
            String projection = this.getValeurChamp(CHAMP_PROJECTION, ligne, CHAMP_PROJECTION_UTM30);
            if (GLS.egal((String)projection, (String)CHAMP_PROJECTION_L93)) {
                Lambert93 l3 = new Lambert93((double)x, (double)y, 0.0);
                WGS84 wgs84 = l3.toWGS84();
                GeoPoint px = new GeoPoint(wgs84.longitude(), wgs84.latitude());
                x = (float)px.getX();
                y = (float)px.getY();
            }
            Position pointDebut = new Position();
            pointDebut.setX(x);
            pointDebut.setY(y);
            l.setPositionDebut(pointDebut);
        }
        return evenement;
    }

    @Override
    protected String getCodeUtilisateur() {
        return "#PRISM#";
    }

    @Override
    public void sauvegarder(List<Evenement> listeEvts) {
        Log.debug("Debut");
        try {
            if (listeEvts != null && listeEvts.size() > 0) {
                MainCourante mc = MetierCommun.genereMainCourante((String)"#PRISM#", (String)this.getCodeUtilisateur());
                PrismCentralUser utilisateur = this.service.rechercheUtilisateurParLogin(this.getCodeUtilisateur());
                this.service.verificationMainCourante(utilisateur, mc, 0);
                for (Evenement evenementTemp : listeEvts) {
                    this.sauvegarder(evenementTemp, utilisateur, mc);
                }
                this.service.deconnexion(mc);
            } else {
                Log.debug("Pas d'\u00e9v\u00e9nement \u00e0 synchroniser");
            }
        }
        catch (Exception e) {
            Log.error("Ev\u00e9nement non cr\u00e9\u00e9", e);
        }
    }

    @Override
    public void sauvegarder(Evenement evenement, PrismCentralUser utilisateur, MainCourante mc) {
        try {
            EvenementASauvegarder eas = null;
            evenement.setMainCourante(mc);
            eas = (EvenementASauvegarder)EvenementASauvegarder.aSauvegarder((Evenement)evenement, null, null, (boolean)this.config.getBoolean("envoyerParMail", true), (boolean)false, (boolean)true, (boolean)true);
            InfoTerritoire info = new InfoTerritoire();
            info.setCentre(evenement.getCei());
            info.setDelegation(evenement.getDistrict());
            eas.setInfoTerritoire(info);
            this.traitementEvenement(eas);
        }
        catch (Exception e) {
            Log.error("Erreur lors de la synchronisation ", e);
        }
    }

    protected void majEvenement(Nature n, String[] ligne) {
        Map mapChamps = MetierCommun.getChamps((Nature)n);
        for (int i : this.champsNonSystemes) {
            String valeurChamp = ligne[i];
            String champ = this.entete[i];
            try {
                Champ c = (Champ)mapChamps.get(champ);
                c.setValeurChamp(c.parseValeur(valeurChamp));
            }
            catch (Exception e) {
                Log.error("ERR CHAMP MAJ ", e);
            }
        }
    }
}

