/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampDateHeure;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.service.ImportEvenementService;
import gls.outils.GLS;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImportEvenementCD22Service
extends ImportEvenementService {
    private static final Logger LOGGER = Logger.getLogger(ImportEvenementCD22Service.class);
    private static final long serialVersionUID = -4071873117796838664L;
    protected static int LIGNE_TYPECIRCULATION = 10;
    protected static int LIGNE_MESUREEXPLOIT1 = 11;
    protected static int LIGNE_MESUREEXPLOIT2 = 12;
    protected static String TYPE_CIRCULATION = "typeCirculation";
    protected static String MESURES_EXPLOITATION = "mesuresExploitation";
    protected static String IDARRETE = "idArrete";
    protected static String STO = "sto";
    protected static String STA = "sta";
    protected Map<String, String> corresTypeCirculation;
    protected Map<String, String> corresMesuresExploitation;

    public ImportEvenementCD22Service() {
        this.nbLignesEntete = 0;
    }

    @Override
    protected void init() {
        super.init();
        this.corresTypeCirculation = this.importEvenementDal.getCorrespondance("typeCirculation");
        if (this.corresTypeCirculation == null) {
            this.corresTypeCirculation = new HashMap<String, String>();
        }
        this.corresMesuresExploitation = this.importEvenementDal.getCorrespondance("mesuresExploitation");
        if (this.corresMesuresExploitation == null) {
            this.corresMesuresExploitation = new HashMap<String, String>();
        }
    }

    @Override
    public String[] getZonesRoutiere() {
        return new String[]{"cd22"};
    }

    @Override
    public boolean estZoneValide(String zone) {
        return GLS.estDansLaListe((String[])this.getZonesRoutiere(), (String)zone);
    }

    @Override
    public Evenement ligneToEvenement(String[] ligneInit) throws Exception {
        return super.ligneToEvenement(ligneInit);
    }

    @Override
    protected String[] getListeChampsMaj() {
        String[] champs = new String[]{TYPE_CIRCULATION, MESURES_EXPLOITATION, STA, STO};
        return champs;
    }

    @Override
    protected void cloturerEvenements(MainCourante mc, HashSet<String> evtMaj) {
        IBusinessService.EvenementFiltre filtreSql2 = IBusinessService.EvenementFiltre.getVersionActive(null, null);
        ArrayList<String> nautres = new ArrayList<String>();
        nautres.add("chan");
        filtreSql2.nature = nautres;
        filtreSql2.annules = 0;
        filtreSql2.termines = 0;
        List listeSituation2 = this.service.getEvenements(filtreSql2, null);
        for (Situation situation : listeSituation2) {
            for (Evenement evtTemp : situation.getEvenements()) {
                try {
                    ValeurChampTexte v = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evtTemp.getValeurNature().getValeurs(), (String)IDARRETE);
                    if (GLS.estVide((String)v.getValeur()) || evtMaj.contains(evtTemp.getIdReference())) continue;
                    this.cloturerEvenement(mc, evtTemp);
                }
                catch (Exception e) {
                    LOGGER.error((Object)IDARRETE, (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void majEvenement(Nature n, Evenement evenement, String[] ligne) {
        int i;
        String[] valeurs;
        GregorianCalendar cal;
        ValeurChampTexte v;
        try {
            v = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)IDARRETE);
            v.setValeur(evenement.getIdReference());
        }
        catch (Exception e) {
            LOGGER.error((Object)IDARRETE, (Throwable)e);
        }
        try {
            v = (ValeurChampDateHeure)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)STA);
            cal = new GregorianCalendar();
            cal.setTimeInMillis(evenement.getDateCreation());
            v.setAnnee(cal.get(1));
            v.setMois(cal.get(2));
            v.setJour(cal.get(5));
            v.setHeure(cal.get(11));
            v.setMinute(cal.get(12));
            v.setChecked(true);
        }
        catch (Exception e) {
            LOGGER.error((Object)STA, (Throwable)e);
        }
        try {
            v = (ValeurChampDateHeure)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)STO);
            cal = new GregorianCalendar();
            cal.setTimeInMillis(evenement.getDateFin());
            v.setAnnee(cal.get(1));
            v.setMois(cal.get(2));
            v.setJour(cal.get(5));
            v.setHeure(cal.get(11));
            v.setMinute(cal.get(12));
            v.setChecked(true);
        }
        catch (Exception e) {
            LOGGER.error((Object)STO, (Throwable)e);
        }
        String valeur = ligne[LIGNE_TYPECIRCULATION];
        if (!GLS.estVide((String)valeur)) {
            String typeCirculation = this.corresTypeCirculation.get(valeur);
            if (typeCirculation == null) {
                typeCirculation = valeur;
            }
            try {
                ValeurChampCollectionChoixUnique v2 = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)TYPE_CIRCULATION);
                ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), TYPE_CIRCULATION);
                v2.setValeur(typeCirculation);
                int iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v2.getValeur());
                if (iDesc > -1) {
                    v2.setIndexSelectionnee(iDesc);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)TYPE_CIRCULATION, (Throwable)e);
            }
        }
        valeur = ligne[LIGNE_MESUREEXPLOIT1];
        HashSet<String> listeValeurs = new HashSet<String>();
        String valeurUnique = null;
        if (!GLS.estVide((String)valeur)) {
            valeurs = valeur.split("\\b( \\| )\\b");
            i = 0;
            while (i < valeurs.length) {
                if (this.corresMesuresExploitation.get(valeurs[i]) != null) {
                    listeValeurs.add(this.corresMesuresExploitation.get(valeurs[i]));
                    valeurUnique = this.corresMesuresExploitation.get(valeurs[i]);
                } else {
                    listeValeurs.add(valeurs[i]);
                }
                ++i;
            }
        }
        if (!GLS.estVide((String)(valeur = ligne[LIGNE_MESUREEXPLOIT2]))) {
            valeurs = valeur.split("\\b( +\\| )\\b");
            i = 0;
            while (i < valeurs.length) {
                if (this.corresMesuresExploitation.get(valeurs[i]) != null) {
                    listeValeurs.add(this.corresMesuresExploitation.get(valeurs[i]));
                    valeurUnique = this.corresMesuresExploitation.get(valeurs[i]);
                } else {
                    listeValeurs.add(valeurs[i]);
                }
                ++i;
            }
        }
        if (listeValeurs != null) {
            try {
                ValeurChampCollectionChoixUnique v3 = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)MESURES_EXPLOITATION);
                ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), MESURES_EXPLOITATION);
                v3.setValeur(valeurUnique);
                int iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v3.getValeur());
                if (iDesc > -1) {
                    v3.setIndexSelectionnee(iDesc);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)MESURES_EXPLOITATION, (Throwable)e);
            }
        }
    }
}

