/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.InfoTerritoire;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BgBDDConfig;
import com.geolocsystems.prismcentral.beans.EvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.service.ImportEvenementService;
import commun.UnPoint;
import gls.geometry.GeoPoint;
import gls.localisation.recherche.Recherche;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCSV;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImportEvenementBG
extends ImportEvenementService {
    private static final Logger LOGGER = Logger.getLogger(ImportEvenementBG.class);
    public static final String TYPE_IMPORT_CSV = "csv";
    public static final String TYPE_IMPORT_WEBSERVICE = "webservice";
    public static final String TYPE_IMPORT_BDD = "bdd";
    protected Map<String, String> corresCentre;
    protected List<BgBDDConfig> configBgBdd;
    private static final long serialVersionUID = -4071873117796838664L;

    public ImportEvenementBG() {
        this.nbLignesEntete = 0;
    }

    @Override
    protected void init() {
        super.init();
        this.corresCentre = this.importEvenementDal.getCorrespondance("centre");
        this.configBgBdd = this.importEvenementDal.getCorresBgBDDConfig();
        if (this.corresCentre == null) {
            this.corresCentre = new HashMap<String, String>();
        }
        if (this.configBgBdd == null) {
            this.configBgBdd = new ArrayList<BgBDDConfig>();
        }
    }

    @Override
    public String[] getZonesRoutiere() {
        return new String[]{"cd40"};
    }

    @Override
    protected String getCodeUtilisateur() {
        return "#BG";
    }

    @Override
    protected Nature getNatureEvenement(String[] ligne) {
        return this.service.getNatureFromDescription((String)this.corresDescriptions.get(ligne[LIGNE_DESCRIPTION]));
    }

    protected Nature getNatureEvenement(String codeDescription) {
        return this.service.getNatureFromDescription(codeDescription);
    }

    @Override
    protected boolean estLigneValide(String[] ligne) {
        return ligne != null && ligne.length >= 6;
    }

    @Override
    protected SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    }

    @Override
    public Evenement ligneToEvenement(String[] ligne) throws Exception {
        return null;
    }

    @Override
    protected String[] getListeChampsMaj() {
        return null;
    }

    @Override
    protected void cloturerEvenements(MainCourante mc, HashSet<String> evtMaj) {
        IBusinessService.EvenementFiltre filtreSql2 = IBusinessService.EvenementFiltre.getVersionActive(null, null);
        ArrayList<String> nautres = new ArrayList<String>();
        nautres.add("chan");
        filtreSql2.nature = nautres;
        filtreSql2.annules = 0;
        filtreSql2.termines = 0;
        List listeSituation2 = this.service.getEvenements(filtreSql2, null);
        for (Situation situation : listeSituation2) {
            for (Evenement evtTemp : situation.getEvenements()) {
                try {
                    ValeurChampTexte v = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evtTemp.getValeurNature().getValeurs(), (String)"");
                    if (GLS.estVide((String)v.getValeur()) || evtMaj.contains(evtTemp.getIdReference())) continue;
                    this.cloturerEvenement(mc, evtTemp);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean importation(List<Partenaire> partenairesATraiter) {
        try {
            if (!GLS.estVide(partenairesATraiter)) {
                for (Partenaire partenaire : partenairesATraiter) {
                    Log.debug("[" + partenaire.getLibelle() + "]" + "Traitement en cours");
                    long prochaineSynchro = System.currentTimeMillis();
                    long derniereSynchro = 0L;
                    derniereSynchro = partenaire.getDernierTransfert() != null ? partenaire.getDernierTransfert().getTime() : 0L;
                    if (!partenaire.isTypeEchangeBDD()) continue;
                    this.importEvenementsBDD(this.getConnexion(partenaire), derniereSynchro);
                    this.miseAJourPartenaire(partenaire, prochaineSynchro);
                }
            }
        }
        catch (Exception e) {
            Log.error("ERREUR IMPORT EVTS BG", e);
            return false;
        }
        return true;
    }

    protected void miseAJourPartenaire(Partenaire p, long prochaineSynchro) {
        this.service.miseAjourPartenaire(p, new Date(prochaineSynchro));
    }

    public void importEvenementsBDD(Connection connection, long derniereSynchro) {
        ArrayList<Evenement> evenements = new ArrayList<Evenement>();
        if (connection != null) {
            for (BgBDDConfig conf : this.configBgBdd) {
                evenements.addAll(this.importEvenementDal.getEvenements(connection, conf, derniereSynchro));
            }
        }
        if (!GLS.estVide(evenements)) {
            MainCourante mc = MetierCommun.genereMainCourante((String)"#BG", (String)"#BG");
            PrismCentralUser utilisateurUsager = this.service.rechercheUtilisateurParLogin(this.getCodeUtilisateur());
            this.service.verificationMainCourante(utilisateurUsager, mc, 0);
            for (Evenement evenement : evenements) {
                try {
                    PrismCentralUser utilisateur = this.service.rechercheUtilisateurParLogin(evenement.getCodeUtilisateur());
                    this.sauvegarder(evenement, utilisateur, mc);
                }
                catch (Exception e) {
                    Log.error("ERREUR INTEGRATION EVT BG " + evenement.getCodeEvenement(), e);
                }
            }
        }
    }

    @Override
    public boolean importEvenementsFichier(String fichierCSV) {
        this.timeStart = Calendar.getInstance().getTimeInMillis();
        FichierCSV f = null;
        if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
            f = new FichierCSV(fichierCSV);
            f.setNbLignesEntete(this.nbLignesEntete);
        } else {
            Log.error("ERREUR fichier impossible \u00e0 ouvrir");
        }
        if (f != null && f.isReady()) {
            Log.info("D\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            int indice = 0;
            try {
                f.setIndiceChampCle(indice);
                f.charger();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            MainCourante mc = MetierCommun.genereMainCourante((String)"#USAGERS", (String)"#USAGERS");
            PrismCentralUser utilisateurUsager = this.service.rechercheUtilisateurParLogin(this.getCodeUtilisateur());
            this.service.verificationMainCourante(utilisateurUsager, mc, 0);
            for (String[] ligne : f.values()) {
                if (this.estLigneValide(ligne)) {
                    try {
                        Evenement evenement = this.ligneToEvenement(ligne);
                        PrismCentralUser utilisateur = this.service.rechercheUtilisateurParLogin(evenement.getCodeUtilisateur());
                        this.sauvegarder(evenement, utilisateur, mc);
                    }
                    catch (Exception e) {
                        Log.error("ERREUR IMPORT EVENEMENT " + ligne[0] + " " + e.getMessage(), e);
                    }
                    continue;
                }
                Log.debug("LIGNE NON INTEGREE " + ligne);
            }
            return true;
        }
        return false;
    }

    @Override
    public void sauvegarder(List<Evenement> listeEvts) {
        LOGGER.debug((Object)"Debut");
        try {
            if (listeEvts != null && listeEvts.size() > 0) {
                MainCourante mc = MetierCommun.genereMainCourante((String)"#USAGERS", (String)"#USAGERS");
                PrismCentralUser utilisateurUsager = this.service.rechercheUtilisateurParLogin(this.getCodeUtilisateur());
                this.service.verificationMainCourante(utilisateurUsager, mc, 0);
                for (Evenement evenementTemp : listeEvts) {
                    PrismCentralUser utilisateur = this.service.rechercheUtilisateurParLogin(evenementTemp.getCodeUtilisateur());
                    if (!evenementTemp.getLocalisation().isAccrochage()) {
                        GeoPoint geoPoint;
                        ValeurChampLocalisation l = evenementTemp.getLocalisation();
                        evenementTemp.setEtat(2);
                        if (l.getPositionDebut() != null) {
                            geoPoint = new GeoPoint(l.getPositionFin().getX(), l.getPositionFin().getY()).toUTM();
                        }
                        if (l.getPositionFin() != null) {
                            geoPoint = new GeoPoint(l.getPositionFin().getX(), l.getPositionFin().getY()).toUTM();
                        }
                    }
                    this.sauvegarder(evenementTemp, utilisateur, mc);
                }
                this.service.deconnexion(mc);
            } else {
                LOGGER.debug((Object)"Pas d'\u00e9v\u00e9nement \u00e0 synchroniser");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Ev\u00e9nement non cr\u00e9\u00e9", (Throwable)e);
        }
    }

    @Override
    public void sauvegarder(Evenement evenement, PrismCentralUser utilisateur, MainCourante mc) {
        try {
            EvenementASauvegarder eas = null;
            evenement.setMainCourante(mc);
            eas = (EvenementASauvegarder)EvenementASauvegarder.aSauvegarder((Evenement)evenement, null, null, (boolean)this.config.getBoolean("envoyerParMail", true), (boolean)false, (boolean)true, (boolean)true);
            InfoTerritoire info = new InfoTerritoire();
            info.setCentre(evenement.getCei());
            info.setDelegation(evenement.getDistrict());
            if (!evenement.getLocalisation().isAccrochage()) {
                evenement.setEtat(2);
            }
            if (GLS.estVide((String)evenement.getLocalisation().getCommune())) {
                UnPoint p = new UnPoint(evenement.getLocalisation().getPositionDebut().getX(), evenement.getLocalisation().getPositionDebut().getY());
                p = p.toUTM(this.referentielDal.getConfiguration().getInt("zoneUTM", 30));
                String[] communes = this.getCartoService().getListeCommune();
                evenement.getLocalisation().setCommune(Recherche.rechercherPremiereCommune((float)p.x, (float)p.y));
            }
            eas.setInfoTerritoire(info);
            this.traitementEvenement(eas);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur lors de la synchronisation ", (Throwable)e);
        }
    }

    protected void importEvenementsWebService(String url) {
    }
}

