/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.prismandroid.IFiltreFauchage;
import com.geolocsystems.prismandroid.IFiltreReleve;
import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.beans.MCIG;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.BarreauVHExport;
import com.geolocsystems.prismcentral.export.FauchageExport;
import com.geolocsystems.prismcentral.export.FicheTravailExport;
import com.geolocsystems.prismcentral.export.McigExport;
import com.geolocsystems.prismcentral.export.ReleveExport;
import com.geolocsystems.prismcentral.export.SituationExport;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExportService
implements IExportService {
    McigExport mcigExport;
    SituationExport situationExport;
    FauchageExport fauchageExport;
    ReleveExport releveExport;
    FicheTravailExport ficheTravailExport;
    BarreauVHExport barreauVhExport;
    IBusinessService service;

    public ExportService(IBusinessService service) {
        this.service = service;
        this.mcigExport = new McigExport();
        this.situationExport = new SituationExport(service);
        this.fauchageExport = new FauchageExport();
        this.releveExport = new ReleveExport();
        this.ficheTravailExport = new FicheTravailExport(service);
        this.barreauVhExport = new BarreauVHExport();
    }

    public InputStream exportMCIG(List<MCIG> list, String format) {
        return this.mcigExport.export(list, format);
    }

    public InputStream exportFauchage(List<IFiltreFauchage> filtresFauchage, String format) {
        return this.fauchageExport.export(filtresFauchage, format);
    }

    public InputStream exportSituation(Object list, String format, PrismCentralUser user, List<String[]> criteres, String typeExport, Map<String, Object> parametres, String document) {
        return this.situationExport.export(list, format, user, criteres, typeExport, parametres, document);
    }

    public List<String> getMCIGExportFormat() {
        return this.mcigExport.getExportFormat();
    }

    public List<String> getFauchageExportFormat() {
        return this.fauchageExport.getExportFormat();
    }

    public InputStream exportFicheTravail(List<Integer> list, Map<String, Object> parametres, String format) {
        return this.ficheTravailExport.export(list, parametres, format);
    }

    public InputStream exportReleve(List<IFiltreReleve> list, String format) {
        return this.releveExport.export(list, format);
    }

    public InputStream exportBarreauVHHisto(List<BarreauVHHisto> listPourExport, String format, Map<String, Object> parameters, String delegation, String centre, Date dateDebut, Date dateFin, HashMap<String, String> mapNomsCircuits) {
        return this.barreauVhExport.export(listPourExport, format, parameters, delegation, centre, dateDebut, dateFin, mapNomsCircuits);
    }
}

