/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.eq2r.DefinitionCritere;
import com.geolocsystems.eq2r.TronconEq2r;
import com.geolocsystems.export.FileFilterBarreau;
import com.geolocsystems.export.reader.BarreauxReaderXML;
import com.geolocsystems.export.transfertFtp.FTPClientExample;
import com.geolocsystems.export.writer.BarreauxWriterXML;
import com.geolocsystems.export.writer.EvtWriterXML;
import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ActionCentral;
import com.geolocsystems.prismandroid.model.Activite;
import com.geolocsystems.prismandroid.model.Bounds;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.CircuitExploitation;
import com.geolocsystems.prismandroid.model.Commentaire;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.Direction;
import com.geolocsystems.prismandroid.model.DonneesSynchro;
import com.geolocsystems.prismandroid.model.FauchageCircuitPasse;
import com.geolocsystems.prismandroid.model.FauchageExploitation;
import com.geolocsystems.prismandroid.model.FauchagePasse;
import com.geolocsystems.prismandroid.model.FauchagePasseType;
import com.geolocsystems.prismandroid.model.IUtilisateur;
import com.geolocsystems.prismandroid.model.InfoTerritoire;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.NiveauExploitation;
import com.geolocsystems.prismandroid.model.Parametre;
import com.geolocsystems.prismandroid.model.ParametrePatrouille;
import com.geolocsystems.prismandroid.model.Patrouille;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.PrismAction;
import com.geolocsystems.prismandroid.model.Releve;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.TronconFauchage;
import com.geolocsystems.prismandroid.model.TronconStats;
import com.geolocsystems.prismandroid.model.TypeUtilisateur;
import com.geolocsystems.prismandroid.model.Ua;
import com.geolocsystems.prismandroid.model.Utilisateur;
import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismandroid.model.ZoneSensible;
import com.geolocsystems.prismandroid.model.echanges.AlerteRequete;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.NatureEtDescriptionScoop;
import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.Restriction;
import com.geolocsystems.prismandroid.model.evenements.tri.EvenementTriListe;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.tunnel.Tunnel;
import com.geolocsystems.prismbirtbean.PatrouilleSemaineList;
import com.geolocsystems.prismbirtbean.SyntheseAccidentologieBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleBirt;
import com.geolocsystems.prismbirtbean.SyntheseTBDelaiDureeInterventionBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordFrequencePatrouilleBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordFrequencePatrouilleV2Bean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueCircuitBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueFauchageBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.geolocsystems.prismbirtbean.SyntheseViseeBean;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.IAdminDAO;
import com.geolocsystems.prismcentral.DAO.IAnonymisation;
import com.geolocsystems.prismcentral.DAO.IDatex2DAO;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IExportDAO;
import com.geolocsystems.prismcentral.DAO.IFauchageDAO;
import com.geolocsystems.prismcentral.DAO.IIG4DAO;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.DAO.IImportDAO;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IPartenaireDAO;
import com.geolocsystems.prismcentral.DAO.IPhotoDAO;
import com.geolocsystems.prismcentral.DAO.IPublicationDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IScoopDAO;
import com.geolocsystems.prismcentral.DAO.IStatsDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.DAO.IVhDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOConfigurationException;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.beans.ActionProfil;
import com.geolocsystems.prismcentral.beans.Astreinte;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.beans.BulletinInforoute;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH2;
import com.geolocsystems.prismcentral.beans.BulletinVH;
import com.geolocsystems.prismcentral.beans.CircuitESVHBean;
import com.geolocsystems.prismcentral.beans.Commune;
import com.geolocsystems.prismcentral.beans.ComposantBean;
import com.geolocsystems.prismcentral.beans.ComposantNatureCommunBean;
import com.geolocsystems.prismcentral.beans.ConfigurationBean;
import com.geolocsystems.prismcentral.beans.DatePublication;
import com.geolocsystems.prismcentral.beans.DescriptionNatureBean;
import com.geolocsystems.prismcentral.beans.DestinataireMail;
import com.geolocsystems.prismcentral.beans.EvenementInforoute;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.FiltreComposantNatureCommunBean;
import com.geolocsystems.prismcentral.beans.FiltreDescriptionNatureBean;
import com.geolocsystems.prismcentral.beans.IEvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.InformationInterventionBean;
import com.geolocsystems.prismcentral.beans.IntentionPatrouille;
import com.geolocsystems.prismcentral.beans.ListeDestinataireMail;
import com.geolocsystems.prismcentral.beans.ListeDiffusion;
import com.geolocsystems.prismcentral.beans.Localisation;
import com.geolocsystems.prismcentral.beans.LocalisationDonneesSaleuse;
import com.geolocsystems.prismcentral.beans.MCIG;
import com.geolocsystems.prismcentral.beans.MarqueVehicule;
import com.geolocsystems.prismcentral.beans.MessageAlertePublication;
import com.geolocsystems.prismcentral.beans.NatureBean;
import com.geolocsystems.prismcentral.beans.NatureExport;
import com.geolocsystems.prismcentral.beans.NiveauService;
import com.geolocsystems.prismcentral.beans.NiveauServicePeriode;
import com.geolocsystems.prismcentral.beans.Onglet;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.beans.PatrouilleVH;
import com.geolocsystems.prismcentral.beans.PrESVHBean;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.beans.ReformulationDescription;
import com.geolocsystems.prismcentral.beans.StatsCamionsVHBean;
import com.geolocsystems.prismcentral.beans.Synthese;
import com.geolocsystems.prismcentral.beans.SyntheseInterventionAgentBean;
import com.geolocsystems.prismcentral.beans.SynthesePatrouillesVHBean;
import com.geolocsystems.prismcentral.beans.TableauBordFiltre;
import com.geolocsystems.prismcentral.beans.TronconESVHBean;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentral.beans.TronconSuiviComplet;
import com.geolocsystems.prismcentral.beans.TypeAxeVH;
import com.geolocsystems.prismcentral.beans.TypesMarques;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.beans.apachepoi.ApachePoiConvert;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.geolocsystems.prismcentral.export.PublicationComposantFactory;
import com.geolocsystems.prismcentral.export.SituationExport;
import com.geolocsystems.prismcentral.mail.MailService;
import com.geolocsystems.prismcentral.mail.i18n.MailI18n;
import com.geolocsystems.prismcentral.service.ExportService;
import com.geolocsystems.prismcentraldata.util.URLTools;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import gls.outils.Util;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class BusinessServiceDAO
implements IBusinessService {
    private static final long serialVersionUID = 5146456826185547753L;
    IUserDAO userDal;
    IReferentielDAO referentielDal;
    IMcigDAO mcigDal;
    IIG4DAO ig4Dal;
    IFauchageDAO fauchageDal;
    IEvenementsDAO evenements;
    IVehiculeDAO vehiculesDal;
    IAdminDAO adminDal;
    IVhDAO vhDal;
    IPublicationDAO publicationDal;
    MailService mailService;
    IDatex2DAO datex2Dal;
    IPhotoDAO photoDal;
    IIconDAO iconDal = DAOFactory.getInstance().getIconDAO();
    IExportDAO exportDal;
    IPartenaireDAO partenaireDAO;
    IImportDAO importDal;
    IAnonymisation anonymisationDal;
    IScoopDAO scoopDal;
    SituationExport situationExport;
    IStatsDAO statsDal;
    Object servletContext;
    static long sauvegardeDateDerniereMaj = GregorianCalendar.getInstance().getTimeInMillis();

    public BusinessServiceDAO() {
        this.referentielDal = DAOFactory.getInstance().getReferentielDAO(this.iconDal);
        this.userDal = DAOFactory.getInstance().getUserDAO(this.referentielDal);
        this.vehiculesDal = DAOFactory.getInstance().getVehiculeDAO(this);
        this.mcigDal = DAOFactory.getInstance().getMcigDAO(this.referentielDal, this.vehiculesDal);
        this.evenements = DAOFactory.getInstance().getEvenementsDAO(this.referentielDal, this.userDal, this.mcigDal);
        this.adminDal = DAOFactory.getInstance().getAdminDAO(this.referentielDal);
        this.ig4Dal = DAOFactory.getInstance().getIG4DAO(this.adminDal, this.referentielDal, this.userDal, this.evenements, this.mcigDal, this.vehiculesDal);
        this.publicationDal = DAOFactory.getInstance().getPublicationDAO(this.referentielDal, this.vehiculesDal, this.ig4Dal);
        this.fauchageDal = DAOFactory.getInstance().getFauchageDAO();
        this.vhDal = DAOFactory.getInstance().getVhDAO(this.referentielDal, this.publicationDal);
        this.mailService = new MailService(this, new ExportService(this));
        this.datex2Dal = DAOFactory.getInstance().getDatex2DAO();
        this.photoDal = DAOFactory.getInstance().getPhotoDAO();
        this.exportDal = DAOFactory.getInstance().getExportDAO();
        this.partenaireDAO = DAOFactory.getInstance().getPartenaireDAO();
        this.importDal = DAOFactory.getInstance().getImportDAO();
        this.anonymisationDal = DAOFactory.getInstance().getAnonymisationDAO(this.referentielDal);
        try {
            this.scoopDal = DAOFactory.getInstance().getScoopDAO(this.adminDal, this.referentielDal, this.userDal);
        }
        catch (Exception e) {
            Log.error("Error ScoopDAL", e);
        }
        this.situationExport = new SituationExport(this);
        this.statsDal = DAOFactory.getInstance().getStatsDAO();
    }

    public void setServletContext(Object sc) {
        this.servletContext = sc;
    }

    public Object getServletContext() {
        return this.servletContext;
    }

    public PrismCentralUser login(String user, String password) {
        Log.debug("SQLBusinessService : login");
        return this.userDal.login(user, password);
    }

    public Map<String, Nature> getNatures() {
        return this.referentielDal.getNatureMap();
    }

    public Map<String, Integer> getNaturesMm() {
        return this.referentielDal.getNatureMmMap();
    }

    public List<NatureOuRaccourci> getNaturesList() {
        return this.referentielDal.getNatures();
    }

    public List<Onglet> getOngletsChamps() {
        return this.referentielDal.getOngletsChamps();
    }

    public PrismCentralUser getUtilisateur(String codeUtilisateur) {
        return this.referentielDal.getUtilisateur(codeUtilisateur);
    }

    public PrismCentralUser getUtilisateur(int codeUtilisateur) {
        return this.referentielDal.getUtilisateur(codeUtilisateur);
    }

    public List<PrismCentralUser> rechercheToutUtilisateur() {
        return this.referentielDal.rechercheToutUtilisateur();
    }

    public List<Utilisateur> rechercheToutUtilisateurEmbarque() {
        return this.userDal.rechercheToutUtilisateurEmbarque();
    }

    public List<PrismCentralUser> rechercheUtilisateurParDelegation(PrismCentralUser user) {
        return this.userDal.rechercheUtilisateurParDelegation(user);
    }

    public List<PrismCentralUser> rechercheUtilisateurParDelegationCentre(PrismCentralUser user) {
        return this.userDal.rechercheUtilisateurParDelegationCentre(user);
    }

    public PrismCentralUser rechercheUtilisateurParLogin(String codeUtilisateur) {
        return this.userDal.rechercheUtilisateurParLogin(codeUtilisateur);
    }

    public List<Situation> getEvenements(IBusinessService.EvenementFiltre filtre, List<FiltreJava> filtresJava) {
        return this.evenements.getEvenements(filtre, filtresJava);
    }

    public List<String> getKeyMCIG(TableauBordFiltre filtre) {
        return this.mcigDal.getKeyMCIG(filtre);
    }

    public Collection<MCIG> getMCIGFromRange(TableauBordFiltre filtre, int startIndex, int endIndex, List<String> keys) {
        return this.mcigDal.getMCIGFromRange(filtre, startIndex, endIndex, keys);
    }

    public List<Delegation> getDelegations() {
        return this.referentielDal.getDelegations();
    }

    public List<Delegation> getDelegationsActives() {
        return this.referentielDal.getDelegationsActives();
    }

    public Extension getConfiguration() {
        return this.referentielDal.getConfiguration();
    }

    public List<TronconFauchage> getTronconFauchage(Delegation delegation, Centre centre, Calendar dateDebut, Calendar dateFin) {
        return this.fauchageDal.getTronconFauchage(delegation, centre, dateDebut, dateFin);
    }

    public MainCourante creerMainCouranteCentral(PrismCentralUser user) {
        return this.mcigDal.creerMainCouranteCentral(user);
    }

    public void fermerMainCourante(MainCourante mc) {
        this.mcigDal.fermerMainCourante(mc);
    }

    public void inactivationEvenement(Evenement evenement) {
        this.evenements.inactivationEvenement(evenement);
    }

    public boolean estPublicationAutomatique(Evenement e) {
        List l = MetierCommun.getListe((String)((String)this.getConfiguration().get((Object)"naturesPublicationAutoBackOffice")));
        return MetierCommun.estDedans((List)l, (Object)e.getValeurNature().getCode());
    }

    private ReformulationDescription getReformulation(Evenement e) {
        List<DescriptionNature> listeDesc = this.getDescriptionsNatureMap().get(e.getValeurNature().getCode());
        DescriptionNature descriptionNature = null;
        String libelleDescription = e.getValeurNature().getDescription().getValeur();
        for (DescriptionNature d : listeDesc) {
            if (!d.getLibelle().equals(libelleDescription)) continue;
            descriptionNature = d;
            break;
        }
        String codeDescription = descriptionNature.getCode();
        ReformulationDescription reformulation = this.getReformulations().get(codeDescription);
        if (reformulation == null) {
            Log.debug("Reformulation non configur\u00e9 pour la description " + codeDescription);
            reformulation = new ReformulationDescription();
            reformulation.setCode(codeDescription);
            reformulation.setCodeNature(e.getValeurNature().getCode());
            reformulation.setLibelle(descriptionNature.getLibelle());
        }
        return reformulation;
    }

    public String getPublicationValeurPeriode(Evenement e) {
        return this.publicationDal.getValeurPeriode(e);
    }

    protected void publish(Evenement evt) {
        try {
            String complement5;
            int type5;
            String complement4;
            int type4;
            String complement3;
            int type3;
            String complement2;
            int type2;
            String complement1;
            int type1;
            ReformulationDescription reformulation = this.getReformulation(evt);
            Nature nature = (Nature)DeepCopy.copy((Object)this.getNatures().get(reformulation.getCodeNature()));
            nature.chargerValeurs(evt.getValeurNature());
            PublicationComposantFactory factory = new PublicationComposantFactory(this.getValeursReformulation());
            HashMap<String, String> lignes = this.getSavePublicationEvenement(evt);
            if (!lignes.isEmpty()) {
                type1 = Integer.parseInt(lignes.get("type1"));
                complement1 = lignes.get("complement1");
                type2 = Integer.parseInt(lignes.get("type2"));
                complement2 = lignes.get("complement2");
                type3 = Integer.parseInt(lignes.get("type3"));
                complement3 = lignes.get("complement3");
                type4 = Integer.parseInt(lignes.get("type4"));
                complement4 = lignes.get("complement4");
                type5 = Integer.parseInt(lignes.get("type5"));
                complement5 = lignes.get("complement5");
            } else {
                type1 = reformulation.getType(1);
                type2 = reformulation.getType(2);
                type3 = reformulation.getType(3);
                type4 = reformulation.getType(4);
                type5 = reformulation.getType(5);
                complement1 = reformulation.getValeur(1);
                complement2 = reformulation.getValeur(2);
                complement3 = reformulation.getValeur(3);
                complement4 = reformulation.getValeur(4);
                complement5 = reformulation.getValeur(5);
            }
            int longueurMax = this.getConfiguration().getInt("publicationLongueurLigneMax", 35);
            String valeur1 = this.publicationDal.getLigneReformulee(evt, nature, reformulation, factory, 1, type1, complement1, longueurMax);
            String valeur2 = this.publicationDal.getLigneReformulee(evt, nature, reformulation, factory, 2, type2, complement2, longueurMax);
            String valeur3 = this.publicationDal.getLigneReformulee(evt, nature, reformulation, factory, 3, type3, complement3, longueurMax);
            String valeur4 = this.publicationDal.getLigneReformulee(evt, nature, reformulation, factory, 4, type4, complement4, longueurMax);
            String valeur5 = this.publicationDal.getLigneReformulee(evt, nature, reformulation, factory, 5, type5, complement5, longueurMax);
            this.publierEvenement(evt, valeur1, valeur2, valeur3, valeur4, valeur5);
            this.saveGetPublicationEvenement(evt, "" + type1, complement1, valeur1, "" + type2, complement2, valeur2, "" + type3, complement3, valeur3, "" + type4, complement4, valeur4, "" + type5, complement5, valeur5);
        }
        catch (Exception e) {
            Log.error("Erreur publication ", e);
        }
    }

    public void sauvegarderEvenement(IEvenementASauvegarder eas) {
        if (eas.getEvenement().isPublie() && eas.getEvenement().isTermine()) {
            try {
                this.publicationDal.depublierEvenement(eas.getEvenement());
                eas.getEvenement().setPublie(false);
                this.publicationDal.deleteGetPublicationEvenement(eas.getEvenement());
            }
            catch (Exception e) {
                Log.error("Erreur d\u00e9publication suite annulation", e);
            }
        }
        this.evenements.sauvegarderEvenement(eas);
        if (!eas.getEvenement().isTermine() && this.estPublicationAutomatique(eas.getEvenement())) {
            this.publish(eas.getEvenement());
        }
        if (eas.isDiffuserDatex2()) {
            this.datex2Dal.ajouterEvenementASynchroniser(eas.getEvenement());
        }
        if (eas.isEnvoyerParMail()) {
            this.mailService.evenement(eas.getEvenement());
        }
    }

    public void exportEvenementAxione(Evenement evenement) throws Exception {
        this.exportEvenement(this.partenaireDAO.getListePartenaireExportEvenementAxione(evenement.getValeurNature().getCode()), evenement);
    }

    private void exportEvenement(List<Partenaire> partenaires, Evenement evenement) throws Exception {
        if (!GLS.estVide(partenaires)) {
            this.situationExport.export(partenaires, evenement);
        }
    }

    public void lireEvenement(Evenement e) {
        if (e != null && !e.isLu()) {
            this.evenements.lireEvenement(e);
        } else {
            Log.debug("evenement deja lu " + (e != null ? Integer.valueOf(e.getkEventid()) : ""));
        }
    }

    public Map<Integer, ModuleMetier> getModulesMetiers() {
        return this.referentielDal.getModulesMetiers();
    }

    public List<VehiculeEnIntervention> getVehiculesEnIntervention(IBusinessService.VehiculeFiltre filtre) {
        return this.vehiculesDal.getVehiculesEnIntervention(filtre);
    }

    public List<VehiculeEnIntervention> getVehiculesEnIntervention(List<String> idsPatrouille) {
        return this.vehiculesDal.getVehiculesEnIntervention(idsPatrouille);
    }

    public List<VehiculeEnIntervention> getVehiculesEnInterventionRecente(IBusinessService.VehiculeFiltre filtre) {
        return this.vehiculesDal.getVehiculesEnInterventionRecente(filtre);
    }

    public List<Profil> getProfils() {
        return this.userDal.getProfils();
    }

    public Collection<TronconSuivi> getTronconsPatrouilles(Set<String> idPatrouilleSuivi) {
        return this.vehiculesDal.getTronconsPatrouilles(idPatrouilleSuivi);
    }

    public List<ActionProfil> getActionsProfil() {
        return this.referentielDal.getActionsProfil();
    }

    public void creerProfil(Profil object) {
        this.adminDal.creerProfil(object);
    }

    public void updateProfil(Profil object) {
        this.adminDal.updateProfil(object);
    }

    public void creerUtilisateur(PrismCentralUser user, String newpwd) {
        this.adminDal.creerUtilisateur(user, newpwd);
    }

    public void deleteUtilisateur(int idUtilisateur) {
        this.adminDal.deleteUtilisateur(idUtilisateur);
    }

    public void updateUtilisateur(PrismCentralUser user, String newpwd) {
        this.adminDal.updateUtilisateur(user, newpwd);
    }

    public List<Vehicule> getListeVehicule() {
        return this.referentielDal.getListeVehicule();
    }

    public List<MarqueVehicule> getMarquesVehicules() {
        return this.referentielDal.getMarquesVehicules();
    }

    public void creerVehicule(Vehicule v) {
        this.adminDal.creerVehicule(v);
    }

    public void updateVehicule(Vehicule v) {
        this.adminDal.updateVehicule(v);
    }

    public Map<Integer, TypesMarques> getTypesMarques() {
        return this.referentielDal.getTypesMarques();
    }

    public void creerMarqueVehicule(MarqueVehicule marque) {
        this.adminDal.creerMarqueVehicule(marque);
    }

    public void updateMarqueVehicule(MarqueVehicule marque) {
        this.adminDal.updateMarqueVehicule(marque);
    }

    public void updatePatrouilleVH(PatrouilleVH patrouilleVH) {
        this.vhDal.updatePatrouilleVH(patrouilleVH);
    }

    public List<PatrouilleVH> getPatrouillesVH(Calendar calDebut, Calendar calFin) {
        return this.vhDal.getPatrouillesVH(calDebut, calFin);
    }

    public List<PatrouilleVH> getPatrouillesVH(Calendar cal) {
        return this.vhDal.getPatrouillesVH(cal);
    }

    public void creerDelegation(Delegation delegation) {
        this.adminDal.creerDelegation(delegation);
    }

    public void updateDelegation(Delegation delegation) {
        this.adminDal.updateDelegation(delegation);
    }

    public void creerCentre(Centre centre) {
        this.adminDal.creerCentre(centre);
    }

    public void updateCentre(Centre centre) {
        this.adminDal.updateCentre(centre);
    }

    public int getDernierIdBulletin(String nomCT) {
        return this.vhDal.getDernierIdBulletin(nomCT);
    }

    public HashMap<String, BulletinVH> getDerniersBulletinsCTCG() {
        return this.vhDal.getDerniersBulletinsCTCG();
    }

    public void enregistrerBulletin(BulletinVH bulletin) {
        this.vhDal.enregistrerBulletin(bulletin);
    }

    public PatrouilleVH getPatrouille(String nomCT, Calendar cal) {
        return this.vhDal.getPatrouilleVH(nomCT, cal);
    }

    public BulletinVH getBulletin(int id, String nomCT) {
        return this.vhDal.getBulletin(id, nomCT);
    }

    public List<TypeAxeVH> getTypesAxe(int typeBulletin, int id) {
        return this.vhDal.getTypesAxe(typeBulletin, id);
    }

    public List<TypeAxeVH> getTypesAxeV2(int typeBulletin, int id) {
        return this.vhDal.getTypesAxeV2(typeBulletin, id);
    }

    public List<TypeAxeVH> getTypesAxe(String nomCT, int id) {
        return this.vhDal.getTypesAxe(nomCT, id);
    }

    public List<TypeAxeVH> getTypesAxeV2(String nomCT, int id) {
        return this.vhDal.getTypesAxeV2(nomCT, id);
    }

    public List<DestinataireMail> getDestinatairesMail() {
        return this.referentielDal.getDestinatairesMail();
    }

    public List<String> getCategoriesDestinatairesMail() {
        return this.referentielDal.getCategoriesDestinatairesMail();
    }

    public void creerDestinataireMail(DestinataireMail destinataire) {
        this.adminDal.creerDestinataireMail(destinataire);
    }

    public void updateDestinataireMail(DestinataireMail destinataire) {
        this.adminDal.updateDestinataireMail(destinataire);
    }

    public List<ListeDestinataireMail> getListeDestinataireMails() {
        return this.referentielDal.getListeDestinataireMails();
    }

    public int creerListeDestinatairesMail(ListeDestinataireMail liste) {
        return this.adminDal.creerListeDestinatairesMail(liste);
    }

    public void updateListeDestinatairesMail(ListeDestinataireMail liste) {
        this.adminDal.updateListeDestinatairesMail(liste);
    }

    public List<ListeDiffusion> getListesDiffusions() {
        return this.referentielDal.getListesDiffusions();
    }

    public Map<String, List<DescriptionNature>> getDescriptionsNatureMap() {
        return this.referentielDal.getDescriptionsNatureMap();
    }

    public Map<String, Integer> getDesciptionDiffusionEvt() {
        return this.referentielDal.getDesciptionDiffusionEvt();
    }

    public void updateMailConfiguration(Map<String, Integer> diffusion, Map<String, Integer> evenements) {
        this.adminDal.updateMailConfiguration(diffusion, evenements);
    }

    public void verifierVehiculesEnDifficultes() {
        this.vehiculesDal.updateVehiculesEnDifficultes();
    }

    public Map<String, ReformulationDescription> getReformulations() {
        return this.referentielDal.getReformulations();
    }

    public void updateReformulationPublication(ReformulationDescription reformulation) {
        this.adminDal.updateReformulationPublication(reformulation);
    }

    public void depublierEvenement(Evenement e) {
        this.publicationDal.depublierEvenement(e);
    }

    public void publierEvenement(Evenement e, String ligne1, String ligne2, String ligne3, String ligne4, String ligne5) {
        this.publicationDal.publierEvenement(e, ligne1, ligne2, ligne3, ligne4, ligne5);
    }

    public Map<String, String[]> getValeursReformulation() {
        return this.referentielDal.getValeursReformulation();
    }

    public void deleteListeDestinatairesMail(ListeDestinataireMail liste) {
        this.adminDal.deleteListeDestinatairesMail(liste);
    }

    public void deleteDestinataireMail(DestinataireMail object) {
        this.adminDal.deleteDestinataireMail(object);
    }

    public void ajoutCommentaire(MainCourante mc, Commentaire c) {
        this.mcigDal.ajouterCommentaire(mc, c);
    }

    public List<VehiculeEnIntervention> getVehiculesEnIntervention(IBusinessService.VehiculeFiltre filtre, Date dateHisto) {
        return this.vehiculesDal.getVehiculesEnIntervention(filtre, dateHisto);
    }

    public Vector<TronconSuiviComplet> getTronconsCompletsPatrouilles(List<String> codeVehicules) {
        return this.vehiculesDal.getTronconsCompletsPatrouilles(codeVehicules);
    }

    public Vector<TronconSuiviComplet> getTronconsCompletsPatrouilles(List<String> codeVehicules, Date dateHisto) {
        return this.vehiculesDal.getTronconsCompletsPatrouilles(codeVehicules, dateHisto);
    }

    public List<Situation> getEvenementsASynchroniserDatex2(IBusinessService.EvenementFiltre filtreSql, List<FiltreJava> filtresJava) {
        return this.evenements.getEvenementsASynchroniserDatex2(filtreSql, filtresJava);
    }

    public Evenement getDernierEvenementActif(Evenement evenement) {
        return this.evenements.getDernierEvenementActif(evenement);
    }

    public byte[] getPhoto(String hash) {
        return this.photoDal.getPhoto(hash);
    }

    public void sauvegarderPhoto(String hash, byte[] data) {
        this.photoDal.sauvegarderPhoto(hash, data);
    }

    public boolean isPhotoExist(String hash) {
        return this.photoDal.isPhotoExist(hash);
    }

    public File getNatureIconHd(String code) {
        return this.iconDal.getNatureIconHd(code);
    }

    public File getIconHd(String code) {
        return this.iconDal.getIconHd(code);
    }

    public File getVehicleIcon(String code) {
        return this.iconDal.getVehicleIcon(code);
    }

    public File getImageComboItemIcon(String nom, String valeur) {
        return this.iconDal.getImageComboItemIcon(nom, valeur);
    }

    public Map<String, Map<String, byte[]>> getImagesComposantsChoixImage(List<NatureOuRaccourci> natures) {
        return this.iconDal.getImagesComposantsChoixImage(natures);
    }

    public List<VehiculeEnIntervention> getVehiculesEnInterventionHistorique(IBusinessService.VehiculeFiltre filtre) {
        return this.vehiculesDal.getVehiculesEnInterventionHistorique(filtre);
    }

    public MainCourante creerMainCourante(PrismCentralUser user, MainCourante mc, int typePoste) {
        return this.mcigDal.creerMainCourante(user, mc, typePoste);
    }

    public void fermerMainCourante(MainCourante mc, Commentaire c) {
        this.mcigDal.fermerMainCourante(mc, c);
    }

    public void debutPatrouille(DonneesSynchro d, boolean ajoutCommentaire) throws Exception {
        this.vehiculesDal.debutPatrouille(d, ajoutCommentaire);
    }

    public void finPatrouille(DonneesSynchro d, boolean ajoutCommentaire) throws Exception {
        this.vehiculesDal.finPatrouille(d, ajoutCommentaire);
    }

    public void verifierPatrouilleEtMainCouranteObsoletes() {
        this.mcigDal.verifierPatrouilleEtMainCouranteObsoletes();
    }

    public void deconnexion(MainCourante m) {
        this.mcigDal.deconnexion(m);
    }

    public Map<String, Circuit> getListeCircuit() {
        return this.referentielDal.getCircuits();
    }

    public List<TronconEq2r> getTronconsEq2r() {
        throw new UnsupportedOperationException();
    }

    public List<String> getListeCommunes() {
        return this.referentielDal.getListeCommunes();
    }

    public String getDelegationCommune(String commune) {
        return this.referentielDal.getDelegationCommune(commune);
    }

    public void ajouterTronconEq2r(TronconEq2r troncon) {
        throw new UnsupportedOperationException();
    }

    public void updateTronconEq2r(TronconEq2r troncon) {
        throw new UnsupportedOperationException();
    }

    public void deleteTronconEq2r(TronconEq2r troncon) {
        throw new UnsupportedOperationException();
    }

    public Map<Integer, Date> getDatesVisiteTronconsEq2r(Date date, List<TronconEq2r> troncons) {
        throw new UnsupportedOperationException();
    }

    public BulletinMediaVH getStructureBulletinMediaVH() {
        return this.vhDal.getStructureBulletinMediaVH();
    }

    public BulletinMediaVH getInformationsBulletinMediaVH() {
        return this.vhDal.getInformationsBulletinMediaVH();
    }

    public void enregistrerBulletinMedia(BulletinMediaVH bulletin) {
        this.vhDal.enregistrerBulletinMedia(bulletin);
    }

    public List<BarreauVH> getBarreauxVH(boolean sansCoordonnees) {
        return this.referentielDal.getBarreauxVH(sansCoordonnees);
    }

    public List<BarreauVH> getBarreauxVH() {
        return this.referentielDal.getBarreauxVH();
    }

    public List<BarreauVH> getBarreauxVH(String delegation, String centre) {
        return this.referentielDal.getBarreauxVH(delegation, centre);
    }

    public BarreauVH getBarreauVH(String tronconId, boolean sansCoordonnees) {
        return this.referentielDal.getBarreauVH(tronconId, sansCoordonnees);
    }

    public void updateBarreauVH(BarreauVH barreau) {
        this.vhDal.updateBarreauVH(barreau);
    }

    public void updateBarreauVH(BarreauVH barreau, boolean force) {
        this.vhDal.updateBarreauVH(barreau, force);
    }

    public void updateBarreauVHCCH(BarreauVH barreau) {
        this.vhDal.updateBarreauVHCCH(barreau);
    }

    public void updateBarreauVHCCH(BarreauVH barreau, boolean force) {
        this.vhDal.updateBarreauVHCCH(barreau, force);
    }

    public void updateBarreauxVH(List<BarreauVH> barreaux) {
        this.vhDal.updateBarreauxVH(barreaux);
    }

    public void pasDeChangementBarreauxVH(String delegation, String centre) {
        Date date = new Date();
        List<BarreauVH> barreaux = this.getBarreauxVH(delegation, centre, true);
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreau : barreaux) {
                barreau.setMajDate(date);
            }
            this.vhDal.updateBarreauxVH(barreaux);
        }
    }

    public void remiseAZeroBarreauxVH(String delegation, String centre) {
        Date date = new Date();
        ConstantesPrismCommun.EnumVHTypeCCH vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.C1;
        try {
            vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.valueOf((String)((String)this.getConfiguration().get((Object)"vh.raz.valeur")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<BarreauVH> barreaux = this.getBarreauxVH(delegation, centre, true);
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreau : barreaux) {
                barreau.setMajDate(date);
                barreau.setCch(vhTypeCCH.getValue());
                barreau.setCch2(vhTypeCCH.getValue());
                barreau.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
                barreau.setEquipements(ConstantesPrismCommun.EnumVHTypeEquipement.NR.getValue());
                barreau.setEtatChaussee(ConstantesPrismCommun.EnumVHEtatChaussees.NR.getValue());
                barreau.setMeteo(ConstantesPrismCommun.EnumVHMeteo.NR.getValue());
                barreau.setTraitement(ConstantesPrismCommun.EnumVHTraitement.NR.getValue());
                barreau.setTemperature("NR");
                barreau.setVent(ConstantesPrismCommun.EnumVHVent.NR.getValue());
                barreau.setCommentaire("");
                barreau.setCommentaireInterne("");
            }
            this.vhDal.updateBarreauxVH(barreaux);
        }
    }

    public void previsionPatrouilleBarreauxVH(String delegation, String centre) {
        Date date = new Date();
        ConstantesPrismCommun.EnumVHTypeCCH vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.C1;
        try {
            vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.valueOf((String)((String)this.getConfiguration().get((Object)"vh.raz.valeur")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<BarreauVH> barreaux = this.getBarreauxVH(delegation, centre, true);
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreau : barreaux) {
                barreau.setMajDate(date);
                barreau.setCch(vhTypeCCH.getValue());
                barreau.setCch2(vhTypeCCH.getValue());
                barreau.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
                barreau.setEquipements(ConstantesPrismCommun.EnumVHTypeEquipement.NR.getValue());
                barreau.setEtatChaussee(ConstantesPrismCommun.EnumVHEtatChaussees.NR.getValue());
                barreau.setMeteo(ConstantesPrismCommun.EnumVHMeteo.NR.getValue());
                barreau.setTraitement(ConstantesPrismCommun.EnumVHTraitement.NR.getValue());
                barreau.setTemperature("NR");
                barreau.setVent(ConstantesPrismCommun.EnumVHVent.NR.getValue());
                barreau.setCommentaire("");
                barreau.setCommentaireInterne("");
            }
            this.vhDal.updateBarreauxVH(barreaux);
        }
    }

    public void remiseAZeroBarreauxVH(Date dateCourante, int nbMinutesValidites, ConstantesPrismCommun.EnumVHTypeCCH cch) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(dateCourante);
        BarreauVH barreau = new BarreauVH();
        barreau.setMajDate(dateCourante);
        barreau.setCch(cch.getValue());
        barreau.setCch2(cch.getValue());
        barreau.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
        barreau.setEquipements(ConstantesPrismCommun.EnumVHTypeEquipement.NR.getValue());
        barreau.setEtatChaussee(ConstantesPrismCommun.EnumVHEtatChaussees.NR.getValue());
        barreau.setMeteo(ConstantesPrismCommun.EnumVHMeteo.NR.getValue());
        barreau.setTraitement(ConstantesPrismCommun.EnumVHTraitement.NR.getValue());
        barreau.setTemperature("NR");
        barreau.setVent(ConstantesPrismCommun.EnumVHVent.NR.getValue());
        barreau.setCommentaire("");
        barreau.setCommentaireInterne("");
        barreau.setPublie(true);
        this.vhDal.updateBarreauVHDureeValiditeVariable(gc.getTime(), barreau, cch.getValue());
    }

    public boolean remiseAZeroBarreauxVHPublication(Date dateCourante, int nbMinutesValidites, ConstantesPrismCommun.EnumVHTypeCCH cch) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(dateCourante);
        gc.set(12, gc.get(12) - nbMinutesValidites);
        BarreauVH barreau = new BarreauVH();
        barreau.setMajDate(dateCourante);
        barreau.setCch(cch.getValue());
        barreau.setCch2(cch.getValue());
        barreau.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
        barreau.setEquipements(ConstantesPrismCommun.EnumVHTypeEquipement.NR.getValue());
        barreau.setEtatChaussee(ConstantesPrismCommun.EnumVHEtatChaussees.NR.getValue());
        barreau.setMeteo(ConstantesPrismCommun.EnumVHMeteo.NR.getValue());
        barreau.setTraitement(ConstantesPrismCommun.EnumVHTraitement.NR.getValue());
        barreau.setTemperature("NR");
        barreau.setVent(ConstantesPrismCommun.EnumVHVent.NR.getValue());
        barreau.setCommentaire("");
        barreau.setCommentaireInterne("");
        barreau.setPublie(true);
        boolean response = false;
        if (this.getConfiguration().getBoolean("publication.donnees_externes.vh", false)) {
            try {
                if (this.vhDal.updateBarreauVHDonnesExterne(gc.getTime(), barreau, ConstantesPrismCommun.EnumVHTypeCCH.NR.getValue())) {
                    response = true;
                }
            }
            catch (Exception e) {
                Log.debug("RAZ Donnes externes", e);
            }
        }
        if (this.getConfiguration().getBoolean("CONFIG_VALIDITE_TRONCON_VH_VARIABLE", false)) {
            if (this.vhDal.updateBarreauVHPublicationDureeValiditeVariable(dateCourante, barreau, ConstantesPrismCommun.EnumVHTypeCCH.NR.getValue())) {
                response = true;
            }
            if (this.getConfiguration().getBoolean("CONFIG_RAZ_TRONCON_VH_VARIABLE", false) && this.vhDal.updateBarreauVHDureeValiditeVariable(dateCourante, barreau, ConstantesPrismCommun.EnumVHTypeCCH.NR.getValue())) {
                response = true;
            }
            return response;
        }
        if (this.vhDal.updateBarreauVHPublication(gc.getTime(), barreau, ConstantesPrismCommun.EnumVHTypeCCH.NR.getValue())) {
            response = true;
        }
        return response;
    }

    public void updateBarreauVHDonnesExterne(List<BarreauVH> barreaux) {
        this.vhDal.updateBarreauVHDonnesExterne(barreaux);
    }

    public boolean remiseAZeroSyntheseVHPublication(Date dateCourante, int nbMinutesValidites) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(dateCourante);
        gc.set(12, gc.get(12) - nbMinutesValidites);
        Synthese synthese = this.publicationDal.getMessageSynthesePublication();
        if (synthese != null && synthese.getDate() != null && synthese.getDate().before(gc.getTime())) {
            this.vhDal.depublierCopieSyntheseVH();
            return true;
        }
        return false;
    }

    public List<BarreauVH> getBarreauxVH(String delegation, String centre, boolean sansCoordonnees) {
        return this.referentielDal.getBarreauxVH(delegation, centre, sansCoordonnees);
    }

    public long getMaxDateMiseAJourVH() {
        return this.referentielDal.getMaxDateMiseAJourVH();
    }

    public Bounds getBoundsCommune(String comm) {
        return this.referentielDal.getBoundsCommune(comm);
    }

    public List<DefinitionCritere> getDefinitionsCriteresEq2r() {
        throw new UnsupportedOperationException();
    }

    public List<Integer> getCriteresEq2rDesactives() {
        throw new UnsupportedOperationException();
    }

    public void supprimerCritereEq2r(int object) {
        throw new UnsupportedOperationException();
    }

    public void activerCritereEq2r(int object, boolean enable) {
        throw new UnsupportedOperationException();
    }

    public void ajouterCritereEq2r(DefinitionCritere crit) {
        throw new UnsupportedOperationException();
    }

    public void updateCritereEq2r(DefinitionCritere crit) {
        throw new UnsupportedOperationException();
    }

    public List<NatureExport> getNatureExport(Nature nature) {
        return this.exportDal.getNaturesExport(nature);
    }

    public void reprisePatrouille(DonneesSynchro d, boolean ajoutCommentaire) throws Exception {
        this.vehiculesDal.reprisePatrouille(d, ajoutCommentaire);
    }

    public void pausePatrouille(DonneesSynchro d, boolean ajoutCommentaire) {
        this.vehiculesDal.pausePatrouille(d, ajoutCommentaire);
    }

    public NatureExport getNatureExport(Nature nature, String format) {
        return this.exportDal.getNaturesExport(nature, format);
    }

    public NatureExport getNatureExport(String code, String libelle) {
        return this.exportDal.getNatureExport(code, libelle);
    }

    public ModuleMetier getModuleMetier(String libelleModuleMetier) {
        return this.referentielDal.getModuleMetier(libelleModuleMetier);
    }

    public List<NatureExport> getNatureExport(List<Nature> natures) {
        return this.exportDal.getNatureExport(natures);
    }

    public Calendar getDatePublication() {
        return this.publicationDal.getDerniereDatePublication();
    }

    public String getCoordonneesEvenementsJSON() {
        return this.publicationDal.getCoordonneesEvenementsJSON();
    }

    public String getDerniereDatePublicationJSON(DatePublication datePublication) {
        return this.publicationDal.getDerniereDatePublicationJSON(datePublication);
    }

    public String getDerniereDatePublicationJSON() {
        return this.publicationDal.getDerniereDatePublicationJSON();
    }

    public String getEvenementsPubliesJSON(String status, String nature) {
        return this.publicationDal.getEvenementsPubliesJSON(status, nature, null);
    }

    public String getEvenementsPubliesJSON() {
        return this.publicationDal.getEvenementsPubliesJSON();
    }

    public String getConfigurationJSON() {
        return this.publicationDal.getConfigurationJSON();
    }

    public String getNaturesJSON() {
        return this.referentielDal.getNaturesJSON();
    }

    public Rectangle2D getExtentTroncons(List<String> tronconsId) {
        return this.referentielDal.getExtentTroncons(tronconsId);
    }

    public Rectangle2D getExtentMcig(String mcigId) {
        return this.mcigDal.getExtentMcig(mcigId);
    }

    public Rectangle2D getExtentPatrouille(String id_patrouille) {
        return this.vehiculesDal.getExtentPatrouille(id_patrouille);
    }

    public Rectangle2D getExtentPatrouille(List<String> ids_patrouille) {
        return this.vehiculesDal.getExtentPatrouille(ids_patrouille);
    }

    public Rectangle2D getExtentCircuit(String circuitId) {
        return this.referentielDal.getExtentCircuit(circuitId);
    }

    public Rectangle2D[] getExtentMcig2(String mcigId) {
        return this.mcigDal.getExtentMcig2(mcigId);
    }

    public void programmeEvenement(Evenement event, boolean etat) {
        this.evenements.programmeEvenement(event, etat);
    }

    public File getModuleMetierIcon(String code) {
        return this.iconDal.getModuleMetierIcon(code);
    }

    public void initialiserReferentiel() {
        this.referentielDal.update();
        this.exportDal.update();
        this.initialiserScoopCorrespondance();
    }

    public void publierPatrouilleVH(String idPatrouille) {
        this.publicationDal.publierPatrouilleVH(idPatrouille);
    }

    public void depublierPatrouilleVH(String idPatrouille) {
        this.publicationDal.depublierPatrouilleVH(idPatrouille);
    }

    public Collection<TronconSuivi> getTronconPatrouille(String idPatrouilleSuivi) {
        return this.vehiculesDal.getTronconPatrouille(idPatrouilleSuivi);
    }

    public Map<String, Long> getMajDonneesMetiers() {
        return this.referentielDal.getMiseAJourDonneesMetiers();
    }

    public void updateSyntheseSerpeVH(Synthese synthese) {
        Log.debug("updateSyntheseSerpeVH : D\u00e9but");
        synthese.setZoneRoutiere(ConfigurationFactory.getInstance().get("zoneroutiere"));
        this.referentielDal.updateSyntheseVH(synthese);
    }

    public void updateSynthesePublicationVH(Synthese synthese) {
        Log.debug("updateSynthesePublicationVH : D\u00e9but");
        synthese.setZoneRoutiere(ConfigurationFactory.getInstance().get("zoneroutiere"));
        this.referentielDal.updateSynthesePublieVH(synthese);
    }

    public Synthese getSyntheseSerpeVH() {
        Log.debug("updateSyntheseSerpeVH : D\u00e9but");
        return this.referentielDal.getSyntheseVH(ConfigurationFactory.getInstance().get("zoneroutiere"));
    }

    public Synthese getSynthesePublicationVH() {
        Log.debug("updateSyntheseSerpeVH : D\u00e9but");
        return this.referentielDal.getSynthesePublieVH(ConfigurationFactory.getInstance().get("zoneroutiere"));
    }

    private boolean aUnPartenaireAMettreAJour(List<Partenaire> partenairesSerpeVH, long derniereDateMajBarreau) {
        for (Partenaire partenaireSerpeVH : partenairesSerpeVH) {
            if (!this.doitEtreMisAJour(partenaireSerpeVH, derniereDateMajBarreau)) continue;
            return true;
        }
        return false;
    }

    private boolean doitEtreMisAJour(Partenaire p, long derniereDateMajBarreau) {
        if (p.getDernierTransfert() == null) {
            return true;
        }
        return p.getDernierTransfert().getTime() < derniereDateMajBarreau;
    }

    public boolean transmettreBarreauxSerpeVH(boolean selectionBarreauxParDelegation, List<BarreauVH> barreaux) {
        return this.transmettreBarreauxSerpeVH(selectionBarreauxParDelegation, true, barreaux);
    }

    public boolean transmettreBarreauxSerpeVH(boolean selectionBarreauxParDelegation) {
        return this.transmettreBarreauxSerpeVH(selectionBarreauxParDelegation, true, null);
    }

    public boolean transmettreBarreauxSerpeVH(boolean selectionBarreauxParDelegation, boolean force) {
        return this.transmettreBarreauxSerpeVH(selectionBarreauxParDelegation, force, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean transmettreBarreauxSerpeVH(boolean selectionBarreauxParDelegation, boolean force, List<BarreauVH> barreaux) {
        String nom;
        String nom2;
        ArrayList<BarreauVH> listeBarreaux;
        Log.debug("transmettreBarreauxSerpeVH : D\u00e9but");
        List<Partenaire> partenairesSerpeVH = null;
        try {
            partenairesSerpeVH = this.partenaireDAO.getListePartenaireSERPEVH();
        }
        catch (SQLException e1) {
            Log.error("getPartenaireSERPEVH", e1);
            return false;
        }
        if (partenairesSerpeVH == null || partenairesSerpeVH.size() == 0) {
            Log.error("PAs de partenaire SERPE VH");
            return true;
        }
        long derniereDateVhMaj = this.getMaxDateMiseAJourVH();
        if (!force && !this.aUnPartenaireAMettreAJour(partenairesSerpeVH, derniereDateVhMaj)) {
            Log.info("Force mode off - tron\u00e9ons mis \u00e9 jour - " + derniereDateVhMaj + " tous les partenaires sont \u00e9 jour");
            return false;
        }
        Synthese synthese = this.referentielDal.getSyntheseVH(ConfigurationFactory.getInstance().get("zoneroutiere"));
        BarreauxWriterXML barreauxWriter = new BarreauxWriterXML();
        Element racine = barreauxWriter.genererXMLSerpeVH();
        String nomZone = null;
        try {
            nomZone = ConfigurationFactory.getInstance().get("zoneroutiere.serpevh");
        }
        catch (Exception e) {
            nomZone = ConfigurationFactory.getInstance().get("zoneroutiere");
        }
        if (GLS.estVide((String)nomZone)) {
            nomZone = ConfigurationFactory.getInstance().get("zoneroutiere");
        }
        Element dir = barreauxWriter.genererXMLDirSerpeVH(nomZone, synthese.getCommentaire());
        racine.addContent((Content)dir);
        Log.debug("transmettreBarreauxSerpeVH : Envoi des barreaux \u00e9 TIPI VH " + selectionBarreauxParDelegation);
        List<Delegation> listeDelegations = this.getDelegationsActives();
        if (barreaux == null) {
            for (Delegation delegation : listeDelegations) {
                if (selectionBarreauxParDelegation) {
                    listeBarreaux = this.getBarreauxVH(delegation.getNom(), null, true);
                    nom2 = delegation.getNom();
                    if (this.getConfiguration().getBoolean("vh.renommer.districtcentre", false)) {
                        nom2 = this.getConfiguration().getString("vh.renommer.districtcentre." + nom2.trim(), nom2);
                    }
                    dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(nom2, listeBarreaux));
                    continue;
                }
                if (delegation.getCentres() == null || delegation.getCentres().size() <= 0) continue;
                for (Centre centre : delegation.getCentres()) {
                    listeBarreaux = this.getBarreauxVH(delegation.getNom(), centre.getNom(), true);
                    nom = centre.getNom();
                    if (this.getConfiguration().getBoolean("vh.renommer.districtcentre", false)) {
                        nom = this.getConfiguration().getString("vh.renommer.districtcentre." + nom.trim(), nom);
                    }
                    dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(nom, listeBarreaux));
                }
            }
        } else {
            block34: for (Delegation delegation : listeDelegations) {
                listeBarreaux = new ArrayList();
                if (selectionBarreauxParDelegation) {
                    Iterator<Object> iterator = barreaux.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            nom2 = delegation.getNom();
                            if (this.getConfiguration().getBoolean("vh.renommer.districtcentre", false)) {
                                nom2 = this.getConfiguration().getString("vh.renommer.districtcentre." + nom2.trim(), nom2);
                            }
                            if (listeBarreaux.size() <= 0) continue block34;
                            dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(nom2, listeBarreaux));
                            continue block34;
                        }
                        BarreauVH barreau = (BarreauVH)iterator.next();
                        if (!delegation.getNom().equals(barreau.getDelegation())) continue;
                        listeBarreaux.add(barreau);
                    }
                }
                if (delegation.getCentres() == null || delegation.getCentres().size() <= 0) continue;
                block36: for (Centre centre : delegation.getCentres()) {
                    listeBarreaux = new ArrayList();
                    Iterator<BarreauVH> iterator = barreaux.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            nom = centre.getNom();
                            if (this.getConfiguration().getBoolean("vh.renommer.districtcentre", false)) {
                                nom = this.getConfiguration().getString("vh.renommer.districtcentre." + nom.trim(), nom);
                            }
                            if (listeBarreaux.size() <= 0) continue block36;
                            dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(nom, listeBarreaux));
                            continue block36;
                        }
                        BarreauVH barreau = iterator.next();
                        if (!delegation.getNom().equals(barreau.getDelegation()) || !centre.getNom().equals(barreau.getCentre())) continue;
                        listeBarreaux.add(barreau);
                    }
                }
            }
        }
        boolean traitementOK = false;
        Iterator<Partenaire> iterator = partenairesSerpeVH.iterator();
        while (true) {
            Partenaire partenaireSerpeVH;
            block82: {
                if (!iterator.hasNext()) {
                    return traitementOK;
                }
                partenaireSerpeVH = iterator.next();
                if (!force && !this.doitEtreMisAJour(partenaireSerpeVH, derniereDateVhMaj)) {
                    Log.info(String.valueOf(partenaireSerpeVH.getLibelle()) + " - Force mode off - Aucune mise \u00e9 jour \u00e9 effectuer - " + derniereDateVhMaj);
                    return false;
                }
                if (!new File(partenaireSerpeVH.getCheminServeur()).exists()) {
                    new File(partenaireSerpeVH.getCheminServeur()).mkdirs();
                }
                if (!new File(partenaireSerpeVH.getRepArchivage()).exists()) {
                    new File(partenaireSerpeVH.getRepArchivage()).mkdirs();
                }
                if (partenaireSerpeVH.isWSTipi()) {
                    barreauxWriter.writeSOAPXmlFile(String.valueOf(partenaireSerpeVH.getCheminServeur()) + Util.getFilePattern((String)partenaireSerpeVH.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                } else {
                    barreauxWriter.writeXmlFile(String.valueOf(partenaireSerpeVH.getCheminServeur()) + Util.getFilePattern((String)partenaireSerpeVH.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                }
                StringBuffer sb = new StringBuffer("[AAAA][MM][JJ]_[HH][mm][ss][SSS]_");
                sb.append(partenaireSerpeVH.getPatternFichier());
                if (partenaireSerpeVH.isWSTipi()) {
                    barreauxWriter.writeSOAPXmlFile(String.valueOf(partenaireSerpeVH.getRepArchivage()) + Util.getFilePattern((String)sb.toString(), (String)"", (String)"", (String)"", (int)0));
                } else {
                    barreauxWriter.writeXmlFile(String.valueOf(partenaireSerpeVH.getRepArchivage()) + Util.getFilePattern((String)sb.toString(), (String)"", (String)"", (String)"", (int)0));
                }
                if (partenaireSerpeVH.isFTP()) {
                    FTPClientExample ftp = new FTPClientExample();
                    try {
                        traitementOK = ftp.ftpSendOneTime(partenaireSerpeVH.getCheminServeur(), partenaireSerpeVH.getRepDepotFtp(), partenaireSerpeVH.getFtpExtensionTemporaire(), partenaireSerpeVH.getNomServeur(), partenaireSerpeVH.getPortServeur(), partenaireSerpeVH.getLogin(), partenaireSerpeVH.getPassword(), partenaireSerpeVH.getModeConnexion(), partenaireSerpeVH.getModeTransfert());
                    }
                    catch (Exception e) {
                        Log.error("ftpSend", e);
                    }
                } else if (partenaireSerpeVH.isMail()) {
                    try {
                        File input = new File(String.valueOf(partenaireSerpeVH.getCheminServeur()) + Util.getFilePattern((String)partenaireSerpeVH.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                        ArrayList<File> liste = new ArrayList<File>();
                        liste.add(input);
                        this.mailService.sendMessage(partenaireSerpeVH.getEMail(), MailI18n.getString("vh.objet"), "", liste);
                        traitementOK = true;
                    }
                    catch (Exception e) {
                        Log.error("sendMessage", e);
                    }
                } else if (partenaireSerpeVH.isWSTipi()) {
                    File input;
                    block81: {
                        Charset charsetUTF8 = StandardCharsets.UTF_8;
                        Charset charsetISO88591 = StandardCharsets.ISO_8859_1;
                        File inputXML = new File(String.valueOf(partenaireSerpeVH.getCheminServeur()) + Util.getFilePattern((String)partenaireSerpeVH.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                        try {
                            try {
                                Throwable throwable = null;
                                Object var22_29 = null;
                                try {
                                    FileInputStream fileInputStream = new FileInputStream(inputXML);
                                    try {
                                        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charsetISO88591);){
                                            StringBuffer sbWS = new StringBuffer();
                                            if (partenaireSerpeVH.getPortServeur() == 443) {
                                                sbWS.append("https://");
                                            } else {
                                                sbWS.append("http://");
                                            }
                                            sbWS.append(partenaireSerpeVH.getNomServeur());
                                            sbWS.append(partenaireSerpeVH.getRepDepotFtp());
                                            Log.debug(sbWS.toString());
                                            URL url = new URL(sbWS.toString());
                                            if (partenaireSerpeVH.getPortServeur() == 443) {
                                                SSLSocketFactory sslSocketFactory = null;
                                                try {
                                                    String pathCert = "/prism_data";
                                                    String pathCertTemp = ConfigurationFactory.getInstance().get("certificat.path");
                                                    if (!GLS.estVide((String)pathCertTemp)) {
                                                        pathCert = pathCertTemp;
                                                    } else {
                                                        Log.debug("Param\u00e9tre certificat.path non trouv\u00e9. Par d\u00e9faut : " + pathCert);
                                                    }
                                                    StringBuffer sbCert = new StringBuffer();
                                                    sbCert.append(pathCert);
                                                    sbCert.append(File.separator);
                                                    sbCert.append(ConfigurationFactory.getInstance().get("zoneroutiere"));
                                                    sbCert.append(".jks");
                                                    String password = "superGLS33!";
                                                    String passwwordPathCertTemp = ConfigurationFactory.getInstance().get("certificat.password");
                                                    if (!GLS.estVide((String)passwwordPathCertTemp)) {
                                                        password = passwwordPathCertTemp;
                                                    } else {
                                                        Log.debug("Param\u00e9tre certificat.password non trouv\u00e9. Par d\u00e9faut : " + password);
                                                    }
                                                    sslSocketFactory = URLTools.getSSLSocketFactory(sbCert.toString(), password, null, null);
                                                    HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
                                                }
                                                catch (IOException | CertificateException e1) {
                                                    e1.printStackTrace();
                                                }
                                                catch (KeyManagementException e) {
                                                    e.printStackTrace();
                                                }
                                                catch (KeyStoreException e) {
                                                    e.printStackTrace();
                                                }
                                                catch (NoSuchAlgorithmException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
                                            httpCon.setDoOutput(true);
                                            httpCon.setRequestProperty("Content-Type", "text/xml; charset=iso-8859-1");
                                            httpCon.setRequestProperty("Accept", "application/soap+xml, application/dime, multipart/related, text/*");
                                            httpCon.setRequestProperty("SOAPAction", "\"http://tipi.e2.rie.gouv.fr/ns/vh/putVHData\"");
                                            httpCon.setRequestMethod("POST");
                                            byte[] postDataBytes = IOUtils.toByteArray((Reader)inputStreamReader);
                                            httpCon.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                                            OutputStream os = httpCon.getOutputStream();
                                            os.write(postDataBytes);
                                            httpCon.connect();
                                            int statusCode = httpCon.getResponseCode();
                                            Log.debug("StatusCode = " + statusCode);
                                            Log.debug(httpCon.getResponseMessage());
                                            if (statusCode == 200) {
                                                traitementOK = true;
                                            }
                                            StringBuilder responseSB = new StringBuilder();
                                            BufferedReader br = new BufferedReader(new InputStreamReader(httpCon.getInputStream()));
                                            while (true) {
                                                String line;
                                                if ((line = br.readLine()) == null) {
                                                    Log.debug("responseSB = " + responseSB.toString());
                                                    br.close();
                                                    os.close();
                                                    httpCon.disconnect();
                                                    break;
                                                }
                                                responseSB.append(line);
                                                Log.debug(line);
                                            }
                                        }
                                        if (fileInputStream == null) break block81;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (fileInputStream == null) throw throwable;
                                        fileInputStream.close();
                                        throw throwable;
                                    }
                                    fileInputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                        throw throwable;
                                    }
                                    if (throwable == throwable3) throw throwable;
                                    throwable.addSuppressed(throwable3);
                                    throw throwable;
                                }
                            }
                            catch (Exception e) {
                                Log.error("sendMessage", e);
                                try {
                                    input = new File(String.valueOf(partenaireSerpeVH.getCheminServeur()) + Util.getFilePattern((String)partenaireSerpeVH.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                                    input.delete();
                                }
                                catch (Exception e2) {
                                    Log.error("delete file WS VH", e2);
                                }
                                break block82;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                input = new File(String.valueOf(partenaireSerpeVH.getCheminServeur()) + Util.getFilePattern((String)partenaireSerpeVH.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                                input.delete();
                                throw throwable;
                            }
                            catch (Exception e) {
                                Log.error("delete file WS VH", e);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        input = new File(String.valueOf(partenaireSerpeVH.getCheminServeur()) + Util.getFilePattern((String)partenaireSerpeVH.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                        input.delete();
                    }
                    catch (Exception e) {
                        Log.error("delete file WS VH", e);
                    }
                }
            }
            try {
                this.miseAjourPartenaire(partenaireSerpeVH, new Date(derniereDateVhMaj));
                continue;
            }
            catch (Exception e) {
                Log.error("Erreur mise \u00e9 jour partenaire", e);
                continue;
            }
            break;
        }
    }

    public boolean importationBarreaux(List<Partenaire> partenairesATraiter) {
        for (Partenaire partenaire : partenairesATraiter) {
            FileFilterBarreau filtreFichierPartenaire;
            File repertoire;
            File[] fichiers;
            if (!new File(partenaire.getRepArchivageImport()).exists()) {
                new File(partenaire.getRepArchivageImport()).mkdirs();
            }
            if ((fichiers = (repertoire = new File(partenaire.getRepertoireReception())).listFiles(filtreFichierPartenaire = new FileFilterBarreau(partenaire.getPattenFichierReception()))) == null) continue;
            File[] fileArray = fichiers;
            int n = fichiers.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                BarreauxReaderXML barreauReader = new BarreauxReaderXML(MapDescription.parse((String)partenaire.getParametres()));
                Log.debug("[PrismVHImport]fichier xml: " + f.getName());
                List<BarreauVH> barreaux = barreauReader.lireXML(String.valueOf(partenaire.getRepertoireReception()) + "/" + f.getName());
                Log.debug("[PrismVHImport]barreaux " + barreaux.size());
                for (BarreauVH barreau : barreaux) {
                    barreau.setMajIdPartenaire(Integer.valueOf(partenaire.getId()).intValue());
                    Log.debug("[PrismVHImport]updateBarreauVH " + barreau.toString());
                    try {
                        this.vhDal.updateBarreauVH(barreau, false);
                    }
                    catch (Exception e) {
                        Log.error("[PrismVHImport]", e);
                    }
                }
                Path fromPath = f.toPath();
                Path toPath = new File(String.valueOf(partenaire.getRepArchivageImport()) + "/" + f.getName()).toPath();
                try {
                    Files.move(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    Log.error("Impossible de d\u00e9placer le ficheir:" + fromPath + " vers " + toPath);
                    Log.error("", e);
                }
                ++n2;
            }
        }
        return true;
    }

    private Vector<BarreauVH> filtrerBarreau(List<BarreauVH> barreaux, Partenaire partenaire) {
        Vector<BarreauVH> barreauxAEnvoyer = new Vector<BarreauVH>();
        for (BarreauVH barreau : barreaux) {
            if ((barreau.getMajIdPartenaire() == Integer.parseInt(partenaire.getId()) && barreau.getMajIdPartenaire() != -1 || partenaire.getDernierTransfert() != null && !barreau.getMajDate().after(partenaire.getDernierTransfert()) && !barreau.getMajDateServeur().after(partenaire.getDernierTransfert())) && !barreau.isPublie()) continue;
            barreauxAEnvoyer.add(barreau);
        }
        return barreauxAEnvoyer;
    }

    protected boolean sendVHGeoSIGWeb(Partenaire partenaire, Vector<BarreauVH> barreauxAEnvoyer) {
        for (BarreauVH barreauVH : barreauxAEnvoyer) {
            try {
                StringBuffer sb = new StringBuffer();
                if (partenaire.getPortServeur() == 443) {
                    sb.append("https://");
                } else {
                    sb.append("http://");
                }
                sb.append(partenaire.getNomServeur());
                sb.append(partenaire.getCheminServeur());
                Log.debug(sb.toString());
                URL url = new URL(sb.toString());
                HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
                httpCon.setDoOutput(true);
                httpCon.setRequestProperty("Content-Type", "application/json");
                httpCon.setRequestMethod("POST");
                String postData = "{\"client_id\": \"testid\",\"code\": \"troncon1\", \"value\": \"CCH\"}";
                postData = postData.replaceAll("testid", partenaire.getLogin());
                postData = postData.replaceAll("troncon1", barreauVH.getCircuit());
                postData = postData.replaceAll("CCH", barreauVH.getCch());
                Log.debug("postData=" + postData);
                byte[] postDataBytes = postData.getBytes("UTF-8");
                httpCon.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                httpCon.getOutputStream().write(postDataBytes);
                httpCon.connect();
                int statusCode = httpCon.getResponseCode();
                Log.debug("StatusCode = " + statusCode);
                Log.debug(httpCon.getResponseMessage());
                httpCon.disconnect();
            }
            catch (MalformedURLException e) {
                Log.error("Erreur envoi", e);
                return false;
            }
            catch (IOException e) {
                Log.error("Erreur envoi", e);
                return false;
            }
            catch (Exception e) {
                Log.error("Erreur envoi", e);
                return false;
            }
        }
        return true;
    }

    public boolean exportationBarreaux(List<Partenaire> partenairesExternes, List<Partenaire> partenairesATraiter) {
        boolean traitement = true;
        if (partenairesATraiter != null && partenairesATraiter.size() > 0) {
            List<BarreauVH> barreaux = this.referentielDal.getBarreauxVH();
            Log.debug("Nombre de barreaux total: " + barreaux.size());
            for (Partenaire partenaire : partenairesATraiter) {
                BarreauxWriterXML barreaWriter = new BarreauxWriterXML(MapDescription.parse((String)partenaire.getParametres()));
                Log.debug("[" + partenaire.getLibelle() + "]" + "Traitement en cours");
                Vector<BarreauVH> barreauxAEnvoyer = this.filtrerBarreau(barreaux, partenaire);
                Log.debug("[Barreaux filtr\u00e9s]" + barreauxAEnvoyer.size());
                if (barreauxAEnvoyer.size() > 0) {
                    if ("WS_CD19".equals(partenaire.getFormatEchange())) {
                        Vector<BarreauVH> barreauxAEnvoyerBis = new Vector<BarreauVH>();
                        HashMap<String, ConstantesPrismCommun.EnumVHTypeCCH> circuits = new HashMap<String, ConstantesPrismCommun.EnumVHTypeCCH>();
                        for (BarreauVH barreau : barreauxAEnvoyer) {
                            circuits.put(barreau.getCircuit(), ConstantesPrismCommun.EnumVHTypeCCH.NR);
                        }
                        if (circuits.size() > 0) {
                            block16: for (BarreauVH barreauVH : barreaux) {
                                if (circuits.get(barreauVH.getCircuit()) == null) continue;
                                try {
                                    ConstantesPrismCommun.EnumVHTypeCCH cchActuelle = (ConstantesPrismCommun.EnumVHTypeCCH)circuits.get(barreauVH.getCircuit());
                                    ConstantesPrismCommun.EnumVHTypeCCH cch = ConstantesPrismCommun.EnumVHTypeCCH.valueOf((String)barreauVH.getCch());
                                    switch (cchActuelle) {
                                        case NR: {
                                            circuits.put(barreauVH.getCircuit(), cch);
                                            cchActuelle = cch;
                                            break;
                                        }
                                        case C1: {
                                            if (!cch.equals((Object)ConstantesPrismCommun.EnumVHTypeCCH.C2) && !cch.equals((Object)ConstantesPrismCommun.EnumVHTypeCCH.C3) && !cch.equals((Object)ConstantesPrismCommun.EnumVHTypeCCH.C4)) continue block16;
                                            circuits.put(barreauVH.getCircuit(), cch);
                                            cchActuelle = cch;
                                            break;
                                        }
                                        case C2: {
                                            if (!cch.equals((Object)ConstantesPrismCommun.EnumVHTypeCCH.C3) && !cch.equals((Object)ConstantesPrismCommun.EnumVHTypeCCH.C4)) continue block16;
                                            circuits.put(barreauVH.getCircuit(), cch);
                                            cchActuelle = cch;
                                            break;
                                        }
                                        case C3: {
                                            if (!cch.equals((Object)ConstantesPrismCommun.EnumVHTypeCCH.C4)) continue block16;
                                            circuits.put(barreauVH.getCircuit(), cch);
                                            cchActuelle = cch;
                                            break;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Log.error("Erreur calcul cch", e);
                                }
                            }
                            for (String circuit : circuits.keySet()) {
                                Circuit circuitRef = this.referentielDal.getCircuitDirect(Long.valueOf(circuit));
                                BarreauVH barreauVHTemp = new BarreauVH();
                                barreauVHTemp.setCircuit(circuitRef.getNom());
                                barreauVHTemp.setCch(((ConstantesPrismCommun.EnumVHTypeCCH)circuits.get(circuit)).getValue());
                                barreauxAEnvoyerBis.add(barreauVHTemp);
                            }
                            if (!this.sendVHGeoSIGWeb(partenaire, barreauxAEnvoyerBis)) {
                                traitement = false;
                            } else {
                                this.depublierBarreauxVH(barreauxAEnvoyer);
                            }
                        }
                    } else if ("XML_SERPEVH".equals(partenaire.getFormatEchange())) {
                        boolean selectionBarreauxParDelegation = false;
                        try {
                            selectionBarreauxParDelegation = ConfigurationFactory.getInstance().getBoolean("vh.barreauxvh.delegation", true);
                        }
                        catch (Exception e) {
                            selectionBarreauxParDelegation = true;
                        }
                        Synthese synthese = this.referentielDal.getSyntheseVH(ConfigurationFactory.getInstance().get("zoneroutiere"));
                        BarreauxWriterXML barreauxWriter = new BarreauxWriterXML();
                        Element racine = barreauxWriter.genererXMLSerpeVH();
                        String nomZone = null;
                        try {
                            nomZone = ConfigurationFactory.getInstance().get("zoneroutiere.serpevh");
                        }
                        catch (Exception e) {
                            nomZone = ConfigurationFactory.getInstance().get("zoneroutiere");
                        }
                        Element dir = barreauxWriter.genererXMLDirSerpeVH(nomZone, synthese.getCommentaire());
                        racine.addContent((Content)dir);
                        Log.debug("transmettreBarreauxSerpeVH : Envoi des barreaux \u00e9 TIPI VH " + selectionBarreauxParDelegation);
                        List<Delegation> listeDelegations = this.getDelegationsActives();
                        for (Delegation delegation : listeDelegations) {
                            ArrayList<Object> listeBarreauxMaj;
                            if (selectionBarreauxParDelegation) {
                                listeBarreauxMaj = new ArrayList<BarreauVH>();
                                for (BarreauVH barreauVH : barreauxAEnvoyer) {
                                    if (!delegation.getNom().equals(barreauVH.getDelegation())) continue;
                                    listeBarreauxMaj.add(barreauVH);
                                }
                                if (listeBarreauxMaj.size() <= 0) continue;
                                dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(delegation.getNom(), listeBarreauxMaj));
                                continue;
                            }
                            if (delegation.getCentres() == null || delegation.getCentres().size() <= 0) continue;
                            for (Centre centre : delegation.getCentres()) {
                                listeBarreauxMaj = new ArrayList();
                                for (BarreauVH barreauVH : barreauxAEnvoyer) {
                                    if (!centre.getNom().equals(barreauVH.getCentre())) continue;
                                    listeBarreauxMaj.add(barreauVH);
                                }
                                if (listeBarreauxMaj.size() <= 0) continue;
                                dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(centre.getNom(), listeBarreauxMaj));
                            }
                        }
                        if (!new File(partenaire.getCheminServeur()).exists()) {
                            new File(partenaire.getCheminServeur()).mkdirs();
                        }
                        if (!new File(partenaire.getRepArchivage()).exists()) {
                            new File(partenaire.getRepArchivage()).mkdirs();
                        }
                        barreauxWriter.writeXmlFile(String.valueOf(partenaire.getCheminServeur()) + Util.getFilePattern((String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                        barreauxWriter.writeXmlFile(String.valueOf(partenaire.getRepArchivage()) + Util.getFilePattern((String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                    } else {
                        barreaWriter.genererXML(barreauxAEnvoyer);
                        if (!new File(partenaire.getCheminServeur()).exists()) {
                            new File(partenaire.getCheminServeur()).mkdirs();
                        }
                        if (!new File(partenaire.getRepArchivage()).exists()) {
                            new File(partenaire.getRepArchivage()).mkdirs();
                        }
                        barreaWriter.writeXmlFile(String.valueOf(partenaire.getCheminServeur()) + Util.getFilePattern((String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                        barreaWriter.writeXmlFile(String.valueOf(partenaire.getRepArchivage()) + Util.getFilePattern((String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                    }
                }
                Log.debug("[" + partenaire.getLibelle() + "]" + "Traitement termin\u00e9");
            }
        }
        for (Partenaire partenaire : partenairesExternes) {
            if ("WS_CD19".equals(partenaire.getFormatEchange()) || partenaire.getTypeEmission().equals((Object)Partenaire.EnumTypeEmission.NON)) continue;
            FTPClientExample ftp = new FTPClientExample();
            try {
                ftp.ftpSend(partenaire.getCheminServeur(), partenaire.getRepDepotFtp(), partenaire.getFtpExtensionTemporaire(), partenaire.getNomServeur(), partenaire.getPortServeur(), partenaire.getLogin(), partenaire.getPassword(), partenaire.getModeConnexion(), partenaire.getModeTransfert());
            }
            catch (Exception e) {
                Log.error("Renommage en erreur ", e);
            }
        }
        return traitement;
    }

    public boolean exportationEvenementsInforoute(List<Partenaire> partenairesExternes, List<Partenaire> partenairesATraiter, List<EvenementInforoute> evtsInforoute) {
        boolean traitement = true;
        if (partenairesATraiter != null && partenairesATraiter.size() > 0) {
            Log.debug("Nombre d'\u00e9v\u00e9nements total: " + evtsInforoute.size());
            for (Partenaire partenaire : partenairesATraiter) {
                EvtWriterXML evtsWriter = new EvtWriterXML(MapDescription.parse((String)partenaire.getParametres()));
                Log.debug("[" + partenaire.getLibelle() + "]" + "Traitement en cours");
                if (evtsInforoute.size() > 0) {
                    evtsWriter.genererXML(evtsInforoute);
                    if (!new File(partenaire.getCheminServeur()).exists()) {
                        new File(partenaire.getCheminServeur()).mkdirs();
                    }
                    if (!new File(partenaire.getRepArchivage()).exists()) {
                        new File(partenaire.getRepArchivage()).mkdirs();
                    }
                    evtsWriter.writeXmlFile(String.valueOf(partenaire.getCheminServeur()) + Util.getFilePattern((String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                    evtsWriter.writeXmlFile(String.valueOf(partenaire.getRepArchivage()) + Util.getFilePattern((String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                }
                Log.debug("[" + partenaire.getLibelle() + "]" + "Traitement termin\u00e9");
            }
        }
        for (Partenaire partenaire : partenairesExternes) {
            FTPClientExample ftp = new FTPClientExample();
            try {
                ftp.ftpSend(partenaire.getCheminServeur(), partenaire.getRepDepotFtp(), partenaire.getFtpExtensionTemporaire(), partenaire.getNomServeur(), partenaire.getPortServeur(), partenaire.getLogin(), partenaire.getPassword(), partenaire.getModeConnexion(), partenaire.getModeTransfert());
            }
            catch (Exception e) {
                Log.error("Renommage en erreur ", e);
            }
        }
        return traitement;
    }

    public List<Partenaire> getListePartenaire() throws SQLException {
        return this.partenaireDAO.getListePartenaire(-1);
    }

    public List<Partenaire> getListePartenaire(int type) throws SQLException {
        return this.partenaireDAO.getListePartenaire(type);
    }

    public List<Partenaire> getListePartenaireExportEvenement(String nature) throws SQLException {
        return this.partenaireDAO.getListePartenaireExportEvenement(nature);
    }

    public List<Partenaire> getListePartenaireExportEvenementAxione(String nature) throws SQLException {
        return this.partenaireDAO.getListePartenaireExportEvenementAxione(nature);
    }

    public Partenaire getPartenaireSERPEVH() throws SQLException {
        return this.partenaireDAO.getPartenaireSERPEVH();
    }

    public void miseAjourPartenaire(Partenaire partenaire, Date dateIterationCourante) {
        try {
            this.partenaireDAO.miseAjourPartenaire(partenaire, dateIterationCourante);
        }
        catch (SQLException e) {
            new Exception(e);
        }
    }

    public List<ModuleMetier> getListeModulesMetiers() {
        return this.referentielDal.getListeModulesMetiers();
    }

    public Map<String, String> getMapTypeComposants() {
        return this.referentielDal.getMapTypeComposants();
    }

    public Map<String, String> getMapCorrespondanceComposantsChamp() {
        return this.referentielDal.getMapCorrespondanceComposantChamp();
    }

    public void creerCircuit(Circuit v) {
        this.adminDal.creerCircuit(v);
    }

    public void updateCircuit(Circuit v) {
        this.referentielDal.updateTronconCircuit(v);
        this.adminDal.updateCircuit(v);
    }

    public boolean alerte(AlerteRequete req) {
        return this.mailService.alerte(req);
    }

    public List<Circuit> getListeCircuits() {
        return this.adminDal.getListeCircuits();
    }

    public void diffusionVH() {
        this.mailService.diffusionVH();
    }

    public void diffusionVH(String object, String message, ListeDestinataireMail liste) {
        this.mailService.diffusionVH(object, message, liste);
    }

    public Map<String, ComposantBean> getMapComposants() {
        return this.referentielDal.getMapComposants();
    }

    public Map<String, ComposantBean> getMapComposantsUtilises() {
        return this.referentielDal.getMapComposantsUtilises();
    }

    public boolean updateComposantFromNature(NatureBean n, ComposantNatureCommunBean c) {
        return this.referentielDal.UpdateComposantFromNature(n, c);
    }

    public boolean deleteComposantFromNature(NatureBean n, ComposantNatureCommunBean o) {
        return this.referentielDal.DeleteComposantFromNature(n, o);
    }

    public boolean createComposantFromNature(NatureBean object, ComposantNatureCommunBean c) {
        return this.referentielDal.CreateComposantFromNature(object, c);
    }

    public List<NatureBean> getListeNaturePerso(boolean withZoneRoutiere) {
        return this.referentielDal.getListeNaturePerso(withZoneRoutiere);
    }

    public List<ComposantBean> getListComposants(boolean withZoneRoutiere) {
        return this.referentielDal.getListComposants(withZoneRoutiere);
    }

    public List<ComposantNatureCommunBean> getListComposantsCommun(FiltreComposantNatureCommunBean filtre) {
        return this.referentielDal.getListComposantsCommun(filtre);
    }

    public List<ComposantNatureCommunBean> getListComposantsNature(FiltreComposantNatureCommunBean filtre) {
        return this.referentielDal.getListComposantsNature(filtre);
    }

    public boolean creerNatureBean(NatureBean nature) {
        return this.referentielDal.creerNatureBean(nature);
    }

    public boolean updateNatureBean(NatureBean nature) {
        return this.referentielDal.updateNatureBean(nature);
    }

    public List<DescriptionNatureBean> getListDescriptionsNature(FiltreDescriptionNatureBean filtre) {
        return this.referentielDal.getListDescriptionsNature(filtre);
    }

    public boolean createDescriptionNature(DescriptionNatureBean d) {
        return this.referentielDal.createDescriptionNature(d);
    }

    public boolean updateDescriptionNature(DescriptionNatureBean d) {
        return this.referentielDal.updateDescriptionNature(d);
    }

    public boolean deleteDescriptionNature(DescriptionNatureBean d) {
        return this.referentielDal.deleteDescriptionNature(d);
    }

    public boolean creerComposantBean(ComposantBean composant) {
        return this.referentielDal.creerComposantBean(composant);
    }

    public boolean updateComposantBean(ComposantBean composant) {
        return this.referentielDal.updateComposantBean(composant);
    }

    public boolean updateOldPassword() {
        return this.adminDal.updateOldPassword();
    }

    public List<ConfigurationBean> getListConfiguration(boolean withZoneRoutiere) {
        return this.adminDal.getListConfiguration(withZoneRoutiere);
    }

    public void creerConfigurationBean(ConfigurationBean config) {
        this.adminDal.creerConfigurationBean(config);
    }

    public void updateConfigurationBean(ConfigurationBean config) {
        this.adminDal.updateConfigurationBean(config);
    }

    public void deleteConfiguration(String champ) {
        this.adminDal.deleteConfigurationBean(champ);
    }

    public void publierBarreauxVH(List<BarreauVH> barreaux) {
        this.referentielDal.publierBarreauxVH(barreaux);
    }

    public void publierCopieBarreauxVH() {
        this.vhDal.publierCopieBarreauxVH();
        try {
            Date iterationCourante = GregorianCalendar.getInstance().getTime();
            int minutesValidite = this.getConfiguration().getInt("validiteTronconVH", 2) * 60;
            this.remiseAZeroBarreauxVHPublication(iterationCourante, minutesValidite, ConstantesPrismCommun.EnumVHTypeCCH.NR);
        }
        catch (Exception e1) {
            Log.error("RAZ VH", e1);
        }
    }

    public void depublierBarreauxVH(List<BarreauVH> barreaux) {
        this.referentielDal.depublierBarreauxVH(barreaux);
    }

    public Map<String, Integer> getLongueurPatrouilleParConditionConduites(IBusinessService.VehiculeFiltre filtre) {
        return this.vehiculesDal.getLongueurPatrouilleParConditionConduites(filtre);
    }

    public Map<String, List<Troncon>> getCategoriesRoute() {
        return this.referentielDal.getCategoriesRoute();
    }

    public Map<String, List<Troncon>> getTraficRoute() {
        return this.referentielDal.getTraficRoute();
    }

    public Map<String, Map<String, List<Troncon>>> getCaracteristiquesRoute() {
        return this.referentielDal.getCaracteristiquesRoute();
    }

    public Collection<TronconSuivi> getTronconsRecents(List<Integer> codeMM) {
        return this.vehiculesDal.getTronconsRecents(codeMM);
    }

    public Collection<TronconSuivi> getTronconsRecents(List<Integer> codeMM, Timestamp minValidite) {
        return this.vehiculesDal.getTronconsRecents(codeMM, minValidite);
    }

    public List<NiveauExploitation> getNiveauExploitation(List<FiltreJava> filtresJava) {
        return this.referentielDal.getNiveauExploitation(filtresJava);
    }

    public void importUtilisateurs(String fichier) {
        this.importDal.importUtilisateurs(fichier);
    }

    public List<CircuitExploitation> getCircuitExploitation(String d, String c, Date debut, Date fin) throws DAOException {
        return this.referentielDal.getCircuitExploitation(d, c, debut, fin);
    }

    public Localisation getLocalisationPatrouille(String idMCIG) {
        return this.vehiculesDal.getLocalisationPatrouille(idMCIG);
    }

    public List<LocalisationDonneesSaleuse> getLocalisationDonneesSaleusePatrouille(String idPatrouille) {
        return this.vehiculesDal.getLocalisationDonneesSaleusePatrouille(idPatrouille);
    }

    public void insertionReleveDebroussaillage(DonneesSynchro d, Releve r) {
        this.fauchageDal.insertionReleveDebroussaillage(d, r);
    }

    public List<Releve> getReleveDebroussaillage(Calendar dateDebut, Calendar dateFin) {
        return this.fauchageDal.getReleveDebroussaillage(dateDebut, dateFin);
    }

    public void importNiveauxExploitation(String fichier) {
        this.importDal.importNiveauxExploitation(fichier);
    }

    public void desactiverPosition(String mcigId) {
        this.vehiculesDal.desactiverPosition(mcigId);
    }

    public void anonymisation() {
        this.anonymisationDal.anonymisation();
    }

    public void anonymisation(PrismCentralUser u) {
        this.anonymisationDal.anonymisation(u);
    }

    public List<CircuitExploitation> getFrequenceCircuitExploitation(Date debut, Date fin) {
        return this.referentielDal.getFrequenceCircuitExploitation(debut, fin);
    }

    public List<CircuitExploitation> getCircuitsAnomalies(String division, String district, String departement, Date dateJourDebut, Date dateJourFin) {
        return this.referentielDal.getCircuitsAnomalies(division, district, departement, dateJourDebut, dateJourFin);
    }

    public List<Troncon> getCircuitTroncons(Circuit circuit) {
        return this.referentielDal.getCircuitTroncons(circuit);
    }

    public void creerCircuitTroncons(Circuit circuit) {
        int idCircuit = this.adminDal.creerCircuit(circuit);
        circuit.setId(String.valueOf(idCircuit));
        this.referentielDal.creerCircuitTroncons(circuit);
    }

    public void creerIntentionPatrouille(IntentionPatrouille ip) {
        this.adminDal.creerIntentionPatrouille(ip);
    }

    public void updateIntentionPatrouille(IntentionPatrouille ip) {
        this.adminDal.updateIntentionPatrouille(ip);
    }

    public List<IntentionPatrouille> getIntentionPatrouille(String delegation, String centre) {
        return this.adminDal.getIntentionPatrouille(delegation, centre);
    }

    public void insertPosition(DonneesSynchro d, ValeurChampLocalisation v, int etat) {
        this.vehiculesDal.insertPosition(d, v, etat);
    }

    public Map<Activite, List<Centre>> getCentresParActivite() {
        return this.referentielDal.getCentresParActivite();
    }

    public void supprimerEvenement(Evenement e) {
        this.evenements.supprimeEvenement(e);
    }

    public void annulerEvenement(IEvenementASauvegarder event) {
        this.evenements.annulerEvenement(event);
        try {
            if (event.getEvenement().isPublie()) {
                this.depublierEvenement(event.getEvenement());
                event.getEvenement().setPublie(false);
                this.publicationDal.deleteGetPublicationEvenement(event.getEvenement());
            }
        }
        catch (Exception e) {
            Log.error("Erreur d\u00e9publication suite annulation", e);
        }
    }

    public SynthesePatrouilleBirt getSynthesePatrouilleBirt(String idPatrouille, String type, boolean regroupementPatrouilles) {
        return this.vehiculesDal.getSynthesePatrouilleBirt(idPatrouille, type, regroupementPatrouilles, "");
    }

    public SynthesePatrouilleBirt getSynthesePatrouilleBirt(String idPatrouille, String type, boolean regroupementPatrouilles, String adresseServeur) {
        return this.vehiculesDal.getSynthesePatrouilleBirt(idPatrouille, type, regroupementPatrouilles, adresseServeur);
    }

    public Map<String, Map<String, Map<Integer, Integer>>> getNbPatrouillesParAnnee(int annee) {
        return this.vehiculesDal.getNbPatrouillesParAnnee(annee);
    }

    public Map<String, Map<String, Map<Integer, Integer>>> getNbAccidentsEtInterventionsParAnnee(IBusinessService.EvenementFiltre filtre) {
        return this.evenements.getNbAccidentsEtInterventionsParAnnee(filtre);
    }

    public Map<String, Map<String, Integer>> getNbAccidentsEtInterventionsParAnneeParAxe(IBusinessService.EvenementFiltre filtre) {
        return this.limiterNbAxes(this.evenements.getNbAccidentsEtInterventionsParAnneeParAxe(filtre));
    }

    public SyntheseAccidentologieBean getAccidentologie(IBusinessService.EvenementFiltre filtre, boolean annuel) {
        return this.evenements.getAccidentologie(filtre, annuel);
    }

    public SyntheseTBDelaiDureeInterventionBean getDelaisDureesIntervention(IBusinessService.EvenementFiltre filtre, boolean annuel) {
        return this.evenements.getDelaisDureesIntervention(filtre, annuel);
    }

    private Map<String, Map<String, Integer>> limiterNbAxes(Map<String, Map<String, Integer>> evts) {
        Integer nbMaxAxes;
        try {
            nbMaxAxes = ConfigurationFactory.getInstance().getInt("synthese.tableau.bord.pc.nbmaxaxes");
        }
        catch (Exception e) {
            nbMaxAxes = 5;
        }
        LinkedHashMap<String, Map<String, Integer>> evtsRetour = new LinkedHashMap<String, Map<String, Integer>>();
        if (!evts.isEmpty()) {
            Map mapMois;
            int nb;
            Map<String, Integer> axes = evts.get("tableaubord.stats.pc.total.general");
            if (axes.size() <= nbMaxAxes) {
                return evts;
            }
            HashMap<String, Integer> axesRetenues = new HashMap<String, Integer>();
            ValueComparator comparateur = new ValueComparator(axes);
            TreeMap<String, Integer> axesPrincipaux = new TreeMap<String, Integer>(comparateur);
            axesPrincipaux.putAll(axes);
            String[] axesArray = new String[axesPrincipaux.keySet().size()];
            axesArray = axesPrincipaux.keySet().toArray(axesArray);
            int i = 0;
            while (i < nbMaxAxes) {
                axesRetenues.put(axesArray[i], -1);
                ++i;
            }
            String autres = PrismI18n.getString("tableaubord.stats.pc.autres");
            LinkedHashMap<String, Integer> mapTotal = new LinkedHashMap<String, Integer>();
            int autresValuesTotal = 0;
            int autresValues = 0;
            for (String nature : evts.keySet()) {
                if ("tableaubord.stats.pc.total.general".equals(nature) || "tableaubord.stats.pc.accident.mortel".equals(nature) || "tableaubord.stats.pc.accident.corporel".equals(nature)) continue;
                autresValues = 0;
                for (String string : evts.get(nature).keySet()) {
                    nb = evts.get(nature).get(string);
                    mapMois = evtsRetour.containsKey(nature) ? (Map)evtsRetour.get(nature) : new LinkedHashMap();
                    if (axesRetenues.get(string) != null) {
                        mapMois.put(string, nb);
                        mapTotal.put(string, (mapTotal.get(string) != null ? (Integer)mapTotal.get(string) : 0) + nb);
                    } else {
                        autresValues += nb;
                        autresValuesTotal += nb;
                    }
                    evtsRetour.put(nature, mapMois);
                }
                ((Map)evtsRetour.get(nature)).put(autres, autresValues);
            }
            mapTotal.put(autres, autresValuesTotal);
            evtsRetour.put("tableaubord.stats.pc.total.general", mapTotal);
            String natureMortel = "tableaubord.stats.pc.accident.mortel";
            autresValues = 0;
            mapMois = new LinkedHashMap();
            for (String axe : evts.get(natureMortel).keySet()) {
                int nb2 = evts.get(natureMortel).get(axe);
                mapMois = evtsRetour.containsKey(natureMortel) ? (Map)evtsRetour.get(natureMortel) : new LinkedHashMap();
                if (axesRetenues.get(axe) != null) {
                    mapMois.put(axe, nb2);
                } else {
                    autresValues += nb2;
                }
                evtsRetour.put(natureMortel, mapMois);
            }
            if (evtsRetour.get(natureMortel) != null) {
                ((Map)evtsRetour.get(natureMortel)).put(autres, autresValues);
            } else {
                evtsRetour.put(natureMortel, new LinkedHashMap());
            }
            evtsRetour.put("tableaubord.stats.pc.accident.mortel", mapMois);
            String natureCorporel = "tableaubord.stats.pc.accident.corporel";
            autresValues = 0;
            mapMois = new LinkedHashMap();
            for (String string : evts.get(natureCorporel).keySet()) {
                nb = evts.get(natureCorporel).get(string);
                mapMois = evtsRetour.containsKey(natureCorporel) ? (Map)evtsRetour.get(natureCorporel) : new LinkedHashMap();
                if (axesRetenues.get(string) != null) {
                    mapMois.put(string, nb);
                } else {
                    autresValues += nb;
                }
                evtsRetour.put(natureCorporel, mapMois);
            }
            if (evtsRetour.get(natureCorporel) != null) {
                ((Map)evtsRetour.get(natureCorporel)).put(autres, autresValues);
            } else {
                evtsRetour.put(natureCorporel, new LinkedHashMap());
            }
            evtsRetour.put("tableaubord.stats.pc.accident.corporel", mapMois);
        }
        return evtsRetour;
    }

    public void effacerEvenementMission() {
        this.adminDal.effacerEvenementMission();
    }

    public List<Astreinte> rechercheAstreintes(String delegation, String centre, Long timestamp) {
        return this.adminDal.rechercheAstreintes(delegation, centre, timestamp);
    }

    public boolean supprimerAstreinte(long id) {
        return this.adminDal.supprimerAstreinte(id);
    }

    public Long creerAstreinte(Astreinte object) {
        return this.adminDal.creerAstreinte(object);
    }

    public Long updateAstreinte(Astreinte object) {
        return this.adminDal.udapteAstreinte(object);
    }

    public List<String> listeTypeAstreintes() {
        return this.adminDal.listeTypeAstreintes();
    }

    public List<NiveauService> getNiveauxService() {
        return this.referentielDal.getNiveauxService();
    }

    public List<SyntheseTableauBordFrequencePatrouilleBean> getFrequencePatrouilleTroncons(Circuit circuit, Timestamp dateDebut, int bufferSize, double ratioParcours) {
        return this.referentielDal.getFrequencePatrouilleTroncons(circuit, dateDebut, bufferSize, ratioParcours);
    }

    public LinkedHashMap<String, List<Position>> getAccidentologieCoordonneesAccidents(IBusinessService.EvenementFiltre filtre) {
        return this.evenements.getAccidentologieCoordonneesAccidents(filtre);
    }

    public List<Troncon> getCircuitTroncons(Circuit circuit, boolean lateralized, double lateralizedValue, boolean obligatoireUniquement) {
        return this.referentielDal.getCircuitTroncons(circuit, lateralized, lateralizedValue, obligatoireUniquement);
    }

    public Map<String, List<ZoneSensible>> getZonesSensibles() {
        return this.referentielDal.getZonesSensibles();
    }

    public List<Troncon> getTroncons(String table) {
        return this.referentielDal.getTroncons(table);
    }

    public void miseAJourCoordonneesTroncon(String table, Troncon t) {
        this.referentielDal.miseAJourCoordonneesTroncon(table, t);
    }

    public void miseAJourCoordonneesTroncon(String table, List<Troncon> troncons) {
        this.referentielDal.miseAJourCoordonneesTroncon(table, troncons);
    }

    public void importZoneOmbre(String fichierCSV) {
        this.importDal.importZoneOmbre(fichierCSV);
    }

    public void miseAJourPRTroncon(String table, Troncon t) {
        this.referentielDal.miseAJourPRTroncon(table, t);
    }

    public List<TronconESVHBean> getEtatSurfaceVHTroncons(String idCircuit) {
        return this.vhDal.getEtatSurfaceVHTroncons(idCircuit);
    }

    public List<PrESVHBean> getEtatSurfaceVHPrs(String delegation) {
        return this.vhDal.getEtatSurfaceVHPrs(delegation);
    }

    public List<PrESVHBean> getEtatSurfaceVHPrs() {
        return this.vhDal.getEtatSurfaceVHPrs();
    }

    public void saveEtatSurfaceVH(List<String> circuits, int etatSurface) {
        this.vhDal.saveEtatSurfaceVH(circuits, etatSurface);
    }

    public void updateEtatSurfaceVHCircuits(List<String> circuits) {
        this.vhDal.updateEtatSurfaceVHCircuits(circuits);
    }

    public void saveEtatSurfaceVHTroncons(List<TronconESVHBean> tronconsESVH) {
        this.vhDal.saveEtatSurfaceVHTroncons(tronconsESVH);
    }

    public void updateEtatSurfaceVHTroncons(List<TronconESVHBean> tronconsESVH) {
        this.vhDal.updateEtatSurfaceVHTroncons(tronconsESVH);
    }

    public void saveEtatSurfaceVHPrs(List<PrESVHBean> prsESVH) {
        this.vhDal.saveEtatSurfaceVHPrs(prsESVH);
    }

    public void updateEtatSurfaceVHPrs(List<PrESVHBean> prsESVH) {
        this.vhDal.updateEtatSurfaceVHPrs(prsESVH);
    }

    public void addEtatSurfaceVHPr(PrESVHBean prESVH) {
        this.vhDal.addEtatSurfaceVHPr(prESVH);
    }

    public void deleteEtatSurfaceVHPrs(List<PrESVHBean> prsESVH) {
        this.vhDal.deleteEtatSurfaceVHPrs(prsESVH);
    }

    public List<TronconESVHBean> getTronconsVH(Circuit c) {
        ArrayList<TronconESVHBean> troncons = new ArrayList<TronconESVHBean>();
        for (Troncon troncon : this.getCircuitTroncons(c)) {
            TronconESVHBean tronconESVH = new TronconESVHBean(troncon);
            tronconESVH.setDate(new Date());
            troncons.add(tronconESVH);
        }
        return troncons;
    }

    public List<TronconESVHBean> getTronconsVHaRenouveler(String delegation, long ageMax) {
        return this.vhDal.getTronconsVHaRenouveler(delegation, ageMax);
    }

    public List<PrESVHBean> getPrsVHaRenouveler(String delegation, long ageMax) {
        return this.vhDal.getPrsVHaRenouveler(delegation, ageMax);
    }

    public List<Restriction> getStylesPublication() {
        return this.referentielDal.getStylesPublication();
    }

    public void datePublicationMaj() {
        this.publicationDal.datePublicationMaj();
    }

    public List<VehiculeEnIntervention> getVehiculesEnIntervention(IBusinessService.VehiculeFiltre filtre, boolean regroupementPatrouille) {
        return this.vehiculesDal.getVehiculesEnIntervention(filtre, regroupementPatrouille);
    }

    public List<VehiculeEnIntervention> getVehiculesEnInterventionHistorique(IBusinessService.VehiculeFiltre filtre, boolean regroupementPatrouille) {
        return this.vehiculesDal.getVehiculesEnInterventionHistorique(filtre, regroupementPatrouille);
    }

    public List<String> getSynthesePatrouilleRegroupeeIds(String idPatrouille, int codeMM) {
        return this.vehiculesDal.getSynthesePatrouilleRegroupeeIds(idPatrouille, codeMM);
    }

    public List<SynthesePatrouillesVHBean> getAnalysePatrouillesVH(Timestamp dateDebut, Timestamp dateFin) {
        return this.vehiculesDal.getAnalysePatrouillesVH(dateDebut, dateFin);
    }

    public void updateDateModificationAdmin(String donnees) {
        this.adminDal.updateDateModificationAdmin(donnees);
    }

    public List<CircuitESVHBean> getDerniersCircuitsVHModifies(String delegation) {
        return this.vhDal.getDerniersCircuitsVHModifies(delegation);
    }

    public void miseAJourEvenementPrevisionnel(List<String> ret) {
        this.publicationDal.miseAJourEvenementPrevisionnel(ret);
    }

    public List<String> verificationEtatEvenementPrevisionnel() {
        return this.evenements.verificationEtatEvenementPrevisionnel();
    }

    public List<Circuit> getCircuitsVHActifs() {
        return this.adminDal.getCircuitsVHActifs();
    }

    public List<BarreauVH> getBarreauxVH(int circuit, boolean sansCoordonnees) {
        return this.referentielDal.getBarreauxVH(circuit, sansCoordonnees);
    }

    public Map<String, List<Direction>> getDirections() {
        return this.referentielDal.getDirections();
    }

    public void verifierEtatNiveauService() {
        List<Circuit> liste = this.getListeCircuits();
        int bufferSize = ConfigurationFactory.getInstance().getInt("carto.frequence.patrouille.buffer.size");
        double ratioParcours = ConfigurationFactory.getInstance().getDouble("carto.frequence.patrouille.ratio.parcours");
        Timestamp date = new Timestamp(Calendar.getInstance().getTimeInMillis());
        for (Circuit circuit : liste) {
            List<SyntheseTableauBordFrequencePatrouilleBean> troncons = this.getFrequencePatrouilleTroncons(circuit, date, bufferSize, ratioParcours);
            boolean niveauServiceOk = true;
            for (SyntheseTableauBordFrequencePatrouilleBean t : troncons) {
                if (t.getFrequence() >= t.getFrequenceMin()) continue;
                niveauServiceOk = false;
                break;
            }
            this.referentielDal.changerEtatNiveauServiceCircuit(circuit, niveauServiceOk ? 1 : 0);
            Log.info("Mise \u00e9 jour des V\u00e9rification des Stats circuit " + circuit.getId());
            try {
                this.referentielDal.miseAJourStatsCircuitExploitation(circuit, date, bufferSize, ratioParcours);
            }
            catch (Exception e) {
                Log.debug("", e);
            }
        }
    }

    public void precalculEtatNiveauService() {
        List<Circuit> liste = this.getListeCircuits();
        int bufferSize = ConfigurationFactory.getInstance().getInt("carto.frequence.patrouille.buffer.size");
        double ratioParcours = ConfigurationFactory.getInstance().getDouble("carto.frequence.patrouille.ratio.parcours");
        Timestamp date = new Timestamp(Calendar.getInstance().getTimeInMillis());
        boolean LOCAL = false;
        for (Circuit circuit : liste) {
            Log.info("Mise \u00e9 jour des V\u00e9rification des Stats circuit " + circuit.getId());
            try {
                if (LOCAL) continue;
                this.referentielDal.miseAJourStatsCircuitExploitation(circuit, date, bufferSize, ratioParcours);
            }
            catch (Exception e) {
                Log.debug("", e);
            }
        }
    }

    public List<Circuit> getListeCircuitsParEtatNiveauService(PrismCentralUser userConnecte, int etatNiveauService) {
        if (userConnecte != null && (etatNiveauService == 1 || etatNiveauService == 0 || etatNiveauService == 2)) {
            return this.referentielDal.getListeCircuitsParEtatNiveauService(etatNiveauService);
        }
        return null;
    }

    public void pasDeChangementBarreauxVH(int circuit) {
        Date date = new Date();
        List<BarreauVH> barreaux = this.getBarreauxVH(circuit, true);
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreau : barreaux) {
                barreau.setMajDate(date);
            }
            this.vhDal.updateBarreauxVH(barreaux);
        }
    }

    public void remiseAZeroBarreauxVH(int circuit) {
        Date date = new Date();
        ConstantesPrismCommun.EnumVHTypeCCH vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.NR;
        try {
            vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.valueOf((String)((String)this.getConfiguration().get((Object)"vh.raz.valeur")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<BarreauVH> barreaux = this.getBarreauxVH(circuit, true);
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreau : barreaux) {
                barreau.setMajDate(date);
                barreau.setCch(vhTypeCCH.getValue());
                barreau.setCch2(vhTypeCCH.getValue());
                barreau.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
                barreau.setEquipements(ConstantesPrismCommun.EnumVHTypeEquipement.NR.getValue());
                barreau.setEtatChaussee(ConstantesPrismCommun.EnumVHEtatChaussees.NR.getValue());
                barreau.setMeteo(ConstantesPrismCommun.EnumVHMeteo.NR.getValue());
                barreau.setTraitement(ConstantesPrismCommun.EnumVHTraitement.NR.getValue());
                barreau.setTemperature("NR");
                barreau.setVent(ConstantesPrismCommun.EnumVHVent.NR.getValue());
                barreau.setCommentaire("");
                barreau.setCommentaireInterne("");
            }
            this.vhDal.updateBarreauxVH(barreaux);
        }
    }

    public void previsionPatrouilleBarreauxVH(int circuit) {
        Date date = new Date();
        ConstantesPrismCommun.EnumVHTypeCCH vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.C0;
        try {
            vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.valueOf((String)this.getConfiguration().getString("vh.previsionPatrouille.valeur", ConstantesPrismCommun.CONFIG_VH_PREVISION_PATROUILLE_VALEUR_DEFAUT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<BarreauVH> barreaux = this.getBarreauxVH(circuit, true);
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreau : barreaux) {
                barreau.setMajDate(date);
                barreau.setCch(vhTypeCCH.getValue());
                barreau.setCch2(vhTypeCCH.getValue());
                barreau.setDuree(this.getConfiguration().getInt("vh.previsionPatrouille.duree", 20));
                barreau.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
            }
            this.vhDal.updateBarreauxVH(barreaux);
        }
    }

    public List<SyntheseTableauBordStatistiqueCircuitBean> getStatistiqueCircuitTroncons(Circuit circuit, Timestamp dateDebut, int bufferSize, double ratioParcours, boolean tronconPreCalcules) {
        return this.referentielDal.getStatistiqueCircuitTroncons(circuit, dateDebut, bufferSize, ratioParcours, tronconPreCalcules);
    }

    public List<SyntheseTableauBordStatistiqueCircuitBean> getStatistiqueCircuitTroncons(List<Circuit> circuits, Timestamp dateDebut, int bufferSize, double ratioParcours) {
        return this.referentielDal.getStatistiqueCircuitTroncons(circuits, dateDebut, bufferSize, ratioParcours);
    }

    public boolean verificationMainCouranteEmbarque(PrismCentralUser user, MainCourante m) {
        return this.mcigDal.verificationMainCouranteEmbarque(user, m);
    }

    public boolean verificationMainCourante(PrismCentralUser user, MainCourante m, int typeSupport) {
        return this.mcigDal.verificationMainCourante(user, m, typeSupport);
    }

    public void creerMessageAlertePublication(MessageAlertePublication message) {
        this.publicationDal.creerMessageAlertePublication(message);
    }

    public void updateMessageAlertePublication(MessageAlertePublication message) {
        this.publicationDal.updateMessageAlertePublication(message);
    }

    public List<MessageAlertePublication> getMessagesAlertePublication() {
        return this.publicationDal.getMessagesAlertePublication();
    }

    public void deleteMessageAlertePublication(MessageAlertePublication message) {
        this.publicationDal.deleteMessageAlertePublication(message);
    }

    public TreeMap<String, String> getModelesMessagePublicationAlerte() {
        return this.publicationDal.getModelesMessagePublication("alerte");
    }

    public TreeMap<String, String> getModelesMessagePublicationSynthese() {
        return this.publicationDal.getModelesMessagePublication("synthese");
    }

    public HashMap<String, String> getSavePublicationEvenement(Evenement e) {
        return this.publicationDal.getSavePublicationEvenement(e);
    }

    public void saveGetPublicationEvenement(Evenement e, String type1, String complement1, String valeur1, String type2, String complement2, String valeur2, String type3, String complement3, String valeur3, String type4, String complement4, String valeur4, String type5, String complement5, String valeur5) {
        this.publicationDal.saveGetPublicationEvenement(e, type1, complement1, valeur1, type2, complement2, valeur2, type3, complement3, valeur3, type4, complement4, valeur4, type5, complement5, valeur5);
    }

    public List<ConfigurationBean> getListConfigurationPublication() {
        return this.adminDal.getListConfigurationPublication();
    }

    public void updateConfigurationPublicationBean(ConfigurationBean config) {
        this.adminDal.updateConfigurationPublicationBean(config);
    }

    public void miseAJourGeometryEvenement(Evenement evt) {
        this.evenements.miseAJourGeometryEvenement(evt);
    }

    public Map<String, Map<?, ?>> getScoopConfiguration() {
        Map map = this.scoopDal.getScoopConfiguration();
        HashMap mapScoop = new HashMap();
        for (String key : map.keySet()) {
            if (key.equals("scoop.eventsscoop")) continue;
            mapScoop.put(key, (Map)map.get(key));
        }
        return mapScoop;
    }

    public Map<String, Map<?, ?>> getScoopConfigurationIHM() {
        return this.scoopDal.getScoopConfiguration();
    }

    public List<Tunnel> getTunnels() {
        return this.referentielDal.getTunnels();
    }

    public List<ParametrePatrouille> getParametresPatrouille() {
        return this.referentielDal.getParametresPatrouille();
    }

    public void verifierReferentielMaj() {
        try {
            long dateDerniereMaj = this.referentielDal.getDerniereDateMajDonneesMetiers();
            Log.debug("V\u00e9rification de la mise \u00e9 jour du r\u00e9f\u00e9rentiel sauvegarde " + sauvegardeDateDerniereMaj + " -- derniere date " + dateDerniereMaj);
            if (sauvegardeDateDerniereMaj < dateDerniereMaj) {
                Log.debug("Mise \u00e9 jour du r\u00e9f\u00e9rentiel sauvegarde en cours...");
                this.initialiserReferentiel();
                this.getNatures();
                Log.debug("Mise \u00e9 jour du r\u00e9f\u00e9rentiel sauvegarde termin\u00e9");
            }
        }
        catch (Exception e) {
            Log.error("Erreur controle m\u00e9j r\u00e9f\u00e9rentiel", e);
        }
    }

    public void initialiserScoopCorrespondance() {
        if (this.scoopDal != null) {
            this.scoopDal.update();
        }
    }

    public void miseAJourParametresPatrouille(DonneesSynchro d) {
        this.vehiculesDal.miseAJourParametresPatrouille(d);
    }

    public void pasDeChangementBarreauxVH(String delegation, String centre, int circuit) {
        Date date = new Date();
        List<BarreauVH> barreaux = this.getBarreauxVH(delegation, centre, circuit, true);
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreau : barreaux) {
                barreau.setMajDate(date);
            }
            this.vhDal.updateBarreauxVH(barreaux);
        }
    }

    public void remiseAZeroBarreauxVH(String delegation, String centre, int circuit) {
        Date date = new Date();
        ConstantesPrismCommun.EnumVHTypeCCH vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.C1;
        try {
            vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.valueOf((String)((String)this.getConfiguration().get((Object)"vh.raz.valeur")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<BarreauVH> barreaux = this.getBarreauxVH(delegation, centre, circuit, true);
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreau : barreaux) {
                barreau.setMajDate(date);
                barreau.setCch(vhTypeCCH.getValue());
                barreau.setCch2(vhTypeCCH.getValue());
                barreau.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
                barreau.setEquipements(ConstantesPrismCommun.EnumVHTypeEquipement.NR.getValue());
                barreau.setEtatChaussee(ConstantesPrismCommun.EnumVHEtatChaussees.NR.getValue());
                barreau.setMeteo(ConstantesPrismCommun.EnumVHMeteo.NR.getValue());
                barreau.setTraitement(ConstantesPrismCommun.EnumVHTraitement.NR.getValue());
                barreau.setTemperature("NR");
                barreau.setVent(ConstantesPrismCommun.EnumVHVent.NR.getValue());
                barreau.setCommentaire("");
                barreau.setCommentaireInterne("");
            }
            this.vhDal.updateBarreauxVH(barreaux);
        }
    }

    public void previsionPatrouilleBarreauxVH(String delegation, String centre, int circuit) {
        Date date = new Date();
        ConstantesPrismCommun.EnumVHTypeCCH vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.C1;
        try {
            vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.valueOf((String)((String)this.getConfiguration().get((Object)"vh.raz.valeur")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<BarreauVH> barreaux = this.getBarreauxVH(delegation, centre, circuit, true);
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreau : barreaux) {
                barreau.setMajDate(date);
                barreau.setCch(vhTypeCCH.getValue());
                barreau.setCch2(vhTypeCCH.getValue());
                barreau.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
                barreau.setEquipements(ConstantesPrismCommun.EnumVHTypeEquipement.NR.getValue());
                barreau.setEtatChaussee(ConstantesPrismCommun.EnumVHEtatChaussees.NR.getValue());
                barreau.setMeteo(ConstantesPrismCommun.EnumVHMeteo.NR.getValue());
                barreau.setTraitement(ConstantesPrismCommun.EnumVHTraitement.NR.getValue());
                barreau.setTemperature("NR");
                barreau.setVent(ConstantesPrismCommun.EnumVHVent.NR.getValue());
                barreau.setCommentaire("");
                barreau.setCommentaireInterne("");
            }
            this.vhDal.updateBarreauxVH(barreaux);
        }
    }

    public List<BarreauVH> getBarreauxVH(String delegation, String centre, int circuit, boolean sansCoordonnees) {
        return this.referentielDal.getBarreauxVH(delegation, centre, circuit, sansCoordonnees);
    }

    public List<BarreauVH> getBarreauxVH(boolean sansCoordonnees, int bufferSize) {
        return this.referentielDal.getBarreauxVH(sansCoordonnees, bufferSize);
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierTroncons(Timestamp dateDebut, int bufferSize, int ratioParcours, boolean tronconPreCalcules) {
        return this.referentielDal.getStatistiqueSchemaRoutier(null, dateDebut, bufferSize, ratioParcours, tronconPreCalcules, null, true);
    }

    public List<String> getSchemaRoutierAxes(Delegation delegation, Centre centre) {
        return this.referentielDal.getSchemaRoutierAxes(delegation, centre);
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierTroncons(List<Centre> centres, Timestamp dateDebut, int bufferSize, int ratioParcours, boolean tronconPreCalcules, String axe) {
        return this.referentielDal.getStatistiqueSchemaRoutier(centres, dateDebut, bufferSize, ratioParcours, tronconPreCalcules, axe, true);
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierTroncons(List<Centre> centres, Timestamp dateDebut, int bufferSize, int ratioParcours, boolean tronconPreCalcules, String axe, boolean dateDernierPassageConnue) {
        return this.referentielDal.getStatistiqueSchemaRoutier(centres, dateDebut, bufferSize, ratioParcours, tronconPreCalcules, axe, dateDernierPassageConnue);
    }

    public void precalculSchemaRoutier() {
        int bufferSize = ConfigurationFactory.getInstance().getInt("carto.frequence.patrouille.buffer.size");
        Timestamp date = new Timestamp(Calendar.getInstance().getTimeInMillis());
        this.referentielDal.precalculSchemaRoutier(date, bufferSize);
    }

    public void precalculSchemaExploitation(String fonctionExploitation) {
        int bufferSize = ConfigurationFactory.getInstance().getInt("carto.frequence.patrouille.buffer.size");
        Timestamp date = new Timestamp(Calendar.getInstance().getTimeInMillis());
        this.referentielDal.precalculSchemaExploitation(fonctionExploitation, date, bufferSize);
    }

    public Map<String, Map<?, ?>> getIG4Configuration() {
        return this.ig4Dal.getIG4Configuration();
    }

    public void importTronconsPr(String table, String nomChamp, String fichierCSV) {
        this.importDal.importTronconsPr(table, nomChamp, fichierCSV);
    }

    public PrismCentralUser loginLDAP(String login) {
        Log.debug("SQLBusinessService : loginLDAP");
        return this.userDal.loginLDAP(login);
    }

    public Evenement getDernierEvenementActif(String idSit, String idEvt) {
        return this.evenements.getDernierEvenementActif(idSit, idEvt);
    }

    public Evenement getDernierEvenementActifAvecRecalculTerritoire(Evenement evt) {
        return this.evenements.getDernierEvenementActifAvecRecalculTerritoire(evt);
    }

    public int countUsersByProfile(int idProfil) {
        return this.adminDal.countUsersByProfile(idProfil);
    }

    public void deleteProfil(int idProfil) {
        this.adminDal.deleteProfil(idProfil);
    }

    public Date getDateGenerationStatSchemaRoutier() {
        return this.referentielDal.getDateGenerationStatSchemaRoutier();
    }

    public Nature getNatureFromDescription(String codeDescription) {
        return this.referentielDal.getNatureFromDescription(codeDescription);
    }

    public String getUserConnectionType(String login) {
        return this.userDal.getUserConnectionType(login);
    }

    public List<TypeUtilisateur> getTypesUtilisateur() {
        return this.referentielDal.getTypesUtilisateur();
    }

    public EvenementTriListe getEvenementTriListe(String codeNature) {
        return this.evenements.getEvenementTriListe(codeNature);
    }

    public Map<String, EvenementTriListe> getEvenementTriListe() {
        return this.evenements.getEvenementTriListe();
    }

    public void lancementTachesQuotidiennes() {
        try {
            this.anonymisation();
        }
        catch (Throwable t) {
            Log.error("Erreur lors de l'anonymisation", t);
        }
        try {
            this.effacerEvenementMission();
        }
        catch (Throwable t) {
            Log.error("Erreur lors de l'effacement des donn\u00e9es", t);
        }
        String typeCalculNiveauService = this.getConfiguration().getString("mct.niveauservice.calcul", "aucun");
        if (GLS.egal((String)typeCalculNiveauService, (String)"circuit")) {
            try {
                this.precalculEtatNiveauService();
            }
            catch (Throwable t) {
                Log.error("Erreur lors du pr\u00e9calcul du niveau de service", t);
            }
        } else if (GLS.egal((String)typeCalculNiveauService, (String)"schema_routier")) {
            try {
                Log.info("Lancement du  pr\u00e9calcul du sch\u00e9ma routier");
                this.precalculSchemaRoutier();
                Log.info("pr\u00e9calcul du sch\u00e9ma routier termin\u00e9");
            }
            catch (Throwable t) {
                Log.error("Erreur lors du pr\u00e9calcul du sch\u00e9ma routier", t);
            }
        }
        if (this.getModulesMetiers() != null && this.getModulesMetiers().containsKey(3)) {
            try {
                Log.info("Lancement du  pr\u00e9calcul du sch\u00e9ma fauchage");
                this.precalculSchemaExploitation("fauchage.mise_a_jour_stats_schema_fauchage_exploitation");
                Log.info("pr\u00e9calcul du sch\u00e9ma fauchage termin\u00e9");
            }
            catch (Throwable t) {
                Log.error("Erreur lors du pr\u00e9calcul du sch\u00e9ma fauchage", t);
            }
        }
    }

    public void nouvelleAction(ActionCentral a) {
        this.mcigDal.nouvelleAction(a);
    }

    public PatrouilleSemaineList getPatrouilleSemaineBean(Timestamp debut, Timestamp fin) {
        return this.evenements.getPatrouilleSemaineBean(debut, fin);
    }

    public List<BarreauVH> getBarreauVHMisAJour(Date dateDerniereVerification) {
        return this.vhDal.getTronconsVHMiseAJour(dateDerniereVerification);
    }

    public List<Patrouille> getPatrouilles(double lat, double lon, String delegation, String centre, int nbPatrouillesARechercher, Timestamp dateDebut, Timestamp dateFin) {
        return this.vehiculesDal.getPatrouilles(lat, lon, delegation, centre, nbPatrouillesARechercher, dateDebut, dateFin);
    }

    public List<Localisation> getLocalisationsPatrouille(String idMCIG) {
        return this.vehiculesDal.getLocalisationsPatrouille(idMCIG);
    }

    public Collection<TronconSuivi> getTronconPatrouille(String idPatrouille, boolean lateralize) {
        return this.vehiculesDal.getTronconPatrouille(idPatrouille, lateralize);
    }

    public List<Patrouille> getPatrouilles(String idPatrouille) {
        return this.vehiculesDal.getPatrouilles(idPatrouille);
    }

    public List<BarreauVH> getBarreauxVH(boolean sansCoordonnees, boolean sansCoordonnees2) {
        return this.referentielDal.getBarreauxVH(sansCoordonnees, sansCoordonnees2);
    }

    public List<BarreauVH> getBarreauxVH(String delegation, String centre, boolean sansCoordonnees, boolean sansCoordonnees2) {
        return this.referentielDal.getBarreauxVH(delegation, centre, sansCoordonnees, sansCoordonnees2);
    }

    public Date getHistoriqueCCHDate(Date dateHistoriqueRecherche) {
        return this.vhDal.getHistoriqueCCHDate(dateHistoriqueRecherche);
    }

    public List<BarreauVH> getHistoriqueCCHTroncon(Date datePublication) {
        return this.vhDal.getHistoriqueCCHTroncon(datePublication);
    }

    public List<BarreauVH> getHistoriqueTronconVH(Date dateHistoriqueRecherche) {
        return this.vhDal.getHistoriqueTronconVH(dateHistoriqueRecherche);
    }

    public boolean viserVehiculeEnIntervention(VehiculeEnIntervention v) {
        boolean etat = this.vehiculesDal.viserVehiculeEnIntervention(v);
        if (etat) {
            this.evenements.traitementApresVisaPatrouille(v);
        }
        return etat;
    }

    public boolean isEvenementHasPhoto(long idEvenement) {
        return this.evenements.isEvenementHasPhoto(idEvenement);
    }

    public SyntheseViseeBean getSyntheseViseeBean(Timestamp debut, Timestamp fin, int typePatrouille, String delegation, String centre) {
        return this.vehiculesDal.getSyntheseViseeBean(debut, fin, typePatrouille, delegation, centre);
    }

    public List<String> getCentresBulletin() {
        return this.vhDal.getCentresBulletin();
    }

    public List<String> getCentresBulletinOrdonnees() {
        return this.vhDal.getCentresBulletinOrdonnees();
    }

    public Collection<TronconSuivi> getTronconsSales(List<Integer> codeModuleMetier) {
        return this.vehiculesDal.getTronconsSales(codeModuleMetier);
    }

    public Collection<TronconSuivi> getTronconsDeneiges(List<Integer> codeModuleMetier) {
        return this.vehiculesDal.getTronconsDeneiges(codeModuleMetier);
    }

    public Collection<TronconSuivi> getTronconsSalageDeneigement(Set<String> idPatrouilleSuivi) {
        return this.vehiculesDal.getTronconsSalageDeneigement(idPatrouilleSuivi);
    }

    public List<String> getListeCaracteristiquesRoute() {
        return this.referentielDal.getListeCaracteristiquesRoute();
    }

    public List<FauchageExploitation> getFauchageExploitation(List<FiltreJava> filtresJava) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueFauchageBean> getStatistiqueFauchageTroncons(List<Centre> centres, Timestamp dateDebut, int bufferSize, int ratioParcours, boolean tronconPreCalcules, String axe) {
        return this.referentielDal.getStatistiqueFauchageTroncons(centres, dateDebut, bufferSize, ratioParcours, tronconPreCalcules, axe);
    }

    public Date getDateGenerationStatSchemaFauchage() {
        return this.referentielDal.getDateGenerationStatSchemaFauchage();
    }

    public List<SyntheseTableauBordStatistiqueFauchageBean> getFauchageStatistiqueSchema(List<Centre> centres, Timestamp dateMin, Timestamp dateMax, int bufferSize, int ratioParcours, String axe, boolean dateDernierPassageConnue) {
        return this.fauchageDal.getFauchageStatistiqueSchema(centres, dateMin, dateMax, bufferSize, ratioParcours, axe, dateDernierPassageConnue);
    }

    public List<String> getNiveauxExploitation() {
        return this.referentielDal.getNiveauxExploitation();
    }

    public List<String> getNiveauxExploitation(String table) {
        return this.referentielDal.getNiveauxExploitation(table);
    }

    public List<Ua> getUas() {
        return null;
    }

    public List<Ua> getUasScoop() {
        return null;
    }

    public void supprimerMarqueVehicule(MarqueVehicule typeVehicle) {
    }

    public void creerUa(Ua ua) {
    }

    public void updateUa(Ua ua) {
    }

    public void archiveUa(Ua ua) {
    }

    public Connection getConnectionForTransaction() throws DAOConfigurationException, SQLException {
        return null;
    }

    public Map<Integer, ModuleMetier> getScoopCorresModuleMetier() {
        return null;
    }

    public void importZoneOmbre(ZoneSensible zoneOmbrePrism) {
    }

    public void importBarreauxVH(BarreauVH barreauVh) {
    }

    public BulletinMediaVH2 initBulletinMediaVH() {
        return this.vhDal.initBulletinMediaVH();
    }

    public BulletinMediaVH2 getDernierBulletinMediaVH() {
        return this.vhDal.getDernierBulletinMediaVH();
    }

    public BulletinMediaVH2 getBulletinMediaVH(int id_bulletin) {
        return this.vhDal.getBulletinMediaVH(id_bulletin);
    }

    public void enregistrerBulletinMediaVH2(BulletinMediaVH2 bulletin) {
        this.vhDal.enregistrerBulletinMediaVH2(bulletin);
    }

    public BulletinInforoute getDernierBulletinInforoute() {
        return this.vhDal.getDernierBulletinInforoute();
    }

    public List<List<double[]>> localisationTroncon(String axe, String dptd, String prd, double abd, String dptf, String prf, double abf) {
        return null;
    }

    public List<Parametre> getParametres() {
        return null;
    }

    public void updateParametre(String k, String valeurString) {
    }

    public void deleteZonesOmbre() {
    }

    public void deleteBarreauxVH() {
    }

    public void miseAJourOrdreNature(List<Nature> natures) {
    }

    public void deleteCorrespondanceEvent(String[] ids) {
    }

    public void insertCorrespondanceEvent(List<NatureEtDescriptionScoop> listeCorres) {
    }

    public void deleteProfil(Profil profil) {
    }

    public void verifierDonneesVH() {
    }

    public ComposantBean getComposant(String nom, boolean withZoneRoutiere) {
        return null;
    }

    public boolean deleteComposant(String composant) {
        return this.referentielDal.deleteComposant(composant);
    }

    public Commune getCommune(String commune) {
        return this.referentielDal.getCommune(commune);
    }

    public ApachePoiConvert getApachePoiConvert(String idConfig) {
        return this.exportDal.getApachePoiConvert(idConfig);
    }

    public Rectangle2D getExtentMcig(List<String> mcigIds) {
        return this.mcigDal.getExtentMcig(mcigIds);
    }

    public List<String> getVehiculesEnInterventionActivites(VehiculeEnIntervention vehicule) {
        return this.vehiculesDal.getVehiculesEnInterventionActivites(vehicule);
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getModuleMetierSRStatistiqueSchema(ModuleMetier moduleMetier, List<Centre> centres, Timestamp dateMin, Timestamp dateMax, int bufferSize, int ratioParcours, String axe, boolean dateDernierPassageConnue) {
        return this.referentielDal.getModuleMetierStatistiqueSchema(moduleMetier, centres, dateMin, dateMax, bufferSize, ratioParcours, axe, dateDernierPassageConnue);
    }

    public void arriveeDomicile(PrismCentralUser u, MapDescription m) {
        this.mailService.arriveeDomicile(u, m);
    }

    public void visaIntervention(PrismCentralUser u, Evenement evenement) {
        this.mailService.visaIntervention(u, evenement);
    }

    public void cancelVisaIntervention(PrismCentralUser u, Evenement evenement) {
        this.mailService.cancelVisaIntervention(u, evenement);
    }

    public Map<String, Map<String, List<PrismAction>>> getListePrismActions() {
        return this.referentielDal.getListePrismActions();
    }

    public List<PrismAction> getPrismActions(String type, Evenement e) {
        return this.referentielDal.getPrismActions(type, e);
    }

    public DescriptionNature getDescriptionFromCode(String codeDescription) {
        return this.referentielDal.getDescriptionFromCode(codeDescription);
    }

    public Collection<? extends TronconSuivi> getTronconsSalageDeneigementActif(Set<String> patrouilles) {
        return this.vehiculesDal.getTronconsSalageDeneigementActif(patrouilles);
    }

    public List<NiveauServicePeriode> getNiveauxServicePeriodes(long id) {
        return this.referentielDal.getNiveauxServicePeriodes(id);
    }

    public List<SyntheseTableauBordFrequencePatrouilleV2Bean> getFrequencePatrouilleV2Troncons(Circuit circuit, Timestamp dateDebut, int bufferSize, double ratioParcours) {
        return this.referentielDal.getFrequencePatrouilleV2Troncons(circuit, dateDebut, bufferSize, ratioParcours);
    }

    public void validationPointsPassage(MainCourante m, Map<ZoneSensible, Long> l) {
        this.referentielDal.validationPointsPassage(m, l);
    }

    public Map<String, Long> getZonesValidees(String zone, long dateDebut, long dateFin) {
        return this.referentielDal.getZonesValidees(zone, dateDebut, dateFin);
    }

    public List<BarreauVHHisto> getBarreauxVHHistorique(String delegation, String centre, int circuit, boolean b, Date dateDebut, Date dateFin) {
        return this.vhDal.getBarreauxVHHistorique(delegation, centre, circuit, b, dateDebut, dateFin);
    }

    public List<BarreauVHHisto> getBarreauxVHExtend(String delegation, String centre, Integer circuit, boolean sansCoordonnees) {
        return this.referentielDal.getBarreauxVHExtend(delegation, centre, circuit, sansCoordonnees);
    }

    public List<BarreauVHHisto> getBarreauxVHHistorique(BarreauVH barreauVh, Date dateDebut, Date dateFin) {
        return this.vhDal.getBarreauxVHHistorique(barreauVh, dateDebut, dateFin);
    }

    public List<String> getSchemaAxes(Delegation delegation, Centre centre, String table) {
        return this.referentielDal.getSchemaAxes(delegation, centre, table);
    }

    public Map<Integer, List<String>> getListeCategoriesNatureMm() {
        return this.referentielDal.getListeCategoriesNatureMm();
    }

    public Map<String, String> getListeCategoriesNature() {
        return this.referentielDal.getListeCategoriesNature();
    }

    public List<Patrouille> getPatrouilles(List<Integer> modulesMetier, List<String> delegations, List<String> centres, Timestamp dateDebut, Timestamp dateFin) {
        return this.statsDal.getPatrouilles(modulesMetier, delegations, centres, dateDebut, dateFin);
    }

    public String getMCIGFromPatrouille(String patrouilleId) {
        return this.mcigDal.getMCIGFromPatrouille(patrouilleId);
    }

    public StatsCamionsVHBean getCamionsVH(Timestamp dateDebut, Timestamp dateFin, List<String> centres) {
        return this.vhDal.getCamionsVH(dateDebut, dateFin, centres);
    }

    public void updateUserPassword(String code, String newpwd, boolean hash) {
        this.adminDal.updateUserPassword(code, newpwd, hash);
    }

    public Map<Integer, Integer> getNbAgents(List<Integer> listeKEventId) {
        return this.evenements.getNbAgents(listeKEventId);
    }

    public String getDescriptionComposant(String nomComposant) {
        return this.referentielDal.getDescriptionComposant(nomComposant);
    }

    public HashMap<Integer, HashMap<String, Boolean>> getDestinatairesFonctionsMail(int idListeDestinataire) {
        return this.referentielDal.getDestinatairesFonctionsMail(idListeDestinataire);
    }

    public void updateDestinatairesFonctionsMail(int idListe, HashMap<Integer, HashMap<String, Boolean>> mapDiffusion) {
        this.adminDal.updateDestinatairesFonctionsMail(idListe, mapDiffusion);
    }

    public Map<String, List<String>> getAstreintesCommune() {
        return this.referentielDal.getAstreintesCommune();
    }

    public Map<String, Map<String, List<String>>> getTronconsAffectation() {
        return this.referentielDal.getTronconsAffectation();
    }

    public Map<String, List<Troncon>> getTronconsCentre() {
        return this.referentielDal.getTronconsCentre();
    }

    public List<FauchagePasseType> listeTypePasse() {
        return this.fauchageDal.listeTypePasse();
    }

    public void creerFauchagePasse(FauchagePasse passe) {
        this.fauchageDal.creerFauchagePasse(passe);
    }

    public void updateFauchagePasse(FauchagePasse passe) {
    }

    public void updateFauchageCircuitPasse(FauchageCircuitPasse passe) {
        this.fauchageDal.updateFauchageCircuitPasse(passe);
    }

    public List<FauchagePasse> rechercheFauchage(String delegation, String centre) {
        return this.fauchageDal.rechercheFauchage(delegation, centre);
    }

    public List<FauchageCircuitPasse> rechercheFauchageCircuitPasse(String delegation, String centre) {
        return this.fauchageDal.rechercheFauchageCircuit(delegation, centre);
    }

    public Collection<TronconSuivi> getTronconsPatrouilles(Set<String> idPatrouilleSuivi, boolean lateralized) {
        return this.vehiculesDal.getTronconsPatrouilles(idPatrouilleSuivi, lateralized);
    }

    public List<SynthesePatrouilleBean> getSynthesePatrouilleBean(Timestamp dateDebut, Timestamp dateFin, int typePatrouille, String delegation, String centre) {
        return this.vehiculesDal.getSynthesePatrouilleBean(dateDebut, dateFin, typePatrouille, delegation, centre);
    }

    public void associerEvenement(IEvenementASauvegarder event, String nouvelleSituation) {
        this.evenements.associerEvenement(event, nouvelleSituation);
    }

    public List<InformationInterventionBean> getInformationIntervention(Evenement e) {
        return this.exportDal.getInformationIntervention(e);
    }

    public List<InformationInterventionBean> getInformationIntervention(int keventid) {
        return this.exportDal.getInformationIntervention(keventid);
    }

    public boolean diffusionSynthesePatrouille(int deltaHeureAvant, List<Integer> codesModulesMetier) {
        return this.mailService.diffusionSynthesePatrouille(deltaHeureAvant, codesModulesMetier);
    }

    public SyntheseViseeBean getSynthesePatrouilleBean(Timestamp dateDebut, Timestamp dateFin, List<Integer> typePatrouille, String delegation, String centre) {
        return this.vehiculesDal.getSynthesePatrouilleBean(dateDebut, dateFin, typePatrouille, delegation, centre);
    }

    public Troncon getSchemaRoutierTroncons(int codeTroncon) {
        return this.referentielDal.getSchemaRoutierTroncons(codeTroncon);
    }

    public InfoTerritoire getTerritoireEvenementAxePr(Evenement evenement, IUtilisateur utilisateur, String axe, int pr, int abscisse, String dpt, boolean rechercheCentreGeometrie) throws RuntimeException {
        return this.evenements.getTerritoireEvenementAxePr(evenement, utilisateur, axe, pr, abscisse, dpt, rechercheCentreGeometrie);
    }

    public String getLibelleCorrespondance(String code) {
        return this.referentielDal.getLibelleCorrespondance(code);
    }

    public Map<String, Map<String, Map<Integer, Map<String, Integer>>>> getStatsSimplePatrouillesParAnnee(int annee) {
        return this.statsDal.getStatsSimplePatrouillesParAnnee(annee);
    }

    public InfoTerritoire getTerritoireEvenementGeometrieCentre(Evenement evenement, IUtilisateur utilisateur) throws RuntimeException {
        return this.evenements.getTerritoireEvenementGeometrieCentre(evenement, utilisateur);
    }

    public SyntheseInterventionAgentBean getSyntheseInterventionAgentBean(Timestamp dateDebutValue, Timestamp dateFinValue, String delegationValue, String centreValue, String agentValue) {
        return this.exportDal.getSyntheseInterventionAgentBean(dateDebutValue, dateFinValue, delegationValue, centreValue, agentValue);
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierHistorique(List<Centre> centres, Timestamp dateDebut, int bufferSize, int ratioParcours, boolean tronconPreCalcules, String axe, boolean dateDernierPassageConnu) {
        return this.statsDal.getStatistiqueSchemaRoutierHistorique(centres, dateDebut, bufferSize, ratioParcours, tronconPreCalcules, axe, dateDernierPassageConnu);
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistorique(int typeGestionPasse, Timestamp dateDebut, Timestamp dateFin, String delegation, String centre) {
        return this.statsDal.getStatistiqueSchemaFauchageHistorique(typeGestionPasse, delegation, centre, dateDebut, dateFin, 25, 1);
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistorique(int typeGestionPasse, String passeLibelle, String delegation, String centre) {
        return this.statsDal.getStatistiqueSchemaFauchageHistorique(typeGestionPasse, delegation, centre, passeLibelle, 25, 1);
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierHistorique(Timestamp dateDebut, Timestamp dateFin, int codeModuleMetier, String delegation, String centre) {
        return this.statsDal.getStatistiqueSchemaRoutierHistorique(dateDebut, dateFin, codeModuleMetier, delegation, centre);
    }

    public List<TronconStats> getRoadsAmplitude(String mcigId) {
        return this.statsDal.getRoadsAmplitude(mcigId);
    }

    public boolean diffusionEvenementsDepasses(String delegation, String centre) {
        return this.mailService.diffusionEvenementsDepasses(delegation, centre);
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, Integer> base;

        public ValueComparator(Map<String, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            if (this.base.get(a) >= this.base.get(b)) {
                return -1;
            }
            return 1;
        }
    }
}

