/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.maincourante;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAlternat;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImage;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImageMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampCoucheBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDate;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDateHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDecimal;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDocuments;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampEntier;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampImages;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLabel;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampOneDrive;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampPatrouilleProcedure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampRadioBouton;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampSignature;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampTexte;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVehiculeEnCause;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVraiFaux;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.export.csv.ChampCSV;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class CommentaireComposantFactory2
implements IComposantFactory {
    private static final String SEPARATEUR = " : ";
    private static final String CRLR = "\u00a7";
    private static final String ESPACE = " ";
    private static final String BULLET = "\u2022 ";
    public static final String CHAMP_NOUVEAU = "(+) ";
    public static final String CHAMP_MODIFIE = "(*) ";
    public static final String CHAMP_SUPPRIME = "(-) ";
    private static final String SEPARATEUR_LISTE = ", ";
    private DateFormat dateFormat;
    private DateFormat heureFormat;
    private DateFormat dateHeureFormat;

    public CommentaireComposantFactory2() {
        Locale locale = new Locale(ConfigurationFactory.getInstance().get("report.lang"));
        this.dateFormat = new SimpleDateFormat(ReportI18n.getString("format.date"), locale);
        this.heureFormat = new SimpleDateFormat(ReportI18n.getString("format.heure"), locale);
        this.dateHeureFormat = new SimpleDateFormat(ReportI18n.getString("format.dateheure"), locale);
    }

    public static Map<String, ChampCSV> getMapViewCommentaire(Nature n, IComposantFactory f) {
        LinkedHashMap<String, ChampCSV> mapView = new LinkedHashMap<String, ChampCSV>();
        for (Champ c : MetierCommun.getChampsFiltresTest((Nature)n)) {
            if (c.getNom().equals("description")) continue;
            mapView.putAll((Map)c.getView(f));
        }
        return mapView;
    }

    public static Map<String, String> getMapViewCommentaireString(Nature n, IComposantFactory f) {
        Map<String, ChampCSV> mapView = CommentaireComposantFactory2.getMapViewCommentaire(n, f);
        LinkedHashMap<String, String> mapViewString = new LinkedHashMap<String, String>();
        for (String k : mapView.keySet()) {
            mapViewString.put(k, mapView.get(k).getValeur());
        }
        return mapViewString;
    }

    public Object createView(ChampAlternat c) {
        throw new RuntimeException("not implemented");
    }

    public Object createView(ChampEntier c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (!c.isCheckbox() || c.isChecked()) {
            map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), String.valueOf(c.getValeur())));
        }
        return map;
    }

    public Object createView(ChampDecimal c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (!c.isCheckbox() || c.isChecked()) {
            map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), String.valueOf(c.getValeur())));
        }
        return map;
    }

    public Object createView(ChampDropListe c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (!GLS.estVide((String)c.getValeur())) {
            map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), c.getValeur()));
        }
        return map;
    }

    public Object createView(ChampLabel c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), c.getValeur()));
        return map;
    }

    public Object createView(ChampLocalisation c) {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    public Object createView(ChampMultiCheckBox c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        ArrayList<String> l = new ArrayList<String>();
        String libelle = "";
        boolean isListeParametres = false;
        if (c.getValeurs().size() == 1) {
            String[] stringArray = ConstantesPrismCommun.LISTE_PARAMETRES;
            int n = ConstantesPrismCommun.LISTE_PARAMETRES.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(c.getValeurs().get(0))) {
                    isListeParametres = true;
                    break;
                }
                ++n2;
            }
        }
        if (c.getValeurs().size() == 1 && !isListeParametres) {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                libelle = (String)c.getValeurs().get(0);
                if (!c.getValeursSelectionnee().isEmpty()) {
                    l.add(ReportI18n.getString("oui"));
                } else {
                    l.add(ReportI18n.getString("non"));
                }
            } else {
                libelle = String.valueOf(c.getLibelle()) + " - " + (String)c.getValeurs().get(0);
                if (!c.getValeursSelectionnee().isEmpty()) {
                    l.add(ReportI18n.getString("oui"));
                } else {
                    l.add(ReportI18n.getString("non"));
                }
            }
        } else {
            libelle = c.getLibelle() == null || c.getLibelle().isEmpty() ? GLS.getLibelleChampEnClair((String)c.getNom()) : c.getLibelle();
            for (String item : c.getValeursSelectionnee()) {
                l.add(BULLET.concat(ESPACE).concat(item));
            }
            if (c.getAutreValeur() != null) {
                l.add(BULLET.concat(ESPACE).concat(c.getAutreValeur()));
            }
        }
        if (!GLS.estVide(l)) {
            map.put(c.getNom(), new ChampCSV(c.getNom(), libelle, MetierCommun.getString(l, (String)SEPARATEUR_LISTE)));
        }
        return map;
    }

    public Object createView(ChampChoixImageMultiple c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        ArrayList<String> l = new ArrayList<String>();
        String libelle = "";
        if (c.getValeurs().size() == 1) {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                libelle = (String)c.getValeurs().get(0);
                if (!c.getValeursSelectionnee().isEmpty()) {
                    l.add(ReportI18n.getString("oui"));
                } else {
                    l.add(ReportI18n.getString("non"));
                }
            } else {
                libelle = String.valueOf(c.getLibelle()) + " - " + (String)c.getValeurs().get(0);
                if (!c.getValeursSelectionnee().isEmpty()) {
                    l.add(ReportI18n.getString("oui"));
                } else {
                    l.add(ReportI18n.getString("non"));
                }
            }
        } else {
            libelle = c.getLibelle() == null || c.getLibelle().isEmpty() ? GLS.getLibelleChampEnClair((String)c.getNom()) : c.getLibelle();
            for (String item : c.getValeursSelectionnee()) {
                l.add(BULLET.concat(ESPACE).concat(item));
            }
            if (c.getAutreValeur() != null) {
                l.add(BULLET.concat(ESPACE).concat(c.getAutreValeur()));
            }
        }
        if (!GLS.estVide(l)) {
            map.put(c.getNom(), new ChampCSV(c.getNom(), libelle, MetierCommun.getString(l, (String)SEPARATEUR_LISTE)));
        }
        return map;
    }

    public Object createView(ChampMultiple c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (!GLS.estVide((String)c.getLibelle())) {
            map.put(c.getLibelle(), new ChampCSV(c.getNom(), c.getLibelle(), "_"));
        }
        for (Champ champ : c.getChamps()) {
            LinkedHashMap m = (LinkedHashMap)champ.getView((IComposantFactory)this);
            if (champ instanceof ChampMultiple) {
                for (ChampCSV ccsv : m.values()) {
                    if (ccsv.getLibelle() == null) {
                        ccsv.setLibelle("-".concat(ESPACE).concat(GLS.getLibelleChampEnClair((String)ccsv.getCode())));
                        continue;
                    }
                    ccsv.setLibelle("-".concat(ESPACE).concat(ccsv.getLibelle()));
                }
            } else {
                for (ChampCSV ccsv : m.values()) {
                    if (ccsv.getLibelle() == null) {
                        ccsv.setLibelle("-".concat("> ").concat(GLS.getLibelleChampEnClair((String)ccsv.getCode())));
                        continue;
                    }
                    ccsv.setLibelle("-".concat("> ").concat(ccsv.getLibelle()));
                }
            }
            map.putAll(m);
        }
        if (map.size() == 1) {
            map.clear();
        }
        return map;
    }

    public Object createView(ChampRadioBouton c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), c.getValeurSelectionnee()));
        return map;
    }

    public Object createView(ChampTexte c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (!GLS.estVide((String)c.getValeur())) {
            map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), c.getValeur()));
        }
        return map;
    }

    public Object createView(ChampVraiFaux c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), c.getValeur() ? ReportI18n.getString("oui") : ReportI18n.getString("non")));
        return map;
    }

    public Object createView(ChampVehiculeEnCause c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (c.isDisplayVl() && c.getVl() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.vl")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.vl")), ReportI18n.getString("vec.vl"), String.valueOf(c.getVl())));
        }
        if (c.isDisplayPl() && c.getPl() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.pl")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.pl")), ReportI18n.getString("vec.pl"), String.valueOf(c.getPl())));
        }
        if (c.isDisplayVtc() && c.getVtc() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.tc")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.tc")), ReportI18n.getString("vec.tc"), String.valueOf(c.getVtc())));
        }
        if (c.isDisplayVelo() && c.getVelo() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.velo")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.velo")), ReportI18n.getString("vec.velo"), String.valueOf(c.getVelo())));
        }
        if (c.isDisplayTmd() && c.getTmd() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.tmd")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.tmd")), ReportI18n.getString("vec.tmd"), String.valueOf(c.getTmd())));
        }
        if (c.isDisplayAutres() && c.getAutres() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.autres")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.autres")), ReportI18n.getString("vec.autres"), String.valueOf(c.getAutres())));
        }
        if (c.isDisplayPietonCycle() && c.getPietonCycle() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.pietonCycle")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.pietonCycle")), ReportI18n.getString("vec.pietonCycle"), String.valueOf(c.getPietonCycle())));
        }
        if (c.isDisplayMoto() && c.getMoto() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.moto")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.moto")), ReportI18n.getString("vec.moto"), String.valueOf(c.getMoto())));
        }
        if (c.isDisplayCampingCar() && c.getCampingCar() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.campingCar")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.campingCar")), ReportI18n.getString("vec.campingCar"), String.valueOf(c.getCampingCar())));
        }
        if (c.isDisplayDeuxRoues() && c.getDeuxRoues() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.deuxRoues")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.deuxRoues")), ReportI18n.getString("vec.deuxRoues"), String.valueOf(c.getDeuxRoues())));
        }
        if (c.isDisplayScooter() && c.getScooter() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.scooter")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.scooter")), ReportI18n.getString("vec.scooter"), String.valueOf(c.getScooter())));
        }
        if (c.isDisplayCaravane() && c.getCaravane() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.caravane")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.caravane")), ReportI18n.getString("vec.caravane"), String.valueOf(c.getCaravane())));
        }
        if (c.isDisplayTrain() && c.getTrain() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.train")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.train")), ReportI18n.getString("vec.train"), String.valueOf(c.getTrain())));
        }
        if (c.isDisplayTramway() && c.getTramway() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.tramway")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.tramway")), ReportI18n.getString("vec.tramway"), String.valueOf(c.getTramway())));
        }
        if (c.isDisplayEnginAgricole() && c.getEnginAgricole() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.enginAgricole")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.enginAgricole")), ReportI18n.getString("vec.enginAgricole"), String.valueOf(c.getEnginAgricole())));
        }
        if (c.isDisplayAnimaux() && c.getAnimaux() > 0) {
            map.put(c.getNom().concat("-").concat(ReportI18n.getString("vec.animaux")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("vec.animaux")), ReportI18n.getString("vec.animaux"), String.valueOf(c.getAnimaux())));
        }
        return map;
    }

    public Object createView(ChampDate c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (c.isChecked()) {
            GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour());
            map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), this.dateFormat.format(cal.getTime())));
        }
        return map;
    }

    public Object createView(ChampDateHeure c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (c.isChecked()) {
            GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour(), c.getHeure(), c.getMinute());
            map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), this.dateHeureFormat.format(cal.getTime())));
        }
        return map;
    }

    public Object createView(ChampHeure c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (c.isChecked()) {
            GregorianCalendar cal = new GregorianCalendar(0, 0, 0, c.getHeure(), c.getMinute());
            map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), this.heureFormat.format(cal.getTime())));
        }
        return map;
    }

    public void setChampLectureSeule(boolean lectureSeule) {
    }

    public Object createView(ChampPatrouilleProcedure c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        if (!this.competenceVide(c)) {
            if (this.competenceCg(c)) {
                map.put(c.getNom().concat("-").concat(ReportI18n.getString("pp.competence")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("pp.competence")), ReportI18n.getString("pp.competence"), String.valueOf(c.getValeur().getCompetence())));
                String urgence = c.getValeur().isUrgence() ? ReportI18n.getString("oui") : ReportI18n.getString("non");
                map.put(c.getNom().concat("-").concat(ReportI18n.getString("pp.urgence")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("pp.urgence")), ReportI18n.getString("pp.urgence"), urgence));
                if (c.getValeur().isUrgence()) {
                    String immediat = c.getValeur().getImmediate() ? ReportI18n.getString("oui") : ReportI18n.getString("non");
                    map.put(c.getNom().concat("-").concat(ReportI18n.getString("pp.immediat")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("pp.immediat")), ReportI18n.getString("pp.immediat"), immediat));
                    map.put(c.getNom().concat("-").concat(ReportI18n.getString("pp.mesure")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("pp.mesure")), ReportI18n.getString("pp.mesure"), c.getValeur().getMesure()));
                }
            } else {
                String urgence = c.getValeur().isUrgence() ? ReportI18n.getString("oui") : ReportI18n.getString("non");
                map.put(c.getNom().concat("-").concat(ReportI18n.getString("pp.urgence")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("pp.urgence")), ReportI18n.getString("pp.urgence"), urgence));
                String immediat = c.getValeur().getImmediate() ? ReportI18n.getString("oui") : ReportI18n.getString("non");
                map.put(c.getNom().concat("-").concat(ReportI18n.getString("pp.immediat")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("pp.immediat")), ReportI18n.getString("pp.immediat"), immediat));
                map.put(c.getNom().concat("-").concat(ReportI18n.getString("pp.mesure")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("pp.mesure")), ReportI18n.getString("pp.mesure"), c.getValeur().getMesure()));
                if (c.getValeur().getCompteRendu()) {
                    map.put(c.getNom().concat("-").concat(ReportI18n.getString("pp.compterendu")), new ChampCSV(c.getNom().concat("-").concat(ReportI18n.getString("pp.compterendu")), ReportI18n.getString("pp.compterendu"), c.getValeur().getCompetence()));
                }
            }
        }
        return map;
    }

    private boolean competenceVide(ChampPatrouilleProcedure champ) {
        return champ.getValeur().getCompetence() == null || champ.getValeur().getCompetence().equals("");
    }

    private boolean competenceCg(ChampPatrouilleProcedure champ) {
        String competenceCg = champ.getCompetenceCg();
        String competenceSelect = champ.getValeur().getCompetence();
        boolean isCompetenceCg = competenceCg.equals(competenceSelect);
        return isCompetenceCg;
    }

    public Object createView(ChampChoixImage c) {
        LinkedHashMap<String, ChampCSV> map = new LinkedHashMap<String, ChampCSV>();
        map.put(c.getNom(), new ChampCSV(c.getNom(), c.getLibelle(), c.getValeurSelectionnee()));
        return map;
    }

    public Object createView(ChampImages champImage) {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    public Object createView(ChampSignature champSignature) {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    public Object createView(ChampDocuments champDocuments) {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    public Object createView(ChampCoucheBox champCoucheBox) {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    public Object createView(ChampOneDrive champOneDrive) {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }
}

