/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.mail;

import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.IFileAttachment;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import gls.outils.GLSDate;
import java.io.File;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import prism.commun.DistrictAdmin;
import prism.commun.vh.MetiersVH;
import prism.commun.vh.document.synthese.SyntheseDir;

public class VHAttachment
implements IFileAttachment {
    private IBusinessService service;
    private String filename;
    private File content;

    public VHAttachment(IBusinessService service) {
        this.service = service;
        this.filename = ConfigurationFactory.getInstance().get("dir.tmp").concat(this.getNomFichier()).concat(".pdf");
    }

    private String getNomFichier() {
        StringBuffer s = new StringBuffer();
        s.append("viabilite_hivernale_");
        GLS.getDate();
        GLS.getDate();
        s.append(GLSDate.toDateComplete((Calendar)GLSDate.maintenant()).replace("/", "-").replace(":", "-").replace(" ", "_"));
        return s.toString();
    }

    public File getFile() {
        if (this.content == null) {
            this.generate();
        }
        return this.content;
    }

    public String getFileName() {
        return this.filename;
    }

    public synchronized void generate() {
        SyntheseDir s = new SyntheseDir();
        Vector<DistrictAdmin> v = new Vector<DistrictAdmin>();
        for (Delegation d : this.service.getDelegations()) {
            List l = this.service.getBarreauxVH(d.getNom(), null, true);
            DistrictAdmin district = new DistrictAdmin();
            district.setLibelle(d.getNom());
            district.setEvenementsVh(MetiersVH.convertir((List)l));
            v.add(district);
        }
        String repertoireCarto = ConfigurationFactory.getInstance().get("cartoj.chemin").concat("/").concat(ConfigurationFactory.getInstance().get("cartoj.nom_carto")).concat("/");
        String logo = ConfigurationFactory.getInstance().get("logo");
        String cheminCarto = repertoireCarto.concat("carto/");
        String cheminFondsCarto = repertoireCarto.concat("fonds/");
        try {
            s.genererSynthese(this.filename, logo, ConfigurationFactory.getInstance().get("zoneroutiere"), cheminCarto, cheminFondsCarto, cheminCarto, this.service.getSyntheseSerpeVH().getCommentaire(), v, false);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        this.content = new File(this.filename);
    }
}

