/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.mail;

import com.geolocsystems.prismbirtbean.SyntheseViseeBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.beans.IFileAttachment;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.SyntheseViseeExport;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import gls.outils.GLSDate;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SynthesePatrouilleAttachement
implements IFileAttachment {
    private IBusinessService service;
    private String filename;
    private File content;
    int deltaHeureAvant;
    List<Integer> codesModulesMetier;
    private Timestamp dateDebutValue;
    private Timestamp dateFinValue;
    private SyntheseViseeBean syntheseViseeBean;

    public SynthesePatrouilleAttachement(IBusinessService service, int deltaHeureAvant, List<Integer> codesModulesMetier) {
        this.service = service;
        this.filename = ConfigurationFactory.getInstance().get("dir.tmp").concat(this.getNomFichier()).concat(".pdf");
        this.deltaHeureAvant = deltaHeureAvant;
        this.codesModulesMetier = codesModulesMetier;
    }

    private String getNomFichier() {
        StringBuffer s = new StringBuffer();
        s.append("synthese_patrouille_");
        GLS.getDate();
        GLS.getDate();
        s.append(GLSDate.toDateComplete((Calendar)GLSDate.maintenant()).replace("/", "-").replace(":", "-").replace(" ", "_"));
        return s.toString();
    }

    public File getFile() {
        if (this.content == null) {
            this.generate();
        }
        return this.content;
    }

    public String getFileName() {
        return this.filename;
    }

    public SyntheseViseeBean getSyntheseViseeBean() {
        return this.syntheseViseeBean;
    }

    public synchronized void generate() {
        Calendar dateDebutCalendar = Calendar.getInstance();
        dateDebutCalendar.add(11, 0 - this.deltaHeureAvant);
        this.dateDebutValue = new Timestamp(dateDebutCalendar.getTimeInMillis());
        Calendar dateFinCalendar = Calendar.getInstance();
        this.dateFinValue = new Timestamp(dateFinCalendar.getTimeInMillis());
        this.syntheseViseeBean = null;
        if (this.dateFinValue != null && this.dateFinValue.before(this.dateDebutValue)) {
            this.content = null;
        } else {
            String titresMM = this.service.getConfiguration().getString("report.synthese.patrouille.titresMM");
            String titre = "Liste des patrouilles VH et des tourn\u00e9es d'itin\u00e9raires";
            if (this.codesModulesMetier != null && this.codesModulesMetier.size() > 0) {
                switch (this.codesModulesMetier.get(0)) {
                    case 0: {
                        titre = "Liste des tourn\u00e9es d'itin\u00e9raires";
                        break;
                    }
                    case 1: {
                        titre = "Liste des patrouilles VH";
                        break;
                    }
                    default: {
                        titre = "Liste des patrouilles VH et des tourn\u00e9es d'itin\u00e9raires";
                    }
                }
                if (titresMM != "" && titresMM.contains(":")) {
                    String[] listeTitres;
                    String[] stringArray = listeTitres = titresMM.split(";");
                    int n = listeTitres.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String keyTitre = stringArray[n2];
                        String[] values = keyTitre.split(":");
                        if (Integer.valueOf(values[0]) == this.codesModulesMetier.get(0)) {
                            titre = values[1];
                        }
                        ++n2;
                    }
                }
            }
            this.syntheseViseeBean = this.service.getSynthesePatrouilleBean(this.dateDebutValue, this.dateFinValue, this.codesModulesMetier, null, null);
            Log.debug("synthesePatrouillesBean : " + this.syntheseViseeBean);
            this.syntheseViseeBean.setNomDelegation(this.service.getConfiguration().getString("global.delegation", PrismI18n.getString("global.delegation")));
            this.syntheseViseeBean.setNomCentre(this.service.getConfiguration().getString("global.centre", PrismI18n.getString("global.centre")));
            this.syntheseViseeBean.setLibelleVisa(this.service.getConfiguration().getString("report.synthese.patrouille.libelle.visa", PrismI18n.getString("report.synthese.patrouille.libelle.visa")));
            if (this.syntheseViseeBean.getLibelleVisa().equals("")) {
                this.syntheseViseeBean.setLibelleVisa("Visa chef CERD");
            }
            this.syntheseViseeBean.setAfficheSecteur(this.service.getConfiguration().getBoolean("report.synthese.patrouille.affiche.secteur", true));
            this.syntheseViseeBean.setAfficheDelegation(this.service.getConfiguration().getBoolean("report.synthese.patrouille.affiche.delegation", true));
            this.syntheseViseeBean.setAfficheVisa(this.service.getConfiguration().getBoolean("report.synthese.patrouille.affiche.visa", false));
            this.syntheseViseeBean.setDureeTexte(this.service.getConfiguration().getBoolean("report.synthese.patrouille.affiche.duree.texte", true));
            this.syntheseViseeBean.setAffichageCumulV2(this.service.getConfiguration().getBoolean("report.synthese.patrouille.affiche.cumul.v2", true));
            this.syntheseViseeBean.setTitre(titre);
            SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            this.syntheseViseeBean.setDateDebut(sdfDate.format(new Date(this.dateDebutValue.getTime())));
            if (this.dateFinValue != null) {
                this.syntheseViseeBean.setDateFin(sdfDate.format(new Date(this.dateFinValue.getTime())));
            } else {
                this.syntheseViseeBean.setDateFin("-");
            }
            this.syntheseViseeBean.setArrondissement("Tous");
            this.syntheseViseeBean.setCerd("Tous");
            Log.debug(this.syntheseViseeBean);
            Object image = null;
            try {
                String dateFin = "";
                dateFin = this.dateFinValue == null ? "01/01/2030" : sdfDate.format(new Date(this.dateFinValue.getTime()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                int lu;
                InputStream in = null;
                in = new SyntheseViseeExport().export(this.syntheseViseeBean, "PDF");
                File f = File.createTempFile("synthesePatrouilles", ".pdf");
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buffer = new byte[4096];
                while ((lu = in.read(buffer)) != -1) {
                    output.write(buffer, 0, lu);
                }
                output.flush();
                output.close();
                in.close();
                this.content = f;
            }
            catch (Throwable e) {
                Log.error(e.getMessage(), e);
                e.printStackTrace();
            }
        }
    }

    public void GenerateImage(SyntheseViseeBean synthese) {
    }
}

