/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.partenaire.axione;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.Commune;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.partenaire.axione.PartenaireAxioneConfigFactory;
import com.geolocsystems.prismcentral.export.partenaire.axione.PartenaireAxioneIConfiguration;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.pool.AbstractConnPool;

public final class PartenaireAxioneExport {
    public static final String AXIONE_TYPE_EQUIPEMENT_POTEAU = "Poteau";
    public static final String AXIONE_TYPE_EQUIPEMENT_CABLE_AERIEN = "C\u00e2ble a\u00e9rien";
    public static final String AXIONE_TYPE_EQUIPEMENT_TRAPPE_PLAQUE = "Trappe - plaque au sol";
    public static final String AXIONE_TYPE_EQUIPEMENT_ARMOIRE_TROTTOIR = "Armoire sur trottoir";
    public static final String AXIONE_TYPE_EQUIPEMENT_COFFRET_POTEAU_FACADE = "Coffret sur poteau ou fa\u00e7ade";
    public static final String AXIONE_TYPE_EQUIPEMENT_SHELTER_LOCAL = "Shelter - local technique";
    public static final String AXIONE_TYPE_EQUIPEMENT_CABLE_SOUTERRAIN = "C\u00e2ble souterrain";
    public static final String PATH_CREATE_DOMMAGE = "/api/v1/dommages/add";
    public static final String PATH_ADD_PHOTO = "/api/v1/dommages/%s/addPhoto";
    private static final Gson gson = new GsonBuilder().create();
    private final IBusinessService service;

    public PartenaireAxioneExport(IBusinessService service) {
        this.service = service;
    }

    private CloseableHttpClient getClientHttp() {
        return HttpClients.createDefault();
    }

    public void exportEvenement(Partenaire partenaire, Evenement evenement) {
        block50: {
            PartenaireAxioneIConfiguration config = PartenaireAxioneConfigFactory.getConfig(ConfigurationFactory.getInstance().get("zoneroutiere"));
            if (config == null) {
                throw new IllegalStateException("Pas de configuration PartenaireAxione pour la zone routi\u00e8re '" + ConfigurationFactory.getInstance().get("zoneroutiere") + "'");
            }
            Log.debug("[EXPORT EVT AXIONE] Inputstream - config ok partenaire" + partenaire.getDescription());
            Nature n = (Nature)DeepCopy.copy((Object)((Nature)this.service.getNatures().get(evenement.getValeurNature().getCode())));
            n.chargerValeurs(evenement.getValeurNature());
            Map mapChamps = MetierCommun.getMapChamps((Nature)n, (Evenement)evenement);
            DommageInformation info = new DommageInformation();
            String typeEquipement = null;
            String typeProbleme = null;
            if (mapChamps.containsKey(config.champEtatPoteau())) {
                typeEquipement = AXIONE_TYPE_EQUIPEMENT_POTEAU;
                typeProbleme = (String)mapChamps.get(config.champEtatPoteau());
            } else if (mapChamps.containsKey(config.champEtatCableAerien())) {
                typeEquipement = AXIONE_TYPE_EQUIPEMENT_CABLE_AERIEN;
                typeProbleme = (String)mapChamps.get(config.champEtatCableAerien());
            } else if (mapChamps.containsKey(config.champEtatTrappePlaque())) {
                typeEquipement = AXIONE_TYPE_EQUIPEMENT_TRAPPE_PLAQUE;
                typeProbleme = (String)mapChamps.get(config.champEtatTrappePlaque());
            } else if (mapChamps.containsKey(config.champEtatArmoireTrottoir())) {
                typeEquipement = AXIONE_TYPE_EQUIPEMENT_ARMOIRE_TROTTOIR;
                typeProbleme = (String)mapChamps.get(config.champEtatArmoireTrottoir());
            } else if (mapChamps.containsKey(config.champEtatCoffretPoteauFacade())) {
                typeEquipement = AXIONE_TYPE_EQUIPEMENT_COFFRET_POTEAU_FACADE;
                typeProbleme = (String)mapChamps.get(config.champEtatCoffretPoteauFacade());
            } else if (mapChamps.containsKey(config.champEtatShelterLocal())) {
                typeEquipement = AXIONE_TYPE_EQUIPEMENT_SHELTER_LOCAL;
                typeProbleme = (String)mapChamps.get(config.champEtatShelterLocal());
            } else if (mapChamps.containsKey(config.champEtatCableSouterrain())) {
                typeEquipement = AXIONE_TYPE_EQUIPEMENT_CABLE_SOUTERRAIN;
                typeProbleme = (String)mapChamps.get(config.champEtatCableSouterrain());
            }
            Commune commune = this.service.getCommune(evenement.getLocalisation().getCommune());
            info.adresse = String.valueOf(commune.getCodePostal()) + " " + commune.getNom();
            info.coordonneesGps = new CoordonneesGps(n.getLocalisation().getPositionDebut());
            info.dangerEstGrave = Optional.ofNullable(config.champDangerGrave()).map(mapChamps::get).orElse("non").equalsIgnoreCase("oui");
            info.dsp = config.dsp();
            info.natureDeposant = config.natureDeposant();
            info.roleDeposant = config.roleDeposant();
            info.typeEquipement = typeEquipement;
            info.typeProbleme = typeProbleme;
            info.nomPrenomDeposant = config.nomPrenomDeposant();
            info.emailDeposant = config.emailDeposant();
            info.telephoneDeposant = config.telephoneDeposant();
            info.deposantEstVictime = false;
            info.localisation_topologie = Optional.ofNullable(config.champLocalisationTopologie()).map(mapChamps::get).orElse(info.typeEquipement.equals(AXIONE_TYPE_EQUIPEMENT_POTEAU) ? "Accotement" : (info.typeEquipement.equals(AXIONE_TYPE_EQUIPEMENT_CABLE_AERIEN) ? "Entre 2 poteaux" : (info.typeEquipement.equals(AXIONE_TYPE_EQUIPEMENT_TRAPPE_PLAQUE) ? "Chauss\u00e9e" : null)));
            Log.debug("[EXPORT EVT AXIONE] HTTPS CLIENTS CREATE - ");
            Log.debug(CloseableHttpClient.class.getProtectionDomain().getCodeSource().getLocation());
            Log.debug(AbstractConnPool.class.getProtectionDomain().getCodeSource().getLocation());
            try {
                try {
                    Throwable throwable = null;
                    Object var13_14 = null;
                    try (CloseableHttpClient httpClient = this.getClientHttp();){
                        Log.debug("[EXPORT EVT AXIONE] HTTPS CLIENT CREATED " + partenaire.getNomServeur() + PATH_CREATE_DOMMAGE);
                        HttpPost dommagePost = new HttpPost(String.valueOf(partenaire.getNomServeur()) + PATH_CREATE_DOMMAGE);
                        dommagePost.setEntity((HttpEntity)new StringEntity(gson.toJson((Object)info), ContentType.APPLICATION_JSON));
                        Log.debug("[EXPORT EVT AXIONE] URI " + dommagePost.getURI().toString());
                        Throwable throwable2 = null;
                        Object var17_20 = null;
                        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)dommagePost);){
                            InputStream in = httpResponse.getEntity().getContent();
                            String inputString = IOUtils.toString((InputStream)in);
                            Log.debug("[EXPORT EVT AXIONE] Inputstream - " + inputString);
                            ResponseCreateDommage responseCreateDommage = (ResponseCreateDommage)gson.fromJson(inputString, ResponseCreateDommage.class);
                            if ("1200".equals(responseCreateDommage.code)) {
                                String photoPath = String.format(PATH_ADD_PHOTO, responseCreateDommage.idDommage);
                                JsonObject errors = new JsonObject();
                                for (String photoHash : evenement.getPhotos()) {
                                    byte[] data = this.service.getPhoto(photoHash);
                                    HttpEntity multipart = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA).addBinaryBody("file", data, ContentType.IMAGE_JPEG, String.valueOf(photoHash) + ".jpeg").build();
                                    Log.debug("[EXPORT EVT AXIONE] HAS PHOTOS - ");
                                    HttpPut photoPut = new HttpPut(String.valueOf(partenaire.getNomServeur()) + photoPath);
                                    photoPut.setEntity(multipart);
                                    Throwable throwable3 = null;
                                    Object var30_35 = null;
                                    try (CloseableHttpResponse photoHttpResponse = httpClient.execute((HttpUriRequest)photoPut);){
                                        ResponseAddPhoto responseAddPhoto = (ResponseAddPhoto)gson.fromJson((Reader)new InputStreamReader(photoHttpResponse.getEntity().getContent()), ResponseAddPhoto.class);
                                        Log.debug("[EXPORT EVT AXIONE] ADD PHOTO - " + responseAddPhoto.code);
                                        if ("1400".equals(responseAddPhoto.code)) continue;
                                        errors.add(photoHash, gson.toJsonTree((Object)responseAddPhoto));
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable3 == null) {
                                            throwable3 = throwable4;
                                        } else if (throwable3 != throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                        throw throwable3;
                                    }
                                }
                                if (errors.size() > 0) {
                                    throw new RuntimeException(gson.toJson((JsonElement)errors));
                                }
                                break block50;
                            }
                            throw new RuntimeException("(" + responseCreateDommage.code + ") " + responseCreateDommage.message);
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Log.error("[EXPORT EVT AXIONE] ERROR CREATION HTTPS CLIENT ", e);
                    throw new RuntimeException(e);
                }
                catch (Throwable t) {
                    Log.error("[EXPORT EVT AXIONE] ERROR GLOBALE", t);
                    throw t;
                }
            }
            finally {
                Log.debug("[EXPORT EVT AXIONE] END OF FUNCTION ");
            }
        }
    }

    private static class CoordonneesGps {
        public float latWGS84;
        public float longWGS84;

        public CoordonneesGps(Position position) {
            this.latWGS84 = position.getY();
            this.longWGS84 = position.getX();
        }
    }

    private static class DommageInformation {
        public String adresse;
        public CoordonneesGps coordonneesGps;
        public Boolean dangerEstGrave;
        public String dsp;
        public String natureDeposant;
        public String roleDeposant;
        public String typeEquipement;
        public String typeProbleme;
        public String nomPrenomDeposant;
        public String emailDeposant;
        public String telephoneDeposant;
        public Boolean deposantEstVictime;
        public String nomPrenomVictime;
        public String emailVictime;
        public String telephoneVictime;
        public String commentaire;
        public String localisation_topologie;

        private DommageInformation() {
        }
    }

    private static class ResponseAddPhoto {
        public String code;
        public String message;

        private ResponseAddPhoto() {
        }
    }

    private static class ResponseCreateDommage {
        public String code;
        public String message;
        public String idDommage;

        private ResponseCreateDommage() {
        }
    }
}

