/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.libreoffice;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImage;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampEntier;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentral.export.libreoffice.DocumentConverter;
import com.geolocsystems.prismcentral.export.libreoffice.ReportComposantFactory;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.PrismConfigurationError;
import gls.outils.GLS;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.jooreports.templates.DocumentTemplate;
import net.sf.jooreports.templates.DocumentTemplateException;
import net.sf.jooreports.templates.DocumentTemplateFactory;
import net.sf.jooreports.templates.image.FileImageSource;
import net.sf.jooreports.templates.image.RenderedImageSource;

public class SituationExportLibreOffice {
    private DateFormat dateFormat;
    private DateFormat heureFormat;
    private File basedir;
    private boolean indatabase;
    private IBusinessService service;

    public SituationExportLibreOffice(IBusinessService service) {
        this.service = service;
        Locale locale = new Locale(ConfigurationFactory.getInstance().get("report.lang"));
        this.dateFormat = new SimpleDateFormat(ReportI18n.getString("format.date"), locale);
        this.heureFormat = new SimpleDateFormat(ReportI18n.getString("format.heure"), locale);
        this.basedir = new File(ConfigurationFactory.getInstance().get("photo.repertoire"));
        this.indatabase = Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photo.usedatabase"));
    }

    public InputStream generate(List<Situation> situations, String format, PrismCentralUser user, List<String[]> criteres) throws IOException, DocumentTemplateException {
        File templateFile = new File(ConfigurationFactory.getInstance().get("report.ficheevt.template"));
        String typeFiche = ConfigurationFactory.getInstance().get("report.ficheevt.type");
        if (GLS.estVide((String)typeFiche)) {
            typeFiche = "base";
        }
        DocumentTemplateFactory documentTemplateFactory = new DocumentTemplateFactory();
        DocumentTemplate template = documentTemplateFactory.getTemplate(templateFile);
        File outfile = File.createTempFile("export", ".odt");
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(outfile));
        Map<String, Object> map = this.getMap(situations, user, criteres, typeFiche);
        template.createDocument(map, (OutputStream)stream);
        stream.flush();
        stream.close();
        File finalFile = IExportService.FORMATS.estODT((String)format) ? outfile : DocumentConverter.convert(outfile, IExportService.FORMATS.getExtension((String)format));
        BufferedInputStream reponse = new BufferedInputStream(new FileInputStream(finalFile));
        return reponse;
    }

    private Map<String, Object> getMap(List<Situation> situations, PrismCentralUser user, List<String[]> criteres, String typeFiche) {
        Map natures = this.service.getNatures();
        ReportComposantFactory factory = new ReportComposantFactory();
        HashMap<String, Object> root = new HashMap<String, Object>();
        if (user != null) {
            root.put("username", user.getNom());
        }
        if (criteres != null) {
            ArrayList criteresList = new ArrayList();
            for (String[] critere : criteres) {
                HashMap<String, String> critereMap = new HashMap<String, String>();
                critereMap.put("cle", critere[0]);
                critereMap.put("valeur", critere[1]);
                criteresList.add(critereMap);
            }
            root.put("criteres", criteresList);
        }
        Date d = new Date();
        root.put("date", this.dateFormat.format(d));
        root.put("heure", this.heureFormat.format(d));
        ArrayList list = new ArrayList();
        root.put("evts", list);
        int cout1 = 0;
        int cout2 = 0;
        int cout3 = 0;
        int i = 0;
        while (i < situations.size()) {
            Situation situation = situations.get(i);
            int y = 0;
            while (y < situation.getEvenements().size()) {
                HashMap<String, String> champMap;
                String value;
                boolean modification;
                Evenement evenement = (Evenement)situation.getEvenements().get(y);
                Nature n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(evenement.getValeurNature().getCode())));
                n.chargerValeurs(evenement.getValeurNature());
                HashMap<String, Object> mapEvenement = new HashMap<String, Object>();
                mapEvenement.put("nature", n.getLabel());
                mapEvenement.put("date", this.dateFormat.format(new Date(evenement.getDateCreation())));
                mapEvenement.put("heure", this.heureFormat.format(new Date(evenement.getDateCreation())));
                boolean bl = modification = evenement.getDateCreation() != evenement.getDateMaj();
                if (modification) {
                    Evenement premiereVersion;
                    mapEvenement.put("datemaj", this.dateFormat.format(new Date(evenement.getDateMaj())));
                    mapEvenement.put("heuremaj", this.heureFormat.format(new Date(evenement.getDateMaj())));
                    List l = this.service.getEvenements(IBusinessService.EvenementFiltre.getPremiereVersion((String)evenement.getIdSituation(), (String)evenement.getIdReference()), null);
                    if (l != null && !l.isEmpty() && !((Situation)l.get(0)).getEvenements().isEmpty() && (premiereVersion = (Evenement)((Situation)l.get(0)).getEvenements().get(0)) != null) {
                        mapEvenement.put("codeutilisateurcreation", premiereVersion.getCodeUtilisateur());
                        mapEvenement.put("nomutilisateurcreation", this.service.getUtilisateur(premiereVersion.getCodeUtilisateur()).getNom());
                    }
                    mapEvenement.put("codeutilisateur", evenement.getCodeUtilisateur());
                    mapEvenement.put("nomutilisateur", this.service.getUtilisateur(evenement.getCodeUtilisateur()).getNom());
                    if (this.service.getConfiguration().getBoolean("afficheIdEvenement", false)) {
                        mapEvenement.put("codeEvenement", " - " + evenement.getCodeEvenement() + " ");
                    } else {
                        mapEvenement.put("codeEvenement", "");
                    }
                    if (evenement.isTermine()) {
                        mapEvenement.put("derniereAction", ReportI18n.getString("report.evenement.cloture"));
                    } else if (evenement.isProgramme()) {
                        mapEvenement.put("derniereAction", ReportI18n.getString("report.evenement.programme"));
                    } else {
                        mapEvenement.put("derniereAction", ReportI18n.getString("report.evenement.modifie"));
                    }
                    mapEvenement.put("premiereAction", ReportI18n.getString("report.evenement.cree"));
                } else {
                    if (this.service.getConfiguration().getBoolean("afficheIdEvenement", false)) {
                        mapEvenement.put("codeEvenement", " - " + evenement.getCodeEvenement() + " ");
                    } else {
                        mapEvenement.put("codeEvenement", "");
                    }
                    mapEvenement.put("codeutilisateurcreation", evenement.getCodeUtilisateur());
                    mapEvenement.put("nomutilisateurcreation", this.service.getUtilisateur(evenement.getCodeUtilisateur()).getNom());
                    if (evenement.isTermine()) {
                        mapEvenement.put("premiereAction", ReportI18n.getString("report.evenement.creecloture"));
                    } else if (evenement.isProgramme()) {
                        mapEvenement.put("premiereAction", ReportI18n.getString("report.evenement.creeprogramme"));
                    } else {
                        mapEvenement.put("premiereAction", ReportI18n.getString("report.evenement.cree"));
                    }
                }
                if (evenement.isTermine()) {
                    mapEvenement.put("etatEvenement", ReportI18n.getString("report.evenement.etatcloture"));
                } else if (evenement.isProgramme()) {
                    mapEvenement.put("etatEvenement", ReportI18n.getString("report.evenement.etatprogramme"));
                } else {
                    mapEvenement.put("etatEvenement", ReportI18n.getString("report.evenement.etatencours"));
                }
                Map champsMap = MetierCommun.getChamps((List)n.getChamps());
                List champs = MetierCommun.getChampsFiltresTest((List)n.getChamps(), (Map)champsMap);
                ArrayList champsList = new ArrayList();
                if (typeFiche.equals("base")) {
                    for (Champ c : champs) {
                        value = (String)c.getView((IComposantFactory)factory);
                        if (!GLS.estVide((String)value)) {
                            champMap = new HashMap<String, String>();
                            champMap.put("name", this.getLibelleChamp(c));
                            champMap.put("value", value == null ? "" : value);
                            champsList.add(champMap);
                        }
                        if (c.getNom().equals("cout1") && c instanceof ChampEntier) {
                            cout1 += ((ChampEntier)c).getValeur();
                        }
                        if (c.getNom().equals("cout2") && c instanceof ChampEntier) {
                            cout2 += ((ChampEntier)c).getValeur();
                        }
                        if (!c.getNom().equals("cout3") || !(c instanceof ChampEntier)) continue;
                        cout3 += ((ChampEntier)c).getValeur();
                    }
                } else {
                    for (Champ c : champs) {
                        value = (String)c.getView((IComposantFactory)factory);
                        if (c instanceof ChampLocalisation) {
                            mapEvenement.put("localisation", value);
                            continue;
                        }
                        if (!GLS.estVide((String)c.getLibelle()) && c.getLibelle().equals("Commentaire")) {
                            mapEvenement.put("commentaire", value);
                            continue;
                        }
                        if (!GLS.estVide((String)value)) {
                            champMap = new HashMap();
                            champMap.put("name", c.getLibelle());
                            champMap.put("value", value == null ? "" : value);
                            champsList.add(champMap);
                        }
                        if (c.getNom().equals("cout1") && c instanceof ChampEntier) {
                            cout1 += ((ChampEntier)c).getValeur();
                        }
                        if (c.getNom().equals("cout2") && c instanceof ChampEntier) {
                            cout2 += ((ChampEntier)c).getValeur();
                        }
                        if (!c.getNom().equals("cout3") || !(c instanceof ChampEntier)) continue;
                        cout3 += ((ChampEntier)c).getValeur();
                    }
                }
                mapEvenement.put("champs", champsList);
                list.add(mapEvenement);
                File dir = new File(this.basedir, String.valueOf(evenement.getIdSituation()) + File.separator + evenement.getIdReference());
                ArrayList<Object> images = new ArrayList<Object>();
                mapEvenement.put("photos", images);
                for (String filename : evenement.getPhotos()) {
                    if (this.indatabase) {
                        byte[] data = this.service.getPhoto(filename);
                        try {
                            ByteArrayInputStream in = new ByteArrayInputStream(data);
                            BufferedImage bImageFromConvert = ImageIO.read(in);
                            images.add(new RenderedImageSource((RenderedImage)bImageFromConvert));
                        }
                        catch (Exception e) {
                            Log.error("image en erreur " + filename);
                        }
                        continue;
                    }
                    File file = new File(dir, filename);
                    if (file.exists()) {
                        images.add(new FileImageSource(file));
                        continue;
                    }
                    Log.error("image introuvable dans le r\u00e9pertoire");
                }
                if (i != situations.size() - 1 || y != situation.getEvenements().size() - 1) {
                    mapEvenement.put("notlast", "true");
                }
                ++y;
            }
            ++i;
        }
        root.put("cout1", cout1);
        root.put("cout2", cout2);
        root.put("cout3", cout3);
        root.put("couttotal", cout1 + cout2 + cout3);
        return root;
    }

    private String getLibelleChamp(Champ c) {
        if (!GLS.estVide((String)c.getLibelle())) {
            return c.getLibelle();
        }
        return c.getNom();
    }

    private FileImageSource getImageChamp(ChampChoixImage c) {
        if (c.getIndexSelectionnee() != c.getIndiceAutreChoix()) {
            File repComboIcon = new File(ConfigurationFactory.getInstance().get("iconcomboitem.dir"));
            File champDir = new File(repComboIcon, c.getNom());
            if (!champDir.isDirectory()) {
                throw new PrismConfigurationError("Le r\u00e9pertoire image pour le champ n'existe pas : " + champDir.getAbsolutePath());
            }
            File icon = new File(champDir, String.valueOf(c.getValeur()) + "." + "png");
            if (!icon.isFile()) {
                throw new PrismConfigurationError("Icone introuvable : " + icon.getAbsolutePath());
            }
            return new FileImageSource(icon);
        }
        return null;
    }
}

