/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.libreoffice;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAlternat;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImage;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImageMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampCoucheBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDate;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDateHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDecimal;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDocuments;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampEntier;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampImages;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLabel;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampOneDrive;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampPatrouilleProcedure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampRadioBouton;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampSignature;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampTexte;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVehiculeEnCause;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVraiFaux;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;

public class ReportComposantFactory
implements IComposantFactory {
    private static final String SEPARATEUR = " : ";
    private static final String CRLR = "\r\n";
    private static final String ESPACE = " ";
    private static final String BULLET = "\u2022 ";
    private DateFormat dateFormat;
    private DateFormat heureFormat;
    private DateFormat dateHeureFormat;

    public ReportComposantFactory() {
        Locale locale = new Locale(ConfigurationFactory.getInstance().get("report.lang"));
        this.dateFormat = new SimpleDateFormat(ReportI18n.getString("format.date"), locale);
        this.heureFormat = new SimpleDateFormat(ReportI18n.getString("format.heure"), locale);
        this.dateHeureFormat = new SimpleDateFormat(ReportI18n.getString("format.dateheure"), locale);
    }

    public Object createView(ChampAlternat c) {
        throw new RuntimeException("not implemented");
    }

    public Object createView(ChampEntier c) {
        if (!c.isCheckbox() || c.isChecked()) {
            return String.valueOf(c.getValeur());
        }
        return ReportI18n.getString("vide");
    }

    public Object createView(ChampDecimal c) {
        if (!c.isCheckbox() || c.isChecked()) {
            return String.valueOf(c.getValeur());
        }
        return ReportI18n.getString("vide");
    }

    public Object createView(ChampDropListe c) {
        return c.getValeur();
    }

    public Object createView(ChampLabel c) {
        return c.getValeur();
    }

    public Object createView(ChampLocalisation c) {
        StringBuffer buf = new StringBuffer();
        if (!GLS.estVide((String)c.getCommune())) {
            buf.append(ReportI18n.getString("commune")).append(SEPARATEUR).append(c.getCommune()).append(CRLR);
        }
        if (!GLS.estVide((String)c.getAxe())) {
            buf.append(ReportI18n.getString("axe")).append(SEPARATEUR).append(c.getAxe()).append(CRLR);
        }
        if (!GLS.estVide((String)c.getAdresseDebut())) {
            if (!GLS.estVide((String)c.getAdresseFin())) {
                buf.append(ReportI18n.getString("dunumero")).append(ESPACE).append(c.getAdresseDebut()).append(ESPACE);
                buf.append(ReportI18n.getString("aunumero")).append(ESPACE).append(c.getAdresseFin()).append(CRLR);
                buf.append(ReportI18n.getString("longueur")).append(SEPARATEUR).append(c.getLongueur()).append(ESPACE).append(ReportI18n.getString("unit.distance")).append(CRLR);
            } else {
                buf.append(ReportI18n.getString("aunumero")).append(ESPACE).append(c.getAdresseDebut()).append(CRLR);
            }
        }
        int sensPrRapport = 0;
        switch (c.getSensPr()) {
            case -1: {
                sensPrRapport = 0;
                break;
            }
            case 1: {
                sensPrRapport = 1;
                break;
            }
            case 0: {
                sensPrRapport = 2;
                break;
            }
            case 2: {
                sensPrRapport = 3;
            }
        }
        if (c.getPrDebut() < 0) {
            buf.append(ReportI18n.getString("xy")).append(SEPARATEUR).append(c.getPositionDebut().getX() + "," + c.getPositionDebut().getY());
            if (c.getLongueur() > 0) {
                buf.append(" --> " + c.getPositionFin().getX() + "," + c.getPositionFin().getY());
            }
        } else if (c.getPrFin() == -1 || c.getPrFin() == c.getPrDebut() && c.getAbsPrDebut() == c.getAbsPrFin()) {
            buf.append(ReportI18n.getString("aupr")).append(c.getPrDebut()).append("+").append(c.getAbsPrDebut()).append(CRLR).append(String.valueOf(ReportI18n.getString("sens")) + ESPACE + sensPrRapport);
        } else {
            buf.append(ReportI18n.getString("dupr")).append(ESPACE).append(c.getPrDebut()).append("+").append(c.getAbsPrDebut()).append(ESPACE);
            buf.append(ReportI18n.getString("topr")).append(ESPACE).append(c.getPrFin()).append("+").append(c.getAbsPrFin()).append(CRLR).append(String.valueOf(ReportI18n.getString("sens")) + ESPACE + sensPrRapport).append(CRLR);
            buf.append(ReportI18n.getString("longueur")).append(SEPARATEUR).append(c.getLongueur()).append(ESPACE).append(ReportI18n.getString("unit.distance"));
        }
        if (!GLS.estVide((String)c.getDirection())) {
            buf.append(ReportI18n.getString("sens")).append(SEPARATEUR).append(c.getDirection());
        }
        return buf.toString();
    }

    public Object createView(ChampMultiCheckBox c) {
        StringBuffer buf = new StringBuffer();
        for (String item : c.getValeursSelectionnee()) {
            buf.append(BULLET).append(ESPACE).append(item).append(CRLR);
        }
        if (c.getAutreValeur() != null) {
            buf.append(BULLET).append(ESPACE).append(c.getAutreValeur()).append(CRLR);
        }
        return buf.toString();
    }

    public Object createView(ChampChoixImageMultiple c) {
        StringBuffer buf = new StringBuffer();
        for (String item : c.getValeursSelectionnee()) {
            buf.append(BULLET).append(ESPACE).append(item).append(CRLR);
        }
        if (c.getAutreValeur() != null) {
            buf.append(BULLET).append(ESPACE).append(c.getAutreValeur()).append(CRLR);
        }
        return buf.toString();
    }

    public Object createView(ChampMultiple c) {
        StringBuffer buf = new StringBuffer();
        for (Champ champ : c.getChamps()) {
            Object valeur = champ.getView((IComposantFactory)this);
            if (GLS.estVide((String)GLS.getString((Object)valeur))) continue;
            if (!GLS.estVide((String)champ.getLibelle())) {
                buf.append(champ.getLibelle()).append(CRLR);
            }
            buf.append(valeur).append(CRLR);
        }
        return buf.toString();
    }

    public Object createView(ChampRadioBouton c) {
        return c.getValeurSelectionnee();
    }

    public Object createView(ChampTexte c) {
        if (c.getValeur() == null) {
            return "";
        }
        String s = c.getValeur();
        s = s.replace("\r", "");
        s = s.replace("\n", CRLR);
        return s;
    }

    public Object createView(ChampVraiFaux c) {
        return c.getValeur() ? ReportI18n.getString("oui") : ReportI18n.getString("non");
    }

    public Object createView(ChampVehiculeEnCause c) {
        StringBuffer buf = new StringBuffer();
        if (c.isDisplayVl() && c.getVl() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.vl")).append(SEPARATEUR).append(c.getVl()).append(CRLR);
        }
        if (c.isDisplayPl() && c.getPl() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.pl")).append(SEPARATEUR).append(c.getPl()).append(CRLR);
        }
        if (c.isDisplayVtc() && c.getVtc() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.tc")).append(SEPARATEUR).append(c.getVtc()).append(CRLR);
        }
        if (c.isDisplayMoto() && c.getMoto() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.moto")).append(SEPARATEUR).append(c.getMoto()).append(CRLR);
        }
        if (c.isDisplayVelo() && c.getVelo() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.velo")).append(SEPARATEUR).append(c.getVelo()).append(CRLR);
        }
        if (c.isDisplayTmd() && c.getTmd() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.tmd")).append(SEPARATEUR).append(c.getTmd()).append(CRLR);
        }
        if (c.isDisplayPietonCycle() && c.getPietonCycle() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.pietonCycle")).append(SEPARATEUR).append(c.getPietonCycle()).append(CRLR);
        }
        if (c.isDisplayCampingCar() && c.getCampingCar() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.campingCar")).append(SEPARATEUR).append(c.getCampingCar()).append(CRLR);
        }
        if (c.isDisplayDeuxRoues() && c.getDeuxRoues() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.deuxRoues")).append(SEPARATEUR).append(c.getDeuxRoues()).append(CRLR);
        }
        if (c.isDisplayScooter() && c.getScooter() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.scooter")).append(SEPARATEUR).append(c.getScooter()).append(CRLR);
        }
        if (c.isDisplayCaravane() && c.getCaravane() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.caravane")).append(SEPARATEUR).append(c.getCaravane()).append(CRLR);
        }
        if (c.isDisplayTrain() && c.getTrain() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.train")).append(SEPARATEUR).append(c.getTrain()).append(CRLR);
        }
        if (c.isDisplayTramway() && c.getTramway() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.tramway")).append(SEPARATEUR).append(c.getTramway()).append(CRLR);
        }
        if (c.isDisplayEnginAgricole() && c.getEnginAgricole() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.enginAgricole")).append(SEPARATEUR).append(c.getEnginAgricole()).append(CRLR);
        }
        if (c.isDisplayAnimaux() && c.getAnimaux() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.animaux")).append(SEPARATEUR).append(c.getAnimaux()).append(CRLR);
        }
        if (c.isDisplayAutres() && c.getAutres() > 0) {
            buf.append(BULLET).append(ReportI18n.getString("vec.autres")).append(SEPARATEUR).append(c.getAutres()).append(CRLR);
        }
        return buf.toString();
    }

    public Object createView(ChampDate c) {
        if (c.isChecked() && c.getAnnee() != 3) {
            GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour());
            return this.dateFormat.format(cal.getTime());
        }
        return "";
    }

    public Object createView(ChampDateHeure c) {
        if (c.isChecked() && c.getAnnee() != 3) {
            GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour(), c.getHeure(), c.getMinute());
            return this.dateHeureFormat.format(cal.getTime());
        }
        return "";
    }

    public Object createView(ChampHeure c) {
        if (c.isChecked()) {
            GregorianCalendar cal = new GregorianCalendar(0, 0, 0, c.getHeure(), c.getMinute());
            return this.heureFormat.format(cal.getTime());
        }
        return "";
    }

    public void setChampLectureSeule(boolean lectureSeule) {
    }

    public Object createView(ChampPatrouilleProcedure c) {
        StringBuffer buf = new StringBuffer();
        if (!this.competenceVide(c)) {
            if (this.competenceCg(c)) {
                buf.append(BULLET).append(ReportI18n.getString("pp.competence")).append(SEPARATEUR).append(c.getValeur().getCompetence()).append(CRLR);
                String urgence = c.getValeur().isUrgence() ? ReportI18n.getString("oui") : ReportI18n.getString("non");
                buf.append(BULLET).append(ReportI18n.getString("pp.urgence")).append(SEPARATEUR).append(urgence).append(CRLR);
                if (c.getValeur().isUrgence()) {
                    String immediat = c.getValeur().getImmediate() ? ReportI18n.getString("oui") : ReportI18n.getString("non");
                    buf.append(BULLET).append(ReportI18n.getString("pp.immediat")).append(SEPARATEUR).append(immediat).append(CRLR);
                    buf.append(BULLET).append(ReportI18n.getString("pp.mesure")).append(SEPARATEUR).append(c.getValeur().getMesure()).append(CRLR);
                }
            } else {
                String urgence = c.getValeur().isUrgence() ? ReportI18n.getString("oui") : ReportI18n.getString("non");
                buf.append(BULLET).append(ReportI18n.getString("pp.urgence")).append(SEPARATEUR).append(urgence).append(CRLR);
                String immediat = c.getValeur().getImmediate() ? ReportI18n.getString("oui") : ReportI18n.getString("non");
                buf.append(BULLET).append(ReportI18n.getString("pp.immediat")).append(SEPARATEUR).append(immediat).append(CRLR);
                buf.append(BULLET).append(ReportI18n.getString("pp.mesure")).append(SEPARATEUR).append(c.getValeur().getMesure()).append(CRLR);
                if (c.getValeur().getCompteRendu()) {
                    buf.append(BULLET).append(ReportI18n.getString("pp.compterendu")).append(ESPACE).append(c.getValeur().getCompetence()).append(CRLR);
                }
            }
        }
        return buf.toString();
    }

    private boolean competenceVide(ChampPatrouilleProcedure champ) {
        return champ.getValeur().getCompetence() == null || champ.getValeur().getCompetence().equals("");
    }

    private boolean competenceCg(ChampPatrouilleProcedure champ) {
        String competenceCg = champ.getCompetenceCg();
        String competenceSelect = champ.getValeur().getCompetence();
        boolean isCompetenceCg = competenceCg.equals(competenceSelect);
        return isCompetenceCg;
    }

    public Object createView(ChampChoixImage c) {
        return c.getValeurSelectionnee();
    }

    public Object createView(ChampImages champImage) {
        return null;
    }

    public Object createView(ChampSignature champSignature) {
        return null;
    }

    public Object createView(ChampDocuments champDocuements) {
        return null;
    }

    public Object createView(ChampCoucheBox champCoucheBox) {
        return null;
    }

    public Object createView(ChampOneDrive champOneDrive) {
        return null;
    }
}

