/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.libreoffice;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.File;
import java.io.IOException;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.ExternalOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;

public class DocumentConverter {
    public static synchronized File convert(File odt, String format) throws IOException {
        File out = File.createTempFile("converted", "." + format, odt.getParentFile());
        OfficeManager manager = DocumentConverter.getManager();
        OfficeDocumentConverter converter = new OfficeDocumentConverter(manager);
        try {
            try {
                converter.convert(odt, out);
                Log.debug("converted to " + out.getAbsolutePath());
            }
            catch (Exception e) {
                Log.error("Erreur de de conversion du fichier PDF", e);
                manager.stop();
            }
        }
        finally {
            manager.stop();
        }
        return out;
    }

    private static OfficeManager getManager() {
        int port = ConfigurationFactory.getInstance().getInt("office.port");
        File home = new File(ConfigurationFactory.getInstance().get("office.home"));
        try {
            DefaultOfficeManagerConfiguration configuration = new DefaultOfficeManagerConfiguration();
            configuration.setPortNumber(port);
            configuration.setOfficeHome(home);
            OfficeManager manager = configuration.buildOfficeManager();
            manager.start();
            return manager;
        }
        catch (OfficeException e) {
            ExternalOfficeManagerConfiguration externalProcessOfficeManager = new ExternalOfficeManagerConfiguration();
            externalProcessOfficeManager.setConnectOnStart(true);
            externalProcessOfficeManager.setPortNumber(port);
            OfficeManager manager = externalProcessOfficeManager.buildOfficeManager();
            manager.start();
            return manager;
        }
    }
}

