/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.json;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.ConstantesCSV;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.export.json.ChampJSON;
import com.geolocsystems.prismcentral.export.json.JSONComposantFactory;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    public static Map<String, String> getListeChamps(List<Situation> situations, Map<String, Nature> natures) {
        String s;
        JSONComposantFactory factory = new JSONComposantFactory();
        LinkedHashMap<String, String> colonnes = new LinkedHashMap<String, String>();
        Object object = ConstantesCSV.CHAMP_CSV_STATIC;
        int n = ConstantesCSV.CHAMP_CSV_STATIC.length;
        int n2 = 0;
        while (n2 < n) {
            s = object[n2];
            colonnes.put(s, s);
            ++n2;
        }
        if (ConfigurationFactory.getInstance().getBoolean("fiche.evenement.csv.date.heure.separe", false)) {
            object = ConstantesCSV.CHAMP_CSV_SYSTEME_DATE_HEURE_SEPARE;
            n = ConstantesCSV.CHAMP_CSV_SYSTEME_DATE_HEURE_SEPARE.length;
            n2 = 0;
            while (n2 < n) {
                s = object[n2];
                colonnes.put(s, s);
                ++n2;
            }
        } else {
            object = ConstantesCSV.CHAMP_CSV_SYSTEME;
            n = ConstantesCSV.CHAMP_CSV_SYSTEME.length;
            n2 = 0;
            while (n2 < n) {
                s = object[n2];
                colonnes.put(s, s);
                ++n2;
            }
        }
        for (Situation situation : situations) {
            for (Evenement evenement : situation.getEvenements()) {
                Nature n3 = (Nature)DeepCopy.copy((Object)natures.get(evenement.getValeurNature().getCode()));
                n3.chargerValeurs(evenement.getValeurNature());
                List listeChamp = MetierCommun.getChampsFiltresTest((Nature)n3);
                for (Champ c : listeChamp) {
                    boolean index = false;
                    List champscsv = (List)c.getView((IComposantFactory)factory);
                    for (ChampJSON champcsv : champscsv) {
                        if (colonnes.containsKey(champcsv.getCode())) continue;
                        Log.debug("Champs csv " + champcsv.getCode() + " -- " + champcsv.getLibelle());
                        if (GLS.estVide((String)champcsv.getLibelle())) {
                            colonnes.put(champcsv.getCode(), GLS.getLibelleChampEnClair((String)champcsv.getCode()));
                            continue;
                        }
                        if (!colonnes.containsValue(champcsv.getLibelle())) {
                            colonnes.put(champcsv.getCode(), champcsv.getLibelle());
                            continue;
                        }
                        colonnes.put(champcsv.getCode(), champcsv.getLibelle().concat(" (" + champcsv.getCode() + ")"));
                    }
                }
            }
        }
        return colonnes;
    }

    public static String getChaine(String valeur) {
        if (valeur == null) {
            return "\"\"";
        }
        return "\"" + valeur + "\"";
    }
}

